<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon MP metrics implements the MicroProfile Metrics specification, providing:</p>

<ul class="ulist">
<li>
<p>a unified way for
MicroProfile
servers to export monitoring data&#8212;&#8203;telemetry&#8212;&#8203;to management agents, and</p>

</li>
<li>
<p>a unified Java API which all application programmers can use to register and update metrics to expose telemetry data from their services.</p>

</li>
<li>
<p>support for metrics-related annotations.</p>

</li>
</ul>

<p>Learn more about the <a target="_blank" href="https://github.com/eclipse/microprofile-metrics/releases/tag/4.0">MicroProfile Metrics specification</a>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable metrics
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Adding this dependency packages the full-featured metrics implementation with your service.</p>


<h3 id="_other_packaging_options">Other packaging options</h3>
<div class="section">
<p>Helidon gives you flexibility in how you make metrics available to your service. <router-link to="/mp/metrics/metrics-capable-components">This document</router-link> explains your options.</p>

</div>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_instrumenting_your_service">Instrumenting Your Service</h3>
<div class="section">
<p>You add metrics to your service
in these ways:</p>

<ul class="ulist">
<li>
<p>Annotate bean methods&#8212;&#8203;typically your REST resource endpoint methods (the Java code that receives incoming REST requests); Helidon automatically registers these metrics and updates them when the annotated methods are invoked via CDI.</p>

</li>
<li>
<p>Write code which explicitly invokes the metrics API to register metrics, retrieve previously-registered metrics, and update metric values.</p>

</li>
<li>
<p>Configure some simple <code>REST.request</code> metrics which Helidon automatically registers and updates for all REST resource endpoints.</p>

</li>
</ul>

<p>Later sections of this document describe how to do
each of these.</p>

</div>


<h3 id="_categorizing_types_of_metrics">Categorizing Types of Metrics</h3>
<div class="section">
<p>Helidon distinguishes among three general <em>types</em>, or scopes, of metrics, as described in the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/microprofile-metrics-spec-4.0.html">MP metrics specification</a>.</p>

<div class="block-title"><span>Types (scopes) of metrics</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Type/scope</th>
<th>Typical Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">base</td>
<td class="">Mandated by the MP metrics specification, such as OS or Java runtime measurements (available heap, disk space, etc.).</td>
</tr>
<tr>
<td class="">vendor</td>
<td class="">Implemented by vendors, including the <code>REST.request</code> metrics and other key performance indicator measurements (described in later sections).</td>
</tr>
<tr>
<td class="">application</td>
<td class="">Declared via annotations or programmatically registered by your service code.</td>
</tr>
</tbody>
</table>
</div>

<p>When you add metrics annotations to your service code, Helidon registers the resulting metrics as type <code>application</code>.</p>

</div>


<h3 id="_metric_registries">Metric Registries</h3>
<div class="section">
<p>A <em>metric registry</em> collects registered metrics of a given type. Helidon supports three registries, one for each of the three metrics types.</p>

<p>When you add code to your service to create a metric programmatically, the code first locates the appropriate registry and then registers the metric with that registry.</p>

</div>


<h3 id="_retrieving_metrics_reports_from_your_service">Retrieving Metrics Reports from your Service</h3>
<div class="section">
<p>When you add the metrics dependency to your project, Helidon automatically provides a built-in REST endpoint <code>/metrics</code> which responds with a report of the registered metrics and their values.</p>

<p>Clients can request a particular output format.</p>

<div class="block-title"><span>Formats for <code>/metrics</code> output</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Format</th>
<th>Requested by</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">OpenMetrics (Prometheus)</td>
<td class="">default (<code>text/plain</code>)</td>
</tr>
<tr>
<td class="">JSON</td>
<td class="">Header <code>Accept: application/json</code></td>
</tr>
</tbody>
</table>
</div>

<p>Clients can also limit the report by appending the metric type to the path:</p>

<ul class="ulist">
<li>
<p><code>/metrics/base</code></p>

</li>
<li>
<p><code>/metrics/vendor</code></p>

</li>
<li>
<p><code>/metrics/application</code></p>

</li>
</ul>

<p>Further, clients can narrow down to a specific metric name by adding the name as a subpath such as <code>/metrics/application/myCount</code>.</p>

<markup
lang="bash"
title="Example Reporting: Prometheus format"
>curl -s -H 'Accept: text/plain' -X GET http://localhost:8080/metrics/</markup>

<div class="listing">
<pre># TYPE base:classloader_total_loaded_class_count counter
# HELP base:classloader_total_loaded_class_count Displays the total number of classes that have been loaded since the Java virtual machine has started execution.
base:classloader_total_loaded_class_count 3157</pre>
</div>

<markup
lang="bash"
title="Example Reporting: JSON format"
>curl -s -H 'Accept: application/json' -X GET http://localhost:8080/metrics/</markup>

<div class="listing">
<pre>{
   "base" : {
      "memory.maxHeap" : 3817865216,
      "memory.committedHeap" : 335544320,
    }
}</pre>
</div>

<p>In addition to your application metrics, the reports contain other
metrics of interest such as system and VM information.</p>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/package-summary.html">MicroProfile Metrics API</a> prescribes all the standard interfaces related to metrics. This section summarizes a few key points about using that API and explains some Helidon-specific interfaces.</p>


<h3 id="_metrics_annotations">Metrics Annotations</h3>
<div class="section">
<p>You can very easily instrument your service and refer to registered metrics by annotating methods to be measured and injecting metrics which your code needs to observe.</p>


<h4 id="_metric_defining_annotations">Metric-defining Annotations</h4>
<div class="section">
<p>The MicroProfile Metrics specification describes several metric types you can create using annotations, summarized in the following table:</p>

<div class="block-title"><span>Metrics Annotations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotation/Counted.html"><code>@Counted</code></a></td>
<td class="">Monotonically increasing count of events.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotationConcurrentGauge.html"><code>@ConcurrentGauge</code></a></td>
<td class="">Increasing and decreasing measurement of currently-executing blocks of code.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotation/Gauge.html"><code>@Gauge</code></a></td>
<td class="">Access to a value managed by other code in the service.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotation/Metered.html"><code>@Metered</code></a></td>
<td class="">Count of invocations and how frequently invocations have occurred.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotation/SimplyTimed.html"><code>@SimplyTimed</code></a></td>
<td class="">Count of invocations and the total duration consumed by those invocations.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotation/Timed.html"><code>@Timed</code></a></td>
<td class="">Frequency of invocations and the distribution of how long the invocations take.</td>
</tr>
</tbody>
</table>
</div>

<p>Place annotations on constructors or methods to measure those specific executables. If you annotate the class instead, Helidon applies that annotation to all constructors and methods which the class declares.</p>

</div>


<h4 id="_metric_referencing_annotations">Metric-referencing Annotations</h4>
<div class="section">
<p>To get a reference to a specific metric, use a metric-referencing annotation in any bean, including your REST resource classes.</p>

<p>You can <code>@Inject</code> a field of the correct type. Helidon uses the MicroProfile Metrics naming conventions to select which specific metric to inject. Use the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotation/Metric.html"><code>@Metric</code></a> annotation to control that selection.</p>

<p>You can also add <code>@Metric</code> on a constructor or method parameter to trigger injection there.</p>

<p>Helidon automatically looks up the metric referenced from any injection site and provides a reference to the metric. Your code then simply invokes methods on the injected metric.</p>

</div>

</div>


<h3 id="_the_metricregistry_api">The <code>MetricRegistry</code> API</h3>
<div class="section">
<p>To register or look up metrics programmatically, your service code uses one of the three  <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/MetricRegistry.html"><code>MetricRegistry</code></a> instances (base, vendor, and application) which Helidon furnishes automatically.</p>

<p>To get a <code>MetricRegistry</code> reference</p>

<ul class="ulist">
<li>
<p><code>@Inject</code> the metric registry you want, perhaps also using the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/annotation/RegistryType.html"><code>@RegistryType</code></a> annotation to select the registry type, or</p>

</li>
<li>
<p>Get a Helidon <a target="_blank" href="./apidocs/io.helidon.metrics.api/RegistryFactory.html"><code>RegistryFactory</code></a>; either</p>
<div><ul class="ulist">
<li>
<p><code>@Inject</code> <code>RegistryFactory</code> or</p>

</li>
<li>
<p>Invoke one of the static <code>getInstance</code> methods on <code>RegistryFactory</code></p>

</li>
</ul>
</div>

<p>Then invoke <code>getRegistry</code> on the <code>RegistryFactory</code> instance.</p>

</li>
</ul>

<p>The <code>MetricRegistry</code> allows your code to register new metrics, look up previously-registered metrics, and remove metrics.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To control how the Helidon metrics subsystem behaves, add a <code>metrics</code> section to
your <code>META-INF/microprofile-config.properties</code> file.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.metrics.serviceapi/io/helidon/metrics/serviceapi/MetricsSupport.html">io.helidon.metrics.serviceapi.MetricsSupport</a></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>appName</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the value for the <code>_app</code> tag to be applied to all metrics.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>base</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_BaseMetricsSettings">BaseMetricsSettings</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the base metrics settings.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the cross-origin config builder for use in establishing CORS support for the service endpoints.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets whether metrics should be enabled.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-performance-indicators</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_KeyPerformanceIndicatorMetricsSettings">KeyPerformanceIndicatorMetricsSettings</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the KPI metrics settings.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>registries</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_RegistrySettings">Map&lt;string, RegistrySettings&gt;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the registry settings for the specified registry type.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>routing</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the routing name to use for setting up the service&#8217;s endpoint.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the global tags to be applied to all metrics.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets the web context to use for the service&#8217;s endpoint.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon MP includes a prewritten example application illustrating
<a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/metrics/filtering/mp">enabling/disabling metrics</a> using configuration.</p>

<p>The rest of this section contains other examples of working with metrics:</p>

<ul class="ulist">
<li>
<p><router-link to="#example-application-code" @click.native="this.scrollFix('#example-application-code')">Example Application Code</router-link></p>

</li>
<li>
<p><router-link to="#example-configuration" @click.native="this.scrollFix('#example-configuration')">Example Configuration</router-link></p>

</li>
</ul>


<h3 id="example-application-code">Example Application Code</h3>
<div class="section">

<h4 id="_adding_method_level_annotations">Adding Method-level Annotations</h4>
<div class="section">
<p>The following example adds a new resource class, <code>GreetingCards</code>, to the Helidon MP QuickStart example. It shows how to use the <code>@Counted</code> annotation to track the number of times
the <code>/cards</code> endpoint is called.</p>

<markup
lang="java"
title="Create a new class <code>GreetingCards</code> with the following code:"
>package io.helidon.examples.quickstart.mp;

import java.util.Collections;
import jakarta.enterprise.context.RequestScoped;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Path("/cards") <span class="conum" data-value="1" />
@RequestScoped <span class="conum" data-value="2" />
public class GreetingCards {

  private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Counted(name = "any-card")  <span class="conum" data-value="3" />
  public JsonObject anyCard() throws InterruptedException {
    return createResponse("Here are some random cards ...");
  }

  private JsonObject createResponse(String msg) {
    return JSON.createObjectBuilder().add("message", msg).build();
  }
}</markup>

<ul class="colist">
<li data-value="1">This class is annotated with <code>Path</code> which sets the path for this resource
as <code>/cards</code>.</li>
<li data-value="2">The <code>@RequestScoped</code> annotation defines that this bean is
request scoped.  The request scope is active only for the duration of
one web service invocation and it is destroyed at the end of that
invocation.</li>
<li data-value="3">The annotation <code>@Counted</code> will register a <code>Counter</code> metric for this method, creating it if needed.
The counter is incremented each time the anyCards method is called.  The <code>name</code> attribute is optional.</li>
</ul>

<markup
lang="bash"
title="Build and run the application"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="base"
title="Access the application endpoints"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl -H "Accept: application/json"  http://localhost:8080/metrics/application</markup>

<markup
lang="json"
title="JSON response:"
>{
  "io.helidon.examples.quickstart.mp.GreetingCards.any-card":2 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The any-card count is two, since you invoked the endpoint twice.</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">Notice the counter name is fully qualified with the class and method names.  You can remove the prefix by using the <code>absolute=true</code> field in the <code>@Counted</code> annotation.
You must use  <code>absolute=false</code> (the default) for class-level annotations.</p>
</div>

</div>


<h4 id="_additional_method_level_metrics">Additional Method-level Metrics</h4>
<div class="section">
<p>The <code>@ConcurrentGauge</code>, @Timed`, <code>@Metered</code>, and <code>@SimplyTimed</code> annotations can also be used with a method.  For the following example.
you can just annotate the same method with <code>@Metered</code> and <code>@Timed</code>. These metrics collect significant
information about the measured methods, but at a cost of some overhead and more complicated output.
Use <code>@SimplyTimed</code> in cases where capturing the invocation count and the total elapsed time
spent in a block of code is sufficient.</p>

<p>Note that when using multiple annotations on a method, you <strong>must</strong> give the metrics different names as shown below (although they do not have to be absolute).</p>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code:"
>package io.helidon.examples.quickstart.mp;

import java.util.Collections;
import jakarta.enterprise.context.RequestScoped;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import org.eclipse.microprofile.metrics.MetricUnits;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Path("/cards")
@RequestScoped
public class GreetingCards {

  private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Counted(name = "cardCount", absolute = true) <span class="conum" data-value="1" />
  @Metered(name = "cardMeter", absolute = true, unit = MetricUnits.MILLISECONDS) <span class="conum" data-value="2" />
  @Timed(name = "cardTimer", absolute = true, unit = MetricUnits.MILLISECONDS) <span class="conum" data-value="3" />
  public JsonObject anyCard() {
    return createResponse("Here are some random cards ...");
  }

  private JsonObject createResponse(String msg) {
    return JSON.createObjectBuilder().add("message", msg).build();
  }
}</markup>

<ul class="colist">
<li data-value="1">Specify a custom name for the <code>Counter</code> metric and set <code>absolute=true</code> to remove the path prefix from the name.</li>
<li data-value="2">Add the <code>@Metered</code> annotation to get a <code>Meter</code> metric.</li>
<li data-value="3">Add the <code>@Timed</code> annotation to get a <code>Timer</code> metric.</li>
</ul>

<markup
lang="bash"
title="Build and run the application"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="base"
title="Access the application endpoints"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl -H "Accept: application/json"  http://localhost:8080/metrics/application</markup>

<markup
lang="json"
title="JSON response:"
>{
  "cardCount": 2,
  "cardMeter": { <span class="conum" data-value="1" />
    "count": 2,
    "meanRate": 0.15653506570241812,
    "oneMinRate": 0,
    "fiveMinRate": 0,
    "fifteenMinRate": 0
  },
  "cardTimer": { <span class="conum" data-value="2" />
    "count": 2,
    "elapsedTime": 2,
    "meanRate": 0.15651866263362785,
    "oneMinRate": 0,
    "fiveMinRate": 0,
    "fifteenMinRate": 0,
    "min": 0,
    "max": 2,
    "mean": 1.0506565,
    "stddev": 1.0405735,
    "p50": 2.09123,
    "p75": 2.09123,
    "p95": 2.09123,
    "p98": 2.09123,
    "p99": 2.09123,
    "p999": 2.09123
  }
}</markup>

<ul class="colist">
<li data-value="1">The <code>Meter</code> metric includes the count field (it is a superset of <code>Counter</code>).</li>
<li data-value="2">The <code>Timer</code> metric includes the <code>Meter</code> fields (it is a superset of <code>Meter</code>).</li>
</ul>

</div>


<h4 id="_class_level_metrics">Class-level Metrics</h4>
<div class="section">
<p>You can collect metrics at the class-level to aggregate data from all methods in that class using the same metric.
The following example introduces a metric to count all card queries.  In the following example, the method-level metrics are not
needed to aggregate the counts, but they are left in the example to demonstrate the combined output of all three metrics.</p>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code:"
>package io.helidon.examples.quickstart.mp;

import java.util.Collections;
import jakarta.enterprise.context.RequestScoped;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Path("/cards")
@RequestScoped
@Counted(name = "totalCards") <span class="conum" data-value="1" />
public class GreetingCards {

  private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Counted(absolute = true) <span class="conum" data-value="2" />
  public JsonObject anyCard() throws InterruptedException {
    return createResponse("Here are some random cards ...");
  }

  @Path("/birthday")
  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Counted(absolute = true) <span class="conum" data-value="3" />
  public JsonObject birthdayCard() throws InterruptedException {
    return createResponse("Here are some birthday cards ...");
  }

  private JsonObject createResponse(String msg) {
    return JSON.createObjectBuilder().add("message", msg).build();
  }
}</markup>

<ul class="colist">
<li data-value="1">This class is annotated with <code>@Counted</code>, which aggregates count data from all the method that have a <code>Count</code> annotation.</li>
<li data-value="2">Use <code>absolute=true</code> to remove path prefix for method-level annotations.</li>
<li data-value="3">Add a method with a <code>Counter</code> metric to get birthday cards.</li>
</ul>

<markup
lang="bash"
title="Build and run the application"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="bash"
title="Access the application endpoints"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards/birthday
curl -H "Accept: application/json"  http://localhost:8080/metrics/application</markup>

<markup
lang="json"
title="JSON response from <code>/metrics/application</code>:"
>{
  "anyCard": 1,
  "birthdayCard": 1,
  "io.helidon.examples.quickstart.mp.totalCards.GreetingCards": 2  <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The <code>totalCards</code> count is a total of all the method-level <code>Counter</code> metrics.  Class level metric names are always
fully qualified.</li>
</ul>

</div>


<h4 id="_field_level_metrics">Field Level Metrics</h4>
<div class="section">
<p>Field level metrics can be injected into managed objects, but they need to be updated by the application code.
This annotation can be used on fields of type <code>Meter</code>, <code>Timer</code>, <code>Counter</code>, and <code>Histogram</code>.</p>

<p>The following example shows how to use a field-level <code>Counter</code> metric to track cache hits.</p>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code:"
>package io.helidon.examples.quickstart.mp;

import java.util.Collections;
import java.util.Random;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metric;

@Path("/cards")
@RequestScoped
@Counted(name = "totalCards")
public class GreetingCards {

  private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

  @Inject
  @Metric(name = "cacheHits", absolute = true) <span class="conum" data-value="1" />
  private Counter cacheHits;

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Counted(absolute = true)
  public JsonObject anyCard() throws InterruptedException {
    updateStats(); <span class="conum" data-value="2" />
    return createResponse("Here are some random cards ...");
  }

  @Path("/birthday")
  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Counted(absolute = true)
  public JsonObject birthdayCard() throws InterruptedException {
    updateStats();  <span class="conum" data-value="3" />
    return createResponse("Here are some birthday cards ...");
  }

  private JsonObject createResponse(String msg) {
    return JSON.createObjectBuilder().add("message", msg).build();
  }

  private void updateStats() {
    if (new Random().nextInt(3) == 1) {
      cacheHits.inc(); <span class="conum" data-value="4" />
    }
  }
}</markup>

<ul class="colist">
<li data-value="1">A <code>Counter</code> metric field, <code>cacheHits</code>, is automatically injected by Helidon.</li>
<li data-value="2">Call <code>updateStats()</code> to update the cache hits.</li>
<li data-value="3">Call <code>updateStats()</code> to update the cache hits.</li>
<li data-value="4">Randomly increment the <code>cacheHits</code> counter.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the following endpoints:"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl http://localhost:8080/cards/birthday
curl http://localhost:8080/cards/birthday
curl http://localhost:8080/cards/birthday
curl -H "Accept: application/json"  http://localhost:8080/metrics/application</markup>

<markup
lang="json"
title="JSON response from <code>/metrics/application</code>:"
>{
  "anyCard": 2,
  "birthdayCard": 3,
  "cacheHits": 2, <span class="conum" data-value="1" />
  "io.helidon.examples.quickstart.mp.totalCards.GreetingCards": 5
}</markup>

<ul class="colist">
<li data-value="1">The cache was hit two times out of five queries.</li>
</ul>

</div>


<h4 id="_gauge_metric">Gauge Metric</h4>
<div class="section">
<p>The metrics you have tested so far are updated in response to an application REST request, i.e GET <code>/cards</code>.  These
metrics can be declared in a request scoped class and Helidon will store the metric in the <code>MetricRegistry</code>, so the value persists
across requests. When GET <code>/metrics/application</code> is invoked, Helidon will return the current value of the metric stored in the <code>MetricRegistry</code>.
The <code>Gauge</code> metric is different from all the other metrics. The application must provide a getter to return the gauge value in an
application scoped class. When GET <code>/metrics/application</code> is invoked, Helidon will call the <code>Gauge</code> getter, store that value
in the <code>MetricsRegistry</code>, and return it as part of the metrics response payload.  So, the <code>Gauge</code> metric value is updated real-time, in response to the
get metrics request.</p>

<p>The following example demonstrates how to use a <code>Gauge</code> to track application up-time.</p>

<markup
lang="java"
title="Create a new <code>GreetingCardsAppMetrics</code> class with the following code:"
>package io.helidon.examples.quickstart.mp;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import org.eclipse.microprofile.metrics.annotation.Gauge;

@ApplicationScoped <span class="conum" data-value="1" />
public class GreetingCardsAppMetrics {

  private AtomicLong startTime = new AtomicLong(0); <span class="conum" data-value="2" />

  public void onStartUp(@Observes @Initialized(ApplicationScoped.class) Object init) {
    startTime = new AtomicLong(System.currentTimeMillis()); <span class="conum" data-value="3" />
  }

  @Gauge(unit = "TimeSeconds")
  public long appUpTimeSeconds() {
    return Duration.ofMillis(System.currentTimeMillis() - startTime.get()).getSeconds();  <span class="conum" data-value="4" />
  }
}</markup>

<ul class="colist">
<li data-value="1">This managed object must be application scoped to properly register and use the <code>Gauge</code> metric.</li>
<li data-value="2">Declare an <code>AtomicLong</code> field to hold the start time of the application.</li>
<li data-value="3">Initialize the application start time.</li>
<li data-value="4">Return the application <code>appUpTimeSeconds</code> metric, which will be included in the application metrics.</li>
</ul>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code to simplify the metrics output:"
>package io.helidon.examples.quickstart.mp;

import java.util.Collections;
import jakarta.enterprise.context.RequestScoped;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Path("/cards")
@RequestScoped
public class GreetingCards {

  private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  @Counted(name = "cardCount", absolute = true)
  public JsonObject anyCard() throws InterruptedException {
    return createResponse("Here are some random cards ...");
  }

  private JsonObject createResponse(String msg) {
    return JSON.createObjectBuilder().add("message", msg).build();
  }
}</markup>

<markup
lang="bash"
title="Build and run the application, then invoke the application metrics endpoint:"
>curl -H "Accept: application/json"  http://localhost:8080/metrics/application</markup>

<markup
lang="json"
title="JSON response from <code>/metrics/application</code>:"
>{
  "cardCount": 0,
  "io.helidon.examples.quickstart.mp.GreetingCardsAppMetrics.appUpTimeSeconds": 6 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The application has been running for 6 seconds.</li>
</ul>

</div>

</div>


<h3 id="example-configuration">Example Configuration</h3>
<div class="section">
<p>Metrics configuration is quite extensive and powerful and, therefore, a bit complicated.
The rest of this section illustrates some of the most common scenarios:</p>

<ul class="ulist">
<li>
<p><router-link to="#config-disable" @click.native="this.scrollFix('#config-disable')">Disable metrics entirely.</router-link></p>

</li>
<li>
<p><router-link to="#config-selective" @click.native="this.scrollFix('#config-selective')">Selectively enable or disable metrics by metric registry type and, within type, by name.</router-link></p>

</li>
<li>
<p><router-link to="#config-kpi" @click.native="this.scrollFix('#config-kpi')">Choose whether to collect extended key performance indicator metrics.</router-link></p>

</li>
<li>
<p><router-link to="#config-rest-request" @click.native="this.scrollFix('#config-rest-request')">Control <code>REST.request</code> metrics collection.</router-link></p>

</li>
</ul>


<h4 id="config-disable">Disable Metrics Subsystem</h4>
<div class="section">
<markup
lang="properties"
title="Disabling metrics entirely"
>metrics.enabled=false</markup>

<p>Helidon does not update metrics, and the <code>/metrics</code> endpoints respond with <code>404</code> plus a message that the metrics subsystem is disabled.</p>

</div>


<h4 id="config-selective">Disable Selected Metrics</h4>
<div class="section">
<p>You can be even more selective. Within a registry type you can configure up to two regular expression patterns:</p>

<ul class="ulist">
<li>
<p>one matching metric names to <em>exclude</em>, and</p>

</li>
<li>
<p>one matching metric names to <em>include</em>.</p>

</li>
</ul>

<p>Helidon updates and reports a metric only if two conditions hold:</p>

<ul class="ulist">
<li>
<p>the metric name <em>does not</em> match the <code>exclude</code> regex pattern (if you define one), and</p>

</li>
<li>
<p>either</p>
<ul class="ulist">
<li>
<p>there is no <code>include</code> regex pattern, or</p>

</li>
<li>
<p>the metric name matches the <code>include</code> pattern.</p>

</li>
</ul>

</li>
</ul>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>Make sure any <code>include</code> regex pattern you specify matches <em>all</em> the metric names you want to capture.</p>
</p>
</div>

<p>Suppose your application creates and updates a group of metrics with names such as <code>myapp.xxx.queries</code>, <code>myapp.xxx.creates</code>, <code>myapp.xxx.updates</code>, and <code>myapp.xxx.deletes</code> where <code>xxx</code> can be either <code>supplier</code> or <code>customer</code>.</p>

<p>The following example gathers all metrics <em>except</em> those from your application regarding suppliers <em>although</em> supplier updates are <em>included</em>:</p>

<markup
lang="properties"
title="Disabling and enabling metrics by name"
>metrics.registries.0.type=application
metrics.registries.0.application.filter.exclude=myapp\.supplier\..*
metrics.registries.0.application.filter.include=myapp\.supplier\.updates</markup>

<p>This setting excludes metrics with names starting with <code>myapp.supplier</code> <em>except</em> for the metric <code>myapp.supplier.updates</code>. The <code>exclude</code> and <code>include</code> values are regular expressions.</p>

</div>


<h4 id="config-kpi">Collecting Basic and Extended Key Performance Indicator (KPI) Metrics</h4>
<div class="section">
<p>Any time you include the Helidon metrics module in your application, Helidon tracks two basic performance indicator metrics:</p>

<ul class="ulist">
<li>
<p>a <code>Counter</code> of all requests received (<code>requests.count</code>), and</p>

</li>
<li>
<p>a <code>Meter</code> of all requests received (<code>requests.meter</code>).</p>

</li>
</ul>

<p>Helidon MP also includes additional, extended KPI metrics which are disabled by default:</p>

<ul class="ulist">
<li>
<p>current number of requests in-flight - a <code>ConcurrentGauge</code> (<code>requests.inFlight</code>) of requests currently being processed</p>

</li>
<li>
<p>long-running requests - a <code>Meter</code> (<code>requests.longRunning</code>) measuring the rate at which Helidon processes requests which take at least a given amount of time to complete; configurable, defaults to 10000 milliseconds (10 seconds)</p>

</li>
<li>
<p>load - a <code>Meter</code> (<code>requests.load</code>) measuring the rate at which requests are worked on (as opposed to received)</p>

</li>
<li>
<p>deferred - a <code>Meter</code> (<code>requests.deferred</code>) measuring the rate at which a request&#8217;s processing is delayed after Helidon receives the request</p>

</li>
</ul>

<p>You can enable and control these metrics using configuration:</p>

<markup
lang="properties"
title="Controlling extended KPI metrics"
>metrics.key-performance-indicators.extended = true
metrics.key-performance-indicators.long-running.threshold-ms = 2000</markup>

</div>


<h4 id="config-rest-request">Enable <code>REST.request</code> Metrics</h4>
<div class="section">
<markup
lang="properties"
title="Controlling REST request metrics"
>metrics.rest-request-enabled=true</markup>

<p>Helidon automatically registers and updates <code>SimpleTimer</code> metrics for every REST endpoint in your service.</p>

</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_integration_with_kubernetes_and_prometheus">Integration with Kubernetes and Prometheus</h3>
<div class="section">

<h4 id="_kubernetes_integration">Kubernetes Integration</h4>
<div class="section">
<p>The following example shows how to integrate the Helidon MP application with Kubernetes.</p>

<markup
lang="bash"
title="Stop the application and build the docker image:"
>docker build -t helidon-metrics-mp .</markup>

<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>metrics.yaml</code>, with the following content:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-metrics <span class="conum" data-value="1" />
  labels:
    app: helidon-metrics
  annotations:
    prometheus.io/scrape: true <span class="conum" data-value="2" />
spec:
  type: NodePort
  selector:
    app: helidon-metrics
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-metrics
spec:
  replicas: 1 <span class="conum" data-value="3" />
  selector:
    matchLabels:
      app: helidon-metrics
  template:
    metadata:
      labels:
        app: helidon-metrics
        version: v1
    spec:
      containers:
        - name: helidon-metrics
          image: helidon-metrics-mp
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">An annotation that will allow Prometheus to discover and scrape the application pod.</li>
<li data-value="3">A deployment with one replica of a pod.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./metrics.yaml</markup>

<markup
lang="bash"
title="Get the service information:"
>kubectl get service/helidon-metrics</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-metrics   NodePort   10.99.159.2   &lt;none&gt;        8080:31143/TCP   8s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>31143</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the metrics endpoint using port <code>30116</code>, your port will likely be different:"
>curl http://localhost:31143/metrics</markup>

<div class="admonition note">
<p class="admonition-inline">Leave the application running in Kubernetes since it will be used for Prometheus integration.</p>
</div>

</div>


<h4 id="_prometheus_integration">Prometheus Integration</h4>
<div class="section">
<p>The metrics service that you just deployed into Kubernetes is already annotated with <code>prometheus.io/scrape:</code>.  This will allow
Prometheus to discover the service and scrape the metrics.  This example shows how to install Prometheus
into Kubernetes, then verify that it discovered the Helidon metrics in your application.</p>

<markup
lang="bash"
title="Install Prometheus and wait until the pod is ready:"
>helm install stable/prometheus --name metrics
export POD_NAME=$(kubectl get pods --namespace default -l "app=prometheus,component=server" -o jsonpath="{.items[0].metadata.name}")
kubectl get pod $POD_NAME</markup>

<p>You will see output similar to the following.  Repeat the <code>kubectl get pod</code> command until you see <code>2/2</code> and <code>Running</code>. This may take up to one minute.</p>

<markup
lang="bash"

>metrics-prometheus-server-5fc5dc86cb-79lk4   2/2     Running   0          46s</markup>

<markup
lang="bash"
title="Create a port-forward so you can access the server URL:"
>kubectl --namespace default port-forward $POD_NAME 7090:9090</markup>

<p>Now open your browser and navigate to <code><a target="_blank" href="http://localhost:7090/targets" class="bare">http://localhost:7090/targets</a></code>.  Search for helidon on the page and you will see your
Helidon application as one of the Prometheus targets.</p>

</div>


<h4 id="_final_cleanup">Final Cleanup</h4>
<div class="section">
<p>You can now delete the Kubernetes resources that were just created during this example.</p>

<markup
lang="bash"
title="Delete the Prometheus Kubernetes resources:"
>helm delete --purge metrics</markup>

<markup
lang="bash"
title="Delete the application Kubernetes resources:"
>kubectl delete -f ./metrics.yaml</markup>

</div>

</div>


<h3 id="_references">References</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/microprofile-metrics-spec-4.0.html">MicroProfile Metrics specification</a></p>

<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/apidocs/org/eclipse/microprofile/metrics/package-info.html">MicroProfile Metrics API</a></p>

</div>

</div>

</doc-view>
