<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>JSON Web Tokens (JWT) are an open, industry standard <a target="_blank" href="https://datatracker.ietf.org/doc/html/rfc7519">(RFC 7519)</a> method for representing claims securely between two parties.</p>

<p>JSON Web Token defines a compact and self-contained way for securely transmitting information between parties as a JSON object. With JWT Auth you can integrate security features such as single sign on into your Helidon MP applications.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable JWT Authentication
either add a dependency on the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.jwt&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-jwt-auth&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>The main configuration point for JWT Auth is a JAX-RS Application class.
As this class is discovered using CDI, it must have a bean defining annotation.</p>

<p>Minimal required setup is done using <code>@LoginConfig(authMethod = "MP-JWT")</code>:</p>

<markup
lang="java"

>@LoginConfig(authMethod = "MP-JWT")
@ApplicationScoped
public class ProtectedApplication extends Application{
}</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The following interfaces and annotations are used to work with JWT in Helidon MP:</p>

<ul class="ulist">
<li>
<p><code>JsonWebToken</code> - an interface used in CDI beans <em>(@RequestScoped)</em> dependency injection to obtain the JWT of the currently executing caller.</p>

</li>
<li>
<p><code>@Claim</code> - an annotation used by CDI bean <em>(@RequestScoped)</em>  dependency injection to obtain individual claims from the caller’s JWT.</p>

</li>
<li>
<p><code>ClaimValue</code> - a proxy interface used with <code>@Claim</code> annotation to оbtain the value of a claim by calling <code>getValue()</code>.</p>

</li>
</ul>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">

<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>MicroProfile configuration options:</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>mp.jwt.verify.publickey</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The property allows the Public Verification Key text itself to be supplied as a string.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.publickey.location</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The property allows for an external or internal location of Public Verification Key to be specified. The value may be a relative path or a URL.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.jwt.verify.publickey.algorithm</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The  configuration property allows for specifying which Public Key Signature Algorithm is supported by the MP JWT endpoint. This property can be set to either <code>RS256</code> or <code>ES256</code>. Default value is <code>RS256</code>. Support for the other asymmetric signature algorithms such as <code>RS512</code>, <code>ES512</code> and others is optional.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Optional configuration options:</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>optional</code></td>
<td class="">boolean</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>If set to <code>true</code>, failure to authenticate will return <code>ABSTAIN</code> result instead of <code>FAILURE</code>. This is
an important distinction when more than one provider is used</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticate</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to attempt authentication</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagate</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to attempt identity propagation/JWT creation</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class="">string</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Whether we authenticate a user or a service (other option is SERVICE)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A group for configuring authentication of the request</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.verify-signature</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to verify signature in incoming JWT. If disabled, <em>ANY</em> JWT will be accepted</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwt-audience</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Expected audience of the JWT. If not defined, any audience is accepted (and we may accept JWT not inteded for us)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.jwk.resource.*</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of the JWK to obtain key(s) to validate signatures of inbound token. The JWK should contain public keys. This may be: jwk.resource.path, jwk.resource.resource-path, jwk.resource.url, jwk.resource.content-plain (actual JSON string), jwk.resource.content (base64)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler</code></td>
<td class="">string</td>
<td class=""><code>Authorization</code> header with `bearer ` prefix</td>
<td class=""><doc-view>
<p>A handler configuration for inbound token - e.g. how to extract it</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler.header</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of a header the token is expected in</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler.prefix</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Prefix before the token value (optional)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>atn-token.handler.regexp</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Regular expression to obtain the token, first matching group is used (optional)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A group for configuring outbound security</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-token.jwk.resource.*</code></td>
<td class="">&#160;</td>
<td class="">Configuration of the JWK to use when generating tokens (follows same rules as atn-token.jwk above), this JWK must contain private keys when using asymmetric ciphers</td>
<td class=""><doc-view>
<p><code>sign-token.jwt-issuer</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">When we issue a new token, this is the issuer to be placed into it (validated by target service)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">A group for configuring outbound rules (based on transport, host and.or path)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.name</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">A short descriptive name for configured target service(s)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.transports</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">any</td>
<td class="">An array of transports this outbound matches (e.g. https)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.hosts</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">any</td>
<td class="">An array of hosts this outbound matches, may use * as a wild-card (e.g. *.oracle.com)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.paths</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">any</td>
<td class="">An array of paths on the host this outbound matches, may use * as a wild-card (e.g. /some/path/*)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.outbound-token</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class=""><code>Authorization</code> header with `bearer ` prefix</td>
<td class="">Configuration of outbound token handler (same as atn-token.handler)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.outbound-token.format</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Java text format for generating the value of outbound token header (e.g. "bearer %1$s")</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.jwk-kid</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">If this key is defined, we are generating a new token, otherwise we propagate existing. Defines the key id of a key definition in the JWK file to use for signing the outbound token</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.jwt-kid</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">A key to use in the generated JWT - this is for the other service to locate the verification key in their JWK</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.jwt-audience</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Audience this key is generated for (e.g. <a target="_blank" href="http://www.example.org/api/myService" class="bare">http://www.example.org/api/myService</a>) - validated by the other service</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.jwt-not-before-seconds</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class="">string</td>
<td class=""><code>5</code></td>
<td class="">Makes this key valid this amount of seconds into the past. Allows a certain time-skew for the generated token to be valid before current time (e.g. when we expect a certain misalignment of clocks)</td>
<td class=""><doc-view>
<p><code>sign-token.outbound.*.jwt-validity-seconds</code></p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>A configuration example in <code>microprofile-config.properties</code>:</p>

<markup
lang="properties"

>mp.jwt.verify.issuer=https://{PublicIssuerDomain}/oauth2/default
mp.jwt.verify.publickey.location=${mp.jwt.verify.issuer}/v1/keys</markup>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<markup
lang="java"

>@Path("/hello")
public class HelloResource {

    @GET
    @Produces(TEXT_PLAIN)
    public String hello(@Context SecurityContext context) {
        Optional&lt;Principal&gt; userPrincipal = context.userPrincipal();
        return "Hello, " + userPrincipal.get().getName() + "!";
    }
}</markup>

<p>Do not forget to annotate the <code>HelloApplication</code> class to enable JWT:</p>

<markup
lang="java"

>@LoginConfig(authMethod = "MP-JWT")
@ApplicationScoped
public class HelloApplication extends Application {

    @Override
    public Set&lt;Class&lt;?&gt;&gt; getClasses() {
        return Set.of(HelloResource.class);
    }
}</markup>

<p>Add the following configuration in <code>microprofile-config.properties</code>:</p>

<markup
lang="properties"

>mp.jwt.verify.issuer=https://{IssuerPublicDomain}/oauth2/default
mp.jwt.verify.publickey.location=${mp.jwt.verify.issuer}/v1/keys</markup>

<p>Obtain the Security Token from external issuer:</p>

<markup
lang="bash"

>TOKEN=sdf4dDSWFcswdsffDSasEgv...</markup>

<p>Run the application and execute an http request against it:</p>

<markup
lang="bash"

>curl -X GET -I -H "Authorization: Bearer $TOKEN" http://localhost:8080/hello</markup>

<p>The result should be:</p>

<markup
lang="bash"

>HTTP/1.1 200 OK
Date: 08.06.2022 10:33:47 EEST
connection: keep-alive
content-length: 28

Hello, secure@helidon.io!</markup>

<p>which means that the request successfully passed authentication.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>Learn more about JWT authentication at:<br>

<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-jwt-auth-2.0#_introduction">Eclipse MicroProfile Interoperable JWT RBAC</a></p>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-jwt-auth-2.0/microprofile-jwt-auth-spec-2.0.html">MicroProfile JWT Auth Spec</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/eclipse/microprofile-jwt-auth">MicroProfile JWT Auth GitHub Repository</a></p>

</li>
</ul>

</div>

</doc-view>
