<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_references" @click.native="this.scrollFix('#_references')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Neo4j is a graph database management system developed by Neo4j, Inc. It is an ACID-compliant transactional database with native graph storage and processing. Neo4j is available in a GPL3-licensed open-source “community edition”.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Neo4j
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-integrations-neo4j&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<div class="admonition note">
<p class="admonition-inline">Check <router-link to="#_neo4j_metrics_propagation" @click.native="this.scrollFix('#_neo4j_metrics_propagation')">Neo4j Metrics propagation</router-link> and <router-link to="#_neo4j_health_checks" @click.native="this.scrollFix('#_neo4j_health_checks')">Neo4j Health Checks</router-link> for additional dependencies for <em>Neo4j</em> <code>Metrics</code> and <code>Health Checks</code> integration.</p>
</div>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>The support for Neo4j is implemented in Neo4j driver level. Just add the dependency, add configuration in <code>microprofile-config.properties</code> file and Neo4j driver will be configured by Helidon and can be injected using CDI.</p>

<p>First describe Neo4j connection properties:</p>

<markup
lang="properties"

># Neo4j settings
neo4j.uri=bolt://localhost:7687
neo4j.authentication.username=neo4j
neo4j.authentication.password: secret
neo4j.pool.metricsEnabled: true</markup>

<p>Then just inject the driver:</p>

<markup
lang="java"

>@Inject
public MovieRepository(Driver driver) {
   this.driver = driver;
}</markup>

<p>The driver can be used according to the <a target="_blank" href="https://neo4j.com/developer/java/">Neo4j documentation</a>.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>MicroProfile configuration options:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>mp.jwt.verify.publickey</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">The property allows the Public Verification Key text itself to be supplied as a string.</td>
</tr>
<tr>
<td class=""><code>authentication.username</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Neo4j authentication user name</td>
</tr>
<tr>
<td class=""><code>authentication.password</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Neo4j authentication password</td>
</tr>
<tr>
<td class=""><code>authentication.enabled</code></td>
<td class="">boolean</td>
<td class="">TRUE</td>
<td class="">If Neo4j authentication is enabled</td>
</tr>
<tr>
<td class=""><code>encrypted</code></td>
<td class="">boolean</td>
<td class="">FALSE</td>
<td class="">If Neo4j encryption is enabled</td>
</tr>
<tr>
<td class=""><code>pool.metricsEnabled</code></td>
<td class="">boolean</td>
<td class="">FALSE</td>
<td class="">If Neo4J metrics is enabled</td>
</tr>
<tr>
<td class=""><code>pool.logLeakedSessions</code></td>
<td class="">boolean</td>
<td class="">&#160;</td>
<td class="">Log leaking sessions</td>
</tr>
<tr>
<td class=""><code>pool.maxConnectionPoolSize</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Maximum connection pool size</td>
</tr>
<tr>
<td class=""><code>pool.idleTimeBeforeConnectionTest</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Idle time before connection test</td>
</tr>
<tr>
<td class=""><code>pool.maxConnectionLifetime</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Connection lifetime in seconds</td>
</tr>
<tr>
<td class=""><code>pool.connectionAcquisitionTimeout</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Connection Acquisition Timeout</td>
</tr>
<tr>
<td class=""><code>trustsettings.trustStrategy</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Trust Strategy: Trust All certificates, <code>TRUST_ALL_CERTIFICATES</code>, Trust custom certificates -
<code>TRUST_CUSTOM_CA_SIGNED_CERTIFICATES</code>, Trust system CA - <code>TRUST_SYSTEM_CA_SIGNED_CERTIFICATES</code></td>
</tr>
<tr>
<td class=""><code>trustsettings.certificate</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Path to trusted certificate</td>
</tr>
<tr>
<td class=""><code>trustsettings.hostnameVerificationEnabled</code></td>
<td class="">string</td>
<td class="">FALSE</td>
<td class="">If hostname verification is enabled.</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>This example implements a simple Neo4j REST service using MicroProfile. For this example a working Neo4j database is required. The Neo4j Movie database is used for this example.</p>

<p>Bring up a Neo4j instance via Docker</p>

<markup
lang="bash"

>docker run --publish=7474:7474 --publish=7687:7687 -e 'NEO4J_AUTH=neo4j/secret'  neo4j:latest</markup>

<p>Go to the Neo4j browser and play the first step of the movies graph: <a target="_blank" href="http://localhost:7474/browser/?cmd=play&amp;arg=movies"><code>:play movies</code></a></p>

<p>Now go to the <code>pom.xml</code> and add the following dependencies:</p>

<markup
lang="xml"

> &lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-neo4j&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-neo4j-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-neo4j-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Next add the connection configuration properties for Neo4j:</p>

<markup
lang="properties"

># Neo4j settings
neo4j.uri=bolt://localhost:7687
neo4j.authentication.username=neo4j
neo4j.authentication.password: secret
neo4j.pool.metricsEnabled: true

# Enable the optional MicroProfile Metrics REST.request metrics
metrics.rest-request.enabled=true</markup>

<p>This includes both connection information and enables Neo4j metrics propagation.</p>

<p>Finally, we are able to inject and use the <code>Neo4j</code> driver.</p>

<markup
lang="java"

>@ApplicationScoped
public class MovieRepository {

    private final Driver driver;

    @Inject
    public MovieRepository(Driver driver) { <span class="conum" data-value="1" />
        this.driver = driver;
    }

    public List&lt;Movie&gt; findAll() { <span class="conum" data-value="2" />

        try (var session = driver.session()) {

            var query = ""
                    + "match (m:Movie) "
                    + "match (m) &lt;- [:DIRECTED] - (d:Person) "
                    + "match (m) &lt;- [r:ACTED_IN] - (a:Person) "
                    + "return m, collect(d) as directors, collect({name:a.name, roles: r.roles}) as actors";

            return session.readTransaction(tx -&gt; tx.run(query).list(r -&gt; {
                var movieNode = r.get("m").asNode();

                var directors = r.get("directors").asList(v -&gt; {
                    var personNode = v.asNode();
                    return new Person(personNode.get("born").asInt(), personNode.get("name").asString());
                });

                var actors = r.get("actors").asList(v -&gt; {
                    return new Actor(v.get("name").asString(), v.get("roles").asList(Value::asString));
                });

                var m = new Movie(movieNode.get("title").asString(), movieNode.get("tagline").asString());
                m.setReleased(movieNode.get("released").asInt());
                m.setDirectorss(directors);
                m.setActors(actors);
                return m;
            }));
        }
    }
}</markup>

<ul class="colist">
<li data-value="1"><code>Neo4j</code> driver constructor injection</li>
<li data-value="2">Use of <code>Neo4j</code> driver to extract all Movies</li>
</ul>

<p>Movies can now be returned as JSON objects:</p>

<markup
lang="java"

>@GET
@Produces(MediaType.APPLICATION_JSON)
public List&lt;Movie&gt; getAllMovies() {
    return movieRepository.findAll();
}</markup>

<p>Now build and run with JDK17+</p>

<markup
lang="bash"

>mvn package
java -jar target/helidon-examples-integration-neo4j-mp.jar</markup>

<p>Exercise the application:</p>

<markup
lang="bash"

>curl -X GET http://localhost:8080/movies
{. . .}

# Try health and metrics

curl -s -X GET http://localhost:8080/health
{"outcome":"UP",...
. . .

# Prometheus Format
curl -s -X GET http://localhost:8080/metrics
# TYPE base:gc_g1_young_generation_count gauge
. . .

# JSON Format
curl -H 'Accept: application/json' -X GET http://localhost:8080/metrics
{"base":...
. . .</markup>

<p>Full example code is available in <a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/integrations/neo4j/neo4j-mp">Helidon GitHub Repository</a>.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_neo4j_metrics_propagation">Neo4j Metrics propagation</h3>
<div class="section">
<p>Neo4j metrics can be propagated to the user as <code>MicroProfile</code> metrics. This is implemented in a separate Maven module. Just add</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-integrations-neo4j-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<div class="admonition note">
<p class="admonition-inline">Works with <em>Neo4j Integration</em> main dependency described in <router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link>.</p>
</div>

<p>To enable metrics in Neo4j, add the following property to <code>microprofile-config.properties</code>:</p>

<markup
lang="properties"

>neo4j.pool.metricsEnabled=true</markup>

<p>By applying these two actions, Neo4j metrics will be automatically added to the output of the <code>/metrics</code> endpoint.</p>

</div>


<h3 id="_neo4j_health_checks">Neo4j Health Checks</h3>
<div class="section">
<p>If your application is highly dependent on Neo4j database, health and liveness checks are essential for this application to work correctly.</p>

<p><code>MicroProfile</code> Health checks for Neo4j are implemented in a separate Maven module:</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-integrations-neo4j-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<div class="admonition note">
<p class="admonition-inline">Works with <em>Neo4j Integration</em> main dependency described in <router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link>.</p>
</div>

<p>Health checks for Neo4j will be included in <code>/health</code> endpoint output.</p>

</div>

</div>


<h2 id="_references">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://neo4j.com/">Neo4j official website</a></p>

</li>
<li>
<p><a target="_blank" href="https://neo4j.com/developer/java/">Neo4j Java developer guide</a></p>

</li>
</ul>

</div>

</doc-view>
