<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_references" @click.native="this.scrollFix('#_references')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p><a target="_blank" href="https://github.com/xetorthio/jedis">Jedis</a> is a Java client for <a target="_blank" href="https://github.com/redis/redis">Redis</a>.</p>

<p>This <a target="_blank" href="https://jakarta.ee/specifications/cdi/3.0/jakarta-cdi-spec-3.0.html#spi">CDI portable extension</a> provides support for
injecting Jedis clients in your Helidon MicroProfile applications.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Jedis
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.cdi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-cdi-jedis&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>After you have added the above dependency to your project you can inject
a Jedis client in your application. The following examples show how to create
and inject a Jedis pool named <code>orders</code> in your application code.</p>

<markup
lang="java"
title="Field-injection example"
> @Inject
 @Named("orders")
 private JedisPool ordersPool;</markup>

<markup
lang="java"
title="Constructor-injection example"
> private final JedisPool ordersPool;
 @Inject
 public YourConstructor(@Named("orders") JedisPool pool) {
   super();
   this.ordersPool = pool;
 }</markup>

<p>Helidon implements this injection point by creating a
<a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/jedis/JedisPool.html">JedisPool</a> object in the
<a target="_blank" href="https://jakarta.ee/specifications/cdi/3.0/apidocs//jakarta/enterprise/context/ApplicationScoped.html">application scope</a>.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>You can configure the object using <router-link to="/mp/config/introduction">MicroProfile config</router-link>.
For example, the Jedis pool created above can be configured as follows:</p>

<markup
lang="properties"
title="META-INF/microprofile-config.properties"
>redis.clients.jedis.JedisPool.orders.port=6379</markup>

<p>The Jedis client can be configured using the following properties.</p>

<p>Property names that start with
<code>redis.clients.jedis.JedisPoolConfig.instanceName.</code> are parsed, and
the remaining portion of each name is treated as a Java Bean property
of <a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/jedis/JedisPoolConfig.html"><code>JedisPoolConfig</code></a>.  Because
the <code>JedisPoolConfig</code> class inherits from
<a target="_blank" href="https://commons.apache.org/proper/commons-pool/apidocs/org/apache/commons/pool2/impl/GenericObjectPoolConfig.html">Apache
commons-pool&#8217;s <code>GenericObjectPoolConfig</code></a> class and from
<a target="_blank" href="https://commons.apache.org/proper/commons-pool/apidocs/org/apache/commons/pool2/impl/BaseObjectPoolConfig.html">Apache commons-pool&#8217;s
<code>BaseObjectPoolConfig</code></a> class, those writable Java Bean properties are
available as well.</p>

<p>Accordingly, the <code>JedisPoolConfig</code> Java Bean properties that can be
set are as follows, where <code>instanceName</code> should be replaced with the
actual name used in application code:</p>


<div class="table__overflow elevation-1  flex md7
">
<table class="datatable table">
<colgroup>
<col style="width: 100%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.blockWhenExhausted</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.evictionPolicyClassName</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.fairness</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.jmxEnabled</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.jmxNameBase</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.jmxNamePrefix</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.lifo</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.maxIdle</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.maxTotal</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.maxWaitMillis</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.minEvictableTimeMillis</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.minIdle</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.numTestsPerEvictionRun</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.softMinEvictableIdleTimeMillis</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.testOnBorrow</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.testOnCreate</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.testOnReturn</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.testWhileIdle</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPoolConfig.instanceName.timeBetweenEvictionRunsMillis</code></td>
</tr>
</tbody>
</table>
</div>

<p>Any documentation for these properties that exists may be found in the
javadocs for the
<a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/jedis/JedisPoolConfig.html"><code>JedisPoolConfig</code></a>,
<a target="_blank" href="https://commons.apache.org/proper/commons-pool/apidocs/org/apache/commons/pool2/impl/GenericObjectPoolConfig.html"><code>GenericObjectPoolConfig</code></a>
and
<a target="_blank" href="https://commons.apache.org/proper/commons-pool/apidocs/org/apache/commons/pool2/impl/BaseObjectPoolConfig.html"><code>BaseObjectPoolConfig</code></a>
classes.</p>

<p>Property names that start with
<code>redis.clients.jedis.JedisPool.instanceName.</code> are parsed, and the
remaining portion of each name is treated as a Java Bean property of
<a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/jedis/JedisPool.html"><code>JedisPool</code></a>, or as a primitive value
accepted by <a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/jedis/JedisPool.html#JedisPool-org.apache.commons.pool2.impl.GenericObjectPoolConfig-java.lang.String-int-int-java.lang.String-int-boolean-javax.net.ssl.SSLSocketFactory-javax.net.ssl.SSLParameters-javax.net.ssl.HostnameVerifier-">its constructor</a>.  Because the
<code>JedisPool</code> class inherits from the <a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/util/Pool.html"><code>Pool</code></a> class, its writable Java Bean
properties are available as well.</p>

<p>Accordingly, the <code>JedisPool</code> properties that can be set are as
follows, where <code>instanceName</code> should be replaced with the actual named
used in application code:</p>


<div class="table__overflow elevation-1  flex md7
">
<table class="datatable table">
<colgroup>
<col style="width: 100%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.clientName</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.connectionTimeout</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.database</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.host</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.password</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.port</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.socketTimeout</code></td>
</tr>
<tr>
<td class=""><code>redis.clients.jedis.JedisPool.instanceName.ssl</code></td>
</tr>
</tbody>
</table>
</div>

<p>Any documentation for these properties that exists may be found in the
javadocs for the <a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/jedis/JedisPool.html"><code>JedisPool</code></a> and
<a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/util/Pool.html"><code>Pool</code></a> classes.</p>

<p>Injection without a <code>@Named</code> annotation is also possible:</p>

<markup
lang="java"

> @Inject
 private JedisPool ordersPool;</markup>

<p>In this case, the properties for JedisPoolConfig and JedisPool that can be set will start
with <code>redis.clients.jedis.JedisPoolConfig.default</code> and <code>redis.clients.jedis.JedisPool.default</code> respectively.</p>

</div>


<h2 id="_references">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/integrations/cdi/jedis">Helidon Jedis Example</a></p>

</li>
<li>
<p><a target="_blank" href="https://www.javadoc.io/static/redis.clients/jedis/2.9.0/redis/clients/jedis/package-summary.html">Jedis Javadoc</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/xetorthio/jedis">Jedis</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/redis/redis">Redis</a></p>

</li>
</ul>

</div>

</doc-view>
