<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Performance Tuning</dt>
<dd slot="desc"><p>In this guide you fill find basic advice for performance tuning of your Helidon application. Most of them target Netty tuning, as Helidon is based on it.
You should also consider configuring/tuning Java heap size as per any Java application.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_use_io_helidon_microprofile_bundleshelidon_microprofile_core">Use <code>io.helidon.microprofile.bundles:helidon-microprofile-core</code></h2>
<div class="section">
<p>Use <code>helidon-microprofile-core</code> dependency (and not the <code>helidon-microprofile</code> dependency) and add only what you use. For example:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.bundles&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-core&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-health&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.reactive.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-reactive-media-jsonp&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_configure_netty_worker_thread_pool_size">Configure Netty worker thread pool size</h2>
<div class="section">
<p>The Netty worker thread-pool is what handles your incoming requests. It defaults to 2*NCPU. To set it to something else you can set this property in <code>microprofile-config.properties</code>:</p>

<markup
lang="properties"

>server.worker-count=4</markup>


<h3 id="_configure_helidon_server_pool_size">Configure Helidon server pool size</h3>
<div class="section">
<p>The Helidon server thread-pool takes requests from Netty and invokes your JAX-RS endpoints.  You can control lts configuration in <code>microprofile-config.properties</code>. This is Helidon MP specific only.</p>

<markup
lang="properties"

>server.executor-service.core-pool-size: 2
server.executor-service.max-pool-size: 4</markup>

<p>To verify settings increase the log level for Helidon&#8217;s executor service by adding this to your <code>logging.properties</code>:</p>

<markup
lang="properties"

>io.helidon.common.configurable.ThreadPool.level=FINE</markup>

</div>


<h3 id="_configure_nettys_maxorder_helidon_2_4_1_or_earlier">Configure Netty&#8217;s maxOrder (Helidon 2.4.1 or earlier)</h3>
<div class="section">
<p>In some situations Netty can aggressively allocate memory per request. This has been addressed in recent versions of Helidon and Netty, but if you are running an earlier version set this system property when you start your Helidon application:</p>

<markup


>-Dio.netty.allocator.maxOrder=6</markup>

<p>You can try smaller numbers.</p>

</div>

</div>

</doc-view>
