<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon MP 3.x Upgrade Guide</dt>
<dd slot="desc"><p>In Helidon 3.x we have made some changes to APIs and runtime behavior. This guide
will help you upgrade a Helidon MP 2.x application to 3.x.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_java_17_runtime">Java 17 Runtime</h2>
<div class="section">
<p>Java 11 is no longer supported in Helidon 3. Java 17 or newer is required. Please follow the instructions in <router-link to="/about/prerequisites">Prerequisites</router-link> for proper installation.</p>

</div>


<h2 id="_javax_namespace_to_jakarta_namespace">javax.* namespace to jakarta.* namespace</h2>
<div class="section">
<p>Helidon 3 supports MicroProfile 5.0  and <em>selected</em> Jakarta EE 9.1 APIs. In Jakarta EE 9.1 the Java package namespace was changed from <code>javax</code> to <code>jakarta</code>. Therefore, you must change your application to use <code>jakarta</code> instead of corresponding <code>javax</code> for Jakarta EE packages.</p>

<p>In version 3.x Helidon supports MicroProfile 5.0  specification, which now is fully migrated to <code>jakarta</code> namespace.</p>

<p>As a result, <code>javax</code> module is no longer in dependency management of Helidon parent pom files.</p>

</div>


<h2 id="_microprofile_5_0_support">MicroProfile 5.0  support</h2>
<div class="section">
<p>MicroProfile 5.0  enables MicroProfile APIs to be used together with Jakarta EE 9.1 (Jakarta EE namespace). This release was mainly focused on updating dependencies from <code>javax</code> to <code>jakarta</code>, as well as overall stability and usability improvements.</p>

<p>MicroProfile 5.0  lays the foundation for the rapid innovation of MicroProfile APIs for its 2022 releases.</p>

<p>MicroProfile 5.0  is an umbrella for the following specifications and their corresponding versions:</p>

<ul class="ulist">
<li>
<p>MicroProfile Config 3.0.1</p>

</li>
<li>
<p>MicroProfile Fault Tolerance 4.0</p>

</li>
<li>
<p>MicroProfile Health 4.0</p>

</li>
<li>
<p>MicroProfile JWT Authentication 2.0</p>

</li>
<li>
<p>MicroProfile Metrics 4.0</p>

</li>
<li>
<p>MicroProfile OpenAPI 3.0</p>

</li>
<li>
<p>MicroProfile OpenTracing 3.0</p>

</li>
<li>
<p>MicroProfile Rest Client 3.0</p>

</li>
</ul>

<p>Helidon 3.x supports the following Jakarta EE specifications:</p>

<ul class="ulist">
<li>
<p>CDI (Jakarta Contexts and Dependency Injection) 3.0</p>

</li>
<li>
<p>JAX-RS (Jakarta RESTful Web Services) 3.0</p>

</li>
<li>
<p>JSON-B (Jakarta JSON Binding) 2.0</p>

</li>
<li>
<p>JSON-P (Jakarta JSON Processing) 2.0.1</p>

</li>
<li>
<p>Jakarta Annotations 2.0</p>

</li>
<li>
<p>Jakarta Persistence API 3.0</p>

</li>
<li>
<p>Jakarta Transactions API 2.0</p>

</li>
<li>
<p>Jakarta WebSocket API 2.0</p>

</li>
<li>
<p>Jakarta Bean Validation 2.0</p>

</li>
</ul>

<p>Corresponding changes to Helidon code were made to support the corresponding specifications' versions.</p>


<h3 id="_incompatible_changes_for_each_specification">Incompatible changes for each specification</h3>
<div class="section">
<p>Migration from <code>javax</code> to <code>jakarta</code> namespace is making this release backward incompatible with previous version of MicroProfile. For each specification there are also API and functional changes, described below.</p>


<h4 id="_microprofile_specifications">MicroProfile specifications</h4>
<div class="section">
<ul class="ulist">
<li>
<p><strong>MicroProfile Config 3.0.1</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-config-3.0.1/microprofile-config-spec-3.0.1.html#_incompatible_changes">MicroProfile Config 3.0.1 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Fault Tolerance 4.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-fault-tolerance-4.0/microprofile-fault-tolerance-spec-4.0.html#_backward_incompatible_changes=">MicroProfile Fault Tolerance 4.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Health 4.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-health-4.0/microprofile-health-spec-4.0.html#_incompatible_changes">MicroProfile Health 4.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile JWT Authentication 2.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-jwt-auth-2.0/microprofile-jwt-auth-spec-2.0.html#_incompatible_changes">MicroProfile JWT Authentication 2.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Metrics 4.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-4.0/microprofile-metrics-spec-4.0.html#_incompatible_changes">MicroProfile Metrics 4.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile OpenAPI 3.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-2.0.1/microprofile-openapi-spec-2.0.1.html#_incompatible_changes">MicroProfile OpenAPI 3.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile OpenTracing 3.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-opentracing-3.0/microprofile-opentracing-spec-3.0.html#_incompatible_changes">MicroProfile OpenTracing 3.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Rest Client 3.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-rest-client-3.0/microprofile-rest-client-spec-3.0.html#_incompatible_changes">MicroProfile Rest Client 3.0 Specification</a></p>

</li>
</ul>

</div>

</div>


<h3 id="_supported_jakarta_ee_specifications">Supported Jakarta EE specifications</h3>
<div class="section">
<ul class="ulist">
<li>
<p><strong>CDI (Jakarta Contexts and Dependency Injection) 3.0</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/cdi/3.0/jakarta-cdi-spec-3.0.html#architecture">CDI (Jakarta Contexts and Dependency Injection) 3.0 Specification</a></p>

</li>
<li>
<p><strong>JAX-RS (Jakarta RESTful Web Services) 3.0</strong>:</p>
<p>Moved to <code>jakarta</code> namespace. Changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-rest-client-3.0/microprofile-rest-client-spec-3.0.html#_incompatible_changes">JAX-RS (Jakarta RESTful Web Services) 3.0Specification</a></p>

</li>
<li>
<p><strong>JSON-B (Jakarta JSON Binding) 2.0</strong>:</p>
<p>Moved to <code>jakarta</code> namespace. Changes described in <a target="_blank" href="https://jakarta.ee/specifications/jsonb/2.0/jakarta-jsonb-spec-2.0.html#change-log">JSON-B (Jakarta JSON Binding) 2.0 Specification</a></p>

</li>
<li>
<p><strong>JSON-P (Jakarta JSON Processing) 2.0.1</strong>:</p>
<p>Moved to <code>jakarta</code> namespace.</p>

</li>
<li>
<p><strong>Jakarta Annotations 2.0</strong>:</p>
<p>Moved to <code>jakarta</code> namespace. Moved to <code>jakarta</code> namespace. Full information in <a target="_blank" href="https://jakarta.ee/specifications/annotations/2.0/annotations-spec-2.0.html">Jakarta Annotations 2.0 Specification</a></p>

</li>
<li>
<p><strong>Jakarta Persistence API 3.0</strong>:</p>
<p>Moved to <code>jakarta</code> namespace. Changes described in <a target="_blank" href="https://jakarta.ee/specifications/persistence/3.0/jakarta-persistence-spec-3.0.html#revision-history">Jakarta Persistence API 3.0 Specification</a></p>

</li>
<li>
<p><strong>Jakarta Transactions API 2.0</strong>:</p>
<p>Moved to <code>jakarta</code> namespace. Changes described in <a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/jakarta-transactions-spec-2.0.html#revision-history">Jakarta Transactions API 2.0 Specification</a></p>

</li>
<li>
<p><strong>Jakarta WebSocket API 2.0</strong>:</p>
<p>Moved to <code>jakarta</code> namespace. Changes described in <a target="_blank" href="https://jakarta.ee/specifications/websocket/2.0/websocket-spec-2.0.html#changes">Jakarta WebSocket API 2.0 Specification</a></p>

</li>
<li>
<p><strong>Jakarta Bean Validation 2.0</strong>:</p>
<p>Moved to <code>jakarta</code> namespace. Changes described in <a target="_blank" href="https://jakarta.ee/specifications/bean-validation/2.0/bean-validation_2.0.html#changelog">Jakarta Bean Validation 2.0 Specification</a></p>

</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">Please, read each specification carefully for incompatible changes!</p>
</div>

</div>

</div>


<h2 id="_deprecations">Deprecations</h2>
<div class="section">
<ul class="ulist">
<li>
<p>The custom Helidon OCI clients have been deprecated. Use the OCI Java SDK instead. If you use Helidon MP you can inject OCI SDK clients by adding the dependency <code>io.helidon.integrations.oci.sdk:helidon-integrations-oci-sdk-cdi</code>.</p>

</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">See <router-link :to="{path: '/mp/integrations/oci', hash: '#oci-compatibility'}">Resolving compatibility issue with OCI SDK</router-link> for detailed information on how to work around this issue.</p>
</div>

<ul class="ulist">
<li>
<p>The <code>MultiPart buffered readers</code> have been deprecated. Use the <code>MultiPart stream readers</code> instead.</p>

</li>
</ul>


<h3 id="_helidon_common">Helidon Common</h3>
<div class="section">
<p>Deprecations in the following classes:</p>

<ul class="ulist">
<li>
<p><code>Resource</code> - old configuration approach (since 2.0)</p>

</li>
<li>
<p><code>ThreadPoolSupplier</code> - Named thread pools (since 2.4.2)</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4363">Task</a>.</p>

</div>


<h3 id="_media_common">Media Common</h3>
<div class="section">
<p>Deprecations in the following classes:</p>

<ul class="ulist">
<li>
<p><code>ContentReaders</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>ContentTypeCharset</code> - Class with alternative (since 2.0)</p>

</li>
<li>
<p><code>ContentWriters</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>MessageBodyReaderContext</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>MessageBodyWriterContext</code> - Methods with alternatives (since 2.0)</p>

</li>
<li>
<p><code>ReadableByteChannelPublisher</code> - Class with alternative (since 2.0)</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4364">Task</a>.</p>

</div>


<h3 id="_metrics">Metrics</h3>
<div class="section">
<p>Deprecations in the following classes:</p>

<ul class="ulist">
<li>
<p><code>MetricsSupport</code> - 3 methods, replacing Config with metrics settings</p>

</li>
<li>
<p><code>KeyPerformanceIndicatorMetricsSettings</code> - New class in metrics API, for backward compatibility only</p>

</li>
<li>
<p><code>RegistryFactory</code> - New class in metrics API, for backward compatibility only</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4365">Task</a>.</p>

</div>


<h3 id="_common_context">Common Context</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>DataPropagationProvider</code> - clearData should use new method</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4366">Task</a>.</p>

</div>


<h3 id="_grpc_core">GRPC core</h3>
<div class="section">
<p>Deprecations:</p>

<ul class="ulist">
<li>
<p><code>JavaMarshaller</code> - removed support for JavaMarshaller</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4367">Task</a>.</p>

</div>


<h3 id="_lra">LRA</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>CoordinatorClient</code> - multiple methods</p>

</li>
<li>
<p><code>Headers</code></p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4368">Task</a>.</p>

</div>


<h3 id="_mp_messaging">MP Messaging</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>MessagingCdiExtension</code> - Alternative methods used</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4369">Task</a>.</p>

</div>


<h3 id="_jwt">JWT</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>Jwt</code> - Audience can be a list (since 2.4.0)</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4370">Task</a>.</p>

</div>


<h3 id="_mp_metrics">MP Metrics</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>MetricUtil</code> - multiple methods</p>

</li>
<li>
<p><code>MetricsCdiExtension</code> - multiple methods</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4371">Task</a>.</p>

</div>


<h3 id="_http_signature_security_provider">HTTP Signature Security Provider</h3>
<div class="section">
<ul class="ulist">
<li>
<p><code>backwardCompatibleEol</code> - set to false</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4372">Task</a>.</p>

</div>


<h3 id="_service_common">Service Common</h3>
<div class="section">
<p>Deprecations in the following class:</p>

<ul class="ulist">
<li>
<p><code>HelidonRestServiceSupport</code> - method <em>configureEndpoint(Rules)</em></p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4371">Task</a>.</p>

</div>


<h3 id="_webserver">WebServer</h3>
<div class="section">
<ul class="ulist">
<li>
<p><code>Static content support</code> in <code>WebServer</code> - moved to a separate module. Fully removed from <code>WebServer</code> module.</p>

</li>
</ul>

<p>More information in the following <a target="_blank" href="https://github.com/oracle/helidon/issues/4374">Task</a>.</p>

</div>

</div>

</doc-view>
