<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The gRPC Microprofile APIs are an extension to <router-link to="/mp/introduction">Helidon MP</router-link> to allow building
of gRPC services and clients that integrate with the Microprofile APIs. Using Helidon gRPC MP makes building gRPC services
and clients an easier process compared to the traditional approach using Protobuf files and code generation. Services can be built
using POJOs that are then discovered and deployed at runtime in the same way the Helidon MP discovers and deploys web resources
in the MP http server.</p>

<p>Building gRPC services using Helidon gRPC MP is very simple and allows the developer to concentrate on their
application logic without needing to write a lot of boilerplate gRPC code.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable gRPC MicroProfile Server
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.grpc&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-grpc-server&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The following annotations are used to implement Helidon MP gRPC Services:</p>

<ul class="ulist">
<li>
<p><code>@Grpc</code> - an annotation used to mark a class as representing a gRPC service.</p>

</li>
<li>
<p><code>@GrpcMarshaller</code> -  an annotation used to annotate a type or method to specify the named marshaller supplier to use for rpc method calls.</p>

</li>
</ul>

<p>gRPC method types:</p>

<ul class="ulist">
<li>
<p><router-link to="#_unary_methods" @click.native="this.scrollFix('#_unary_methods')"><code>@Unary</code></router-link> - a simple method with at most a single request value and returning at most a single response value.</p>

</li>
<li>
<p><router-link to="#_serverstreaming_methods" @click.native="this.scrollFix('#_serverstreaming_methods')"><code>@ServerStreaming</code></router-link> -  a method that takes at most a single request value but may return zero or more response values.</p>

</li>
<li>
<p><router-link to="#_clientstreaming_methods" @click.native="this.scrollFix('#_clientstreaming_methods')"><code>@ClientStreaming</code></router-link> - a request that takes one or more request values and returns at most one response value.</p>

</li>
<li>
<p><router-link to="#_bi_directional_streaming_methods" @click.native="this.scrollFix('#_bi_directional_streaming_methods')"><code>@Bidirectional</code></router-link> - a method that can take one or more request values and return zero or more response values.</p>

</li>
</ul>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_defining_a_service">Defining a Service</h3>
<div class="section">
<p>The traditional approach to building Java gRPC services is to write Protobuf files describing the service and then
use these to generate service stubs and finally implementing the service methods by extending the generated stub classes.
Using Helidon gRPC MP, all you need to do is write an annotated service implementation class that is just a normal POJO.</p>

<p>For example:</p>

<markup
lang="java"
title="Simple gRPC Service"
>@ApplicationScoped
@io.helidon.microprofile.grpc.core.Grpc
public class StringService {

    @io.helidon.microprofile.grpc.core.Unary
    public String upper(String s) {
        return s == null ? null : s.toUpperCase();
    }
}</markup>

<p>The code above is a simple service with a single unary method that just converts a String to uppercase.
The important parts in the example are the <code>@ApplicationScoped</code>, <code>@Grpc</code> and <code>@Unary</code> annotations. These,
along with other annotations discussed later, allow the gRPC MP APIs to discover, configure and deploy the service.</p>

<p>Of course Helidon gRPC MP does not preclude you from using the Protobuf files approach as traditional gRPC Java services
also work in a gRPC MP server.</p>

<p>As already shown above, a Helidon gRPC MP service is just an annotated POJO. To make a class a service, it requires two
annotations.</p>

<markup
lang="java"

>@ApplicationScoped                             <span class="conum" data-value="1" />
@io.helidon.microprofile.grpc.core.Grpc        <span class="conum" data-value="2" />
public class StringService {
    /* code is omitted */
}</markup>

<ul class="colist">
<li data-value="1">The <code>ApplicationScoped</code> annotation is what makes the service implementation a CDI bean and hence discoverable.</li>
<li data-value="2">The <code>Grpc</code> annotation is what defines the class as a gRPC service so that when the bean is discovered, it is
then deployed by the gRPC MP server.</li>
</ul>

</div>


<h3 id="_service_name">Service Name</h3>
<div class="section">
<p>By default when a class is annotated with <code>Grpc</code>, the class name will be used as the gRPC service name. So in the example
above, the service name will be <code>StringService</code>. This can be changed by supplying a name to the annotation.</p>

<markup
lang="java"

>@ApplicationScoped
@io.helidon.microprofile.grpc.core.Grpc(name="Strings") <span class="conum" data-value="1" />
public class StringService {</markup>

<ul class="colist">
<li data-value="1">The name of the deployed service will be <code>Strings</code>.</li>
</ul>

</div>


<h3 id="_defining_service_methods">Defining Service Methods</h3>
<div class="section">
<p>Once a class is properly annotated to make it a gRPC MP service, it needs to have service methods that implement the
application business logic. In gRPC there are four different types of method:</p>

<ul class="ulist">
<li>
<p><code>Unary</code> - a simple method with at most a single request value and returning at most a single response value.</p>

</li>
<li>
<p><code>Server Streaming</code> - a method that takes at most a single request value but may return zero or more response values.</p>

</li>
<li>
<p><code>Client Streaming</code> - a request that takes one or more request values and returns at most one response value.</p>

</li>
<li>
<p><code>Bi-directional Streaming</code> - a method that can take one or more request values and return zero or more response values.</p>

</li>
</ul>

<p>The Helidon gRPC MP API determines a method type by its annotation, which should be one of the following:</p>

<markup
lang="java"

>@io.helidon.microprofile.grpc.core.Unary
@io.helidon.microprofile.grpc.core.ServerStreaming
@io.helidon.microprofile.grpc.core.ClientStreaming
@io.helidon.microprofile.grpc.core.Bidirectional</markup>


<h4 id="_request_and_response_types">Request and Response Types</h4>
<div class="section">
<p>A gRPC service method typically takes a request parameter and returns a response value (<code>streaming</code> methods may take or return
multiple requests or responses). In traditional gRPC Java, the types used for the request and response values must be
Protobuf serializable classes but this is not the case with Helidon gRPC. Helidon supports
<router-link to="#_custom_marshalling" @click.native="this.scrollFix('#_custom_marshalling')">pluggable Marshallers</router-link> and by default will support Protobuf types. Any type that
can be marshalled by the built-in marshallers or custom supplied marshaller may be used as a request or response type.</p>

</div>


<h4 id="_unary_methods">Unary Methods</h4>
<div class="section">
<p>A unary gRPC method is the simplest type of service method. Typically a unary method takes a request value and returns a
response value but this does not have to be the case. A unary method could just as easily take no request parameter and/or
return no response.</p>

<p>All of the signatures below are valid unary methods in Helidon gRPC MP.</p>

<markup
lang="java"

>// A unary method with a simple request and response
@io.helidon.microprofile.grpc.core.Unary
public ResponseType invoke(RequestType req)

// A unary method that just returns a response
@io.helidon.microprofile.grpc.core.Unary
public ResponseType invoke()

// A unary method that takes a request but returns no response
@io.helidon.microprofile.grpc.core.Unary
public void invoke(RequestType req)

// A unary method that takes no request and returns no response
@io.helidon.microprofile.grpc.core.Unary
public void invoke()

// An async unary request that takes a request and returns a future
// that will complete when the response is ready
@io.helidon.microprofile.grpc.core.Unary
public CompletableFuture&lt;ResponseType&gt; invoke(RequestType req)

// An async unary request that takes no request and returns a future
// that will complete when the response is ready
@io.helidon.microprofile.grpc.core.Unary
public CompletableFuture&lt;ResponseType&gt; invoke()

// The standard gRPC Java unary method signature
@io.helidon.microprofile.grpc.core.Unary
public void invoke(RequestType req, StreamObserver&lt;ResponseType&gt; observer)

// The standard gRPC Java unary method signature but without a request type
@io.helidon.microprofile.grpc.core.Unary
public void invoke(StreamObserver&lt;ResponseType&gt; observer)

// A unary method that takes a request type and a future to complete
// with the response type
@io.helidon.microprofile.grpc.core.Unary
public void invoke(RequestType req, CompletableFuture&lt;ResponseType&gt; observer)

// A unary method that takes no request type but just takes a future
// to complete with the response type
@io.helidon.microprofile.grpc.core.Unary
public void invoke(CompletableFuture&lt;ResponseType&gt; observer)</markup>

<p>The various signatures supported above allow the service developer to choose the method signature that best fits their
application business logic without needing to worry about handling standard gRPC Java requests and StreamObservers. The
standard gRPC Java method signature is in the list above so it can still be used if required.</p>

</div>


<h4 id="_serverstreaming_methods">ServerStreaming Methods</h4>
<div class="section">
<p>A server streaming method receives a requests from the client and when the request stream is complete, it sends back a stream
of response values. A traditional gRPC Java server streaming method takes two parameters, the request and a <code>StreamObserver</code>
that is used to send back the single response in the same way that a unary method sends a response. As with unary methods,
Helidon gRPC MP supports different method signatures for server streaming methods.</p>

<p>All of the signatures below are valid server streaming methods in Helidon gRPC MP.</p>

<markup
lang="java"

>// The standard gRPC Java server streaming method signature
@io.helidon.microprofile.grpc.core.ServerStreaming
public void invoke(RequestType req, StreamObserver&lt;ResponseType&gt; observer)

// A server streaming method that uses a Stream to send the responses to the client
@io.helidon.microprofile.grpc.core.ServerStreaming
public Stream&lt;ResponseType&gt; invoke(RequestType req)

// The server streaming method without a request parameter
@io.helidon.microprofile.grpc.core.ServerStreaming
public void invoke(StreamObserver&lt;ResponseType&gt; observer)

// A server streaming method without a request parameter
// that uses a Stream to send the responses to the client
@io.helidon.microprofile.grpc.core.ServerStreaming
public Stream&lt;ResponseType&gt; invoke(RequestType req)</markup>

<p>As with unary methods, the Helidon gRPC MP API supports multiple different method signatures for implementing server streaming
methods.</p>

</div>


<h4 id="_clientstreaming_methods">ClientStreaming Methods</h4>
<div class="section">
<p>A client streaming method receives a stream of requests from the client and when the request stream is complete, it sends back a
response. A traditional gRPC Java client streaming method takes two <code>StreamObserver</code> parameters, one is the stream of client
requests and the other is used to send back the single response in the same way that a unary method sends a response. As with
unary methods, Helidon gRPC MP supports different method signatures for client streaming methods.</p>

<p>All of the signatures below are valid client streaming methods in Helidon gRPC MP.</p>

<markup
lang="java"

>// The standard gRPC Java client streaming method signature
@io.helidon.microprofile.grpc.core.ClientStreaming
public StreamObserver&lt;RequestType&gt; invoke(StreamObserver&lt;ResponseType&gt; observer)

// The gRPC Java client streaming method with an asynchronous response
@io.helidon.microprofile.grpc.core.ClientStreaming
public StreamObserver&lt;RequestType&gt; invoke(CompletableFuture&lt;ResponseType&gt; observer)</markup>

</div>


<h4 id="_bi_directional_streaming_methods">Bi-Directional Streaming Methods</h4>
<div class="section">
<p>A bidirectional streaming method is a method that is a constant stream of client requests and server responses. Other than
the standard gRPC Java <code>StreamObserver</code>, there are not any other built-in types that make sense to use to implement
different method signatures for a bidirectional method so the only supported signature is the standard gRPC Java method.</p>

<markup
lang="java"

>@io.helidon.microprofile.grpc.core.Bidirectional
public StreamObserver&lt;RequestType&gt; invoke(StreamObserver&lt;ResponseType&gt; observer)</markup>

</div>

</div>


<h3 id="_deploying_protobuf_services">Deploying Protobuf Services</h3>
<div class="section">
<p>Whilst the examples above show how simple it is to write gRPC services with basic POJOs, there may be cases where there is a
requirement to deploy services built the traditional way using gRPC Java generated classes or built as
<router-link :to="{path: '/se/grpc/server', hash: '#_service_implementation'}">non-microprofile Helidon gRPC services</router-link>.</p>


<h4 id="_annotate_the_service_implementation">Annotate the Service Implementation</h4>
<div class="section">
<p>When the gRPC MP server is starting, it will discover all CDI beans of type <code>io.grpc.BindableService</code>. Service sub-classes
implemented the traditional way with code generation are instances of <code>BindableService</code> so by annotating the implementation class
with the <code>@ApplicationScoped</code> annotation, they become discoverable and will be deployed into the gRPC server.</p>

<markup
lang="java"

>@ApplicationScoped
public class StringService
    extends StringServiceGrpc.StringServiceImplBase {</markup>

<p>In exactly the same way, if a class is an implementation of <code>io.helidon.grpc.server.GrpcService</code>, then it will be discovered and deployed when the MP gRPC server starts by simply annotating the class with the <code>@ApplicationScoped</code> annotation.</p>

<markup
lang="java"

>@ApplicationScoped
public class StringService implements GrpcService {</markup>

</div>


<h4 id="_implement_a_grpcmpextension">Implement a GrpcMpExtension</h4>
<div class="section">
<p>If it is not possible to annotate the service class (for example the code is built by a third party), another way to deploy non-CDI bean services is to implement a gRPC MP server extension.
The extension will then be called when the MP server is starting and be given the chance to add additional services for deployment.
An extension should implement the <code>io.helidon.microprofile.grpc.server.spi.GrpcMpExtension</code> interface.</p>

<p>For example, assuming that there was a gRPC service class called <code>StringService</code> that needed to be deployed, an extension class might look like this:</p>

<markup
lang="java"

>public class MyExtension
        implements GrpcMpExtension {
    @Override
    public void configure(GrpcMpContext context) {  <span class="conum" data-value="1" />
        context.routing()
               .register(new ServiceService());     <span class="conum" data-value="2" />
    }
}</markup>

<ul class="colist">
<li data-value="1">The <code>configure</code> method of the extension will be called to allow the extension to add extra configuration to the server.</li>
<li data-value="2">In this example, an instance of the <code>StringService</code> is registered with the routing (as described in
the <router-link :to="{path: '/se/grpc/server', hash: '#_grpc_server_routing'}">gRPC server routing</router-link> documentation).</li>
</ul>

<p>The <code>GrpcMpExtension</code> instances are discovered and loaded using the service loader so for the example above to work, a file
<code>META-INF/services/io.helidon.microprofile.grpc.server.spi.GrpcMpExtension</code> would need to be created that contained the names
of the service implementations.</p>

</div>

</div>


<h3 id="_marshalling">Marshalling</h3>
<div class="section">

<h4 id="_default_marshalling_support">Default Marshalling Support</h4>
<div class="section">
<p>Helidon gRPC supports Protobuf out of the box. The Protobuf marshaller will be used by default for any request and response classes that extend <code>com.google.protobuf.MessageLite</code>, which is the case for all classes generated from a <code>proto</code> file using <code>protoc</code> compiler.</p>

<p>That means that you don&#8217;t need any special handling or configuration in order to support Protobuf serialization of requests and responses.</p>

</div>


<h4 id="_custom_marshalling">Custom Marshalling</h4>
<div class="section">
<p>Helidon makes the use of custom marshallers trivial and provides one custom implementation, <a target="_blank" href="https://github.com/oracle/helidon/tree/master/grpc/core/src/main/java/io/helidon/grpc/core/JsonbMarshaller.java">JsonbMarshaller</a>, out of the box.</p>

<p>You can also easily implement your own marshaller to support serialization formats that are not supported natively
by Helidon, by implementing <code>Marshaller</code> and <code>MarshallerSupplier</code> interfaces. As an example, check out
the source code of the built-in marshaller:
<a target="_blank" href="https://github.com/oracle/helidon/tree/master/grpc/core/src/main/java/io/helidon/grpc/core/JsonbMarshaller.java">JsonbMarshaller.java</a>.</p>

<p>Furthermore, <a target="_blank" href="https://coherence.community/">Oracle Coherence CE</a> provides a marshaller for a highly optimized, binary, platform independent Portable Object Format (POF). You can find more information about POF in <a target="_blank" href="https://coherence.community/20.12/docs/#/docs/core/04_portable_types">Coherence documentation</a></p>


<h5 id="_setting_the_custom_marshaller">Setting the custom marshaller</h5>
<div class="section">
<p>You can annotate your service&#8217;s class or interface with @GrpcMarshaller:</p>

<markup
lang="java"
title="Sample code with <code>@GrpcMarshaller</code> annotation"
>@Grpc
@ApplicationScoped
@GrpcMarshaller("jsonb")  <span class="conum" data-value="1" />
public class AsyncStringService {
    // code is omitted
}</markup>

<ul class="colist">
<li data-value="1">Set the named marshaller supplier via the @GrpcMarshaller annotation.</li>
</ul>

</div>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Configure the gRPC server using the Helidon microprofile configuration framework by which the ConfigSource defaults to
<code>microprofile-config.properties</code>. Alternatively, you can also use other ConfigSources such as <code>application.yaml</code>.
Refer to <router-link to="/mp/config/introduction">MicroProfile Config</router-link> for more details about the different options for
ConfigSources.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.grpc.server/io/helidon/grpc/server/GrpcServerConfiguration.html">io.helidon.grpc.server.GrpcServerConfiguration</a></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>grpc.server</code></td>
<td class=""><doc-view>
<p>Set the name of the gRPC server.</p>

<pre>Configuration key: `name`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>native</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Specify if native transport should be used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1408</code></td>
<td class=""><doc-view>
<p>Sets server port. If port is <code>0</code> or less then any available ephemeral port will be used.</p>

<pre>Configuration key: `port`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>workers</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>Number of processors available to the JVM</code></td>
<td class=""><doc-view>
<p>Sets a count of threads in pool used to process HTTP requests.
 Default value is <code>CPU_COUNT * 2</code>.</p>

<pre>Configuration key: `workers`</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="yaml"
title="GrpcServer configuration file example using <code>application.yaml</code>"
>grpc:
  name: test.server  <span class="conum" data-value="1" />
  port: 3333  <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Specifies the name of the gRPC server.</li>
<li data-value="2">Sets the server port.</li>
</ul>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon MP includes some examples that demonstrate the gRPC server usage:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/grpc/microprofile/basic-server-implicit">Basic gRPC Server example</a> provides
a simple gRPC application that deploys a gRPC service that will be discovered by CDI. Two additional services are
included that are not normally CDI managed beans, but are manually added as CDI managed beans so that they can also be
discovered by Helidon MP.</p>

</li>
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/grpc/microprofile/metrics">gRPC Server Metrics example</a> demonstrates a
Helidon MP application that enables <code>metrics</code> and <code>tracing</code> on a gRPC Service.</p>

</li>
</ul>

</div>

</doc-view>
