<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')"></router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')"></router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')"></router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')"></router-link></p>

</li>
<li>
<p><router-link to="#_guides" @click.native="this.scrollFix('#_guides')"></router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')"></router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon MicroProfile Config is an implementation of <a target="_blank" href="https://github.com/eclipse/microprofile-config/">Eclipse MicroProfile Config</a>. You can configure your applications using MicroProfile&#8217;s config configuration sources and APIs. You can also extend the configuration using MicroProfile SPI to add custom <code>ConfigSource</code> and <code>Converter</code>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Config
either add a dependency on the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.config&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-config&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_microprofile_config_features">MicroProfile Config Features</h3>
<div class="section">

<h4 id="_microprofile_config_sources">MicroProfile Config Sources</h4>
<div class="section">
<p>A Config Source provides configuration values from different sources such as property files and user classes that are registered by the application.</p>

<p>By default, the following configuration sources are used to retrieve the configuration:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 37.5%;">
<col style="width: 62.5%;">
</colgroup>
<thead>
<tr>
<th>Source</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">System properties</td>
<td class="">A mutable source that uses <code>System.getProperties()</code> to obtain configuration values.</td>
</tr>
<tr>
<td class="">Environment variables</td>
<td class="">An immutable source that uses <code>System.env()</code> to obtain configuration values and resolves aliases as defined by the MicroProfile Config specification.</td>
</tr>
<tr>
<td class=""><code>META-INF/microprofile-config.properties</code></td>
<td class="">The properties config source as defined by MicroProfile Config specification.</td>
</tr>
</tbody>
</table>
</div>

<p>MicroProfile Config uses <code>ConfigSource</code> SPI to load configuration data, either from default configuration sources or from custom <code>ConfigSource</code> located by Java Service Loader.</p>

</div>


<h4 id="_using_microprofile_config_api">Using MicroProfile Config API</h4>
<div class="section">
<p>You can use MicroProfile Config API to get configuration properties by using a <code>Config</code>
instance programmatically or injecting configuration values with <code>@ConfigProperty</code>.</p>

<markup
lang="java"
title="Using <code>Config</code>"
>org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
config.getOptionalValue("app.greeting", String.class).orElse("Hello");</markup>

<markup
lang="java"
title="Injecting configured properties into a constructor"
>@Inject
public GreetingProvider(@ConfigProperty(name = "app.greeting", defaultValue = "Hello") String message) {
    this.message = message
}</markup>

<p>MicroProfile Config provides typed access to configuration values, using built-in converters, and <code>Converter</code> implementations located by Java Service Loader.</p>

</div>


<h4 id="_ordering_of_default_config_sources">Ordering of Default Config Sources</h4>
<div class="section">
<p>In order to properly configure your application using configuration sources, you need to understand the precedence rules used to merge your configuration data. The default MicroProfile Config Sources ordering is:</p>

<ul class="ulist">
<li>
<p>System properties (ordinal=400)</p>

</li>
<li>
<p>Environment variables (ordinal=300)</p>

</li>
<li>
<p>/META-INF/microprofile-config.properties (ordinal=100)</p>

</li>
</ul>

<p>Each Config Source has an ordinal that determines the priority of the Config Source.
A Config Source with higher ordinal has higher priority as compared to the Config Source with
lower ordinal. The values taken from the high-priority Config Source overrides the values
from low-priority Config Source.</p>

<p>This helps to customize the configuration of Config Sources using external Config Source
if an external Config Source has higher ordinal values than the built-in Config Sources of the application.</p>

<p>The example below shows how the MicroProfile configuration file <code>microprofile-config.properties</code> can be used to modify the server listen port property.</p>

<markup
lang="properties"

>// Application properties. This is the default greeting
app.greeting=Hello

// Microprofile server properties
server.port=8080
server.host=0.0.0.0</markup>

</div>


<h4 id="Config-Profiles">MicroProfile Config Profiles</h4>
<div class="section">
<p>MicroProfile Config supports a concept of configuration profiles. You can define a profile using the configuration property <code>mp.config.profile</code>
(when using default configuration, this can be defined as a system property, environment variable or as a property in <code>microprofile-config.properties</code>).
When a profile is defined, additional config source is loaded (<code>microprofile-config-profile.properties</code>) and properties from profile have precedence over
default properties. Profile properties can be defined using <code>%profile</code> prefix, such as <code>%dev.server.port</code>.</p>

</div>

</div>


<h3 id="_helidon_microprofile_config_features">Helidon MicroProfile Config Features</h3>
<div class="section">
<p>Helidon MicroProfile Config offers the following features on top of the specification:</p>

</div>


<h3 id="_helidon_microprofile_config_sources">Helidon MicroProfile Config Sources</h3>
<div class="section">
<p>Helidon configuration sources can use different formats for the configuration data. You can specify the format on a per source bases, mixing and matching formats as required.</p>

<p>The following configuration sources can be used to retrieve the configuration:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 37.5%;">
<col style="width: 62.5%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">Source</td>
<td class="">Description</td>
</tr>
<tr>
<td class="">File</td>
<td class="">Creates the source from a properties file on the file system with <code>MpConfigSources.create(Path)</code>.</td>
</tr>
<tr>
<td class="">URL</td>
<td class="">Creates the source from properties from a URL with <code>MpConfigSources.create(URL)</code>.</td>
</tr>
<tr>
<td class=""><code>Map&lt;String, String&gt;</code></td>
<td class="">Creates the source from a Map with <code>MpConfigSources.create(Map)</code>.</td>
</tr>
<tr>
<td class=""><code>Properties</code></td>
<td class="">Creates the source directly from Properties with <code>MpConfigSources.create(Properties)</code>.</td>
</tr>
<tr>
<td class="">File on classpath</td>
<td class="">Creates the source from a properties file on classpath with <code>MpConfigSources.classpath(String)</code>.</td>
</tr>
<tr>
<td class="">YAML</td>
<td class="">Creates the source from YAML using <code>YamlMpConfigSource.create(Path)</code> or <code>YamlMpConfigSource.create(URL)</code>.</td>
</tr>
</tbody>
</table>
</div>

<p>See <router-link :to="{path: '/mp/config/advanced-configuration', hash: '#_creating_microprofile_config_sources_for_manual_setup_of_config'}">manual setup of config</router-link> section for more information.</p>


<h4 id="_references">References</h4>
<div class="section">
<p>You can use <code>${reference}</code> to reference another configuration key in a key value. This
allows to configure a single key to be reused in multiple other keys.</p>

<markup
lang="yaml"
title="Example"
>uri: "http://localhost:8080"
service-1: "${uri}/service1"
service-2: "${uri}/service2"</markup>

</div>


<h4 id="_change_support">Change support</h4>
<div class="section">
<p>Polling (or change watching) for file based config sources (not classpath based).</p>

<p>To enable polling for a config source created using meta configuration (see below), or using
<code>MpConfigSources.create(Path)</code>, or <code>YamlMpConfigSource.create(Path)</code>, use the following properties:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 37.5%;">
<col style="width: 62.5%;">
</colgroup>
<thead>
<tr>
<th>Property</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>helidon.config.polling.enabled</code></td>
<td class="">To enable polling file for changes, uses timestamp to identify a change.</td>
</tr>
<tr>
<td class=""><code>helidon.config.polling.duration</code></td>
<td class="">Polling period duration, defaults to 10 seconds ('PT10S`)<br>

See <a target="_blank" href="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/time/Duration.html#parse(java.lang.CharSequence)">javadoc</a></td>
</tr>
<tr>
<td class=""><code>helidon.config.watcher.enabled</code></td>
<td class="">To enable watching file for changes using the Java <code>WatchService</code>.<br>

See link:https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/nio/file/WatchService.html</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_encryption">Encryption</h4>
<div class="section">
<p>You can encrypt secrets using a master password and store them in a configuration file.
The config encryption filter in MicroProfile Config is enabled by default.
For more information, see <router-link to="/mp/security/configuration-secrets">Configuration Secrets</router-link>.</p>

<markup
lang="properties"
title="Example of encrypted secrets"
># Password encrypted using a master password
client_secret=${GCM=mYRkg+4Q4hua1kvpCCI2hg==}
# Password encrypted using public key (there are length limits when using RSA)
client_secret=${RSA=mYRkg+4Q4hua1kvpCCI2hg==}
# Password in clear text, can be used in development
# The system needs to be configured to accept clear text
client_secret=${CLEAR=known_password}</markup>

</div>


<h4 id="_meta_configuration">Meta Configuration</h4>
<div class="section">
<p>You can configure the Config using Helidon MP Config meta configuration feature. The meta-config allows configuration of config sources and other
configuration options, including addition of discovered sources and converters.</p>

<p>See
 <router-link :to="{path: '/mp/config/advanced-configuration', hash: '#_creating_microprofile_config_sources_from_meta_config'}">Microprofile Config Sources</router-link> for detailed information.</p>

<div class="admonition note">
<p class="admonition-inline">For backward compatibility, we will support usage of Helidon SE meta-configuration until version 3.0.0. Using this approach causes behavior that is not compatible with MicroProfile Config specification.</p>
</div>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Config sources can be configured using the following properties.</p>

<p>The class responsible for configuration is:</p>

<p>Type: org.eclipse.microprofile.config.Config</p>

<p>This is a standalone configuration type, prefix from configuration root: <code>mp.config</code></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>profile</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure an explicit profile name.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>Current properties may be set in <code>application.yaml</code> or in <code>microprofile-config.properties</code> with <code>mp.config</code> prefix.</p>

<p>See <router-link to="#Config-Profiles" @click.native="this.scrollFix('#Config-Profiles')">Config Profiles</router-link> for more information.</p>

</div>

</div>


<h2 id="_guides">Guides</h2>
<div class="section">
<v-layout row wrap class="mb-5">
<v-flex xs12>
<v-container fluid grid-list-md class="pa-0">
<v-layout row wrap class="pillars">
<v-flex xs12 sm4 lg3>
<v-card>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">MP Config Guide</span>
</v-card-title>
<v-card-text class="caption">
<p>Step-by-step guide about using MicroProfile Config in your Helidon MP application.</p>
</v-card-text>
</v-card>
</v-flex>
</v-layout>
</v-container>
</v-flex>
</v-layout>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-config-3.0.1/microprofile-config-spec-3.0.1.html}">MicroProfile Config Specifications</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-fault-tolerance-4.0/apidocs">MicroProfile Config Javadocs</a></p>

</li>
</ul>

</div>

</doc-view>
