<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>io.opentracing.Tracer Configuration</dt>
<dd slot="desc"><p>Zipkin tracer configuration</p>

<p>Type: io.opentracing.Tracer</p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>api-version</code></td>
<td class=""><doc-view>
<p>Version (V1, V2)</p>

</doc-view>
</td>
<td class=""><code>V2</code></td>
<td class=""><doc-view>
<p>Version of Zipkin API to use.
 Defaults to Version#V2.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>boolean-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, boolean&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, tracing will be sent. If enabled is false, tracing should
 use a no-op tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>global</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When enabled, the created instance is also registered as a global tracer.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Host to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>int-tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, int&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Path on the collector host to use when sending data to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Port to use to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Protocol to use (such as <code>http</code> or <code>https</code>) to connect to tracing collector.
 Default is defined by each tracing integration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>service</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Service name of the traced service.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Tracer level tags that get added to all reported spans.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
