<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>java.lang.Object Configuration</dt>
<dd slot="desc"><p>Type: java.lang.Object</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authorization-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of an authorization endpoint used to redirect users to for logging-in.</p>

<pre>If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
an attempt is made to use #identityUri(URI)/oauth2/v1/authorize.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>base-scopes</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>openid</code></td>
<td class=""><doc-view>
<p>Configure base scopes.
 By default, this is <code>DEFAULT_BASE_SCOPES</code>.
 If scope has a qualifier, it must be used here.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client ID as generated by OIDC server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-secret</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client secret as generated by OIDC server.
 Used to authenticate this application with the server when requesting
 JWT based on a code.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-timeout-millis</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>30000</code></td>
<td class=""><doc-view>
<p>Timeout of calls using web client.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>identity-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of the identity server, base used to retrieve OIDC metadata.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>introspect-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Endpoint to use to validate JWT.
 Either use this or set #signJwk(JwkKeys) or #signJwk(Resource).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>issuer</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Issuer of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata-well-known</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>If set to true, metadata will be loaded from default (well known)
 location, unless it is explicitly defined using oidc-metadata-resource. If set to false, it would not be loaded
 even if oidc-metadata-resource is not defined. In such a case all URIs must be explicitly defined (e.g.
 token-endpoint-uri).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Resource configuration for OIDC Metadata
 containing endpoints to various identity services, as well as information about the identity server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scope-audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of the scope required by this application. This is prefixed to
 the scope name when requesting scopes from the identity server.
 Defaults to empty string.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>server-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>
<p>Configure one of the supported types of identity servers.</p>

<pre>If the type does not have an explicit mapping, a warning is logged and the default implementation is used.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A resource pointing to JWK with public keys of signing certificates used
 to validate JWT.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-auth</code></td>
<td class=""><doc-view>
<p>ClientAuthentication (CLIENT_SECRET_BASIC, CLIENT_SECRET_POST, CLIENT_SECRET_JWT, PRIVATE_KEY_JWT, NONE)</p>

</doc-view>
</td>
<td class=""><code>CLIENT_SECRET_BASIC</code></td>
<td class=""><doc-view>
<p>Type of authentication to use when invoking the token endpoint.
 Current supported options:</p>

<ul class="ulist">
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_BASIC</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_POST</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#NONE</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of a token endpoint used to obtain a JWT based on the authentication
 code.
 If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
 an attempt is made to use #identityUri(URI)/oauth2/v1/token.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-jwt-with-jwk</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Use JWK (a set of keys to validate signatures of JWT) to validate tokens.
 Use this method when you want to use default values for JWK or introspection endpoint URI.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
