<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>IdcsMtRoleMapperRxProvider (security.providers.idcs.mapper) Configuration</dt>
<dd slot="desc"><p>Multitenant IDCS role mapping provider</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.security.providers.idcs.mapper/io/helidon/security/providers/idcs/mapper/IdcsMtRoleMapperRxProvider.html">io.helidon.security.providers.idcs.mapper.IdcsMtRoleMapperRxProvider</a></p>

<markup
lang="text"
title="Config key"
>idcs-role-mapper</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.SubjectMappingProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cache-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_EvictableCache">EvictableCache</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit io.helidon.security.providers.common.EvictableCache for role caching.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>default-idcs-subject-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>user</code></td>
<td class=""><doc-view>
<p>Configure subject type to use when requesting roles from IDCS.
 Can be either #IDCS_SUBJECT_TYPE_USER or #IDCS_SUBJECT_TYPE_CLIENT.
 Defaults to #IDCS_SUBJECT_TYPE_USER.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idcs-app-name-handler</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure token handler for IDCS Application name.
 By default the header <code>IdcsMtRoleMapperRxProvider#IDCS_APP_HEADER</code> is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idcs-tenant-handler</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure token handler for IDCS Tenant ID.
 By default the header <code>IdcsMtRoleMapperRxProvider#IDCS_TENANT_HEADER</code> is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_oidc_common_OidcConfig">OidcConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit io.helidon.security.providers.oidc.common.OidcConfig instance, e.g. when using it also for OIDC
 provider.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>subject-types</code></td>
<td class=""><doc-view>
<p>SubjectType[&#93; (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Add a supported subject type.
 If none added, io.helidon.security.SubjectType#USER is used.
 If any added, only the ones added will be used (e.g. if you want to use
 both io.helidon.security.SubjectType#USER and io.helidon.security.SubjectType#SERVICE,
 both need to be added.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
