<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>HttpSignProvider (security.providers.httpsign) Configuration</dt>
<dd slot="desc"><p>HTTP header signature provider.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.security.providers.httpsign/io/helidon/security/providers/httpsign/HttpSignProvider.html">io.helidon.security.providers.httpsign.HttpSignProvider</a></p>

<markup
lang="text"
title="Config key"
>http-signatures</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backward-compatible-eol</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Enable support for Helidon versions before 3.0.0 (exclusive).</p>

<pre>Until version 3.0.0 (exclusive) there was a trailing end of line added to the signed
data.
To be able to communicate cross versions, we must configure this when talking to older versions of Helidon.
Default value is `false`. In Helidon 2.x, this switch exists as well and the default is `true`, to
allow communication between versions as needed.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>headers</code></td>
<td class=""><doc-view>
<p>HttpSignHeader[&#93; (SIGNATURE, AUTHORIZATION, CUSTOM)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add a header that is validated on inbound requests. Provider may support more than
 one header to validate.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>inbound.keys</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_httpsign_InboundClientDefinition">InboundClientDefinition[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add inbound configuration. This is used to validate signature and authenticate the
 party.</p>

<pre>The same can be done through configuration:
&lt;pre&gt;
{
 name = "http-signatures"
 class = "HttpSignProvider"
 http-signatures {
     inbound {
         # This configures the InboundClientDefinition
         keys: [
         {
             key-id = "service1"
             hmac.secret = "${CLEAR=password}"
         }]
     }
 }
}
&lt;/pre&gt;</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Set whether the signature is optional. If set to true (default), this provider will
 SecurityResponse.SecurityStatus#ABSTAIN from this request if signature is not
 present. If set to false, this provider will SecurityResponse.SecurityStatus#FAILURE fail
 if signature is not present.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundConfig">OutboundConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add outbound targets to this builder.
 The targets are used to chose what to do for outbound communication.
 The targets should have OutboundTargetDefinition attached through
 OutboundTarget.Builder#customObject(Class, Object) to tell us how to sign
 the request.</p>

<pre>The same can be done through configuration:
&lt;pre&gt;
{
 name = "http-signatures"
 class = "HttpSignProvider"
 http-signatures {
     targets: [
     {
         name = "service2"
         hosts = ["localhost"]
         paths = ["/service2/.*"]</pre>
<pre>         # This configures the OutboundTargetDefinition
         signature {
             key-id = "service1"
             hmac.secret = "${CLEAR=password}"
         }
     }]
 }
}
&lt;/pre&gt;</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>realm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>helidon</code></td>
<td class=""><doc-view>
<p>Realm to use for challenging inbound requests that do not have "Authorization" header
 in case header is HttpSignHeader#AUTHORIZATION and singatures are not optional.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-headers</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_httpsign_SignedHeadersConfig_HeadersConfig">HeadersConfig[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Override the default inbound required headers (e.g. headers that MUST be signed and
 headers that MUST be signed IF present).</p>

<pre>Defaults:</pre>
<ul class="ulist">
<li>
<p>get, head, delete methods: date, (request-target), host are mandatory; authorization if present (unless we are
creating/validating the HttpSignHeader#AUTHORIZATION ourselves</p>

</li>
<li>
<p>put, post: same as above, with addition of: content-length, content-type and digest if present</p>

</li>
<li>
<p>for other methods: date, (request-target)</p>

</li>
</ul>

<p>Note that this provider DOES NOT validate the "Digest" HTTP header, only the signature.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
