<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>HttpDigestAuthProvider (security.providers.httpauth) Configuration</dt>
<dd slot="desc"><p>Http digest authentication security provider</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.security.providers.httpauth/io/helidon/security/providers/httpauth/HttpDigestAuthProvider.html">io.helidon.security.providers.httpauth.HttpDigestAuthProvider</a></p>

<markup
lang="text"
title="Config key"
>http-digest-auth</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>algorithm</code></td>
<td class=""><doc-view>
<p>Algorithm (MD5)</p>

</doc-view>
</td>
<td class=""><code>MD5</code></td>
<td class=""><doc-view>
<p>Digest algorithm to use.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>nonce-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>86400000</code></td>
<td class=""><doc-view>
<p>How long will the nonce value be valid. When timed-out, browser will re-request username/password.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether authentication is required.
 By default, request will fail if the authentication cannot be verified.
 If set to false, request will process and this provider will abstain.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>principal-type</code></td>
<td class=""><doc-view>
<p>SubjectType (USER, SERVICE)</p>

</doc-view>
</td>
<td class=""><code>USER</code></td>
<td class=""><doc-view>
<p>Principal type this provider extracts (and also propagates).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>qop</code></td>
<td class=""><doc-view>
<p>Qop (NONE, AUTH)</p>

</doc-view>
</td>
<td class=""><code>NONE</code></td>
<td class=""><doc-view>
<p>Only <code>AUTH</code> supported. If left empty, uses the legacy approach (older RFC version). <code>AUTH-INT</code> is not supported.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>realm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>Helidon</code></td>
<td class=""><doc-view>
<p>Set the realm to use when challenging users.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>server-secret</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The nonce is encrypted using this secret - to make sure the nonce we get back was generated by us and to
 make sure we can safely time-out nonce values.
 This secret must be the same for all service instances (or all services that want to share the same authentication).
 Defaults to a random password - e.g. if deployed to multiple servers, the authentication WILL NOT WORK. You MUST
 provide your own password to work in a distributed environment with non-sticky load balancing.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>users</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_httpauth_ConfigUserStore_ConfigUser">ConfigUser[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set user store to obtain passwords and roles based on logins.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
