<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>GoogleTokenProvider (security.providers.google.login) Configuration</dt>
<dd slot="desc"><p>Google Authentication provider</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.security.providers.google.login/io/helidon/security/providers/google/login/GoogleTokenProvider.html">io.helidon.security.providers.google.login.GoogleTokenProvider</a></p>

<markup
lang="text"
title="Config key"
>google-login</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.security.spi.SecurityProvider</code></p>

</li>
<li>
<p><code>io.helidon.security.spi.AuthenticationProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>client-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Google application client id, to validate that the token was generated by Google for us.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>If set to true, this provider will return io.helidon.security.SecurityResponse.SecurityStatus#ABSTAIN instead
 of failing in case of invalid request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>outbound</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_common_OutboundConfig">OutboundConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Outbound configuration - a set of outbound targets that
 will have the token propagated.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set proxy host when talking to Google.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>80</code></td>
<td class=""><doc-view>
<p>Set proxy port when talking to Google.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>realm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>helidon</code></td>
<td class=""><doc-view>
<p>Set the authentication realm to build challenge, defaults to "helidon".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class=""><code>&#x60;Authorization&#x60; header with &#x60;bearer&#x60; prefix</code></td>
<td class=""><doc-view>
<p>Token provider to extract Google access token from request, defaults to "Authorization" header with a "bearer " prefix.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
