<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>WebServer (reactive.webserver) Configuration</dt>
<dd slot="desc"><p>Configuration of the HTTP server.</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.reactive.webserver/io/helidon/reactive/webserver/WebServer.html">io.helidon.reactive.webserver.WebServer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>server</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backlog</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>Configures a maximum length of the queue of incoming connections on the server
 socket.</p>

<pre>Default value is #DEFAULT_BACKLOG_SIZE.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>backpressure-buffer-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Maximum length of the response data sending buffer can keep without flushing.
 Depends on <code>backpressure-policy</code> what happens if max buffer size is reached.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>backpressure-strategy</code></td>
<td class=""><doc-view>
<p>BackpressureStrategy (LINEAR, AUTO_FLUSH, PREFETCH, UNBOUNDED)</p>

</doc-view>
</td>
<td class=""><code>AUTO_FLUSH</code></td>
<td class=""><doc-view>
<p>Sets a backpressure strategy for the server to apply against user provided response upstream.</p>

<ul class="ulist">
<li>
<p>LINEAR - Data are requested one-by-one, in case buffer reaches watermark, no other data is requested.</p>

</li>
<li>
<p>AUTO_FLUSH - Data are requested one-by-one, in case buffer reaches watermark, no other data is requested.</p>

</li>
<li>
<p>PREFETCH - After first data chunk arrives, probable number of chunks needed to fill the buffer up to watermark is calculated and requested.</p>

</li>
<li>
<p>NONE - No backpressure is applied, Long.MAX_VALUE(unbounded) is requested from upstream.</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><s><code>bind-address</code></s></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p><strong>Deprecated</strong> Configures local address where the server listens on with the server socket.
 If not configured, then listens an all local addresses.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>continue-immediately</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>When true WebServer answers to expect continue with 100 continue immediately,
 not waiting for user to actually request the data.</p>

<pre>Default is `false`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enable-compression</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Enable negotiation for gzip/deflate content encodings. Clients can
 request compression using the "Accept-Encoding" header.</p>

<pre>Default is `false`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>features.print-details</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Set to <code>true</code> to print detailed feature information on startup.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A helper method that just calls #bindAddress(String).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-header-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>Maximal number of bytes of all header values combined. When a bigger value is received, a
 io.helidon.common.http.Http.Status#BAD_REQUEST_400
 is returned.</p>

<pre>Default is `16384`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-initial-line-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>4096</code></td>
<td class=""><doc-view>
<p>Maximal number of characters in the initial HTTP line.</p>

<pre>Default is `4096`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-payload-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set a maximum payload size for a client request. Can prevent DoS
 attacks.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-upgrade-content-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>65536</code></td>
<td class=""><doc-view>
<p>Set a maximum length of the content of an upgrade request.</p>

<pre>Default is `64*1024`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Configures a server port to listen on with the server socket. If port is
 <code>0</code> then any available ephemeral port will be used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configures proposed value of the TCP receive window that is advertised to the remote peer on the
 server socket.</p>

<pre>If `0` then use implementation default.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>requested-uri-discovery</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_http_RequestedUriDiscoveryContext">RequestedUriDiscoveryContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Requested URI discovery for the web server&#8217;s default socket.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_SocketConfiguration">SocketConfiguration[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Adds an additional named server socket configuration. As a result, the server will listen
 on multiple ports.</p>

<pre>An additional named server socket may have a dedicated Routing configured
through WebServer.Builder#addNamedRouting(String, Routing).</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Socket timeout in milliseconds</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webserver_WebServerTls">WebServerTls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configures SSL for this socket. When configured, the server enforces SSL
 configuration.
 If this method is called, any other method except for #tls(java.util.function.Supplier)¨
 and repeated invocation of this method would be ignored.</p>

<pre>If this method is called again, the previous configuration would be ignored.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>worker-count</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets a count of threads in pool used to process HTTP requests.
 Default value is <code>CPU_COUNT * 2</code>.</p>

<pre>Configuration key: `workers`</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
