<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>WebClientConfiguration (webclient) Configuration</dt>
<dd slot="desc"><p>Configuration of the HTTP client</p>

<p>Type: <a target="_blank" href="./apidocs/io.helidon.reactive.webclient/io/helidon/reactive/webclient/WebClientConfiguration.html">io.helidon.reactive.webclient.WebClientConfiguration</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>client</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>connect-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>60000</code></td>
<td class=""><doc-view>
<p>Sets new connection timeout of the request.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookies.automatic-store-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to allow automatic cookie storing</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookies.default-cookies</code></td>
<td class=""><doc-view>
<p>Map</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Default cookies to be used in each request. Each list entry has to have "name" and "value" node</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>follow-redirects</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to follow any response redirections or not.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>headers</code></td>
<td class=""><doc-view>
<p>Map</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Default headers to be used in each request. Each list entry has to have "name" and "value" node</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-redirects</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>5</code></td>
<td class=""><doc-view>
<p>Sets max number of followed redirects.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-support</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_media_common_MediaContext">MediaContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webclient_Proxy">Proxy</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Sets new request proxy.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-timeout-millis</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>600000</code></td>
<td class=""><doc-view>
<p>Sets new read timeout of the response.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>relative-uris</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Can be set to <code>true</code> to force the use of relative URIs in all requests,
 regardless of the presence or absence of proxies or no-proxy lists.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_reactive_webclient_WebClientTls">WebClientTls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>New TLS configuration.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Base uri for each request.</p>

<pre>@return updated builder instance</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>user-agent</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of the user agent which should be used.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
