<doc-view>

<h2 id="_introduction">Introduction</h2>
<div class="section">
<p><router-link to="/about/cli">Helidon CLI</router-link> provides a convenient way to bootstrap Helidon applications. It allows you to choose from a set of archetypes i.e. application with pre-defined feature sets and lets you customize it by providing a host of options.</p>

</div>


<h2 id="_archetypes">Archetypes</h2>
<div class="section">
<p>Helidon provides the following set of archetypes to bootstrap your application development journey.</p>


<h3 id="_quickstart">QuickStart</h3>
<div class="section">
<p>This option creates a Helidon project that includes multiple REST operations along with default observability setup and a set of dependencies to enable ease of development e.g. in case of Helidon MP, it uses <code>helidon-microprofile</code> bundle instead of minimal <code>helidon-microprofile-core</code> bundle.</p>

</div>


<h3 id="_database">Database</h3>
<div class="section">
<p>This option builds on <code>QuickStart</code> to demonstrate how to integrate with database (in-memory H2, by default). In case of, Helidon SE that uses the DbClient API while for Helidon MP that uses JPA.</p>

</div>


<h3 id="_oci">OCI</h3>
<div class="section">
<p>This option builds on <code>QuickStart</code> to demonstrate integration with Oracle Cloud Infrastructure (OCI) services using the OCI SDK. Generated project showcases OpenApi-driven development approach where the practice of designing and building APIs is done first, then creating the rest of an application around them is implemented next. This is available for Helidon MP only.</p>

</div>


<h3 id="_custom">Custom</h3>
<div class="section">
<p>This option enables user to create Helidon project of their choice, suitable to start from scratch i.e. bare minimum, if default values are chosen Or choose from many options available.</p>

</div>

</div>


<h2 id="_generated_application_structure">Generated Application Structure</h2>
<div class="section">
<p>User can scaffold a new Maven project based on these archetypes. See <router-link to="/about/cli">Helidon CLI</router-link> and our <router-link to="/se/guides/quickstart">Helidon SE QuickStart Guide</router-link> or <router-link to="/mp/guides/quickstart">Helidon MP QuickStart Guide</router-link> for details on usage.</p>

<p>Once the archetype is selected the other options have defaults and the project is generated in a directory named after the <code>artifactId</code> value. It mainly contains the following:</p>

<ul class="ulist">
<li>
<p>Maven structure</p>

</li>
<li>
<p>skeletal application code</p>

</li>
<li>
<p>associated unit test code</p>

</li>
<li>
<p>example Dockerfile files</p>

</li>
<li>
<p>application configuration file(s)</p>

</li>
<li>
<p>instructions to build and run application/test</p>

</li>
</ul>

</div>


<h2 id="_using_generated_application">Using Generated Application</h2>
<div class="section">
<p>The easiest way to get started is follow instructions in README file and familiarize with layout and features provided to build upon them esp. look at the pom.xml. You will find the suitable Helidon parent pom, enabling the use of the different dependencies managed/provided by Helidon.</p>

</div>

</doc-view>
