<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE WebClient Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon SE project
that can be used to run some basic examples using WebClient.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>

<h2 id="_what_you_need">What you need</h2>
<div class="section">
<p>For this 15 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon MP Application</td>
<td class="">You can use your own application or use the <a id="" title="" target="_blank" href="https://helidon.io/docs/v2/#/mp/guides/02_quickstart">Helidon MP Quickstart</a> to create a sample application.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;17</a> (<a id="" title="" target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;17</a>)</td>
<td class="">Helidon requires Java 17+.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.6.1+</a></td>
<td class="">Helidon requires Maven 3.6.1+.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/05_kubernetes">install one on your desktop</router-link>).</td>
</tr>
</tbody>
</table>
</div>
<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 17`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-17</markup>

<ul class="ulist">
<li>
<p><router-link to="#WebClient features" @click.native="this.scrollFix('#WebClient features')">WebClient features</router-link></p>

</li>
<li>
<p><router-link to="#WebClient usage" @click.native="this.scrollFix('#WebClient usage')">WebClient usage</router-link></p>

</li>
<li>
<p><router-link to="#_webclient_metrics" @click.native="this.scrollFix('#_webclient_metrics')">WebClient Metrics</router-link></p>

</li>
</ul>

<h3 id="_webclient_features">WebClient Features</h3>
<div class="section">
<p>Helidon&#8217;s WebClient is used to perform HTTP REST requests to target endpoints and handle their responses. Built on top of
a reactive approach, you are no longer blocked while waiting for the data.</p>

<p><strong>Note</strong>: WebClient is still experimental and not intended for production use. APIs and features are not yet fully tested
and are subject to change.</p>

<p>WebClient provides the following features:</p>

<ul class="ulist">
<li>
<p><strong>Reactive</strong>:
As mentioned, the code execution is not blocked by waiting for server response when a request is performed. To avoid
memory overflow, the client has built-in back-pressure support.</p>

</li>
<li>
<p><strong>User-friendly</strong>:
Every client and request is created by a builder pattern, so it improves readability and code maintenance.</p>

</li>
<li>
<p><strong>Following redirects</strong>:
The WebClient is able to follow the redirect chain and perform requests on the correct endpoint for you. You no longer
have to point your client to the correct/final endpoint.</p>

</li>
<li>
<p><strong>Tracing, metrics and security propagation</strong>:
When you configure the Helidon WebServer to use tracing, metrics and security, the settings are automatically
propagated to the WebClient and used during request/response.</p>

</li>
</ul>
</div>

<h3 id="_webclient_usage">WebClient Usage</h3>
<div class="section">

<h4 id="_create_a_sample_se_project">Create a sample SE project</h4>
<div class="section">
<p>Generate the project sources using the Helidon SE Maven archetype.
The result is a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=3.0.0-M2 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

<p>You should now have a directory called <code>helidon-quickstart-se</code>.</p>

<markup
lang="bash"
title="Open this directory"
>cd helidon-quickstart-se</markup>

<p>The Helidon quickstart is a greeting application supporting several HTTP requests such as GET and PUT. Using it will
be time saving and allow us to focus on the WebClient features and how to use it.</p>

</div>

<h4 id="_modify_pom_dependency">Modify pom dependency</h4>
<div class="section">
<p>In the pom.xml, remove the test scope under the WebClient dependency as it will be used not only in the tests.</p>

<markup
lang="xml"
title="Remove test scope:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient&lt;/artifactId&gt;
    &lt;scope&gt;test&lt;/scope&gt; &lt;!--  Remove this line --&gt;
&lt;/dependency&gt;</markup>

</div>

<h4 id="_add_clientexample_class">Add ClientExample class</h4>
<div class="section">
<p>In <code>io.helidon.examples.quickstart.se</code> package, create a new class named ClientExample. This class will use the
WebClient to send request to the greeting application.</p>

<markup
lang="java"
title="Create ClientExample class:"
>package io.helidon.examples.quickstart.se;

public class ClientExample {

    public static void main(String[] args) {

    }
}</markup>

<p>Add the following code to create a WebClient instance. The builder approach allows you to create the WebClient with
specific settings and improves the readability and simplicity of the code.</p>

<markup
lang="java"
title="Add WebClient instance to the main method:"
>import io.helidon.media.jsonp.JsonpSupport;
import io.helidon.webclient.WebClient;

...

WebClient webClient = WebClient.builder()
                .baseUri("http://localhost:8080")   <span class="conum" data-value="1" />
                .addMediaSupport(JsonpSupport.create())     <span class="conum" data-value="2" />
                .build();</markup>

<ul class="colist">
<li data-value="1">The base URI of the outbound requests.</li>
<li data-value="2">Register a support for Jsonp.</li>
</ul>
<p>By default, the Helidon quickstart application runs on localhost:8080. If you changed the host name or port number
make sure to modify the base URI as well.
Once built, the WebClient can be used to send a GET request to the greeting application.</p>

<markup
lang="java"
title="Send a GET request to the target endpoint:"
>webClient.get()     <span class="conum" data-value="1" />
    .path("/greet")     <span class="conum" data-value="2" />
    .request(String.class)  <span class="conum" data-value="3" />
    .peek(System.out::println)  <span class="conum" data-value="4" />
    .await();   <span class="conum" data-value="5" /></markup>

<ul class="colist">
<li data-value="1">Create a HTTP GET request.</li>
<li data-value="2">Target endpoint path.</li>
<li data-value="3">Execute the request and return Single with response entity handled as a String.</li>
<li data-value="4">Print the response in the console.</li>
<li data-value="5">Wait for server response because of reactive approach.</li>
</ul>
<p>The path method joins <code>/greet</code> to the WebClient base URI. The target URI for this request becomes
<code><a id="" title="" target="_blank" href="http://localhost:8080/greet">http://localhost:8080/greet</a></code> where the response should be a greeting message. Received response entity will be
automatically handled as a String. If no specific type is put into the method request(),
WebClientResponse is returned by default. This WebClientResponse object contains response code, headers and non-handled
entity.</p>

</div>

<h4 id="_run_the_application">Run the application</h4>
<div class="section">
<markup
lang="bash"
title="Build the quickstart:"
>mvn package</markup>

<p>This command will create helidon-quickstart-se.jar in the target folder.</p>

<markup
lang="bash"
title="Run the greeting application first:"
>java -cp target/helidon-quickstart-se.jar io.helidon.examples.quickstart.se.Main</markup>

<p>Open a new command prompt or terminal and run the ClientExample class you just created.</p>

<markup
lang="bash"
title="Run the greeting application first:"
>java -cp target/helidon-quickstart-se.jar io.helidon.examples.quickstart.se.ClientExample</markup>

<markup
lang="bash"
title="Output:"
>{"message":"Hello World!"}</markup>

<p>When the ClientExample finishes its execution, you can stop the Main class by pressing <code>ctrl+c</code>.</p>

</div>

<h4 id="_discover_other_webclient_functionality">Discover other WebClient functionality</h4>
<div class="section">
<p>In practice, String is not the most useful return type, since it usually needs some more handling. In this case it could
be more interesting to return an object such as JsonObject. In the previous step JSON support was added to the WebClient
so that it could be used instead of String.</p>

<markup
lang="java"
title="Replace String by JsonObject:"
>import javax.json.JsonObject;

...

webClient.get()
    .path("/greet/David")
    .request(JsonObject.class)  <span class="conum" data-value="1" />
    .peek(System.out::println)
    .await();</markup>

<ul class="colist">
<li data-value="1">Request a JsonObject as return value.</li>
</ul>
<p>In the URI, the String following <code>greet</code> is a path parameter which allows the application to greet someone.</p>

<markup
lang="bash"
title="Output:"
>{"message":"Hello David!"}</markup>

<p>This time, a JsonObject is printed out in the console. It is possible to change the greeting itself by using a PUT
request to <code>/greet/greeting</code> endpoint from the base URI.</p>

<markup
lang="java"
title="Modify the application greeting:"
>import javax.json.Json;

...

JsonObject entity = Json.createObjectBuilder() <span class="conum" data-value="1" />
    .add("greeting", "Bonjour")
    .build();
webClient.put()     <span class="conum" data-value="2" />
    .path("/greet/greeting")
    .submit(entity)     <span class="conum" data-value="3" />
    .thenCompose(response -&gt; webClient.get()    <span class="conum" data-value="4" />
        .path("/greet/David")
        .request(JsonObject.class))
    .thenAccept(System.out::println)
    .await();</markup>

<ul class="colist">
<li data-value="1">Create a JsonObject with key <code>greeting</code> and value <code>bonjour</code>.</li>
<li data-value="2">Create a PUT request.</li>
<li data-value="3">Submit the JsonObject created earlier.</li>
<li data-value="4">Once done, make a GET call to verify the modification was processed to the greeting.</li>
</ul>
<p>According to the quickstart documentation, a JSON object can be sent to the application to change the greeting following
this structure: <code>{"greeting" : "value"}</code>. The first three lines of code create the JsonObject with the required content.
This time, we use the PUT request and submit methods to push the new greeting. One way to check the greeting modification
is to execute GET request again and display obtained response. The <code>thenCompose</code> method will execute a GET request after
the PUT request is executed.</p>

<markup
lang="bash"
title="Output:"
>{"message":"Bonjour David!"}</markup>

</div>
</div>

<h3 id="_webclient_metrics">WebClient Metrics</h3>
<div class="section">
<p>WebClient, like other Helidon components, supports Metrics. The following example introduces the different metrics that
can be used to measure WebClient activity. There are two ways to set up metrics: programmatically on the WebClient
instance or manually using the configuration file.</p>


<h4 id="_add_metrics_dependency">Add metrics dependency</h4>
<div class="section">
<p>There is a specific dependency to use WebClient metrics in your application.</p>

<markup
lang="xml"
title="Add the following dependency to pom.xml:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

<h4 id="_set_up_metrics_on_webclient_instance">Set up metrics on WebClient instance</h4>
<div class="section">
<p>It is possible to register metrics on WebClient directly into the code. The following example shows a general method
that can be used with any metric.</p>

<markup
lang="java"
title="Example of metric creation:"
>import io.helidon.common.http.Http;
import io.helidon.metrics.RegistryFactory;
import io.helidon.webclient.metrics.WebClientMetrics;
import io.helidon.webclient.spi.WebClientService;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics|.Counter;
                                       |.Meter;
                                       |.Timer;
                                       |.ConcurrentGauge;

...

public static void main(String[] args) {

    MetricRegistry metricFactory = RegistryFactory.getInstance()
            .getRegistry(MetricRegistry.Type.APPLICATION);

    String metricName = "metric.GET.localhost";             <span class="conum" data-value="1" />

    Counter counter = metricFactory|.counter(metricName);   <span class="conum" data-value="2" />
                                   |.meter(metricName)
                                   |.timer(metricName)
                                   |.concurrentGauge(metricName)

    WebClientService clientServiceMetric = WebClientMetrics|.counter()
                                                           |.meter()
                                                           |.timer()
                                                           |.gaugeInProgress()

                    .methods(Http.Method.GET)           // OPTIONAL
                    .success(true)                      // OPTIONAL
                    .errors(true)                       // OPTIONAL
                    .description("Metric Description")  // OPTIONAL
                    .nameFormat("counter.%1$s.%2$s")
                    .build();                           <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Choose the metric name.</li>
<li data-value="2">Create a metric from <code>metricFactory</code>.</li>
<li data-value="3">Build a WebClient Service for counting the GET requests.</li>
</ul>
<p>The metric name can indicate what is measured. In this example, the metric target GET requests on the localhost.
In order to pass this information to the webclient, the <code>nameFormat</code> method extracts it from the metric name.
Otherwise, the metric name can also have nothing in common with its job. In this case, the methods with <code>OPTIONAL</code>
comment are not required to be used. The methods will target the chosen HTTP request type. While success and error will
respectively measure if a request is successful or failed. The description will add a metric description.</p>

<markup
lang="java"
title="Add the metric service to the WebClient:"
>WebClient webClient = WebClient.builder()
                .baseUri("http://localhost:8080")
                .addMediaSupport(JsonpSupport.create())
                .addService(clientServiceMetric)           <span class="conum" data-value="1" />
                .build();</markup>

<ul class="colist">
<li data-value="1">Register the metric service to the webclient.</li>
</ul>
<p>Simply use the <code>addService</code> method to add the metric to the WebClient on which the metrics will be measured.</p>

<markup
lang="java"
title="Print the metric count at the end of the main method:"
>System.out.println(metricName + ": " + counter.getCount());</markup>

<p>To quickly check metrics are set up correctly, print the counter at the end of the main method. In this guide, the
WebClient uses GET and PUT requests, so metrics can be applied on.</p>

</div>

<h4 id="_set_up_metrics_with_configuration_files">Set up metrics with configuration files</h4>
<div class="section">
<p>Using the configuration file can reduce the code complexity and make the metrics simpler to use. There is no
need to modify the source code but only the configuration file to measure other values. The <code>application.yaml</code> file
is the default configuration file for Helidon. It can be used to set up metrics settings.</p>

<markup
lang="yaml"
title="Example of metric configuration:"
>client:
  services:
    config:
      metrics:
        - type: METER
          name-format: "client.meter.overall"
        - type: TIMER
          # meter per method
          name-format: "client.meter.%1$s"
        - methods: ["GET"]
          type: COUNTER
          errors: false
          name-format: "client.counter.%1$s.success"
          description: "Counter of successful GET requests"
        - methods: ["PUT", "POST", "DELETE"]
          type: COUNTER
          success: false
          name-format: "wc.counter.%1$s.error"
          description: "Counter of failed PUT, POST and DELETE requests"
        - methods: ["GET"]
          type: GAUGE_IN_PROGRESS
          name-format: "client.inprogress.%2$s"
          description: "In progress requests to host"</markup>

<p>The metrics are located under <code>client.services.config.metrics</code>. The metric setting can start either by its type or
methods. The configuration file uses the same keywords as the programmatic way. <code>type</code> defines the kind of metric.</p>

<markup
lang="java"
title="Add the metric service to the WebClient:"
>Config config = Config.create();       <span class="conum" data-value="1" />

WebClient webClient = WebClient.builder()
                .baseUri("http://localhost:8080")
                .config(config.get("client"))       <span class="conum" data-value="2" />
                .addMediaSupport(JsonpSupport.create())
                .build();</markup>

<ul class="colist">
<li data-value="1">Create a Helidon Config instance from default file <code>application.yaml</code>.</li>
<li data-value="2">Configure the WebClient with the <code>client</code> section from <code>application.yaml</code>.</li>
</ul>
<p>As demonstrated, using the configuration file reduces the amount of code needed in the source code. For more information
about metrics, see the <router-link to="/se/guides/05_metrics">Helidon Metrics Guide</router-link>.</p>

</div>
</div>
</div>
</doc-view>
