<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE Health Check Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon SE project
that can be used to run some basic examples using both built-in and custom health checks.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>

<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 15 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon MP Application</td>
<td class="">You can use your own application or use the <a id="" title="" target="_blank" href="https://helidon.io/docs/v2/#/mp/guides/02_quickstart">Helidon MP Quickstart</a> to create a sample application.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;17</a> (<a id="" title="" target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;17</a>)</td>
<td class="">Helidon requires Java 17+.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.6.1+</a></td>
<td class="">Helidon requires Maven 3.6.1+.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/05_kubernetes">install one on your desktop</router-link>).</td>
</tr>
</tbody>
</table>
</div>
<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 17`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-17</markup>


<h3 id="_create_a_sample_se_project">Create a Sample SE Project</h3>
<div class="section">
<p>Generate the project sources using the Helidon SE Maven archetype.
The result is a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=3.0.0-M2 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

</div>

<h3 id="_using_the_built_in_health_checks">Using the Built-In Health Checks</h3>
<div class="section">
<p>Helidon has a set of built-in health checks that can be optionally enabled to report various
 health check statuses that are commonly used:</p>

<ul class="ulist">
<li>
<p>deadlock detection</p>

</li>
<li>
<p>available disk space</p>

</li>
<li>
<p>available heap memory</p>

</li>
</ul>
<p>The following example will demonstrate how to use the built-in health checks.  These examples are all executed
from the root directory of your project (helidon-quickstart-se).</p>

<markup
lang="xml"
title="Notice that the built-in health check dependency is already in the project&#8217;s pom.xml file:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-health-checks&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="java"
title="Have a look at <code>Main.java</code>, and the <code>createRouting</code> method:"
>private static Routing createRouting(Config config) {

    HealthSupport health = HealthSupport.builder()
      .addLiveness(HealthChecks.healthChecks())  <span class="conum" data-value="1" />
      .build();

    return Routing.builder()
      .register(health)  <span class="conum" data-value="2" />
      .build();
}</markup>

<ul class="colist">
<li data-value="1">Add built-in health checks (requires the <code>helidon-health-checks</code>
dependency).</li>
<li data-value="2">Register the created health support with web server routing (adds the
<code>/health</code> endpoint).</li>
</ul>
<markup
lang="bash"
title="Build the application, skipping unit tests, then run it:"
>mvn package -DskipTests=true
java -jar target/helidon-quickstart-se.jar</markup>

<markup
lang="bash"
title="Verify the health endpoint in a new terminal window:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "deadlock",
      "status": "UP"
    },
    {
      "name": "diskSpace",
      "status": "UP",
      "data": {
        "free": "319.58 GB",
        "freeBytes": 343144304640,
        "percentFree": "68.63%",
        "total": "465.63 GB",
        "totalBytes": 499963174912
      }
    },
    {
      "name": "heapMemory",
      "status": "UP",
      "data": {
        "free": "196.84 MB",
        "freeBytes": 206404016,
        "max": "3.56 GB",
        "maxBytes": 3817865216,
        "percentFree": "98.66%",
        "total": "245.50 MB",
        "totalBytes": 257425408
      }
    }
  ]
}</markup>

</div>

<h3 id="_custom_liveness_health_checks">Custom Liveness Health Checks</h3>
<div class="section">
<p>You can create application specific custom health checks and integrate them with Helidon
using the <code>HealthSupport</code> class, which is a  WebServer service that contains
a collection of registered <code>HealthCheck</code> instances. When queried, it invokes the registered
health check and returns a response with a status code representing the overall
state of the application.</p>

<markup
lang="xml"
title="Notice the custom health checks dependency is already in the project&#8217;s pom.xml file:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="java"
title="Replace the <code>HealthSupport</code> builder in the <code>Main.createRouting</code> method:"
>HealthSupport health = HealthSupport.builder()
  .addLiveness(() -&gt; HealthCheckResponse.named("LivenessCheck")
      .up()
      .withData("time", System.currentTimeMillis())
      .build()) <span class="conum" data-value="1" />
  .build();</markup>

<ul class="colist">
<li data-value="1">Add a custom liveness health check. This example returns <code>UP</code> and current time.</li>
</ul>
<markup
lang="bash"
title="Build and run the application, then verify the custom health endpoint:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
    "status": "UP",
    "checks": [
        {
            "name": "LivenessCheck",
            "status": "UP",
            "data": {
                "time": 1546958376613
            }
        }
    ]
}</markup>

</div>

<h3 id="_custom_readiness_health_checks">Custom Readiness Health Checks</h3>
<div class="section">
<p>You can add readiness checks to indicate that the application is ready to be used.  In this
example, the server will wait five seconds before it becomes ready.</p>

<markup
lang="java"
title="Add a <code>readyTime</code> variable to the <code>Main</code> class, then set it five seconds after the application starts:"
>import java.util.concurrent.atomic.AtomicLong; <span class="conum" data-value="1" />

public final class Main {

  private static AtomicLong readyTime = new AtomicLong(0); <span class="conum" data-value="2" />
  ...

    static WebServer startServer() throws IOException {
    ...
      server.start() ...

        // Server threads are not daemon. No need to block. Just react.
      try {
        Thread.sleep(5000); <span class="conum" data-value="3" />
      } catch (InterruptedException e) {
        throw new RuntimeException(e);
      }

      readyTime.set(System.currentTimeMillis()); <span class="conum" data-value="4" />
      return server;</markup>

<ul class="colist">
<li data-value="1">Import AtomicLong.</li>
<li data-value="2">Declare the <code>readyTime</code> variable.</li>
<li data-value="3">Sleep five seconds.</li>
<li data-value="4">Set the <code>readyTime</code> to the time when the server became ready.</li>
</ul>
<markup
lang="java"
title="Add a readiness check to the <code>HealhSupport</code> builder in the <code>Main.createRouting</code> method:"
>HealthSupport health = HealthSupport.builder()
  .addLiveness(() -&gt; HealthCheckResponse.named("LivenessCheck")
      .up()
      .withData("time", System.currentTimeMillis())
      .build())
  .addReadiness(() -&gt; HealthCheckResponse.named("ReadinessCheck")
      .status(readyTime.get() != 0 )
      .withData( "time", readyTime.get())
      .build()) <span class="conum" data-value="1" />
  .build();</markup>

<ul class="colist">
<li data-value="1">Add the readiness check.</li>
</ul>
<markup
lang="bash"
title="Build and run the application.  Issue the <code>curl</code> command with -v within five seconds and you see the application is not ready:"
>curl -v  http://localhost:8080/health/ready</markup>

<markup
lang="json"
title="HTTP response:"
>...
&lt; HTTP/1.1 503 Service Unavailable <span class="conum" data-value="1" />
...
{
  "status": "DOWN",
  "checks": [
    {
      "name": "ReadinessCheck",
      "status": "DOWN",
      "data": {
        "time,": 0
      }
    }
  ]
}</markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>503</code> since the application is not ready.</li>
</ul>
<markup
lang="bash"
title="After five seconds you will see the application is ready:"
>curl -v http://localhost:8080/health/ready</markup>

<markup
lang="json"
title="JSON response:"
>...
&lt; HTTP/1.1 200 OK <span class="conum" data-value="1" />
...
{
  "status": "UP",
  "checks": [
    {
      "name": "ReadinessCheck",
      "status": "UP",
      "data": {
        "time,": 1566243562097
      }
    }
  ]
}</markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>200</code> indicating that the application is ready.</li>
</ul>
</div>

<h3 id="_custom_startup_health_checks">Custom Startup Health Checks</h3>
<div class="section">
<p>You can create custom startup health checks to indicate when the application has fully started and, therefore, when the readiness and liveness checks are meaningful.</p>

<p>This example reuses the <code>readyTime</code> field added above for the custom readiness check and adds a startup check that waits three additional seconds past the "ready" time before declaring the application started.</p>

<markup
lang="java"
title="Add a startup check to the <code>HealhSupport</code> builder in the <code>Main.createRouting</code> method:"
>HealthSupport health = HealthSupport.builder()
  .addLiveness(() -&gt; HealthCheckResponse.named("LivenessCheck")
      .up()
      .withData("time", System.currentTimeMillis())
      .build())
  .addReadiness(() -&gt; HealthCheckResponse.named("ReadinessCheck")
      .status(readyTime.get() != 0 )
      .withData("time", readyTime.get())
      .build())
  .addStartup(() -&gt; HealthCheckResponse.named("StartupCheck") <span class="conum" data-value="1" />
      .status(readyTime.get() != 0
              &amp;&amp; Duration.ofMillis(System.currentTimeMillis() - readyTime.get()).getSeconds() &gt;= 3)
      .withData("time", readyTime.get())
      .build())
  .build();</markup>

<ul class="colist">
<li data-value="1">Add the startup check.</li>
</ul>
<markup
lang="bash"
title="Build and run the application.  Issue the <code>curl</code> command with -v within eight seconds and you see the application is not reported as started:"
>curl -v  http://localhost:8080/health/started</markup>

<markup
lang="json"
title="HTTP response:"
>...
&lt; HTTP/1.1 503 Service Unavailable <span class="conum" data-value="1" />
...
{
  "status": "DOWN",
  "checks": [
    {
      "name": "StartupCheck",
      "status": "DOWN",
      "data": {
        "time": 1566243562097
      }
    }
  ]
}</markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>503</code> since the application is not started.</li>
</ul>
<markup
lang="bash"
title="After eight seconds you will see the application is started:"
>curl -v http://localhost:8080/health/started</markup>

<markup
lang="json"
title="JSON response:"
>...
&lt; HTTP/1.1 200 OK <span class="conum" data-value="1" />
...
{
  "status": "UP",
  "checks": [
    {
      "name": "StartupCheck",
      "status": "UP",
      "data": {
        "time": 1566243562097
      }
    }
  ]
}</markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>200</code> indicating that the application is started.</li>
</ul>
<p>When using the health check URLs, you can get the following health check data</p>

<ul class="ulist">
<li>
<p>liveness only - <a id="" title="" target="_blank" href="http://localhost:8080/health/live">http://localhost:8080/health/live</a></p>

</li>
<li>
<p>readiness only -  <a id="" title="" target="_blank" href="http://localhost:8080/health/ready">http://localhost:8080/health/ready</a></p>

</li>
<li>
<p>startup only - <a id="" title="" target="_blank" href="http://localhost:8080/health/started">http://localhost:8080/health/started</a></p>

</li>
<li>
<p>all -  <a id="" title="" target="_blank" href="http://localhost:8080/health">http://localhost:8080/health</a></p>

</li>
</ul>
<markup
lang="bash"
title="Get all of liveness, readiness, and startup data from a single query:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "LivenessCheck",
      "status": "UP",
      "data": {
        "time": 1566244094548
      }
    },
    {
      "name": "ReadinessCheck",
      "status": "UP",
      "data": {
        "time,": 1566244093012
      }
    },
    {
      "name": "StartupCheck",
      "status": "UP",
      "data": {
        "time": 1566244093012
      }
    }
  ]
}</markup>

</div>

<h3 id="_combine_built_in_and_custom_health_checks">Combine Built-In and Custom Health Checks</h3>
<div class="section">
<p>You can combine built-in and custom health checks using the same <code>HealthSupport</code> builder.</p>

<markup
lang="java"
title="Register a custom health check in the <code>Main.createRouting</code> method:"
>HealthSupport health = HealthSupport.builder()
    .addLiveness(HealthChecks.healthChecks())  <span class="conum" data-value="1" />
    .addLiveness(() -&gt; HealthCheckResponse.named("LivenessCheck")
      .up()
      .withData("time", System.currentTimeMillis())
      .build())
    .addReadiness(() -&gt; HealthCheckResponse.named("ReadinessCheck")
      .status(readyTime.get() != 0)
      .withData("time", readyTime.get())
      .build())
    .addStartup(() -&gt; HealthCheckResponse.named("StartupCheck")
      .status(readyTime.get() != 0
              &amp;&amp; Duration.ofMillis(System.currentTimeMillis() - readyTime.get()).getSeconds() &gt;= 3)
      .withData("time", readyTime.get())
      .build())
    .build();</markup>

<ul class="colist">
<li data-value="1">Add the built-in health checks back to <code>HealthSupport</code> builder.</li>
</ul>
<markup
lang="bash"
title="Build and run the application, then verify the health endpoint.  You will see both the built-in and custom health check data:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "LivenessCheck",
      "status": "UP",
      "data": {
        "time": 1566245527673
      }
    },
    {
      "name": "ReadinessCheck",
      "status": "UP",
      "data": {
        "time,": 1566245527620
      },
    {
      "name": "StartupCheck",
      "status": "UP",
      "data": {
        "time,": 1566245527620
      }
    },
    {
      "name": "deadlock",
      "status": "UP"
    },
    {
      "name": "diskSpace",
      "status": "UP",
      "data": {
        "free": "326.17 GB",
        "freeBytes": 350224424960,
        "percentFree": "70.05%",
        "total": "465.63 GB",
        "totalBytes": 499963174912
      }
    },
    {
      "name": "heapMemory",
      "status": "UP",
      "data": {
        "free": "247.76 MB",
        "freeBytes": 259791680,
        "max": "4.00 GB",
        "maxBytes": 4294967296,
        "percentFree": "99.80%",
        "total": "256.00 MB",
        "totalBytes": 268435456
      }
    }
  ]
}</markup>

</div>

<h3 id="_custom_health_check_url_path">Custom Health Check URL Path</h3>
<div class="section">
<p>You can use a custom URL path for heath checks by setting the <code>WebContext</code>.  In the following example, only
the liveness URL is changed, but you can do the same for the readiness, startup, and default
health checks.</p>

<markup
lang="java"
title="Register a custom URL path with the custom health check in the <code>Main.createRouting</code> method:"
>HealthSupport health = HealthSupport.builder()
    .webContext("/probe/live")<span class="conum" data-value="1" />
    .addLiveness(() -&gt; HealthCheckResponse.named("livenessProbe")
      .up()
      .withData("time", System.currentTimeMillis())
      .build())
    .build();</markup>

<ul class="colist">
<li data-value="1">Change the liveness URL path using a <code>WebContext</code>.</li>
</ul>
<markup
lang="bash"
title="Build and run the application, then verify that the liveness endpoint is using the <code>/probe/live</code>:"
>curl http://localhost:8080/probe/live</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "livenessProbe",
      "status": "UP",
      "data": {
        "time": 1546958376613
      }
    }
  ]
}</markup>

</div>

<h3 id="_using_liveness_readiness_and_startup_health_checks_with_kubernetes">Using Liveness, Readiness, and Startup Health Checks with Kubernetes</h3>
<div class="section">
<p>The following example shows how to integrate the Helidon health API in an application that implements
health endpoints for the Kubernetes liveness, readiness, and startup probes.</p>

<markup
lang="java"
title="Change the <code>HealthSupport</code> builder in the <code>Main.createRouting</code> method to use the built-in liveness checks and custom liveness, readiness, and startup checks:"
>HealthSupport health = HealthSupport.builder()
    .addLiveness(HealthChecks.healthChecks()) <span class="conum" data-value="1" />
    .addLiveness(() -&gt; HealthCheckResponse.named("LivenessCheck")  <span class="conum" data-value="2" />
      .up()
      .withData("time", System.currentTimeMillis())
      .build())
    .addReadiness(() -&gt; HealthCheckResponse.named("ReadinessCheck")  <span class="conum" data-value="3" />
      .status(readyTime.get() != 0 )
      .withData("time", readyTime.get())
      .build())
    .addStartup(() -&gt; HealthCheckResponse.named("StartupCheck")  <span class="conum" data-value="4" />
      .status(readyTime.get() != 0
              &amp;&amp; Duration.ofMillis(System.currentTimeMillis() - readyTime.get()).getSeconds() &gt;= 3)
      .withData("time", readyTime.get())
      .build())
    .build();</markup>

<ul class="colist">
<li data-value="1">Add built-in health checks.</li>
<li data-value="2">Add a custom liveness check.</li>
<li data-value="3">Add a custom readiness check.</li>
<li data-value="4">Add a custom startup check.</li>
</ul>
<markup
lang="bash"
title="Build and run the application, then verify the liveness, readiness, and started endpoints:"
>curl http://localhost:8080/health/live
curl http://localhost:8080/health/ready
curl http://localhost:8080/health/started</markup>

<markup
lang="bash"
title="Stop the application and build the docker image:"
>docker build -t helidon-quickstart-se .</markup>

<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>health.yaml</code>, with the following content:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-health <span class="conum" data-value="1" />
  labels:
    app: helidon-health
spec:
  type: NodePort
  selector:
    app: helidon-health
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: extensions/v1beta1
metadata:
  name: helidon-health <span class="conum" data-value="2" />
spec:
  replicas: 1
  template:
    metadata:
      labels:
        app: helidon-health
        version: v1
    spec:
      containers:
        - name: helidon-health
          image: helidon-quickstart-se
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080
          livenessProbe:
            httpGet:
              path: /health/live <span class="conum" data-value="3" />
              port: 8080
            initialDelaySeconds: 5 <span class="conum" data-value="4" />
            periodSeconds: 10
            timeoutSeconds: 3
            failureThreshold: 3
          readinessProbe:
            httpGet:
              path: /health/ready <span class="conum" data-value="5" />
              port: 8080
            initialDelaySeconds: 5 <span class="conum" data-value="6" />
            periodSeconds: 2
            timeoutSeconds: 3
          startupProbe:
            httpGet:
              path: /health/started <span class="conum" data-value="7" />
              port: 8080
            initialDelaySeconds: 8 <span class="conum" data-value="8" />
            periodSeconds: 10
            timeoutSeconds: 3
            failureThreshold: 3
---</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">A deployment with one replica of a pod.</li>
<li data-value="3">The HTTP endpoint for the liveness probe.</li>
<li data-value="4">The liveness probe configuration.</li>
<li data-value="5">The HTTP endpoint for the readiness probe.</li>
<li data-value="6">The readiness probe configuration.</li>
<li data-value="7">The HTTP endpoint for the startup probe.</li>
<li data-value="8">The startup probe configuration.</li>
</ul>
<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./health.yaml</markup>

<markup
lang="bash"
title="Get the service information:"
>kubectl get service/helidon-health</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-health   NodePort   10.107.226.62   &lt;none&gt;        8080:30116/TCP   4s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>30116</code>.</li>
</ul>
<markup
lang="bash"
title="Verify the health endpoints using port '30116', your port may be different:"
>curl http://localhost:30116/health</markup>

<markup
lang="bash"
title="Delete the application, cleaning up Kubernetes resources:"
>kubectl delete -f ./health.yaml</markup>

</div>

<h3 id="_summary">Summary</h3>
<div class="section">
<p>This guide demonstrated how to use health checks in a Helidon SE application as follows:</p>

<ul class="ulist">
<li>
<p>Access the default health check</p>

</li>
<li>
<p>Create and use custom readiness, liveness, and startup checks</p>

</li>
<li>
<p>Customize the health check root path</p>

</li>
<li>
<p>Integrate Helidon health check with Kubernetes</p>

</li>
</ul>
<p>Refer to the following reference for additional information:</p>

<ul class="ulist">
<li>
<p>Helidon Javadoc at <a id="" title="" target="_blank" href="https://helidon.io/docs/latest/apidocs/index.html?overview-summary.html">https://helidon.io/docs/latest/apidocs/index.html?overview-summary.html</a></p>

</li>
</ul>
</div>
</div>
</doc-view>
