<doc-view>

<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable JWT Authentication
either add a dependency on the <router-link to="/mp/introduction/02_microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see <router-link to="/about/04_managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>        &lt;dependency&gt;
            &lt;groupId&gt;io.helidon.microprofile.jwt&lt;/groupId&gt;
            &lt;artifactId&gt;helidon-microprofile-jwt-auth&lt;/artifactId&gt;
        &lt;/dependency&gt;</markup>

</div>

<h2 id="_overview">Overview</h2>
<div class="section">
<p>JSON Web Token (JWT) defines a compact and self-contained way for securely transmitting information between parties as a JSON object. With JWT Auth you can integrate security features such as single sign on into your Helidon MP applications.</p>

</div>

<h2 id="_next_steps">Next Steps</h2>
<div class="section">
<p>The main configuration point for JWT Auth is a JAX-RS Application class.
As this class is discovered using CDI, it must have a bean defining annotation.</p>

<p>Example of an application that enables JWT-Auth (with minimal required annotations):</p>

<markup
lang="java"

>@LoginConfig(authMethod = "MP-JWT")
@ApplicationScoped
public class ProtectedApplication extends Application{
}</markup>

<p>Learn more about JWT authentication:<br></p>

<p><a id="" title="" target="_blank" href="https://download.eclipse.org/microprofile/microprofile-jwt-auth-2.0/microprofile-jwt-auth-spec-2.0.pdf#_introduction">Eclipse MicroProfile Interoperable JWT RBAC</a></p>

</div>
</doc-view>
