<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon with JBatch Guide</dt>
<dd slot="desc"><p>This guide describes how Helidon and Jakarta Batch (JBatch) can be used together to execute batch jobs in environments that do not fully support EE environments.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>

<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 20 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon MP Application</td>
<td class="">You can use your own application or use the <a id="" title="" target="_blank" href="https://helidon.io/docs/v2/#/mp/guides/02_quickstart">Helidon MP Quickstart</a> to create a sample application.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;17</a> (<a id="" title="" target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;17</a>)</td>
<td class="">Helidon requires Java 17+.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.6.1+</a></td>
<td class="">Helidon requires Maven 3.6.1+.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a id="" title="" target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/05_kubernetes">install one on your desktop</router-link>).</td>
</tr>
</tbody>
</table>
</div>
<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 17`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-17</markup>

<div class="admonition note">
<p class="admonition-inline">This guide assumes you are familiar with the <a id="" title="" target="_blank" href="https://projects.eclipse.org/projects/ee4j.batch">Jakarta Batch project specification</a> from the Ecplipse Foundation project site.</p>
</div>
</div>

<h2 id="_dependencies">Dependencies</h2>
<div class="section">
<p>For this example, add the IBM JBatch implementation and the <code>derby</code> embedded DB (since JPA and JPA are not available by default) dependencies to the testing module:</p>

<markup
lang="xml"
title="Maven dependencies"
>&lt;dependencies&gt;
  &lt;dependency&gt;
     &lt;groupId&gt;com.ibm.jbatch&lt;/groupId&gt;
     &lt;artifactId&gt;com.ibm.jbatch.container&lt;/artifactId&gt;
 &lt;/dependency&gt;
  &lt;dependency&gt;
     &lt;groupId&gt;org.apache.derby&lt;/groupId&gt;
     &lt;artifactId&gt;derby&lt;/artifactId&gt;
  &lt;/dependency&gt;
&lt;dependencies&gt;</markup>

</div>

<h2 id="_add_sample_jobs">Add Sample Jobs</h2>
<div class="section">
<p>In this demonstration you will first create sample input and output records and then the following jobs: <code>MyItemReader</code>, <code>MyItemProcessor</code> and <code>MyItemWriter</code>. Finally you will create <code>MyBatchlet</code> to demonstrate all possible usages of JBatch.</p>


<h4 id="_1_create_a_unit_of_input_information">1. Create a unit of input information</h4>
<div class="section">
<markup
lang="java"
title="MyInputRecord"
>public class MyInputRecord {
    private int id;


    public MyInputRecord(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "MyInputRecord: " + id;
    }
}</markup>

</div>

<h4 id="_2_create_a_unit_of_output_information">2. Create a unit of output information</h4>
<div class="section">
<markup
lang="java"
title="MyOutputRecord"
>public class MyOutputRecord {

    private int id;

    public MyOutputRecord(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "MyOutputRecord: " + id;
    }
}</markup>

</div>

<h4 id="_3_create_myitemreader_to_extend_abstractitemreader">3. Create <code>MyItemReader</code> to extend <code>AbstractItemReader</code></h4>
<div class="section">
<p><code>MyItemReader</code> should look like this:</p>

<markup
lang="java"
title="MyItemReader"
>public class MyItemReader extends AbstractItemReader {

    private final StringTokenizer tokens;

    public MyItemReader() {
        tokens = new StringTokenizer("1,2,3,4,5,6,7,8,9,10", ",");
    }

    /**
     * Perform read Item.
     * @return Stage result.
     */
    @Override
    public MyInputRecord readItem() {
        if (tokens.hasMoreTokens()) {
            return new MyInputRecord(Integer.valueOf(tokens.nextToken()));
        }
        return null;
    }
}</markup>

</div>

<h4 id="_4_create_myitemprocessor_to_implement_itemprocessor">4. Create <code>MyItemProcessor</code> to implement <code>ItemProcessor</code></h4>
<div class="section">
<p>The <code>MyItemProcessor</code> will perform some simple operations:</p>

<markup
lang="java"
title="MyItemProcessor"
>public class MyItemProcessor implements ItemProcessor {

    @Override
    public MyOutputRecord processItem(Object t) {
        System.out.println("processItem: " + t);

        return (((MyInputRecord) t).getId() % 2 == 0) ? null : new MyOutputRecord(((MyInputRecord) t).getId() * 2);
    }
}</markup>

</div>

<h4 id="_5_create_myitemwriter_to_extend_abstractitemwriter">5. Create <code>MyItemWriter</code> to extend <code>AbstractItemWriter</code></h4>
<div class="section">
<p><code>MyItemWriter</code> prints the result:</p>

<markup
lang="java"
title="MyItemWriter"
>public class MyItemWriter extends AbstractItemWriter {

    @Override
    public void writeItems(List list) {
        System.out.println("writeItems: " + list);
    }
}</markup>

</div>

<h4 id="_6_create_mybatchlet_to_extentd_abstractbatchlet">6. Create <code>MyBatchlet</code> to extentd <code>AbstractBatchlet</code></h4>
<div class="section">
<p><code>MyBatchlet</code> simply completes the process:</p>

<markup
lang="java"
title="MyBatchlet"
>public class MyBatchlet extends AbstractBatchlet {

    @Override
    public String process() {
        System.out.println("Running inside a batchlet");

        return "COMPLETED";
    }

}</markup>

</div>
</div>

<h2 id="_update_the_descriptor_file">Update the Descriptor File</h2>
<div class="section">
<p>Add this code to your job descriptor.xml file:</p>

<markup
lang="java"
title="Updated descriptor file"
>&lt;job id="myJob" xmlns="http://xmlns.jcp.org/xml/ns/javaee" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/jobXML_1_0.xsd" version="1.0"&gt;
    &lt;step id="step1" next="step2"&gt;
        &lt;chunk item-count="3"&gt; <span class="conum" data-value="1" />
            &lt;reader ref="io.helidon.jbatch.example.jobs.MyItemReader"/&gt;
            &lt;processor ref="io.helidon.jbatch.example.jobs.MyItemProcessor"/&gt;
            &lt;writer ref="io.helidon.jbatch.example.jobs.MyItemWriter"/&gt;
        &lt;/chunk&gt;
    &lt;/step&gt;
    &lt;step id="step2" &gt; <span class="conum" data-value="2" />
        &lt;batchlet ref="io.helidon.jbatch.example.jobs.MyBatchlet"/&gt;
    &lt;/step&gt;
&lt;/job&gt;</markup>

<ul class="colist">
<li data-value="1">The first step of the job includes <code>MyItemReader</code>, <code>MyItemProcessor</code> and <code>MyItemWriter</code>.</li>
<li data-value="2">The second step of the job includes <code>MyBatchlet</code>.</li>
</ul>
<div class="admonition note">
<p class="admonition-inline">You must specify the fully qualified names in the <code>ref</code> properties, like “io.helidon.jbatch.example.jobs.MyItemReader”, otherwise it will not work.</p>
</div>
</div>

<h2 id="_create_an_endpoint">Create an Endpoint</h2>
<div class="section">
<p>Create a small endpoint to activate the job:</p>

<markup
lang="java"
title="new endpoint"
>@Path("/batch")
@ApplicationScoped
public class BatchResource {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

    private JobOperator jobOperator;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public JsonObject executeBatch() {

        BatchSPIManager batchSPIManager = BatchSPIManager.getInstance();
        batchSPIManager.registerPlatformMode(BatchSPIManager.PlatformMode.SE);
        batchSPIManager.registerExecutorServiceProvider(new HelidonExecutorServiceProvider());

        jobOperator = getJobOperator();
        Long executionId = jobOperator.start("myJob", new Properties());

        return JSON.createObjectBuilder()
                .add("Started a job with Execution ID: ", executionId)
                .build();
    }


    @GET
    @Path("/status/{execution-id}")
    public JsonObject status(@PathParam("execution-id") Long executionId){
        JobExecution jobExecution = jobOperator.getJobExecution(executionId);

        List&lt;StepExecution&gt; stepExecutions = jobOperator.getStepExecutions(executionId);
        List&lt;String&gt; executedSteps = new ArrayList&lt;&gt;();
        for (StepExecution stepExecution : stepExecutions) {
            executedSteps.add(stepExecution.getStepName());
        }

        return JSON.createObjectBuilder()
                .add("Steps executed", Arrays.toString(executedSteps.toArray()))
                .add("Status", jobExecution.getBatchStatus().toString())
                .build();
    }
}</markup>

<p>Helidon specifies to JBatch that it should run in Standalone (SE) mode. It will also register the <code>HelidonExecutorServiceProvider</code> which is actually relatively small. For our example we need something really small, like a <code>FixedTheadPool</code> with 2 threads. This provider is used to tell our JBatch engine exactly which ExecutorSevice to use.</p>

<markup
lang="java"
title="HelidonExecutorServiceProvider"
>public class HelidonExecutorServiceProvider implements ExecutorServiceProvider {
    @Override
    public ExecutorService getExecutorService() {
        return ThreadPoolSupplier.builder().corePoolSize(2).build().get();
    }
}</markup>

</div>

<h2 id="_run_the_code">Run the Code</h2>
<div class="section">
<markup
lang="bash"

>mvn package
java -jar target/helidon-jbatch-example.jar</markup>

</div>

<h2 id="_call_the_endpoint">Call the Endpoint</h2>
<div class="section">
<markup
lang="bash"

>curl -X GET http://localhost:8080/batch</markup>

<p>You should receive the following log:</p>

<markup
lang="bash"

>processItem: MyInputRecord: 1
processItem: MyInputRecord: 2
processItem: MyInputRecord: 3
writeItems: [MyOutputRecord: 2, MyOutputRecord: 6]
processItem: MyInputRecord: 4
processItem: MyInputRecord: 5
processItem: MyInputRecord: 6
writeItems: [MyOutputRecord: 10]
processItem: MyInputRecord: 7
processItem: MyInputRecord: 8
processItem: MyInputRecord: 9
writeItems: [MyOutputRecord: 14, MyOutputRecord: 18]
processItem: MyInputRecord: 10
Running inside a batchlet</markup>

<p>and the following result:</p>

<markup
lang="bash"

>{"Started a job with Execution ID: ":1}</markup>

<p>This indicates that the batch job was called and executed successfully.</p>


<h3 id="_check_the_status">Check the Status</h3>
<div class="section">
<markup
lang="bash"

>curl -X GET http://localhost:8080/batch/status/1</markup>

<div class="admonition note">
<p class="admonition-inline">In this example the job ID is 1, but make sure that you enter your specfic job ID in the string.</p>
</div>
<p>The results should look something like this:</p>

<markup
lang="bash"

>{"Steps executed":"[step1, step2]","Status":"COMPLETED"}</markup>

</div>
</div>

<h2 id="_summary">Summary</h2>
<div class="section">
<p>This guide demonstrated how to use Helidon with JBatch even though Helidon is not a full EE container.</p>

</div>
</doc-view>
