<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>General Bean Validation</dt>
<dd slot="desc"><p>If bean validation is required outside JAX-RS/Jersey use cases, it is also available in Helidon.
It follows the standard <a id="" title="" target="_blank" href="https://projects.eclipse.org/projects/ee4j.bean-validation">Jakarta Bean
Validation specification</a> which defines an API to validate Java beans.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>

<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable General Bean Validation
add the following dependency to your project&#8217;s <code>pom.xml</code> (see <router-link to="/about/04_managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
  &lt;groupId&gt;io.helidon.microprofile.bean-validation&lt;/groupId&gt;
  &lt;artifactId&gt;helidon-microprofile-bean-validation&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

<h2 id="_validation_example_in_helidon_mp">Validation Example in Helidon MP</h2>
<div class="section">
<p>The following example shows a simple application with one field declared as <em>not null</em> using <code>@NotNull</code> annotation:</p>

<markup
lang="java"

>public class GreetingHolder {
    @NotNull
    private String greeting;
    //...
}</markup>

<p>If the bean contains a method parameter annotated with @Valid, and GreetingHolder with <em>null_greeting is passed, then a _ValidationException</em> will be thrown:</p>

<markup
lang="java"

>@ApplicationScoped
public class GreetingProvider {
    private GreetingHolder greetingHolder;
    //..
    void setGreeting(@Valid GreetingHolder greetingHolder) {
        this.greetingHolder = greetingHolder;
    }
}</markup>

<div class="admonition note">
<p class="admonition-inline"><code>beans.xml</code> is required to identify beans and for bean validation to work properly.</p>
</div>
<p>For more information about the supported validations, see <a id="" title="" target="_blank" href="https://projects.eclipse.org/projects/ee4j.bean-validation">Jakarta Bean Validation specification</a>.</p>

</div>
</doc-view>
