<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_references" @click.native="this.scrollFix('#_references')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Neo4j is a graph database management system developed by Neo4j, Inc. It is an ACID-compliant transactional database with native graph storage and processing. Neo4j is available in a GPL3-licensed open-source “community edition”.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Neo4j
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-integrations-neo4j&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<div class="admonition note">
<p class="admonition-inline">Check <router-link to="#_neo4j_metrics_propagation" @click.native="this.scrollFix('#_neo4j_metrics_propagation')">Neo4j Metrics propagation</router-link> and <router-link to="#_neo4j_health_checks" @click.native="this.scrollFix('#_neo4j_health_checks')">Neo4j Health Checks</router-link> for additional dependencies for <em>Neo4j</em> <code>Metrics</code> and <code>Health Checks</code> integration.</p>
</div>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>The support for Neo4j is implemented in Neo4j driver level. Just add the dependency, add configuration in <code>application.yaml</code> file and Neo4j driver will be configured by Helidon and can be used with <code>Neo4j</code> support object.</p>

<p>First describe Neo4j connection properties:</p>

<markup
lang="yaml"

>neo4j:
 uri: bolt://localhost:7687
 authentication:
   username: neo4j
   password: secret
 pool:
   metricsEnabled: true</markup>

<p>Then just get the driver:</p>

<markup
lang="java"

>Neo4j neo4j = Neo4j.create(config.get("neo4j"));
Driver neo4jDriver = neo4j.driver();</markup>

<p>The driver can be used according to the <a target="_blank" href="https://neo4j.com/developer/java/">Neo4j documentation</a>.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Type: <a target="_blank" href="/apidocs/io.helidon.integrations.neo4j/io/helidon/integrations/neo4j/Neo4j.html">io.helidon.integrations.neo4j.Neo4j</a></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>authentication-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Enable authentication.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>certificate</code></td>
<td class=""><doc-view>
<p>Path</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set certificate path.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-acquisition-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT1MS</code></td>
<td class=""><doc-view>
<p>Set connection acquisition timeout.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>encrypted</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enable encrypted field.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>hostname-verification-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enable hostname verification.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idle-time-before-connection-test</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT-1MS</code></td>
<td class=""><doc-view>
<p>Set idle time.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>log-leaked-sessions</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enable log leaked sessions.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-connection-lifetime</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5H</code></td>
<td class=""><doc-view>
<p>Set max life time.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-connection-pool-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>100</code></td>
<td class=""><doc-view>
<p>Set pool size.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>metrics-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enable metrics.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>password</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Create password.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust-strategy</code></td>
<td class=""><doc-view>
<p>TrustStrategy (TRUST_ALL_CERTIFICATES, TRUST_CUSTOM_CA_SIGNED_CERTIFICATES, TRUST_SYSTEM_CA_SIGNED_CERTIFICATES)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set trust strategy.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Create uri.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>username</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Create username.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>This example implements a simple Neo4j REST service using MicroProfile. For this example a working Neo4j database is required. The Neo4j Movie database is used for this example.</p>

<p>Bring up a Neo4j instance via Docker</p>

<markup
lang="bash"

>docker run --publish=7474:7474 --publish=7687:7687 -e 'NEO4J_AUTH=neo4j/secret'  neo4j:latest</markup>

<p>Go to the Neo4j browser and play the first step of the movies graph: <a target="_blank" href="http://localhost:7474/browser/?cmd=play&amp;arg=movies"><code>:play movies</code></a></p>

<p>Now go to the <code>pom.xml</code> and add the following dependencies:</p>

<markup
lang="xml"

>&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-neo4j&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-neo4j-metrics&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-neo4j-health&lt;/artifactId&gt;
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

<p>Next add the connection configuration properties for Neo4j:</p>

<markup
lang="yaml"

>neo4j:
 uri: bolt://localhost:7687
 authentication:
   username: neo4j
   password: secret
 pool:
   metricsEnabled: true</markup>

<p>This includes both connection information and enables Neo4j metrics propagation.</p>

<p>Finally, we are able to use the <code>Neo4j</code> driver.</p>

<markup
lang="java"

>record MovieRepository(Driver driver) { <span class="conum" data-value="1" />

    List&lt;Movie&gt; findAll() { <span class="conum" data-value="2" />
        try (var session = driver.session()) {
            var query = """
                        match (m:Movie)
                        match (m) &lt;- [:DIRECTED] - (d:Person)
                        match (m) &lt;- [r:ACTED_IN] - (a:Person)
                        return m, collect(d) as directors, collect({name:a.name, roles: r.roles}) as actors
                        """;

            return session.executeRead(tx -&gt; tx.run(query).list(r -&gt; {
                var movieNode = r.get("m").asNode();

                var directors = r.get("directors").asList(v -&gt; {
                    var personNode = v.asNode();
                    return new Person(personNode.get("born").asInt(), personNode.get("name").asString());
                });

                var actors = r.get("actors").asList(v -&gt; {
                    return new Actor(v.get("name").asString(), v.get("roles").asList(Value::asString));
                });

                return new Movie(
                        movieNode.get("title").asString(),
                        movieNode.get("tagline").asString(),
                        movieNode.get("released").asInt(),
                        directors,
                        actors);
            }));
        }
    }
}</markup>

<ul class="colist">
<li data-value="1">Constructor with <code>Neo4j</code> driver parameter</li>
<li data-value="2">Use <code>Neo4j</code> driver to extract all Movies</li>
</ul>

<p>Movies can now be returned as JSON objects:</p>

<markup
lang="java"

>record MovieService(MovieRepository movieRepository) implements HttpService {

    @Override
    public void routing(HttpRules rules) {
        rules.get("/api/movies", this::findMovies);
    }

    void findMovies(ServerRequest request, ServerResponse response) {
        response.send(this.movieRepository.findAll());
    }
}</markup>

<p>To use the service, as well as to add metrics and health support the following routing should be created:</p>

<markup
lang="java"

>Neo4j neo4j = Neo4j.create(config.get("neo4j"));
Driver driver = neo4j.driver(); <span class="conum" data-value="1" />

Neo4jMetricsSupport.builder()
        .driver(driver)
        .build()
        .initialize(); <span class="conum" data-value="2" />

ObserveFeature observeFeature = ObserveFeature.builder()
        .addObserver(HealthObserver.builder()
                             .addCheck(Neo4jHealthCheck.create(driver))
                             .build())
        .build(); <span class="conum" data-value="3" />

WebServer server = WebServer.builder()
        .addFeature(observeFeature)
        .routing(it -&gt; it.register(new MovieService(new MovieRepository(driver)))) <span class="conum" data-value="4" />
        .build()
        .start();

System.out.println("WEB server is up! http://localhost:" + server.port() + "/api/movies");</markup>

<ul class="colist">
<li data-value="1">Use of <code>Neo4j</code> support object to initialise and configure the driver.</li>
<li data-value="2">Use of <code>Neo4jMetricsSupport</code> to add <em>Neo4j</em> metrics to <code>/metrics</code> output.</li>
<li data-value="3">Use of <code>Neo4jHealthCheck</code> to add <em>Neo4j</em> health support.</li>
<li data-value="4">Register  <code>MovieService</code>  in <em>Routing</em>.</li>
</ul>

<p>Now build and run with JDK17+</p>

<markup
lang="bash"

>mvn package
java -jar target/helidon-examples-integration-neo4j-mp.jar</markup>

<p>Exercise the application:</p>

<markup
lang="bash"

>curl -X GET http://localhost:8080/movies

# Try health
curl -s -X GET http://localhost:8080/health

# Try metrics in Prometheus Format
curl -s -X GET http://localhost:8080/metrics

# Try metrics in JSON Format
curl -H 'Accept: application/json' -X GET http://localhost:8080/metrics</markup>

<p>Full example code is available in <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.9/examples/integrations/neo4j/neo4j-mp">Helidon GitHub Repository</a>.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_neo4j_metrics_propagation">Neo4j Metrics propagation</h3>
<div class="section">
<p>Neo4j&#8217;s metrics can be propagated to the user as <code>MicroProfile</code> metrics. This is implemented in a separate Maven module. Just add:</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-integrations-neo4j-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<div class="admonition note">
<p class="admonition-inline">Works with <em>Neo4j Integration</em> main dependency described in <router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link>.</p>
</div>

<p>To enable metrics in Neo4j, add the following property to <code>application.yaml</code>:</p>

<markup
lang="yaml"

>pool:
   metricsEnabled: true</markup>

<p>Finally, to initialize metrics run:</p>

<markup
lang="java"

>Neo4jMetricsSupport.builder()
        .driver(driver)
        .build()
        .initialize();</markup>

<p>Neo4j&#8217;s metrics will be automatically added to the output of the <code>/metrics</code> endpoint.</p>

</div>


<h3 id="_neo4j_health_checks">Neo4j Health Checks</h3>
<div class="section">
<p>If your application is highly dependent on Neo4j database, health and liveness checks are essential for this application to work correctly.</p>

<p><code>MicroProfile</code> Health checks for Neo4j are implemented in a separate Maven module:</p>

<markup
lang="xml"

>&lt;dependency&gt;
   &lt;groupId&gt;io.helidon.integrations.neo4j&lt;/groupId&gt;
   &lt;artifactId&gt;helidon-integrations-neo4j-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<div class="admonition note">
<p class="admonition-inline">Works with <em>Neo4j Integration</em> main dependency described in <router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link>.</p>
</div>

<p>To enable health checks run the following code:</p>

<markup
lang="java"

>ObserveFeature observeFeature = ObserveFeature.builder()
        .addObserver(HealthObserver.builder()
                             .addCheck(Neo4jHealthCheck.create(driver))
                             .build())
        .build();</markup>

<p>Health checks for Neo4j will be included in <code>/health</code> endpoint output.</p>

</div>

</div>


<h2 id="_references">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://neo4j.com/">Neo4j official website</a></p>

</li>
<li>
<p><a target="_blank" href="https://neo4j.com/developer/java/">Neo4j Java developer guide</a></p>

</li>
</ul>

</div>

</doc-view>
