<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE Health Check Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon SE project
that can be used to run some basic examples using both built-in and custom health checks.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 15 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon SE Application</td>
<td class="">You can use your own application or use the
 <router-link to="/se/guides/quickstart">Helidon SE Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>


<h3 id="_create_a_sample_se_project">Create a Sample SE Project</h3>
<div class="section">
<p>Generate the project sources using the Helidon SE Maven archetype.
The result is a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.9 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

</div>


<h3 id="_using_the_built_in_health_checks">Using the Built-In Health Checks</h3>
<div class="section">
<p>Helidon has a set of built-in health checks:</p>

<ul class="ulist">
<li>
<p>deadlock detection</p>

</li>
<li>
<p>available disk space</p>

</li>
<li>
<p>available heap memory</p>

</li>
</ul>

<p>The following example shows how to use the built-in health checks.  These examples are all executed
from the root directory of your project (helidon-quickstart-se).</p>

<p>Notice that the <code>pom.xml</code> file in the generated project already contains dependencies for Helidon&#8217;s health component and for the
 built-in health checks.</p>

<markup
lang="xml"
title="Generated dependencies related to health"
>&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-webserver-observe-health&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.health&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-health-checks&lt;/artifactId&gt;
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

<p>Handling health checks is part of Helidon&#8217;s observability support.
By default, when you add the dependency for the built-in health checks, Helidon automatically registers the built-in checks.</p>

<markup
lang="bash"
title="Build and run the project"
>mvn clean package
java -jar target/helidon-quickstart-se.jar</markup>

<p>In another window, access the application&#8217;s health endpoint.</p>

<markup
lang="bash"
title="Access the health endpoint"
>curl -v http://localhost:8080/observe/health</markup>

<p>The verbose <code>curl</code> output reports the HTTP status:</p>

<markup
lang="text"

>&lt; HTTP/1.1 204 No Content</markup>

<p>The successful status means all health checks reported <code>UP</code>.</p>

<p>To see the details about each health check, add the following <code>features</code> configuration fragment in the <code>server</code> section of the
 <code>application.yaml</code>.
Make sure the <code>features</code> key is at the same level as <code>port</code> and <code>host</code> that are already in the file.</p>

<markup
lang="yaml"
title="Configuration fragment to include details in the health output (nested under <code>server</code>)"
>server:
  port: 8080
  host: 0.0.0.0
  features: <span class="conum" data-value="1" />
    observe:
      observers:
        health:
          details: true</markup>

<ul class="colist">
<li data-value="1">Added <code>features</code> config section.</li>
</ul>

<p>Press ^C to stop the running server, rebuild it, and rerun it.</p>

<markup
lang="bash"
title="Stop, rebuild, and rerun the server"
>^C
mvn clean package
java -jar target/helidon-quickstart-se.jar</markup>

<p>In the other window access the health endpoint again.</p>

<markup
lang="bash"
title="Access the health endpoint"
>curl -v http://localhost:8080/observe/health</markup>

<p>This time the <code>curl</code> output shows not only the HTTP status&#8212;&#8203;as 200 instead of 204 because the response now contains data&#8212;&#8203;but also the detailed output for all health checks.</p>

<markup
lang="hocon"
title="Health check details"
>{
  "status": "UP", <span class="conum" data-value="1" />
  "checks": [ <span class="conum" data-value="2" />
    {
      "name": "diskSpace",
      "status": "UP",
      "data": {
        "total": "465.63 GB",
        "percentFree": "14.10%",
        "totalBytes": 499963174912,
        "free": "65.67 GB",
        "freeBytes": 70513274880
      }
    },
    {
      "name": "heapMemory",
      "status": "UP",
      "data": {
        "total": "516.00 MB",
        "percentFree": "99.82%",
        "max": "8.00 GB",
        "totalBytes": 541065216,
        "maxBytes": 8589934592,
        "free": "500.87 MB",
        "freeBytes": 525201320
      }
    },
    {
      "name": "deadlock",
      "status": "UP"
    }
  ]
}</markup>

<ul class="colist">
<li data-value="1">Overall application health status</li>
<li data-value="2">List of individual health checks.</li>
</ul>

</div>


<h3 id="_adding_custom_health_checks">Adding Custom Health Checks</h3>
<div class="section">
<p>You can add your own custom health checks. These typically assess the conditions in and around your application and report whether the service should be considered started, live, and/or ready.</p>

<p>The following trivial but illustrative example adds a custom start-up check that reports <code>DOWN</code> until the server has been running for eight seconds and reports <code>UP</code> thereafter. Note the two main steps in the example code:</p>

<ol style="margin-left: 15px;">
<li>
Create an explicit instance of <code>ObserveFeature</code> which contains a custom <code>HealthObserver</code> with the custom check.

</li>
<li>
Add that <code>ObserveFeature</code> instance to the <code>WebServerConfig.Builder</code> as a feature.

</li>
</ol>

<markup
lang="java"
title="Updated <code>Main#main</code>, augmenting the creation of <code>WebServer</code> instance with a custom health check"
>void snippet1(Config config) {
    AtomicLong serverStartTime = new AtomicLong();  <span class="conum" data-value="1" />

    HealthObserver healthObserver = HealthObserver.builder() <span class="conum" data-value="2" />
            .details(true) <span class="conum" data-value="3" />
            .addCheck(() -&gt; HealthCheckResponse.builder() <span class="conum" data-value="4" />
                              .status(System.currentTimeMillis() - serverStartTime.get() &gt;= 8000)
                              .detail("time", System.currentTimeMillis())
                              .build(),
                      HealthCheckType.STARTUP,
                      "warmedUp")
            .build();

    ObserveFeature observe = ObserveFeature.builder()
            .config(config.get("server.features.observe")) <span class="conum" data-value="5" />
            .addObserver(healthObserver) <span class="conum" data-value="6" />
            .build();

    WebServer server = WebServer.builder()
            .config(config.get("server"))
            .addFeature(observe)            <span class="conum" data-value="7" />
            .routing(Main::routing)
            .build()
            .start();

    serverStartTime.set(System.currentTimeMillis()); <span class="conum" data-value="8" /></markup>

<ul class="colist">
<li data-value="1">Declare a variable for holding the server start-up time. (This is set later in the code.)</li>
<li data-value="2">Begin preparing the custom <code>HealthObserver</code> according to this app&#8217;s specific needs.</li>
<li data-value="3">Turn on detailed output in HTTP responses to the health endpoint.</li>
<li data-value="4">Add a custom start-up health check:</li>
<li data-value="5">Find and apply configuration for observability observers <em>other</em> than health (because we are about to create our own custom <code>HealthObserver</code>).</li>
<li data-value="6">Add the <code>HealthObserver</code> to the <code>ObserveFeature</code>.</li>
<li data-value="7">Add the <code>ObserveFeature</code> instance as a feature to the webserver.</li>
<li data-value="8">Record when the server has actually started.</li>
</ul>

<p>Note that the health check type and name are fixed, whereas the health check recomputes the value of the response every time Helidon queries it.</p>

<div class="admonition note">
<p class="admonition-inline">For the next step, be ready to access the health endpoint very quickly after you restart the server!</p>
</div>

<markup
lang="bash"
title="Stop, rebuild, and rerun the application"
>^C
mvn package
java -jar target/helidon-quickstart-se.jar</markup>

<markup
lang="bash"
title="Access the health endpoint <strong>quickly</strong>"
>curl -v http://localhost:8080/observe/health</markup>

<p>If you access the health endpoint before the server has been up for eight seconds, <code>curl</code> reports the response status as <code>503 Service Unavailable</code> and displays output similar to the following:</p>

<markup
lang="json"
title="Health response shortly after server restart (partial)"
>{
  "status": "DOWN",
  "checks": [
    {
      "name": "warmedUp",
      "status": "DOWN",
      "data": {
        "time": 1702068978353
      }
    }
  ]
}</markup>

<p>The built-in health checks (not shown in the example output) all report <code>UP</code> but the new custom start-up health check reports <code>DOWN</code> because the server has been up only a short time.</p>

<p>Access the health endpoint again, after the server has been up at least eight seconds.</p>

<markup
lang="bash"
title="Access the health endpoint again <strong>after 8 seconds</strong>"
>curl -v http://localhost:8080/observe/health</markup>

<p>This time, <code>curl</code> reports <code>200 OK</code> for the response status and displays different output for the custom health check.</p>

<markup
lang="json"
title="Health response after the server has been running a while (partial)"
>{
  "status": "UP",
  "checks": [
    {
      "name": "warmedUp",
      "status": "UP",
      "data": {
        "time": 1702069379717
      }
    }
  ]
}</markup>

<p>The example code includes the built-in health checks in Helidon&#8217;s overall health assessment of the application. To exclude them invoke the <code>HealthObserver.Builder</code> <code>useSystemServices</code> method (for example, just after invoking <code>details</code> on the builder).</p>

<markup
lang="java"
title="Disable all built-in health checks"
>HealthObserver.builder()
        .useSystemServices(false)
        .build();</markup>

<p>Alternatively, you could instead remove the dependency on the <code>helidon-health-checks</code> component from the <code>pom.xml</code> file.</p>

</div>


<h3 id="_accessing_specific_health_check_types">Accessing Specific Health Check Types</h3>
<div class="section">
<p>You can choose which category of health check to retrieve when you access the health endpoint by adding the health check type as an additional part of the resource path:</p>

<ul class="ulist">
<li>
<p>liveness only - <a target="_blank" href="http://localhost:8080/observe/health/live" class="bare">http://localhost:8080/observe/health/live</a></p>

</li>
<li>
<p>readiness only -  <a target="_blank" href="http://localhost:8080/observe/health/ready" class="bare">http://localhost:8080/observe/health/ready</a></p>

</li>
<li>
<p>startup only - <a target="_blank" href="http://localhost:8080/observe/health/started" class="bare">http://localhost:8080/observe/health/started</a></p>

</li>
<li>
<p>all -  <a target="_blank" href="http://localhost:8080/observe/health" class="bare">http://localhost:8080/observe/health</a></p>

</li>
</ul>

<markup
lang="bash"
title="Get only start-up health checks"
>curl http://localhost:8080/observe/started</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "warmedUp",
      "status": "UP",
      "data": {
        "time": 1702069835172
      }
    }
  ]
}</markup>

</div>


<h3 id="_applying_configuration_to_a_custom_health_observer_customizing_the_url_path">Applying Configuration to a Custom Health Observer: Customizing the URL path</h3>
<div class="section">
<p>Earlier examples showed how to add custom health checks by building a custom <code>HealthObserver</code> in which the code set up the behavior of the health subsystem explicitly. Recall that the example code invoked the <code>HealthObserver.Builder</code> <code>details</code> method to turn on detailed output.</p>

<p>Once it creates a custom health observer, your code has full responsibility for determining the observer&#8217;s behavior; Helidon does not automatically apply configuration to a custom observer. But your code can easily do so.</p>

<p>The next example customizes the URL path for the health endpoint, first explicitly in the code and then via configuration.</p>


<h4 id="_customizing_the_endpoint_path_in_the_code">Customizing the endpoint path in the code</h4>
<div class="section">
<p>Customize the URL path for health checks by invoking the <code>endpoint</code> method on the <code>HealthObserver.Builder</code>.</p>

<markup
lang="java"
title="Set a custom endpoint path"
>HealthObserver healthObserver = HealthObserver.builder()
        .endpoint("/myhealth") <span class="conum" data-value="1" />
        .build();</markup>

<ul class="colist">
<li data-value="1">Changes the health endpoint path to <code>/myhealth</code>.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then verify that the health check endpoint responds at <code>/myhealth</code>:"
>curl http://localhost:8080/myhealth</markup>

<p>Earlier you added health config to the <code>application.yaml</code> config file to turn on detailed output. If you want to run an experiment, change that <code>details</code> setting in the config file to <code>false</code> and stop, rebuild, and rerun the application. Now access the health endpoint (at <code>/myhealth</code>, remember).
The output <em>remains</em> detailed because your code&#8212;&#8203;which has full responsibility for determining the custom health observer&#8217;s behavior&#8212;&#8203;does not apply configuration to the custom observer&#8217;s builder.</p>

</div>


<h4 id="_adding_configuration_to_a_custom_observer">Adding configuration to a custom observer</h4>
<div class="section">
<p>In addition to preparing the health observer builder with hard-coded settings, your code can also apply configuration for health. This allows someone who deploys your application to control the behavior of the health subsystem using configuration without requiring source code changes to your application.</p>

<p>The generated <code>Main</code> class in the application already creates a <code>Config</code> object for the top-level config node. Using the following code to create the observe feature also applies any health-related configuration settings to the custom health observer. Notice the added line just before the <code>HealthObserver.Build</code> <code>build()</code> invocation near the end of the example code.</p>

<markup
lang="java"
title="Apply health configuration to your custom health observer"
>HealthObserver healthObserver = HealthObserver.builder()
        .config(config.get("server.features.observe.observers.health")) <span class="conum" data-value="1" />
        .build();</markup>

<ul class="colist">
<li data-value="1">Find and apply any health-related settings from configuration at the <code>server.features.observe.observers.health</code> config key.</li>
</ul>

<p>Your code decides what config key to use for retrieving the configuration. Recall earlier, before adding custom health checks, you added a config section for health&#8212;&#8203;to set <code>details</code> to <code>true</code>--at <code>server.features.observe.observers.health</code>. Helidon used that configuration to set up the health observer <em>it</em> created automatically. To be consistent for anyone preparing the configuration file, it&#8217;s a good idea for your application code&#8212;&#8203;as it prepares a custom <code>HealthObserver</code>--to look in the same place Helidon does for health config.</p>

<p>Order is important. Here, the code first sets <code>details</code> to <code>true</code> explicitly and later applies configuration. If your end user sets <code>details</code> in the <code>server.features.observe.observers.health</code> config to <code>false</code>, that setting overrides the hard-coded <code>true</code> setting in the code <em>because of where in the code you apply the configuration</em>. Try changing the <code>details</code> value to <code>false</code> in the config file and then stop, rebuild, and rerun the application. Access the health endpoint and notice that the output is no longer detailed.</p>

<p>In general, most applications should apply settings from config <em>after</em> assigning any settings in the code so users have the final say, but there might be exceptions in your particular case.</p>

</div>

</div>


<h3 id="_using_liveness_readiness_and_startup_health_checks_with_kubernetes">Using Liveness, Readiness, and Startup Health Checks with Kubernetes</h3>
<div class="section">
<p>The following example shows how to integrate the Helidon health API in an application that implements
health endpoints for the Kubernetes liveness, readiness, and startup probes.</p>

<markup
lang="java"
title="Add a <code>readyTime</code> variable to the <code>Main</code> class:"
>private static AtomicLong readyTime = new AtomicLong(0);</markup>

<markup
lang="java"
title="Change the <code>HealthObserver</code> builder in the <code>Main#main</code> method to use new built-in liveness checks and custom liveness, readiness, and startup checks:"
>ObserveFeature observe = ObserveFeature.builder()
        .config(config.get("server.features.observe"))
        .addObserver(HealthObserver.builder()
                             .useSystemServices(true) <span class="conum" data-value="1" />
                             .addCheck(() -&gt; HealthCheckResponse.builder()
                                     .status(readyTime.get() != 0)
                                     .detail("time", readyTime.get())
                                     .build(), HealthCheckType.READINESS) <span class="conum" data-value="2" />
                             .addCheck(() -&gt; HealthCheckResponse.builder()
                                     .status(readyTime.get() != 0
                                             &amp;&amp; Duration.ofMillis(System.currentTimeMillis()
                                                                  - readyTime.get())
                                                        .getSeconds() &gt;= 3)
                                     .detail("time", readyTime.get())
                                     .build(), HealthCheckType.STARTUP) <span class="conum" data-value="3" />
                             .addCheck(() -&gt; HealthCheckResponse.builder()
                                     .status(HealthCheckResponse.Status.UP)
                                     .detail("time", System.currentTimeMillis())
                                     .build(), HealthCheckType.LIVENESS) <span class="conum" data-value="4" />
                             .build())
        .build();</markup>

<ul class="colist">
<li data-value="1">Add built-in health checks.</li>
<li data-value="2">Add a custom readiness check.</li>
<li data-value="3">Add a custom start-up check.</li>
<li data-value="4">Add a custom liveness check.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then verify the liveness, readiness, and started endpoints:"
>curl http://localhost:8080/health/live
curl http://localhost:8080/health/ready
curl http://localhost:8080/health/started</markup>

<markup
lang="bash"
title="Stop the application and build the docker image:"
>docker build -t helidon-quickstart-se .</markup>

<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>health.yaml</code>, with the following content:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-health <span class="conum" data-value="1" />
  labels:
    app: helidon-health
spec:
  type: NodePort
  selector:
    app: helidon-health
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-health <span class="conum" data-value="2" />
spec:
  replicas: 1
  selector:
    matchLabels:
      app: helidon-health
  template:
    metadata:
      labels:
        app: helidon-health
        version: v1
    spec:
      containers:
        - name: helidon-health
          image: helidon-quickstart-se
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080
          livenessProbe:
            httpGet:
              path: /health/live <span class="conum" data-value="3" />
              port: 8080
            initialDelaySeconds: 5 <span class="conum" data-value="4" />
            periodSeconds: 10
            timeoutSeconds: 3
            failureThreshold: 3
          readinessProbe:
            httpGet:
              path: /health/ready <span class="conum" data-value="5" />
              port: 8080
            initialDelaySeconds: 5 <span class="conum" data-value="6" />
            periodSeconds: 2
            timeoutSeconds: 3
          startupProbe:
            httpGet:
              path: /health/started <span class="conum" data-value="7" />
              port: 8080
            initialDelaySeconds: 8 <span class="conum" data-value="8" />
            periodSeconds: 10
            timeoutSeconds: 3
            failureThreshold: 3
---</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">A deployment with one replica of a pod.</li>
<li data-value="3">The HTTP endpoint for the liveness probe.</li>
<li data-value="4">The liveness probe configuration.</li>
<li data-value="5">The HTTP endpoint for the readiness probe.</li>
<li data-value="6">The readiness probe configuration.</li>
<li data-value="7">The HTTP endpoint for the startup probe.</li>
<li data-value="8">The startup probe configuration.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./health.yaml</markup>

<markup
lang="bash"
title="Get the service information:"
>kubectl get service/helidon-health</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-health   NodePort   10.107.226.62   &lt;none&gt;        8080:30116/TCP   4s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>30116</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the health endpoints using port '30116', your port may be different:"
>curl http://localhost:30116/health</markup>

<markup
lang="bash"
title="Delete the application, cleaning up Kubernetes resources:"
>kubectl delete -f ./health.yaml</markup>

</div>


<h3 id="_summary">Summary</h3>
<div class="section">
<p>This guide demonstrates how to use health checks in a Helidon SE application as follows:</p>

<ul class="ulist">
<li>
<p>Access the default health checks</p>

</li>
<li>
<p>Create and use custom readiness, liveness, and startup checks</p>

</li>
<li>
<p>Customize the health check root path</p>

</li>
<li>
<p>Integrate Helidon health check with Kubernetes</p>

</li>
</ul>

<p>Refer to the following reference for additional information:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/index.html?overview-summary.html">Helidon Javadoc</a></p>

</li>
</ul>

</div>

</div>

</doc-view>
