<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#jaeger-tracing" @click.native="this.scrollFix('#jaeger-tracing')">Jaeger Tracing</router-link></p>

</li>
<li>
<p><router-link to="#zipkin-tracing" @click.native="this.scrollFix('#zipkin-tracing')">Zipkin Tracing</router-link></p>

</li>
<li>
<p><router-link to="#Tracing-callbacks" @click.native="this.scrollFix('#Tracing-callbacks')">Responding to Span Life Cycle Events</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<div class="admonition warning">
<p class="admonition-inline">The OpenTracing Specification that MP OpenTracing is based on is no longer maintained.
The MP OpenTracing specification is no longer required by MicroProfile. This feature is marked as <code>@Deprecated</code> in Helidon. The specification is superseded by the <a target="_blank" href="https://github.com/eclipse/microprofile-telemetry">MicroProfile Telemetry specification</a>.</p>
</div>

<p>Distributed tracing is a critical feature of micro-service based applications, since it traces workflow both
within a service and across multiple services. This provides insight to sequence and timing data for specific blocks of work,
which helps you identify performance and operational issues. Helidon MP includes support for distributed tracing
through the <a target="_blank" href="https://opentracing.io">OpenTracing API</a>. Tracing is integrated with WebServer
and Security.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Tracing
either add a dependency on the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-tracing&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>This section explains a few concepts that you need to understand before you get started with tracing.</p>

<ul class="ulist">
<li>
<p>In the context of this document, a <em>service</em> is synonymous with an application.</p>

</li>
<li>
<p>A <em>span</em> is the basic unit of work done within a single service, on a single host.
Every span has a name, starting timestamp, and duration.
For example, the work done by a REST endpoint is a span.
A span is associated to a single service, but its descendants can belong to different services and hosts.</p>

</li>
<li>
<p>A <em>trace</em> contains a collection of spans from one or more services, running on one or more hosts. For example,
if you trace a service endpoint that calls another service, then the trace would contain spans from both services.
Within a trace, spans are organized as a directed acyclic graph (DAG) and
can belong to multiple services, running on multiple hosts.  The <em>OpenTracing Data Model</em> describes the details
at <a target="_blank" href="https://opentracing.io/specification">The OpenTracing Semantic Specification</a>.
Spans are automatically created by Helidon as needed during execution of the REST request. Additional spans can be added
through MP annotation <code>@Traced</code> or through OpenTracing APIs.</p>

</li>
</ul>

</div>


<h2 id="_traced_spans">Traced spans</h2>
<div class="section">
<p>The following table lists all spans traced by Helidon components:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>component</th>
<th>span name</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>HTTP Request</code></td>
<td class="">The overall span of the Web Server from request initiation until response
Note that in <code>Zipkin</code> the name is replaced with <code>jax-rs</code> span name if <code>jax-rs</code> tracing
is used.</td>
</tr>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>content-read</code></td>
<td class="">Span for reading the request entity</td>
</tr>
<tr>
<td class=""><code>web-server</code></td>
<td class=""><code>content-write</code></td>
<td class="">Span for writing the response entity</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security</code></td>
<td class="">Processing of request security</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:atn</code></td>
<td class="">Span for request authentication</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:atz</code></td>
<td class="">Span for request authorization</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:response</code></td>
<td class="">Processing of response security</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security:outbound</code></td>
<td class="">Processing of outbound security</td>
</tr>
<tr>
<td class=""><code>jax-rs</code></td>
<td class="">A generated name</td>
<td class="">Span for the resource method invocation, name is generated from class and method name</td>
</tr>
<tr>
<td class=""><code>jax-rs</code></td>
<td class=""><code>jersey-client-call</code></td>
<td class="">Span for outbound client call</td>
</tr>
</tbody>
</table>
</div>

<p>Some of these spans <code>log</code> to the span. These log events can be (in most cases) configured:</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 14.286%;">
<col style="width: 14.286%;">
<col style="width: 7.143%;">
<col style="width: 7.143%;">
<col style="width: 57.143%;">
</colgroup>
<thead>
<tr>
<th>span name</th>
<th>log name</th>
<th>configurable</th>
<th>enabled by default</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>handler.class</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Each handler has its class and event logged</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs either "status: PROCEED" or "status: DENY"</td>
</tr>
<tr>
<td class=""><code>security:atn</code></td>
<td class=""><code>security.user</code></td>
<td class="">YES</td>
<td class="">NO</td>
<td class="">The username of the user if logged in</td>
</tr>
<tr>
<td class=""><code>security:atn</code></td>
<td class=""><code>security.service</code></td>
<td class="">YES</td>
<td class="">NO</td>
<td class="">The name of the service if logged in</td>
</tr>
<tr>
<td class=""><code>security:atn</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
</tr>
<tr>
<td class=""><code>security:atz</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
</tr>
<tr>
<td class=""><code>security:outbound</code></td>
<td class=""><code>status</code></td>
<td class="">YES</td>
<td class="">YES</td>
<td class="">Logs the status of security response (such as <code>SUCCESS</code>)</td>
</tr>
</tbody>
</table>
</div>

<p>There are also tags that are set by Helidon components. These are not configurable.</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>span name</th>
<th>tag name</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>component</code></td>
<td class="">name of the component - <code>helidon-webserver</code>, or <code>jaxrs</code> when using MP</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.method</code></td>
<td class="">HTTP method of the request, such as <code>GET</code>, <code>POST</code></td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.status_code</code></td>
<td class="">HTTP status code of the response</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>http.url</code></td>
<td class="">The path of the request (for SE without protocol, host and port)</td>
</tr>
<tr>
<td class=""><code>HTTP Request</code></td>
<td class=""><code>error</code></td>
<td class="">If the request ends in error, this tag is set to <code>true</code>, usually accompanied by logs with details</td>
</tr>
<tr>
<td class=""><code>security</code></td>
<td class=""><code>security.id</code></td>
<td class="">ID of the security context created for this request (if security is used)</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.method</code></td>
<td class="">HTTP method of the client request</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.status_code</code></td>
<td class="">HTTP status code of client response</td>
</tr>
<tr>
<td class=""><code>jersey-client-call</code></td>
<td class=""><code>http.url</code></td>
<td class="">Full URL of the request (such as <code><a target="_blank" href="http://localhost:8080/greet" class="bare">http://localhost:8080/greet</a></code>)</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">

<h3 id="_enabling_and_disabling_tracing">Enabling and Disabling Tracing</h3>
<div class="section">
<p>You can configure a custom service name using the <code>tracing.service</code> configuration property. If this
property is undefined, name is created from JAX-RS Application name, or <code>Helidon MP</code> is used if no application
is defined.</p>

<p>Jaeger tracer configuration.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html">io.helidon.tracing.Tracer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>

</div>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>client-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate of client in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>exporter-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT10S</code></td>
<td class=""><doc-view>
<p>Timeout of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-export-batch-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Maximum Export Batch Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-queue-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>2048</code></td>
<td class=""><doc-view>
<p>Maximum Queue Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagation</code></td>
<td class=""><doc-view>
<p>PropagationFormat[&#93; (B3, B3_SINGLE, JAEGER, W3C)</p>

</doc-view>
</td>
<td class=""><code>JAEGER</code></td>
<td class=""><doc-view>
<p>Add propagation format to use.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-param</code></td>
<td class=""><doc-view>
<p>Number</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>The sampler parameter (number).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-type</code></td>
<td class=""><doc-view>
<p>SamplerType (CONSTANT, RATIO)</p>

</doc-view>
</td>
<td class=""><code>CONSTANT</code></td>
<td class=""><doc-view>
<p>Sampler type.</p>

<pre>See &lt;a href="https://www.jaegertracing.io/docs/latest/sampling/#client-sampling-configuration"&gt;Sampler types&lt;/a&gt;.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>schedule-delay</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5S</code></td>
<td class=""><doc-view>
<p>Schedule Delay of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>span-processor-type</code></td>
<td class=""><doc-view>
<p>SpanProcessorType (SIMPLE, BATCH)</p>

</doc-view>
</td>
<td class=""><code>batch</code></td>
<td class=""><doc-view>
<p>Span Processor type used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trusted-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trusted certificates in PEM format.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>To disable Helidon tracing for web server and security:</p>

<markup
lang="properties"

>tracing.components.web-server.enabled=false
tracing.components.security.enabled=false</markup>

<p>To disables MP Tracing as by specification:</p>

<markup
lang="properties"

>mp.opentracing.server.skip-pattern=.*</markup>

<p>Tracing configuration can be defined in <code>application.yaml</code> file.</p>

<markup
lang="yaml"
title="Tracing configuration example"
>tracing:
  paths:
    - path: "/favicon.ico"
      enabled: false
    - path: "/metrics"
      enabled: false
    - path: "/health"
      enabled: false
  components:
    web-server:
      spans:
        - name: "HTTP Request"
          logs:
            - name: "content-write"
              enabled: false</markup>


<h3 id="_controlling_tracing_output">Controlling Tracing Output</h3>
<div class="section">
<p>For Web Server we have a path based support for configuring tracing, in addition
to the configuration described above.</p>

<p>Configuration of path can use any path string supported by the
Web Server. The configuration itself has the same possibilities
as traced configuration described above. The path specific configuration
will be merged with global configuration (path is the "newer" configuration, global is the "older")</p>


<h4 id="_renaming_top_level_span_using_request_properties">Renaming top level span using request properties</h4>
<div class="section">
<p>To have a nicer overview in search pane of a tracer, you can customize the top-level span name using configuration.</p>

<p>Example:</p>

<markup
lang="properties"
title="Configuration properties"
>tracing.components.web-server.spans.0.name="HTTP Request"
tracing.components.web-server.spans.0.new-name: "HTTP %1$s %2$s"</markup>

<p>This is supported ONLY for the span named "HTTP Request" on component "web-server".</p>

<p>Parameters provided:</p>

<ol style="margin-left: 15px;">
<li>
Method - HTTP method

</li>
<li>
Path - path of the request (such as '/greet')

</li>
<li>
Query - query of the request (may be null)

</li>
</ol>

</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>The examples in this guide demonstrate how to integrate tracing with Helidon, how to view traces, how to trace
across multiple services, and how to integrate tracing with Kubernetes.  All examples use Jaeger and traces
will be viewed using both the Jaeger UI.</p>


<h3 id="_set_up_jaeger">Set up Jaeger</h3>
<div class="section">
<p>First, you need to run the Jaeger tracer.  Helidon will communicate with this tracer at runtime.</p>

<markup
lang="bash"
title="Run Jaeger within a docker container, then check the Jaeger server working:"
>docker run -d --name jaeger \                  <span class="conum" data-value="1" />
  -e COLLECTOR_OTLP_ENABLED=true \
  -p 6831:6831/udp \
  -p 6832:6832/udp \
  -p 5778:5778 \
  -p 16686:16686 \
  -p 4317:4317 \
  -p 4318:4318 \
  -p 14250:14250 \
  -p 14268:14268 \
  -p 14269:14269 \
  -p 9411:9411 \
  jaegertracing/all-in-one:1.50</markup>

<ul class="colist">
<li data-value="1">Run the Jaeger docker image.</li>
</ul>

<markup
lang="bash"
title="Check the Jaeger server by opening in browser:"
>http://localhost:16686/search</markup>

</div>


<h3 id="_trace_across_services">Trace Across Services</h3>
<div class="section">
<p>Helidon automatically traces across services as long as the services use the same tracer, for example, the same instance of Jaeger.
This means a single trace can include spans from multiple services and hosts.  OpenTracing uses a <code>SpanContext</code> to propagate tracing information across process boundaries.  When you make client API calls, Helidon will internally call OpenTracing APIs to propagate the <code>SpanContext</code>. There is nothing you need to do in your application to make this work.</p>

<p>To demonstrate distributed tracing, you will need to create a second project, where the server listens on port 8081.
Create a new root directory to hold this new project, then do the following steps, similar to
what you did at the start of this guide:</p>


<h4 id="_create_a_second_service">Create a second service</h4>
<div class="section">
<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-mp \
    -DarchetypeVersion=4.0.9 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-mp-2 \
    -Dpackage=io.helidon.examples.quickstart.mp</markup>

<markup
lang="bash"
title="The project will be built and run from the <code>helidon-quickstart-mp</code> directory:"
>cd helidon-quickstart-mp-2</markup>

<markup
lang="xml"
title="Add the following dependency to <code>pom.xml</code>:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="bash"
title="Replace <code>META-INF/microprofile-config.properties</code> with the following:"
>app.greeting=Hello From MP-2
tracing.service=helidon-mp-2

# Microprofile server properties
server.port=8081</markup>

<markup
lang="bash"
title="Build the application, skipping unit tests, then run it:"
>mvn package -DskipTests=true
java -jar target/helidon-quickstart-mp-2.jar</markup>

<markup
lang="bash"
title="Run the curl command in a new terminal window and check the response (<strong>notice the port is 8081</strong>) :"
>curl http://localhost:8081/greet</markup>

<markup
lang="json"
title="Response body"
>{
  "message": "Hello From MP-2 World!"
}</markup>

</div>


<h4 id="_modify_the_first_service">Modify the first service</h4>
<div class="section">
<p>Once you have validated that the second service is running correctly, you need to modify the original application to
call it.</p>

<markup
lang="java"
title="Replace the <code>GreetResource</code> class with the following code:"
>@Path("/greet")
@RequestScoped
public class GreetResource {

    @Uri("http://localhost:8081/greet")
    private WebTarget target; <span class="conum" data-value="1" />

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());
    private final GreetingProvider greetingProvider;

    @Inject
    public GreetResource(GreetingProvider greetingConfig) {
        this.greetingProvider = greetingConfig;
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public JsonObject getDefaultMessage() {
        return createResponse("World");
    }

    @GET
    @Path("/outbound") <span class="conum" data-value="2" />
    public JsonObject outbound() {
        return target.request().accept(MediaType.APPLICATION_JSON_TYPE).get(JsonObject.class);
    }

    private JsonObject createResponse(String who) {
        String msg = String.format("%s %s!", greetingProvider.getMessage(), who);

        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">This is the <code>WebTarget</code> needed to send a request to the second service at port <code>8081</code>.</li>
<li data-value="2">This is the new endpoint that will call the second service.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the endpoint and check the response:"
>curl -i http://localhost:8080/greet/outbound <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The request went to the service on <code>8080</code>, which then invoked the service at <code>8081</code> to get the greeting.</li>
</ul>

<markup
lang="hocon"
title="Response body"
>{
  "message": "Hello From MP-2 World!" <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">Notice the greeting came from the second service.</li>
</ul>

<p>Refresh the Jaeger UI trace listing page and notice that there is a trace across two services.</p>

<div class="fit"><div>
<div class="block-title"><span>Tracing across multiple services detail view</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/12_tracing_detail_2_services.png" alt="Traces" />
</v-card-text>
</v-card>
</div></div>

<p>In the image above, you can see that the trace includes spans from two services. You will notice there is a gap before the sixth span, which is a <code>get</code> operation. This is a one-time client initialization delay.  Run the <code>/outbound</code> curl command again and look at the new trace to
see that the delay no longer exists.</p>

<p>You can now stop your second service, it is no longer used in this guide.</p>

</div>

</div>

</div>


<h2 id="_integration_with_kubernetes">Integration with Kubernetes</h2>
<div class="section">
<p>The following example demonstrates how to use Jaeger from a Helidon application running in Kubernetes.</p>

<markup
lang="bash"
title="Update <code>application.yaml</code>:"
>tracing:
  host: "jaeger"</markup>

<markup
lang="bash"
title="Stop the application and build the docker image for your application:"
>docker build -t helidon-tracing-mp .</markup>


<h3 id="_deploy_jaeger_into_kubernetes">Deploy Jaeger into Kubernetes</h3>
<div class="section">
<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>jaeger.yaml</code>, with the following contents:"
>apiVersion: v1
kind: Service
metadata:
  name: jaeger
spec:
  ports:
    - port: 16686
      protocol: TCP
  selector:
    app: jaeger
---
kind: Pod
apiVersion: v1
metadata:
  name: jaeger
  labels:
    app: jaeger
spec:
  containers:
    - name: jaeger
      image: jaegertracing/all-in-one
      imagePullPolicy: IfNotPresent
      ports:
        - containerPort: 16686</markup>

<markup
lang="bash"
title="Create the Jaeger pod and ClusterIP service:"
>kubectl apply -f ./jaeger.yaml</markup>

<markup
lang="bash"
title="Create a Jaeger external server and expose it on port 9142:"
>kubectl expose pod jaeger --name=jaeger-external --port=16687 --target-port=16686 --type=LoadBalancer <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">Create a service so that you can access the Jaeger UI.</li>
</ul>

<p>Navigate to <a target="_blank" href="http://localhost:16687/search" class="bare">http://localhost:16687/search</a> to validate that you can access Jaeger running in Kubernetes. It may
take a few seconds before it is ready.</p>

</div>


<h3 id="_deploy_your_helidon_application_into_kubernetes">Deploy Your Helidon Application into Kubernetes</h3>
<div class="section">
<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>tracing.yaml</code>, with the following contents:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-tracing <span class="conum" data-value="1" />
  labels:
    app: helidon-tracing
spec:
  type: NodePort
  selector:
    app: helidon-tracing
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-tracing
spec:
  replicas: 1 <span class="conum" data-value="2" />
  selector:
    matchLabels:
      app: helidon-tracing
  template:
    metadata:
      labels:
        app: helidon-tracing
        version: v1
    spec:
      containers:
        - name: helidon-tracing
          image: helidon-tracing-mp
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">A deployment with one replica of a pod.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./tracing.yaml</markup>

</div>


<h3 id="_access_your_application_and_the_jaeger_trace">Access Your Application and the Jaeger Trace</h3>
<div class="section">
<markup
lang="bash"
title="Get the application service information:"
>kubectl get service/helidon-tracing</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-tracing   NodePort   10.99.159.2   &lt;none&gt;        8080:31143/TCP   8s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>31143</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the tracing endpoint using port <code>31143</code>, your port will likely be different:"
>curl http://localhost:31143/greet</markup>

<markup
lang="json"

>{
  "message": "Hello World!"
}</markup>

<p>Access the Jaeger UI at <a target="_blank" href="http://localhost:16687/search" class="bare">http://localhost:16687/search</a> and click on the refresh icon to see the trace that was just created.</p>

</div>


<h3 id="_cleanup">Cleanup</h3>
<div class="section">
<p>You can now delete the Kubernetes resources that were just created during this example.</p>

<markup
lang="bash"
title="Delete the Kubernetes resources:"
>kubectl delete -f ./jaeger.yaml
kubectl delete -f ./tracing.yaml
kubectl delete service jaeger-external
docker rm -f jaeger</markup>

</div>

</div>


<h2 id="_creating_custom_spans">Creating custom spans</h2>
<div class="section">
<p>Helidon MP fully supports MicroProfile OpenTracing.
You can add custom spans using <code>@Traced</code> annotation on methods of CDI beans.</p>

<p><strong>Note for invoking methods on same class:</strong>
<em>If you invoke a method on the same class, <code>@Traced</code> annotation would be ignored, as it is not
invoked through a CDI proxy and as such cannot be intercepted.
To make sure <code>@Traced</code> is honored, use it on JAX-RS resource methods and on CDI bean methods used from other beans.</em></p>

</div>


<h2 id="_trace_propagation_across_services">Trace propagation across services</h2>
<div class="section">
<p>Automated trace propagation is supported currently only with Jersey client.</p>

<p>Tracing propagation works automatically as long as you run within the scope of
Helidon MP and use Helidon components to invoke external services.</p>


<h3 id="_manual_handling_of_traces_in_jersey_client">Manual handling of traces in Jersey Client</h3>
<div class="section">
<p>There is an option to provide <code>SpanContext</code> programmatically (such as when writing a command line
application that starts the span manually).</p>

<p>You can either configure the span context as the active span, or explicitly define it as client property.</p>

<markup
lang="java"
title="Tracing propagation with Jersey client"
>Response response = client.target(serviceEndpoint)
        .request()
        // tracer should be provided unless available as GlobalTracer
        .property(TRACER_PROPERTY_NAME, tracer)
        .property(CURRENT_SPAN_CONTEXT_PROPERTY_NAME, spanContext)
        .get();</markup>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="jaeger-tracing">Jaeger Tracing</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_configuring_jaeger">Configuring Jaeger</h2>
<div class="section">
<p>Jaeger tracer configuration.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html">io.helidon.tracing.Tracer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options_2">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>client-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate of client in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>exporter-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT10S</code></td>
<td class=""><doc-view>
<p>Timeout of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-export-batch-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Maximum Export Batch Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-queue-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>2048</code></td>
<td class=""><doc-view>
<p>Maximum Queue Size of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key in PEM format.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>propagation</code></td>
<td class=""><doc-view>
<p>PropagationFormat[&#93; (B3, B3_SINGLE, JAEGER, W3C)</p>

</doc-view>
</td>
<td class=""><code>JAEGER</code></td>
<td class=""><doc-view>
<p>Add propagation format to use.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-param</code></td>
<td class=""><doc-view>
<p>Number</p>

</doc-view>
</td>
<td class=""><code>1</code></td>
<td class=""><doc-view>
<p>The sampler parameter (number).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sampler-type</code></td>
<td class=""><doc-view>
<p>SamplerType (CONSTANT, RATIO)</p>

</doc-view>
</td>
<td class=""><code>CONSTANT</code></td>
<td class=""><doc-view>
<p>Sampler type.</p>

<pre>See &lt;a href="https://www.jaegertracing.io/docs/latest/sampling/#client-sampling-configuration"&gt;Sampler types&lt;/a&gt;.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>schedule-delay</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5S</code></td>
<td class=""><doc-view>
<p>Schedule Delay of exporter requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>span-processor-type</code></td>
<td class=""><doc-view>
<p>SpanProcessorType (SIMPLE, BATCH)</p>

</doc-view>
</td>
<td class=""><code>batch</code></td>
<td class=""><doc-view>
<p>Span Processor type used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trusted-cert-pem</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trusted certificates in PEM format.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following is an example of a Jaeger configuration, specified in the YAML format.</p>

<markup
lang="yaml"

>tracing:
    service: "helidon-full-http"
    protocol: "https"
    host: "jaeger"
    port: 14240</markup>


<h3 id="jaeger-tracing-metrics">Jaeger Tracing Metrics</h3>
<div class="section">
<p>As the <router-link to="#jaeger-tracing" @click.native="this.scrollFix('#jaeger-tracing')">Jaeger Tracing</router-link> section describes, you can use Jaeger tracing in your Helidon application.</p>

</div>


<h3 id="zipkin-tracing">Zipkin Tracing</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_configuring_zipkin">Configuring Zipkin</h2>
<div class="section">
<p>Zipkin tracer configuration</p>

<p>Type: io.opentracing.Tracer</p>

<p>This is a standalone configuration type, prefix from configuration root: <code>tracing</code></p>

</div>


<h2 id="_configuration_options_3">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>api-version</code></td>
<td class=""><doc-view>
<p>Version (V1, V2)</p>

</doc-view>
</td>
<td class=""><code>V2</code></td>
<td class=""><doc-view>
<p>Version of Zipkin API to use.
 Defaults to Version#V2.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following is an example of a Zipkin configuration, specified in the YAML format.</p>

<markup
lang="yaml"

>tracing:
  zipkin:
    service: "helidon-service"
    protocol: "https"
    host: "zipkin"
    port: 9987
    api-version: 1
    # this is the default path for API version 2
    path: "/api/v2/spans"
    tags:
      tag1: "tag1-value"
      tag2: "tag2-value"
    boolean-tags:
      tag3: true
      tag4: false
    int-tags:
      tag5: 145
      tag6: 741</markup>

<p>Example of Zipkin trace:</p>



<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="/images/webserver/zipkin.png" alt="Zipkin example" />
</v-card-text>
</v-card>



<h3 id="Tracing-callbacks">Responding to Span Lifecycle Events</h3>
<div class="section">
<p>Applications and libraries can register listeners to be notified at several moments during the lifecycle of every span:</p>

<ul class="ulist">
<li>
<p>Before a new span starts</p>

</li>
<li>
<p>After a new span has started</p>

</li>
<li>
<p>After a span ends</p>

</li>
<li>
<p>After a span is activated (creating a new scope)</p>

</li>
<li>
<p>After a scope is closed</p>

</li>
</ul>

<p>The next sections explain how you can write and add a listener and what it can do. See the <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.html"><code>SpanListener</code></a> Javadoc for more information.</p>


<h4 id="_understanding_what_listeners_do">Understanding What Listeners Do</h4>
<div class="section">
<p>A listener cannot affect the lifecycle of a span or scope it is notified about, but it can add tags and events and update the baggage associated with a span.
Often a listener does additional work that does not change the span or scope such as logging a message.</p>

<p>When Helidon invokes the listener&#8217;s methods it passes proxies for the <code>Span.Builder</code>, <code>Span</code>, and <code>Scope</code> arguments. These proxies limit the access the listener has to the span builder, span, or scope, as summarized in the following table. If a listener method tries to invoke a forbidden operation, the proxy throws a <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.ForbiddenOperationException.html"><code>SpanListener.ForbiddenOperationException</code></a> and Helidon then logs a <code>WARNING</code> message describing the invalid operation invocation.</p>

<div class="block-title"><span>Summary of Permitted Operations on Proxies Passed to Listeners</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Tracing type</th>
<th>Changes allowed</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.Builder.html"><code>Span.Builder</code></a></td>
<td class="">Add tags</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.html"><code>Span</code></a></td>
<td class="">Retrieve and update baggage, add events, add tags</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Scope.html"><code>Scope</code></a></td>
<td class="">none</td>
</tr>
</tbody>
</table>
</div>

<p>The following tables list specifically what operations the proxies permit.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.Builder.html"><code>io.helidon.tracing.Span.Builder</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>build()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>end</code> methods</td>
<td class="">Ends the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>get()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>kind(Kind)</code></td>
<td class="">Sets the "kind" of span (server, client, internal, etc.)</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>parent(SpanContext)</code></td>
<td class="">Sets the parent of the span to be created from the builder.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>start()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>start(Instant)</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>tag</code> methods</td>
<td class="">Add a tag to the builder before the span is built.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>unwrap(Class)</code></td>
<td class="">Cast the builder to the specified implementation type. †</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<p>† Helidon returns the unwrapped object, not a proxy for it.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.html"><code>io.helidon.tracing.Span</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>activate()</code></td>
<td class="">Makes the span "current", returning a <code>Scope</code>.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>addEvent</code> methods</td>
<td class="">Associate a string (and optionally other info) with a span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>baggage()</code></td>
<td class="">Returns the <code>Baggage</code> instance associated with the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>context()</code></td>
<td class="">Returns the <code>SpanContext</code> associated with the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>status(Status)</code></td>
<td class="">Sets the status of the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class="">any <code>tag</code> method</td>
<td class="">Add a tag to the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>unwrap(Class)</code></td>
<td class="">Cast the span to the specified implementation type. †</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<p>† Helidon returns the unwrapped object, not a proxy to it.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Scope.html"><code>io.helidon.tracing.Scope</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>close()</code></td>
<td class="">Close the scope.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>isClosed()</code></td>
<td class="">Reports whether the scope is closed.</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanContext.html"><code>io.helidon.tracing.SpanContext</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>asParent(Span.Builder)</code></td>
<td class="">Sets this context as the parent of a new span builder.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>baggage()</code></td>
<td class="">Returns <code>Baggage</code> instance associated with the span context.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>spanId()</code></td>
<td class="">Returns the span ID.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>traceId()</code></td>
<td class="">Returns the trace ID.</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_adding_a_listener">Adding a Listener</h4>
<div class="section">

<h5 id="_explicitly_registering_a_listener_on_a_tracer">Explicitly Registering a Listener on a <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html"><code>Tracer</code></a></h5>
<div class="section">
<p>Create a <code>SpanListener</code> instance and invoke the <code>Tracer#register(SpanListener)</code> method to make the listener known to that tracer.</p>

</div>


<h5 id="_automatically_registering_a_listener_on_all_tracer_instances">Automatically Registering a Listener on all <code>Tracer</code> Instances</h5>
<div class="section">
<p>Helidon also uses Java service loading to locate listeners and register them automatically on all <code>Tracer</code> objects.
Follow these steps to add a listener service provider.</p>

<ol style="margin-left: 15px;">
<li>
Implement the <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.html"><code>SpanListener</code></a> interface.

</li>
<li>
Declare your implementation as a service provider:
<ol style="margin-left: 15px;">
<li>
Create the file <code>META-INF/services/io.helidon.tracing.SpanListener</code> containing a line with the fully-qualified name of your class which implements <code>SpanListener</code>.

</li>
<li>
If your service has a <code>module-info.java</code> file add the following line to it:
<markup
lang="java"

>provides io.helidon.tracing.SpanListener with &lt;your-implementation-class&gt;;</markup>

</li>
</ol>

</li>
</ol>

<p>The <code>SpanListener</code> interface declares default no-op implementations for all the methods, so your listener can implement only the methods it needs to.</p>

<p>Helidon invokes each listener&#8217;s methods in the following order:</p>

<div class="block-title"><span>Order in which Helidon Invokes Listener Methods</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>When invoked</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>starting(Span.Builder&lt;?&gt; spanBuilder)</code></td>
<td class="">Just before a span is started from its builder.</td>
</tr>
<tr>
<td class=""><code>started(Span span)</code></td>
<td class="">Just after a span has started.</td>
</tr>
<tr>
<td class=""><code>activated(Span span, Scope scope)</code></td>
<td class="">After a span has been activated, creating a new scope. A given span might never be activated; it depends on the code.</td>
</tr>
<tr>
<td class=""><code>closed(Span span, Scope scope)</code></td>
<td class="">After a scope has been closed.</td>
</tr>
<tr>
<td class=""><code>ended(Span span)</code></td>
<td class="">After a span has ended successfully.</td>
</tr>
<tr>
<td class=""><code>ended(Span span, Throwable t)</code></td>
<td class="">After a span has ended unsuccessfully.</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-opentracing-3.0/microprofile-opentracing-spec-3.0.html">MicroProfile Opentracing Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://opentracing.io/">Opentracing Project</a></p>

</li>
</ul>

</div>

</doc-view>
