<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>MicroProfile Rest Client adds the capability to invoke remote services by defining a Java interface with Jakarta REST
 (JAX-RS) annotations that resembles a server-side resource class.</p>

<p>Helidon will automatically create a <em>proxy</em> class for the interface and map local proxy calls to remote REST calls.</p>

<p>For more information, see <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-rest-client-3.0/microprofile-rest-client-spec-3.0.html">Rest Client For MicroProfile Specification</a>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Rest Client
either add a dependency on the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.rest-client&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-rest-client&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">

<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 66.667%;">
</colgroup>
<thead>
<tr>
<th>Class</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">org.eclipse.microprofile.rest.client.RestClientBuilder</td>
<td class="">Base builder instance. Contains configuration options and a <code>build</code> method that creates the actual client instance.</td>
</tr>
</tbody>
</table>
</div>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 66.667%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">@RegisterRestClient</td>
<td class="">A marker annotation to register a client at runtime. This marker must be applied to any CDI managed clients.</td>
</tr>
<tr>
<td class="">@RestClient</td>
<td class="">RestClient qualifier which should be used on an CDI injection points.</td>
</tr>
</tbody>
</table>
</div>


<h3 id="creating-a-new-client">Creating a New Client Using a Builder</h3>
<div class="section">
<p>MicroProfile Rest Client can be created using a builder obtained from <code>RestClientBuilder.newBuilder()</code>.</p>

<p>The builder provides methods to specify the client interface to be proxied as well as to configure
additional details such as server URI, SSL context, connection timeouts, etc.
Any method call on the resulting proxy object will be automatically translated into a remote call to the service using
the provided configuration.</p>

<markup
lang="java"
title="Example"
>GreetRestClient greetResource = RestClientBuilder.newBuilder()
        .baseUri(URI.create("http://localhost:8080/greet"))
        .build(GreetRestClient.class);
greetResource.getDefaultMessage();</markup>

<p>The <code>RestClientBuilder</code> interface extends the <code>Configurable</code> interface from Jakarta REST (JAX-RS),
enabling direct registration of <em>providers</em> such as filters, param converters, exception mappers, etc.</p>

<markup
lang="java"
title="Example"
>GreetRestClient greetResource = RestClientBuilder.newBuilder()
        .baseUri(URI.create("http://localhost:8080"))
        .register(GreetClientRequestFilter.class)
        .register(GreetClientExceptionMapper.class)
        .build(GreetRestClient.class);
greetResource.getDefaultMessage();</markup>

</div>


<h3 id="_creating_a_new_client_using_cdi">Creating a New Client Using CDI</h3>
<div class="section">
<p>A client interface can be annotated with <code>@RegisterRestClient</code> to automatically register it with CDI.
This annotation has a property called <code>baseUri</code> that can be used to define the base endpoint to be used by the client
to access the service.</p>

<markup
lang="java"
title="Example"
>@Path("/greet")
@RegisterRestClient(baseUri = "http://localhost:8080")
public interface GreetRestClient {
    // ...
}</markup>

<p>Any Jakarta REST (JAX-RS) providers for a client can be registered using the (repeatable)
<code>@RegisterProvider</code> annotation on the interface as shown below.</p>

<markup
lang="java"
title="Example"
>@Path("/greet")
@RegisterRestClient(baseUri = "http://localhost:8080")
@RegisterProvider(GreetClientRequestFilter.class)
@RegisterProvider(GreetClientExceptionMapper.class)
public interface GreetRestClient {
    // ...
}</markup>

<p>Once a client interface is annotated, it can be injected into any CDI bean.</p>

<p>All properties in annotation <code>RegisterRestClient</code> can be overridden via configuration as described in
<router-link to="#_configuration_options" @click.native="this.scrollFix('#_configuration_options')">Configuration options</router-link></p>

<markup
lang="java"
title="Example"
>public class MyBean {
    @Inject
    @RestClient
    GreetRestClient client;

    void myMethod() {
        client.getMessage("Helidon");
    }
}</markup>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Configuration is only available for CDI managed client instances, it is not supported for client created
 programmatically using <code>RestClientBuilder</code>.</p>

<p>Most of the configuration properties mentioned below have to be prepended with the fully qualified classname of the
client interface to be configured.</p>

<p>It is possible to avoid fully qualified classname by using <code>@RegisterRestClient(configKey="clientAlias")</code>, the
prefix <code>$restClient</code> is used below to indicate an alias or a class name.</p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<p>Required configuration options:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>$restClient/mp-rest/url</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the base URL to use for this service. This option or <code>/mp-rest/uri</code> need to be set if the value is not present in <code>RegisterRestClient#baseUri</code>.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/uri</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the base URI to use for this service. This option or <code>/mp-rest/url</code> need to be set if the value is not present in <code>RegisterRestClient#baseUri</code>.</td>
</tr>
</tbody>
</table>
</div>

<p>Optional configuration options:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>$restClient/mp-rest/scope</code></td>
<td class="">string</td>
<td class=""><code>jakarta.enterprise.context.Dependent</code></td>
<td class="">The fully qualified classname to a CDI scope to use for injection.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/connectTimeout</code></td>
<td class="">long</td>
<td class="">&#160;</td>
<td class="">Sets timeout in milliseconds to wait to connect to the remote endpoint.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/readTimeout</code></td>
<td class="">long</td>
<td class="">&#160;</td>
<td class="">Sets timeout in milliseconds to wait for a response from the remote endpoint.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/followRedirects</code></td>
<td class="">boolean</td>
<td class=""><code>false</code></td>
<td class="">Sets value used to determine whether the client should follow HTTP redirect responses.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/proxyAddress</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets a string value in the form of &lt;proxyHost&gt;:&lt;proxyPort&gt; that specifies the HTTP proxy server hostname (or IP address) and port for requests of this client to use.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/queryParamStyle</code></td>
<td class="">string (MULTI_PAIRS, COMMA_SEPARATED, ARRAY_PAIRS)</td>
<td class=""><code>MULTI_PAIRS</code></td>
<td class="">Sets enumerated type string value that specifies the format in which multiple values for the same query parameter is used.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/trustStore</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the trust store location. Can point to either a classpath resource (e.g. classpath:/client-truststore.jks) or a file (e.g. file:/home/user/client-truststore.jks).</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/trustStorePassword</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the password for the trust store.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/trustStoreType</code></td>
<td class="">string</td>
<td class=""><code>JKS</code></td>
<td class="">Sets the type of the trust store.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/keyStore</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the key store location. Can point to either a classpath resource (e.g. classpath:/client-keystore.jks) or a file (e.g. file:/home/user/client-keystore.jks).</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/keyStorePassword</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the password for the keystore.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/keyStoreType</code></td>
<td class="">string</td>
<td class=""><code>JKS</code></td>
<td class="">Sets the type of the keystore.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/hostnameVerifier</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the hostname verifier class. This class must have a public no-argument constructor.</td>
</tr>
</tbody>
</table>
</div>

<p>Configuration options affecting CDI and programmatically created clients:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>$restClient/mp-rest/providers</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">A comma separated list of fully-qualified provider classnames to include in the client.</td>
</tr>
<tr>
<td class=""><code>$restClient/mp-rest/providers/&lt;fully-qualified-provider-classname&gt;/priority</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">Sets the priority of the provider for this interface.</td>
</tr>
<tr>
<td class=""><code>org.eclipse.microprofile.rest.client.propagateHeaders</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class="">To specify which headers to propagate from the inbound JAX-RS request to the outbound MP Rest Client request. Should not be prefixed with the rest client class or alias.</td>
</tr>
<tr>
<td class=""><code>microprofile.rest.client.disable.default.mapper</code></td>
<td class="">boolean</td>
<td class=""><code>false</code></td>
<td class="">Whether to disable default exception mapper. Should not be prefixed with the rest client class or alias.</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>To be able to run and test this example, use the  <router-link to="/mp/guides/quickstart">Helidon MP examples/quickstarts</router-link>.
Add a dependency on the Helidon Rest Client implementation and create the following client interface:</p>

<markup
lang="java"
title="client interface"
>@Path("/greet")
interface GreetRestClient {

    @GET
    JsonObject getDefaultMessage();

    @Path("/{name}")
    @GET
    JsonObject getMessage(@PathParam("name") String name);

}</markup>

<p>Then create a runnable method as described in <router-link to="#creating-a-new-client" @click.native="this.scrollFix('#creating-a-new-client')">Creating new client</router-link>, but with baseUri
<code><a target="_blank" href="http://localhost:8080/greet" class="bare">http://localhost:8080/greet</a></code> and the above interface.</p>

<p>By calling <code>GreetRestClient.getDefaultMessage()</code> you reach the endpoint of Helidon quickstart.</p>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.microprofile.restclient/module-summary.html">Helidon MicroProfile RestClient JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-rest-client-3.0/microprofile-rest-client-spec-3.0.html">MicroProfile RestClient Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/eclipse/microprofile-rest-client">MicroProfile RestClient on GitHub</a></p>

</li>
</ul>

</div>

</doc-view>
