<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>PathsConfig (webserver.security) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.security/io/helidon/webserver/security/PathsConfig.html">io.helidon.webserver.security.PathsConfig</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>audit</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to audit this request - defaults to false, if enabled, request is audited with event type "request".</p>

<pre>@return whether to audit</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>audit-event-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Override for event-type, defaults to <code>SecurityHandler#DEFAULT_AUDIT_EVENT_TYPE</code>.</p>

<pre>@return audit event type to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>audit-message-format</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Override for audit message format, defaults to <code>SecurityHandler#DEFAULT_AUDIT_MESSAGE_FORMAT</code>.</p>

<pre>@return audit message format to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticate</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>If called, request will go through authentication process - defaults to false (even if authorize is true).</p>

<pre>@return whether to authenticate or not</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authentication-optional</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>If called, authentication failure will not abort request and will continue as anonymous (defaults to false).</p>

<pre>@return whether authn is optional</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authenticator</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use a named authenticator (as supported by security - if not defined, default authenticator is used).
 Will enable authentication.</p>

<pre>@return name of authenticator as configured in io.helidon.security.Security</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authorize</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enable authorization for this route.</p>

<pre>@return whether to authorize</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authorizer</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use a named authorizer (as supported by security - if not defined, default authorizer is used, if none defined, all is
 permitted).
 Will enable authorization.</p>

<pre>@return name of authorizer as configured in io.helidon.security.Security</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>methods</code></td>
<td class=""><doc-view>
<p>Method[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>roles-allowed</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>An array of allowed roles for this path - must have a security provider supporting roles (either authentication
 or authorization provider).
 This method enables authentication and authorization (you can disable them again by calling
 SecurityHandler#skipAuthorization()
 and #authenticationOptional() if needed).</p>

<pre>@return if subject is any of these roles, allow access</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of sockets this configuration should be applied to.
 If empty, the configuration is applied to all configured sockets.</p>

<pre>@return list of sockets</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
