<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>WebServer (webserver) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/WebServer.html">io.helidon.webserver.WebServer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>server</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backlog</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>Accept backlog.</p>

<pre>@return backlog</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_ConnectionConfig">ConnectionConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of a connection (established from client against our server).</p>

<pre>@return connection configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-options</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_socket_SocketOptions">SocketOptions</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Options for connections accepted by this listener.
 This is not used to setup server connection.</p>

<pre>@return socket options</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>content-encoding</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_encoding_ContentEncodingContext">ContentEncodingContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.encoding.ContentEncodingContext.
 This method discards all previously registered ContentEncodingContext.
 If no content encoding context is registered, content encoding context of the webserver would be used.</p>

<pre>@return content encoding context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>features</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.spi.ServerFeature[&#93; (service provider interface)</p>

<p>Such as:</p>

<ul class="ulist">
<li>
<p><router-link to="/config/io_helidon_webserver_observe_ObserveFeature">observe (ObserveFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_context_ContextFeature">context (ContextFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_cors_CorsFeature">cors (CorsFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_security_SecurityFeature">security (SecurityFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_accesslog_AccessLogFeature">access-log (AccessLogFeature)</router-link></p>

</li>
</ul>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Server features allow customization of the server, listeners, or routings.</p>

<pre>@return server features</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>0.0.0.0</code></td>
<td class=""><doc-view>
<p>Host of the default socket. Defaults to all host addresses (<code>0.0.0.0</code>).</p>

<pre>@return host address to listen on (for the default socket)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idle-connection-period</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT2M</code></td>
<td class=""><doc-view>
<p>How often should we check for #idleConnectionTimeout().
 Defaults to <code>PT2M</code> (2 minutes).</p>

<pre>@return period of checking for idle connections</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idle-connection-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5M</code></td>
<td class=""><doc-view>
<p>How long should we wait before closing a connection that has no traffic on it.
 Defaults to <code>PT5M</code> (5 minutes). Note that the timestamp is refreshed max. once per second, so this setting
 would be useless if configured for shorter periods of time (also not a very good support for connection keep alive,
 if the connections are killed so soon anyway).</p>

<pre>@return timeout of idle connections</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-concurrent-requests</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Limits the number of requests that can be executed at the same time (the number of active virtual threads of requests).
 Defaults to <code>-1</code>, meaning "unlimited" - what the system allows.
 Also make sure that this number is higher than the expected time it takes to handle a single request in your application,
 as otherwise you may stop in-progress requests.</p>

<pre>@return number of requests that can be processed on this listener, regardless of protocol</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-in-memory-entity</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>131072</code></td>
<td class=""><doc-view>
<p>If the entity is expected to be smaller that this number of bytes, it would be buffered in memory to optimize
 performance when writing it.
 If bigger, streaming will be used.</p>

<pre>Note that for some entity types we cannot use streaming, as they are already fully in memory (String, byte[]), for such
cases, this option is ignored.</pre>
<pre>Default is 128Kb.</pre>
<pre>@return maximal number of bytes to buffer in memory for supported writers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-payload-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Maximal number of bytes an entity may have.
 If io.helidon.http.HeaderNames#CONTENT_LENGTH is used, this is checked immediately,
 if io.helidon.http.HeaderValues#TRANSFER_ENCODING_CHUNKED is used, we will fail when the
 number of bytes read would exceed the max payload size.
 Defaults to unlimited (<code>-1</code>).</p>

<pre>@return maximal number of bytes of entity</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-tcp-connections</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Limits the number of connections that can be opened at a single point in time.
 Defaults to <code>-1</code>, meaning "unlimited" - what the system allows.</p>

<pre>@return number of TCP connections that can be opened to this listener, regardless of protocol</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-context</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_media_MediaContext">MediaContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.media.MediaContext.
 This method discards all previously registered MediaContext.
 If no media context is registered, media context of the webserver would be used.</p>

<pre>@return media context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>
<p>Name of this socket. Defaults to <code>@default</code>.
 Must be defined if more than one socket is needed.</p>

<pre>@return name of the socket</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Port of the default socket.
 If configured to <code>0</code> (the default), server starts on a random port.</p>

<pre>@return port to listen on (for the default socket)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocols</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.spi.ProtocolConfig[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of protocols. This may be either protocol selectors, or protocol upgraders from HTTP/1.1.
 As the order is not important (providers are ordered by weight by default), we can use a configuration as an object,
 such as:
 &lt;pre&gt;
 protocols:
   providers:
     http_1_1:
       max-prologue-length: 8192
     http_2:
       max-frame-size: 4096
     websocket:
       &#8230;&#8203;.
 &lt;/pre&gt;</p>

<pre>@return all defined protocol configurations, loaded from service loader by default</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Listener receive buffer size.</p>

<pre>@return buffer size in bytes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>shutdown-grace-period</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.5S</code></td>
<td class=""><doc-view>
<p>Grace period in ISO 8601 duration format to allow running tasks to complete before listener&#8217;s shutdown.
 Default is <code>500</code> milliseconds.
Configuration file values example: <code>PT0.5S</code>, <code>PT2S</code>.</p>

<pre>@return grace period</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>shutdown-hook</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When true the webserver registers a shutdown hook with the JVM Runtime.</p>

<pre>Defaults to true. Set this to false such that a shutdown hook is not registered.</pre>
<pre>@return whether to register a shutdown hook</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_ListenerConfig">Map&lt;string, ListenerConfig&gt;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Socket configurations.
 Note that socket named <code>WebServer#DEFAULT_SOCKET_NAME</code> cannot be used,
 configure the values on the server directly.</p>

<pre>@return map of listener configurations, except for the default one</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_tls_Tls">Tls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Listener TLS configuration.</p>

<pre>@return tls of this configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>write-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Initial buffer size in bytes of java.io.BufferedOutputStream created internally to
 write data to a socket connection. Default is <code>512</code>.</p>

<pre>@return initial buffer size used for writing</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>write-queue-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Number of buffers queued for write operations.</p>

<pre>@return maximal number of queued writes, defaults to 0</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
