<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>OidcConfig (security.providers.oidc.common) Configuration</dt>
<dd slot="desc"><p>Open ID Connect configuration</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security.providers.oidc.common/io/helidon/security/providers/oidc/common/OidcConfig.html">io.helidon.security.providers.oidc.common.OidcConfig</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>authorization-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of an authorization endpoint used to redirect users to for logging-in.</p>

<pre>If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
an attempt is made to use #identityUri(URI)/oauth2/v1/authorize.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>base-scopes</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>openid</code></td>
<td class=""><doc-view>
<p>Configure base scopes.
 By default, this is <code>DEFAULT_BASE_SCOPES</code>.
 If scope has a qualifier, it must be used here.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>check-audience</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Configure audience claim check.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-id</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client ID as generated by OIDC server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-secret</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Client secret as generated by OIDC server.
 Used to authenticate this application with the server when requesting
 JWT based on a code.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-timeout-millis</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>30000</code></td>
<td class=""><doc-view>
<p>Timeout of calls using web client.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-domain</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Domain the cookie is valid for.
 Not used by default.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to encrypt token cookie created by this microservice.
 Defaults to <code>false</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled-id-token</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to encrypt id token cookie created by this microservice.
 Defaults to <code>true</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled-refresh-token</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to encrypt refresh token cookie created by this microservice.
 Defaults to <code>true</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-enabled-tenant-name</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to encrypt tenant name cookie created by this microservice.
 Defaults to <code>true</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of the encryption configuration available through Security#encrypt(String, byte[]) and
 Security#decrypt(String, String).
 If configured and encryption is enabled for any cookie,
 Security MUST be configured in global or current <code>io.helidon.common.context.Context</code> (this
 is done automatically in Helidon MP).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-encryption-password</code></td>
<td class=""><doc-view>
<p>char[]</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Master password for encryption/decryption of cookies. This must be configured to the same value on each microservice
 using the cookie.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-http-only</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When using cookie, if set to true, the HttpOnly attribute will be configured.
 Defaults to <code>OidcCookieHandler.Builder#DEFAULT_HTTP_ONLY</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-max-age-seconds</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>When using cookie, used to set MaxAge attribute of the cookie, defining how long
 the cookie is valid.
 Not used by default.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>JSESSIONID</code></td>
<td class=""><doc-view>
<p>Name of the cookie to use.
 Defaults to <code>DEFAULT_COOKIE_NAME</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name-id-token</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>JSESSIONID_2</code></td>
<td class=""><doc-view>
<p>Name of the cookie to use for id token.
 Defaults to `DEFAULT_COOKIE_NAME`_2.</p>

<pre>This cookie is only used when logout is enabled, as otherwise it is not needed.
Content of this cookie is encrypted.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name-refresh-token</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>JSESSIONID_3</code></td>
<td class=""><doc-view>
<p>The name of the cookie to use for the refresh token.
 Defaults to <code>DEFAULT_REFRESH_COOKIE_NAME</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-name-tenant</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>HELIDON_TENANT</code></td>
<td class=""><doc-view>
<p>The name of the cookie to use for the tenant name.
 Defaults to <code>DEFAULT_TENANT_COOKIE_NAME</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-path</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/</code></td>
<td class=""><doc-view>
<p>Path the cookie is valid for.
 Defaults to "/".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-same-site</code></td>
<td class=""><doc-view>
<p>SameSite (LAX, STRICT, NONE)</p>

</doc-view>
</td>
<td class=""><code>LAX</code></td>
<td class=""><doc-view>
<p>When using cookie, used to set the SameSite cookie value. Can be
 "Strict" or "Lax".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-secure</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>When using cookie, if set to true, the Secure attribute will be configured.
 Defaults to false.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-use</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to use cookie to store JWT between requests.
 Defaults to <code>DEFAULT_COOKIE_USE</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cors</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Assign cross-origin resource sharing settings.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>force-https-redirects</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Force HTTPS for redirects to identity provider.
 Defaults to <code>false</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>frontend-uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Full URI of this application that is visible from user browser.
 Used to redirect request back from identity server after successful login.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>header-token</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_util_TokenHandler">TokenHandler</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A TokenHandler to
 process header containing a JWT.
 Default is "Authorization" header with a prefix "bearer ".</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>header-use</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to expect JWT in a header field.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>id-token-signature-validation</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether id token signature check should be enabled.
 Signature check is enabled by default, and it is highly recommended to not change that.
 Change this setting only when you really know what you are doing, otherwise it could case security issues.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>identity-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of the identity server, base used to retrieve OIDC metadata.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>introspect-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Endpoint to use to validate JWT.
 Either use this or set #signJwk(JwkKeys) or #signJwk(Resource).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>issuer</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Issuer of issued tokens.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-redirects</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>5</code></td>
<td class=""><doc-view>
<p>Configure maximal number of redirects when redirecting to an OIDC provider within a single authentication
 attempt.</p>

<pre>Defaults to `DEFAULT_MAX_REDIRECTS`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata-well-known</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>If set to true, metadata will be loaded from default (well known)
 location, unless it is explicitly defined using oidc-metadata-resource. If set to false, it would not be loaded
 even if oidc-metadata-resource is not defined. In such a case all URIs must be explicitly defined (e.g.
 token-endpoint-uri).</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>oidc-metadata.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Resource configuration for OIDC Metadata
 containing endpoints to various identity services, as well as information about the identity server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>optional-audience</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Allow audience claim to be optional.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Proxy host to use. When defined, triggers usage of proxy for HTTP requests.
 Setting to empty String has the same meaning as setting to null - disables proxy.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>80</code></td>
<td class=""><doc-view>
<p>Proxy port.
 Defaults to <code>DEFAULT_PROXY_PORT</code></p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy-protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>http</code></td>
<td class=""><doc-view>
<p>Proxy protocol to use when proxy is used.
 Defaults to <code>DEFAULT_PROXY_PROTOCOL</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-id-token-param-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>id_token</code></td>
<td class=""><doc-view>
<p>Name of a query parameter that contains the JWT id token when parameter is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-param-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>accessToken</code></td>
<td class=""><doc-view>
<p>Name of a query parameter that contains the JWT access token when parameter is used.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-param-tenant-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>h_tenant</code></td>
<td class=""><doc-view>
<p>Name of a query parameter that contains the tenant name when the parameter is used.
 Defaults to #DEFAULT_TENANT_PARAM_NAME.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>query-param-use</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to use a query parameter to send JWT token from application to this
 server.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>redirect</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>By default, the client should redirect to the identity server for the user to log in.
 This behavior can be overridden by setting redirect to false. When token is not present in the request, the client
 will not redirect and just return appropriate error response code.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>redirect-attempt-param</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>h_ra</code></td>
<td class=""><doc-view>
<p>Configure the parameter used to store the number of attempts in redirect.</p>

<pre>Defaults to `DEFAULT_ATTEMPT_PARAM`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>redirect-uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>/oidc/redirect</code></td>
<td class=""><doc-view>
<p>URI to register web server component on, used by the OIDC server to
 redirect authorization requests to after a user logs in or approves
 scopes.
 Note that usually the redirect URI configured here must be the
 same one as configured on OIDC server.</p>

<pre>Defaults to `DEFAULT_REDIRECT_URI`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>relative-uris</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Can be set to <code>true</code> to force the use of relative URIs in all requests,
 regardless of the presence or absence of proxies or no-proxy lists. By default,
 requests that use the Proxy will have absolute URIs. Set this flag to <code>true</code>
 if the host is unable to accept absolute URIs.
 Defaults to <code>DEFAULT_RELATIVE_URIS</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scope-audience</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Audience of the scope required by this application. This is prefixed to
 the scope name when requesting scopes from the identity server.
 Defaults to empty string.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>server-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>
<p>Configure one of the supported types of identity servers.</p>

<pre>If the type does not have an explicit mapping, a warning is logged and the default implementation is used.</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sign-jwk.resource</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_configurable_Resource">Resource</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>A resource pointing to JWK with public keys of signing certificates used
 to validate JWT.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tenants</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_providers_oidc_common_TenantConfig">TenantConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configurations of the tenants</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-auth</code></td>
<td class=""><doc-view>
<p>ClientAuthentication (CLIENT_SECRET_BASIC, CLIENT_SECRET_POST, CLIENT_SECRET_JWT, PRIVATE_KEY_JWT, NONE)</p>

</doc-view>
</td>
<td class=""><code>CLIENT_SECRET_BASIC</code></td>
<td class=""><doc-view>
<p>Type of authentication to use when invoking the token endpoint.
 Current supported options:</p>

<ul class="ulist">
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_BASIC</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#CLIENT_SECRET_POST</p>

</li>
<li>
<p>io.helidon.security.providers.oidc.common.OidcConfig.ClientAuthentication#NONE</p>

</li>
</ul>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-endpoint-uri</code></td>
<td class=""><doc-view>
<p>URI</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>URI of a token endpoint used to obtain a JWT based on the authentication
 code.
 If not defined, it is obtained from #oidcMetadata(Resource), if that is not defined
 an attempt is made to use #identityUri(URI)/oauth2/v1/token.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>token-signature-validation</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether access token signature check should be enabled.
 Signature check is enabled by default, and it is highly recommended to not change that.
 Change this setting only when you really know what you are doing, otherwise it could case security issues.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-jwt-with-jwk</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Use JWK (a set of keys to validate signatures of JWT) to validate tokens.
 Use this method when you want to use default values for JWK or introspection endpoint URI.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
