<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Tls (common.tls) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.common.tls/io/helidon/common/tls/Tls.html">io.helidon.common.tls.Tls</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cipher-suite</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enabled cipher suites for TLS communication.</p>

<pre>@return cipher suits to enable, by default (or if list is empty), all available cipher suites
        are enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-auth</code></td>
<td class=""><doc-view>
<p>TlsClientAuth (REQUIRED, OPTIONAL, NONE)</p>

</doc-view>
</td>
<td class=""><code>NONE</code></td>
<td class=""><doc-view>
<p>Configure requirement for mutual TLS.</p>

<pre>@return what type of mutual TLS to use, defaults to TlsClientAuth#NONE</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Flag indicating whether Tls is enabled.</p>

<pre>@return enabled flag</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>endpoint-identification-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>HTTPS</code></td>
<td class=""><doc-view>
<p>Identification algorithm for SSL endpoints.</p>

<pre>@return configure endpoint identification algorithm, or set to `NONE`
        to disable endpoint identification (equivalent to hostname verification).
        Defaults to `Tls#ENDPOINT_IDENTIFICATION_HTTPS`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>internal-keystore-provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Provider of the key stores used internally to create a key and trust manager factories.</p>

<pre>@return keystore provider, if not defined, provider is not specified</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>internal-keystore-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Type of the key stores used internally to create a key and trust manager factories.</p>

<pre>@return keystore type, defaults to java.security.KeyStore#getDefaultType()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-manager-factory-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Algorithm of the key manager factory used when private key is defined.
 Defaults to javax.net.ssl.KeyManagerFactory#getDefaultAlgorithm().</p>

<pre>@return algorithm to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>manager</code></td>
<td class=""><doc-view>
<p>io.helidon.common.tls.TlsManager (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The Tls manager. If one is not explicitly defined in the config then a default manager will be created.</p>

<pre>@return the tls manager of the tls instance
@see ConfiguredTlsManager</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key</code></td>
<td class=""><doc-view>
<p>PrivateKey</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key to use. For server side TLS, this is required.
 For client side TLS, this is optional (used when mutual TLS is enabled).</p>

<pre>@return private key to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>TLS</code></td>
<td class=""><doc-view>
<p>Configure the protocol used to obtain an instance of javax.net.ssl.SSLContext.</p>

<pre>@return protocol to use, defaults to `DEFAULT_PROTOCOL`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocols</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enabled protocols for TLS communication.
 Example of valid values for <code>TLS</code> protocol: <code>TLSv1.3</code>, <code>TLSv1.2</code></p>

<pre>@return protocols to enable, by default (or if list is empty), all available protocols are enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit provider to obtain an instance of javax.net.ssl.SSLContext.</p>

<pre>@return provider to use, defaults to none (only #protocol() is used by default)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>revocation</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_tls_RevocationConfig">RevocationConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate revocation check configuration.</p>

<pre>@return certificate revocation configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secure-random-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Algorithm to use when creating a new secure random.</p>

<pre>@return algorithm to use, by default uses java.security.SecureRandom constructor</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secure-random-provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Provider to use when creating a new secure random.
 When defined, #secureRandomAlgorithm() must be defined as well.</p>

<pre>@return provider to use, by default no provider is specified</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>session-cache-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>SSL session cache size.</p>

<pre>@return session cache size, defaults to 1024</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>session-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT30M</code></td>
<td class=""><doc-view>
<p>SSL session timeout.</p>

<pre>@return session timeout, defaults to 30 minutes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust</code></td>
<td class=""><doc-view>
<p>X509Certificate[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of certificates that form the trust manager.</p>

<pre>@return certificates to be trusted</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust-all</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Trust any certificate provided by the other side of communication.</p>

<pre>&lt;b&gt;This is a dangerous setting: &lt;/b&gt; if set to `true`, any certificate will be accepted, throwing away
most of the security advantages of TLS. &lt;b&gt;NEVER&lt;/b&gt; do this in production.</pre>
<pre>@return whether to trust all certificates, do not use in production</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust-manager-factory-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trust manager factory algorithm.</p>

<pre>@return algorithm to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
