<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>SocketOptions (common.socket) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.common.socket/io/helidon/common/socket/SocketOptions.html">io.helidon.common.socket.SocketOptions</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>connect-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT10S</code></td>
<td class=""><doc-view>
<p>Socket connect timeout. Default is 10 seconds.</p>

<pre>@return connect timeout duration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT30S</code></td>
<td class=""><doc-view>
<p>Socket read timeout. Default is 30 seconds.</p>

<pre>@return read timeout duration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>socket-keep-alive</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Configure socket keep alive.
 Default is <code>true</code>.</p>

<pre>@return keep alive
@see java.net.StandardSocketOptions#SO_KEEPALIVE</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>socket-receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>32768</code></td>
<td class=""><doc-view>
<p>Socket receive buffer size.</p>

<pre>@return buffer size, in bytes
@see java.net.StandardSocketOptions#SO_RCVBUF</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>socket-reuse-address</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Socket reuse address.
 Default is <code>true</code>.</p>

<pre>@return whether to reuse address
@see java.net.StandardSocketOptions#SO_REUSEADDR</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>socket-send-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>32768</code></td>
<td class=""><doc-view>
<p>Socket send buffer size.</p>

<pre>@return buffer size, in bytes
@see java.net.StandardSocketOptions#SO_SNDBUF</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tcp-no-delay</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>This option may improve performance on some systems.
 Default is <code>false</code>.</p>

<pre>@return whether to use TCP_NODELAY, defaults to `false`
@see java.net.StandardSocketOptions#TCP_NODELAY</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
