<doc-view>

<h2 id="_what_is_helidon">What is Helidon?</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_what_is_helidon" @click.native="this.scrollFix('#_what_is_helidon')">What is Helidon?</router-link></p>

</li>
<li>
<p><router-link to="#_helidon_flavors" @click.native="this.scrollFix('#_helidon_flavors')">Helidon Flavors</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_what_flavor_shall_i_use" @click.native="this.scrollFix('#_what_flavor_shall_i_use')">What flavor shall I use?</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_prerequisites" @click.native="this.scrollFix('#_prerequisites')">Prerequisites</router-link></p>

</li>
<li>
<p><router-link to="#_next_steps" @click.native="this.scrollFix('#_next_steps')">Next Steps</router-link></p>

</li>
</ul>

</div>


<h2 id="_what_is_helidon_2">What is Helidon?</h2>
<div class="section">
<p><a target="_blank" href="https://helidon.io">Helidon</a> is a collection of Java libraries for writing microservices.</p>

<p>Helidon is open source under the Apache license. Sources are available on <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.9">GitHub</a>.</p>

<p>Helidon is cloud-native ready. It provides fast start-up time and has low memory consumption and a small disk footprint. It also comes with a full observability stack out of the box including health checks, metrics, tracing and logging.</p>

<p>Helidon fully supports GraalVM native image allowing you to build a native executable from your Java application.</p>

<p>Helidon applications are stand-alone Java applications running in their own JVM and powered by the Helidon WebServer.</p>

</div>


<h2 id="_helidon_flavors">Helidon Flavors</h2>
<div class="section">
<p>Helidon comes in two flavors: <strong>Helidon SE</strong> and <strong>Helidon MP</strong>. Think about these flavors as frameworks providing similar functionality but offering different developer experiences.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th><strong>Helidon SE</strong></th>
<th><strong>Helidon MP</strong></th>
</tr>
</thead>
<tbody>
<tr>
<td class="">Gives you full transparency and puts you in control.</td>
<td class="">Built on top of the Helidon SE libraries and provides a platform  that is familiar to enterprise Java developers.</td>
</tr>
<tr>
<td class="">Microframework model with a very small footprint and limited functionality (~7 MB).</td>
<td class=""><a target="_blank" href="https://projects.eclipse.org/proposals/eclipse-microprofile">MicroProfile</a> implementation; slightly larger footprint than SE (~13 MB).</td>
</tr>
<tr>
<td class="">Helidon SE is Helidon’s foundational set of APIs. As of Helidon 4, virtual threads have enabled these APIs to change from asynchronous to blocking. This results in much simpler code that is easier to write, maintain, debug and understand..</td>
<td class="">Declarative style with dependency injection.</td>
</tr>
<tr>
<td class="">Transparent "no magic" development experience; pure java application development with no annotations and no dependency injections.</td>
<td class="">Developer experience similar to that of Spring Boot, Jakarta EE and MicroProfile; layers on some Jakarta EE components (CDI, JAX-RS, JSON-P, JSON-B).</td>
</tr>
<tr>
<td class="">Learn more about <router-link to="/se/introduction">Helidon SE</router-link>.</td>
<td class="">Learn more about <router-link to="/mp/introduction">Helidon MP</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<p>To help illustrate the differences, below are two samples implementing a simple RESTful service. One uses Helidon SE, the other Helidon MP.</p>

<markup
lang="java"
title="Helidon SE sample"
>WebServer.builder()
        .addRouting(HttpRouting.builder()
                            .get("/greet", (req, res)
                                    -&gt; res.send("Hello World!")))
        .build()
        .start();</markup>

<markup
lang="java"
title="Helidon MP sample"
>@Path("hello")
public class HelloWorld {
    @GET
    public String hello() {
        return "Hello World";
    }
}</markup>

<p>Even though Helidon MP supports Jakarta EE APIs it does not require
an application server. Helidon MP applications are stand-alone Java applications running
in their own JVM powered by Helidon WebServer.</p>


<h3 id="_what_flavor_shall_i_use">What flavor shall I use?</h3>
<div class="section">
<p>Use Helidon SE if</p>

<ul class="ulist">
<li>
<p>Performance is your main goal.</p>

</li>
<li>
<p>Your application is heavily using concurrency.</p>

</li>
<li>
<p>You are not planning to use any CDI-based components.</p>

</li>
<li>
<p>You want to use a minimum number of third-party dependencies.</p>

</li>
</ul>

<p>Use Helidon MP if</p>

<ul class="ulist">
<li>
<p>You want to base your application on modern enterprise Java standards such as Jakarta EE and MicroProfile.</p>

</li>
<li>
<p>You are familiar with Java EE, Jakarta EE or Spring Boot and would like to have a  similar development experience.</p>

</li>
<li>
<p>You are migrating existing Java EE/Jakarta EE application to microservices.</p>

</li>
<li>
<p>You are planning to use CDI components or extensions.</p>

</li>
<li>
<p>You are planning to use JPA for data access and Jersey (JAX-RS) for RESTful services.</p>

</li>
</ul>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>If you don&#8217;t know which Helidon flavor to use – use <strong>Helidon MP</strong>.</p>
</p>
</div>

</div>

</div>


<h2 id="_prerequisites">Prerequisites</h2>
<div class="section">
<p>Helidon requires Java and Maven.
You might also need Docker and Kubernetes depending on how you plan to deploy your services.</p>

<div class="block-title"><span>Prerequisite product versions for Helidon 4.0.9</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<p>We also strongly suggest installing the <router-link to="/about/cli">Helidon CLI</router-link> (command line interface) which helps in generating and building Helidon projects.</p>

</div>


<h2 id="_upgrade">Upgrade</h2>
<div class="section">
<p>To upgrade your current version of Helidon, follow the <code>Upgrade Guides</code>:</p>

<p>To upgrade from Helidon 3.x to 4.x:</p>

<ul class="ulist">
<li>
<p><router-link to="/se/guides/upgrade_4x">Helidon SE 4x Upgrade Guide</router-link></p>

</li>
<li>
<p><router-link to="/mp/guides/upgrade_4x">Helidon MP 4x Upgrade Guide</router-link></p>

</li>
</ul>

<p>To upgrade from Helidon 2.x to 3.x:</p>

<ul class="ulist">
<li>
<p><router-link to="/se/guides/upgrade_3x">Helidon SE 3x Upgrade Guide</router-link></p>

</li>
<li>
<p><router-link to="/mp/guides/upgrade_3x">Helidon MP 3x Upgrade Guide</router-link></p>

</li>
</ul>

<p>To upgrade from Helidon 1.x to 2.x:</p>

<ul class="ulist">
<li>
<p><router-link to="/se/guides/upgrade">Helidon SE 2x Upgrade Guide</router-link></p>

</li>
<li>
<p><router-link to="/mp/guides/upgrade">Helidon MP 2x Upgrade Guide</router-link></p>

</li>
</ul>

</div>


<h2 id="_next_steps">Next Steps</h2>
<div class="section">
<p>Choose a Helidon flavor to explore and start using it. Check out the following:</p>

<ul class="ulist">
<li>
<p><router-link to="/se/introduction">Helidon SE Documentation</router-link></p>

</li>
<li>
<p><router-link to="/mp/introduction">Helidon MP Documentation</router-link></p>

</li>
</ul>

</div>

</doc-view>
