<doc-view>

<h2 id="_whats_new_in_this_release">What&#8217;s New in This Release</h2>
<div class="section">
<ul class="ulist">
<li>
<p>Introduction of the new Helidon WebServer (Project N&iacute;ma): a virtual threads-based web server implementation based on <a target="_blank" href="https://openjdk.org/jeps/444">JDK Project Loom</a>  virtual threads.</p>

</li>
<li>
<p>Removed Helidon&#8217;s Reactive WebServer and WebClient that were based on Netty. Our new implementations are based on virtual threads that have a blocking style API (Project N&iacute;ma). Learn more: <router-link to="#_helidon_4_webserver" @click.native="this.scrollFix('#_helidon_4_webserver')">Helidon 4 WebServer.</router-link></p>

</li>
<li>
<p>Converted other <em>reactive</em> API modules to <em>blocking</em> style APIs. The <code>io.helidon.common.reactive</code> APIs will stay as general purpose reactive utilities and operators. Learn more: <router-link to="#_helidon_se" @click.native="this.scrollFix('#_helidon_se')">Helidon SE</router-link></p>

</li>
<li>
<p>Upgraded MicroProfile support to MicroProfile 6 and Jakarta 10 Core Profile running on the Helidon WebServer. Learn more: <router-link to="#_helidon_mp" @click.native="this.scrollFix('#_helidon_mp')">Helidon MP</router-link></p>

</li>
<li>
<p>Java 21 is required to use Helidon 4.</p>

</li>
</ul>

</div>


<h2 id="_helidon_4_webserver">Helidon 4 WebServer</h2>
<div class="section">
<p>Before Helidon 4, the Helidon WebServer was built on Netty and had a reactive API. In Helidon 4 we have replaced this with a new server implementation (Project N&iacute;ma) that is written from the ground up to take full advantage of Java 21&#8217;s virtual threads. With virtual threads, threads are no longer a scarce resource to be carefully pooled and managed. Instead they are an abundant resource that can be created as needed to handle nearly unlimited concurrent requests.</p>

<p>Because each request runs in its own dedicated thread, it is free to perform blocking operations&#8201;&#8212;&#8201;like calling a database, or another service. And it can do so in a simple synchronous way with no fear of blocking a platform thread and starving other requests. You no longer need to resort to complicated asynchronous code to implement a low-overhead, highly concurrent service.</p>

</div>


<h2 id="_helidon_se">Helidon SE</h2>
<div class="section">
<p>Helidon SE is Helidon&#8217;s foundational set of APIs. The big change in Helidon 4 is that the use of virtual threads have enabled these APIs to change from asynchronous to blocking. This results in much simpler code that is easier to write, maintain, debug and understand. Existing Helidon 3 SE code will require modification to run on these new APIs, but the effort is well worth the improved performance and simplicity of the resulting code.</p>

<p>To give a very simple example of the differences between Helidon 3 SE and Helidon 4 SE, let&#8217;s take a look at extracting a JSON body from an HTTP request and doing something with it:</p>

<markup
lang="java"
title="Helidon 3"
>request.content().as(JsonObject.class)
        .thenAccept(jo -&gt; doSomething(jo, response));</markup>

<markup
lang="java"
title="Helidon 4"
>doSomething(request.content().as(JsonObject.class), response);</markup>

</div>


<h2 id="_helidon_mp">Helidon MP</h2>
<div class="section">
<p>Helidon MP is Helidon&#8217;s MicroProfile implementation and in Helidon 4 it supports MicroProfile 6 and the Jakarta EE 10 Core Profile. Your Helidon 3 MicroProfile application should migrate to Helidon 4 fairly easily (the most significant changes are in MicroProfile Metrics 5.0), and since Helidon&#8217;s MicroProfile server is based on the new Helidon WebServer (Project N&iacute;ma), you get all the benefits of running on virtual threads.</p>

</div>

</doc-view>
