<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_registering_and_updating_meters" @click.native="this.scrollFix('#_registering_and_updating_meters')">Registering and Updating Meters</router-link></p>

</li>
<li>
<p><router-link to="#_accessing_the_helidon_micrometer_endpoint" @click.native="this.scrollFix('#_accessing_the_helidon_micrometer_endpoint')">Accessing the Helidon Micrometer Endpoint</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_the_helidon_micrometer_api" @click.native="this.scrollFix('#_the_helidon_micrometer_api')">The Helidon Micrometer API</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_register_an_instance_of_micrometersupport_with_the_web_server" @click.native="this.scrollFix('#_register_an_instance_of_micrometersupport_with_the_web_server')">Register an Instance of MicrometerSupport with the Web Server</router-link></p>

</li>
<li>
<p><router-link to="#_create_and_update_meters_in_your_application_service" @click.native="this.scrollFix('#_create_and_update_meters_in_your_application_service')">Create and Update Meters in Your Application Service</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link>
`
:se-flavor:
:feature-name: Micrometer support</p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon SE simplifies how you can use Micrometer for application-specific metrics:</p>

<ul class="ulist">
<li>
<p>The endpoint <code>/micrometer</code>: A configurable endpoint that exposes metrics according to which Micrometer meter registry
responds to the HTTP request.</p>

</li>
<li>
<p>The <code>MicrometerSupport</code> class: A convenience class for enrolling Micrometer meter registries your application
creates explicitly or for selecting which built-in Micrometer meter registries
to use.</p>

</li>
<li>
<p>Configuration to tailor the Prometheus and other Micrometer meter registries.</p>

</li>
</ul>

<p>In Helidon 4.0.7, Micrometer support is separate from the Helidon SE metrics API and the built-in Helidon metrics.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable {feature-name}
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.micrometer&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-micrometer&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Micrometer supports different types of meter registries which have different output styles and formats.
Helidon provides built-in support for the Prometheus meter registry.
To use other meter registry types, you will need to add dependencies for them to your <code>pom.xml</code> and, optionally, add
code to your application or add
configuration to set them up as you wish.</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Your application registers and updates Micrometer meters using annotations or direct use of the Micrometer API.</p>

<p>Your users retrieve Micrometer meters using an endpoint which Helidon creates automatically.</p>


<h3 id="_registering_and_updating_meters">Registering and Updating Meters</h3>
<div class="section">
<p>Your code
can create, look up, and update metrics programmatically using the Micrometer <code>MeterRegistry</code> API. The <a target="_blank" href="https://docs.micrometer.io/micrometer/reference/concepts.html">Micrometer concepts document</a> provides a good starting point for learning how to use Micrometer&#8217;s interfaces and classes.</p>

</div>


<h3 id="_accessing_the_helidon_micrometer_endpoint">Accessing the Helidon Micrometer Endpoint</h3>
<div class="section">
<p>Your application can easily have Helidon create
a REST endpoint which clients can access to retrieve Micrometer metrics, by default at the <code>/micrometer</code> endpoint.</p>

<p>Within Helidon, each type of meter registry is paired with some code that examines the incoming HTTP request to <code>/micrometer</code> and decides
whether the request matches up with the associated meter registry. The first pairing that accepts the request
returns the response. You will need to take advantage of this if your application uses additional meter registries beyond what Helidon automatically provides <em>and</em> you want those meter registries reflected in the output from the <code>/micrometer</code> REST endpoint.</p>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">

<h3 id="_the_helidon_micrometer_api">The Helidon Micrometer API</h3>
<div class="section">
<p>Helidon provides no special API for dealing with Micrometer meters and meter registries beyond what Micrometer offers itself.</p>

<p>Helidon <em>does</em> give you an easy way to expose a REST endpoint to report the meters stored in the Micrometer meter registry. The <a target="_blank" href="https://javadoc.io/doc/io.micrometer/io/helidon/integrations/micrometer/MicrometerSupport.html"><code>MicrometerSupport</code></a> interface
exposes static methods to directly create an instance of <code>MicrometerSupport</code> and to return a <a target="_blank" href="https://javadoc.io/doc/io.micrometer/io/helidon/integrations/micrometer/MicrometerSupport.Builder.html"><code>Builder</code></a> instance so your
code can fine-tune how the REST service behaves.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>You can configure the Helidon Micrometer REST service as you can other built-in Helidon services by adding configuration settings under the <code>micrometer</code> top-level key.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.integrations.micrometer/io/helidon/integrations/micrometer/MicrometerFeature.html">io.helidon.integrations.micrometer.MicrometerFeature</a></p>

<markup
lang="text"
title="Config key"
>micrometer</markup>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cross-origin-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_cors_CrossOriginConfig">CrossOriginConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the CORS config from the specified <code>CrossOriginConfig</code> object.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Set the root context for the REST API of the service.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>By default, Helidon Micrometer integration exposes the <code>/micrometer</code> endpoint.
You can override the path using
the <a target="_blank" href="https://javadoc.io/doc/io.micrometer/MicrometerSupport.Builder.html"><code>Builder</code></a> or
the <code>micrometer.web-context</code> configuration key.</p>

<markup
lang="yaml"
title="Overriding the default Micrometer path"
>micrometer:
  web-context: my-micrometer</markup>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon SE includes an <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.7/examples/integrations/micrometer/se">example application</a> which uses Micrometer support.</p>

<p>The rest of this section takes you through the process of changing your application to use Helidon SE integration with Micrometer:</p>

<ol style="margin-left: 15px;">
<li>
Register an instance of <a target="_blank" href="https://javadoc.io/doc/io.micrometer/io/helidon/integrations/micrometer/MicrometerSupport.html"><code>MicrometerSupport</code></a> with the web server.

</li>
<li>
Create meters using the meter registry managed by Helidon&#8217;s <code>MicrometerSupport</code> and then update and query those meters.

</li>
</ol>


<h3 id="_register_an_instance_of_micrometersupport_with_the_web_server">Register an Instance of MicrometerSupport with the Web Server</h3>
<div class="section">
<markup
lang="java"
title="Initialize Micrometer support"
>MicrometerFeature micrometerFeature = MicrometerFeature.create(); <span class="conum" data-value="1" />

HttpRouting.builder()
        .addFeature(micrometerFeature) <span class="conum" data-value="2" />
        .register("/myapp", new MyService(micrometerFeature.registry())) <span class="conum" data-value="3" />
        .build();</markup>

<ul class="colist">
<li data-value="1">Create the <code>MicrometerSupport</code> instance, using the default built-in Prometheus meter registry.</li>
<li data-value="2">Register the <code>MicrometerSupport</code> instance as a service; by default, <code>MicrometerSupport</code> exposes the endpoint as <code>/micrometer</code>.</li>
<li data-value="3">Pass the <code>MicrometerSupport</code> object&#8217;s meter registry to your service for use in creating and updating meters.</li>
</ul>

</div>


<h3 id="_create_and_update_meters_in_your_application_service">Create and Update Meters in Your Application Service</h3>
<div class="section">
<markup
lang="java"
title="Define and use a <code>Counter</code>"
>class MyService implements HttpService {

    final Counter requestCounter;

    MyService(MeterRegistry registry) {
        requestCounter = registry.counter("allRequests"); <span class="conum" data-value="1" />
    }

    @Override
    public void routing(HttpRules rules) {
        rules
                .any(this::countRequests) <span class="conum" data-value="2" />
                .get("/", this::myGet);
    }

    void countRequests(ServerRequest request, ServerResponse response) {
        requestCounter.increment(); <span class="conum" data-value="3" />
        response.next();
    }

    void myGet(ServerRequest request, ServerResponse response) {
        response.send("OK");
    }

}</markup>

<ul class="colist">
<li data-value="1">Use the Micrometer meter registry to create the request counter.</li>
<li data-value="2">Add routing for any request to invoke the method which counts requests by updating the counter.</li>
<li data-value="3">Update the counter and then delegate the rest of the request processing to the next handler in the chain.</li>
</ul>

<p>The example above enrolls the built-in Prometheus meter registry with the default Prometheus registry configuration.
You can change the default setup for built-in registries, and you can enroll other meter registries your application
creates itself.</p>


<h4 id="_overriding_defaults_for_built_in_meter_registry_types">Overriding Defaults for Built-in Meter Registry Types</h4>
<div class="section">
<p>Unless you specify otherwise, Helidon uses defaults for any built-in Micrometer meter registry.
For example, Helidon configures the built-in Prometheus registry using <code>PrometheusConfig.DEFAULT</code>.</p>

<p>You can override these defaults in either of two ways:</p>

<ul class="ulist">
<li>
<p>Using the <a target="_blank" href="https://javadoc.io/doc/io.micrometer/io/helidon/integrations/micrometer/MicrometerSupport.Builder.html"><code>MicrometerSupport.Builder</code></a> class</p>

</li>
<li>
<p>Using configuration</p>

</li>
</ul>

</div>


<h4 id="_using_micrometersupport_builder">Using MicrometerSupport.Builder</h4>
<div class="section">
<p>Use the <code>MicrometerSupport.Builder</code> class to set up Micrometer support however your application needs.</p>

<p>The builder lets you:</p>

<ul class="ulist">
<li>
<p>Provide your own Micrometer meter registry configuration that <code>MicrometerSupport</code> uses to create a built-in meter
registry, or</p>

</li>
<li>
<p>Instantiate a Micrometer meter registry yourself, configured however you want, and add it to the <code>MicrometerSupport</code>
object&#8217;s collection of meter registries</p>

</li>
</ul>

<markup
lang="java"
title="Overriding defaults for built-in meter registries using <code>MicrometerSupport.Builder</code>"
>MeterRegistryFactory meterRegistryFactory = MeterRegistryFactory.builder()
        .enrollBuiltInRegistry(BuiltInRegistryType.PROMETHEUS, myPrometheusConfig) <span class="conum" data-value="1" />
        .build();
MicrometerFeature micrometerFeature = MicrometerFeature.builder()
        .meterRegistryFactorySupplier(meterRegistryFactory)
        .build();</markup>

<ul class="colist">
<li data-value="1">Enroll the <code>PROMETHEUS</code> built-in registry type with your meter registry configuration.</li>
</ul>

</div>


<h4 id="_using_configuration">Using Configuration</h4>
<div class="section">
<p>To use configuration to control the selection and behavior of Helidon&#8217;s built-in Micrometer meter registries,
include in your configuration (such as <code>application.yaml</code>) a <code>micrometer.builtin-registries</code> section.</p>

<markup
lang="yaml"
title="Enroll Prometheus built-in meter registry using default configuration"
>micrometer:
  builtin-registries:
    - type: prometheus</markup>

<markup
lang="yaml"
title="Enroll Prometheus built-in meter registry with non-default configuration"
>micrometer:
  builtin-registries:
    - type: prometheus
      prefix: myPrefix</markup>

<p>Note that the first config example is equivalent to the default Helidon Micrometer behavior; Helidon by default supports the Prometheus meter registry.</p>

<p>The configuration keys that are valid for the <code>builtin-registries</code> child entries depend on the type of Micrometer meter
registry.
For example, support in Helidon for the <a target="_blank" href="https://javadoc.io/doc/io.micrometer/micrometer-registry-prometheus/1.11.1/io/micrometer/prometheus/PrometheusConfig.html">Prometheus meter registry</a> respects the <code>prefix</code> configuration setting but other meter registries might not and might support other settings.
Refer to the documentation for the meter registry you want to configure to find out what items apply to that registry
type.</p>

<p>Helidon does not validate the configuration keys you specify for
meter registries.</p>

</div>

</div>


<h3 id="_enrolling_other_micrometer_meter_registries">Enrolling Other Micrometer Meter Registries</h3>
<div class="section">
<p>To create additional types of registries and enroll them with <code>MicrometerSupport</code>, you need to:</p>

<ol style="margin-left: 15px;">
<li>
Write a <code>Handler</code><br>

<p>Each meter registry has its own way of producing output.
Write your handler so that it has a reference to the meter registry it should use and so that
its <code>accept</code> method sets the payload in the HTTP response using the registry&#8217;s mechanism for creating output.</p>

</li>
<li>
Write a <code>Function</code> which accepts a <code>ServerRequest</code> and returns an <code>Optional&lt;Handler&gt;</code><br>

<p>Typically, the function examines the request&#8212;&#8203;the <code>Content-Type</code>, query parameters, etc.--to
decide whether the corresponding handler should respond to the request.
If so, your function should instantiate your <code>Handler</code> and return an <code>Optional.of(theHandlerInstance)</code>;
otherwise, your function should return <code>Optional.empty()</code>.<br>
</p>

<p>When <code>MicrometerSupport</code> receives a request, it invokes the functions of all the enrolled registries,
stopping as soon as one function provides a handler.
<code>MicrometerSupport</code> then delegates to that handler to create and send the response.</p>

</li>
<li>
Pass the <code>Handler</code> and <code>Function</code> to the <code>MicrometerSupport.enrollRegistry</code> method to enroll them<br>

<markup
lang="java"
title="Creating and enrolling your own Micrometer meter registry"
>PrometheusMeterRegistry myRegistry = new PrometheusMeterRegistry(myPrometheusConfig); <span class="conum" data-value="1" />
MeterRegistryFactory meterRegistryFactory = MeterRegistryFactory.builder()
        .enrollRegistry(myRegistry, request -&gt; {
            return request <span class="conum" data-value="2" />
                    .headers()
                    .bestAccepted(MediaTypes.TEXT_PLAIN)
                    .map(mt -&gt; (req, resp) -&gt; resp.send(myRegistry.scrape())); <span class="conum" data-value="3" />
        })
        .build();
MicrometerFeature micrometerFeature = MicrometerFeature.builder()
        .meterRegistryFactorySupplier(meterRegistryFactory)
        .build();</markup>

<ul class="colist">
<li data-value="1">Create the meter registry. This example uses a Prometheus registry, but it can be any extension of <code>MeterRegistry</code>.</li>
<li data-value="2">Provide the function that checks if the <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/http/ServerRequest.html"><code>ServerRequest</code></a></li>
<li data-value="3">A very simple in-line <code>Handler</code> that sets the response entity from the Prometheus registry&#8217;s <code>scrape()</code> method.</li>
</ul>

</li>
</ol>

</div>


<h3 id="_accessing_the_helidon_micrometer_endpoint_2">Accessing the Helidon Micrometer Endpoint</h3>
<div class="section">
<p>Your application can easily have Helidon create
a REST endpoint which clients can access to retrieve Micrometer metrics, by default at the <code>/micrometer</code> endpoint.</p>

<p>Within Helidon, each type of meter registry is paired with some code that examines the incoming HTTP request to <code>/micrometer</code> and decides
whether the request matches up with the associated meter registry. The first pairing that accepts the request
returns the response. You will need to take advantage of this if your application uses additional meter registries beyond what Helidon automatically provides <em>and</em> you want those meter registries reflected in the output from the <code>/micrometer</code> REST endpoint.</p>

<p>When <code>MicrometerSupport</code> receives a request at the endpoint, it looks for the first enrolled meter registry for which
the corresponding <code>Function&lt;ServerRequest, Optional&lt;Handler&gt;&gt;</code> returns a non-empty <code>Handler</code>.
Helidon invokes that <code>Handler</code> which must retrieve the metrics output from its meter registry and set
and send the response.
Note that the <code>Handler</code> which your function returns typically has a reference to the meter registry it will use
in preparing the response.</p>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>The <a target="_blank" href="https://micrometer.io">Micrometer website</a> describes the project as a whole and has links to more information.</p>

</div>

</doc-view>
