<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon MP implements the
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-graphql-2.0/microprofile-graphql-spec-2.0.html">MicroProfile GraphQL specification</a>.
This specifcation describes how applications can be built to expose an endpoint for GraphQL.
GraphQL is an open-source data query and manipulation language for APIs,
and a runtime for fulfilling data queries.
It provides an alternative to, though not necessarily a replacement for, REST.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile GraphQL
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.graphql&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-graphql-server&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The MicroProfile GraphQL specification defines a number of key annotations to be used when writing a GraphQL endpoint:</p>

<ul class="ulist">
<li>
<p><code>@GraphQLApi</code> - identifies a CDI Bean as a GraphQL endpoint</p>

</li>
<li>
<p><code>@Query</code> - identifies a method as returning one or more entities</p>

</li>
<li>
<p><code>@Mutation</code> - identifies a method which creates, deletes or updates entities</p>

</li>
</ul>

<p>For example, the following defines a GraphQL endpoint with a number of queries and mutations that work
against a fictional <code>CustomerService</code> service and <code>Customer</code> class.</p>

<markup
lang="java"
title="Simple ContactGraphQLApi"
>@ApplicationScoped
@GraphQLApi
public class ContactGraphQLApi {

    @Inject
    private CustomerService customerService;

    @Query
    public Collection&lt;Customer&gt; findAllCustomers() { <span class="conum" data-value="1" />
        return customerService.getAllCustomers();
    }

    @Query
    public Customer findCustomer(@Name("customerId") int id) { <span class="conum" data-value="2" />
        return customerService.getCustomer(id);
    }

    @Query
    public Collection&lt;Customer&gt; findCustomersByName(@Name("name") String name) { <span class="conum" data-value="3" />
        return customerService.getAllCustomers(name);
    }

    @Mutation
    public Customer createCustomer(@Name("customerId") int id, <span class="conum" data-value="4" />
                                  @Name("name") String name,
                                  @Name("balance") float balance) {
        return customerService.createCustomer(id, name, balance);
    }
}

public class customer {
    private int id;
    @NonNull
    private String name;
    private float balance;

    // getters and setters omitted for brevity
}</markup>

<ul class="colist">
<li data-value="1">a query with no-arguments that will return all <code>Customer</code> s</li>
<li data-value="2">a query that takes an argument to return a specific <code>Customer</code></li>
<li data-value="3">a query that optionally takes a name and returns a collection of <code>Customer</code> s</li>
<li data-value="4">a mutation that creates a Customer and returns the newly created <code>Customer</code></li>
</ul>

<p>The example above would generate a GraphQL schema as shown below:</p>

<markup
lang="graphql"
title="Sample GraphQL schema"
>type Query {
   findAllCustomers: [Customer]
   findCustomer(customerId: Int!): Customer
   findCustomersByName(name: String): [Customers]
}

type Mutation {
   createCustomer(customerId: Int!, name: String!, balance: Float!): Customer
}

type Customer {
   id: Int!
   name: String!
   balance: Float
}</markup>

<p>After application startup, a GraphQL schema will be generated from your annotated API classes
and POJO&#8217;s and you will be able to access these via the URLs described below.</p>


<h3 id="_building_your_application">Building your application</h3>
<div class="section">
<p>As part of building your application, you must create a Jandex index
using the <code>jandex-maven-plugin</code> for all API and POJO classes.</p>

<markup
lang="xml"
title="Generate Jandex index"
>&lt;plugin&gt;
    &lt;groupId&gt;io.smallrye&lt;/groupId&gt;
    &lt;artifactId&gt;jandex-maven-plugin&lt;/artifactId&gt;
    &lt;executions&gt;
        &lt;execution&gt;
            &lt;id&gt;make-index&lt;/id&gt;
        &lt;/execution&gt;
    &lt;/executions&gt;
&lt;/plugin&gt;</markup>

<div class="admonition note">
<p class="admonition-inline">As per the instructions <router-link to="/mp/introduction/microprofile">here</router-link> ensure you have added a
<code>src/main/resources/META-INF/beans.xml</code> file, so the CDI implementation can pick up your classes.</p>
</div>

</div>


<h3 id="_accessing_the_graphql_endpoints">Accessing the GraphQL endpoints</h3>
<div class="section">
<p>After starting your application you should see a log message indicating that GraphQL
is in the list of features. You can access the GraphQL endpoint at <code><a target="_blank" href="http://host:port/graphql" class="bare">http://host:port/graphql</a></code>, and
the corresponding schema at <code><a target="_blank" href="http://host:port/graphql/schema.graphql" class="bare">http://host:port/graphql/schema.graphql</a></code>. See <router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')"></router-link> for
additional information on how to change the location of these resources.</p>

<p>If you wish to use the
<a target="_blank" href="https://github.com/graphql/graphiql">GraphQL UI</a> then please see the
<a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.7/examples/microprofile/graphql">GraphQL MP Example</a>.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>The specification defines the following configuration options:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>mp.graphql.defaultErrorMessage</code></td>
<td class=""><code>Server Error</code></td>
<td class="">Error message to send to caller in case of error</td>
</tr>
<tr>
<td class=""><code>mp.graphql.exceptionsBlackList</code></td>
<td class="">&#160;</td>
<td class="">Array of checked exception classes that should return default error message</td>
</tr>
<tr>
<td class=""><code>mp.graphql.exceptionsWhiteList</code></td>
<td class="">&#160;</td>
<td class="">Array of unchecked exception classes that should return message to caller (instead of default error message)</td>
</tr>
</tbody>
</table>
</div>

<p>The following configuration keys can be used to set up integration with WebServer:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>graphql.web-context</code></td>
<td class=""><code>/graphql</code></td>
<td class="">Context that serves the GraphQL endpoint.</td>
</tr>
<tr>
<td class=""><code>graphql.schema-uri</code></td>
<td class=""><code>/schema.graphql</code></td>
<td class="">URI that serves the schema (under web context)</td>
</tr>
<tr>
<td class=""><code>graphql.cors</code></td>
<td class="">&#160;</td>
<td class="">CORS configuration for this service</td>
</tr>
<tr>
<td class=""><code>graphql.executor-service</code></td>
<td class="">&#160;</td>
<td class="">Configuration of <code>ServerThreadPoolSupplier</code> used to set up executor service</td>
</tr>
</tbody>
</table>
</div>

<p>The following configuration keys can be used to set up GraphQL invocation:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 22.222%;">
<col style="width: 22.222%;">
<col style="width: 55.556%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>graphql.default-error-message</code></td>
<td class=""><code>Server Error</code></td>
<td class="">Error message to send to caller in case of error</td>
</tr>
<tr>
<td class=""><code>graphql.exception-white-list</code></td>
<td class="">&#160;</td>
<td class="">Array of checked exception classes that should return default error message</td>
</tr>
<tr>
<td class=""><code>graphql.exception-black-list</code></td>
<td class="">&#160;</td>
<td class="">Array of unchecked exception classes that should return message to caller (instead of default error message)</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>For a complete example, see
<a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.7/examples/microprofile/graphql">GraphQL MP Example</a>.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="http://graphql.org">GraphQL</a>.</p>

</li>
</ul>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-graphql-2.0/apidocs">MicroProfile GraphQL Javadocs</a>.</p>

</li>
</ul>

</div>

</doc-view>
