<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>In Helidon 4 all observability features were moved to one logical module: <code>observe</code>. The observability support groups all observe endpoints together under a single context root (the default behavior) <code>/observe</code>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon Observability
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Health Observability features:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Metrics Observability features:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Info Observability features:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-info&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Logging Observability features:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-log&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Each provider usually adds a new endpoint (such as <code>health</code>, <code>metrics</code>).
This is to have a single easily configurable path for security, proxy etc. purposes, rather than expose multiple "root" endpoints that may collide with the business code.</p>


<h3 id="_discovery">Discovery</h3>
<div class="section">
<p><code>ObserveProvider</code> instances are discovered using <code>ServiceLoader</code>. In case an explicit <code>Observer</code> is registered with the
same <code>type</code> as a provider, the provider will not be used (so we do not duplicate services).</p>

</div>


<h3 id="_endpoints">Endpoints</h3>
<div class="section">
<p>The "Observe" service endpoint can be modified on the <code>ObserveFeature</code> that is registered with routing. The feature endpoint defaults to <code>/observe</code>, and all observers are prefixed with it (see further)</p>

<p>Each observer has customizable endpoints as well, and the result is decided as follows:
1. If the custom endpoint is relative, the result would be under observe endpoint (e.g. for <code>health</code> &#8594; <code>/observe/health</code>)
2. If the custom endpoint is absolute, the result would be absolute as well (e.g. for <code>/health</code> &#8594; <code>/health</code>)</p>


<h4 id="_configuration_observability">Configuration Observability</h4>
<div class="section">
<p>Configuration observability allows reading the current application configuration values.
Configuration observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/config/profile</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the current configuration profile</td>
</tr>
<tr>
<td class=""><code>/config/values</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the current configuration values</td>
</tr>
<tr>
<td class=""><code>/config/values/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns specified by <code>name</code> configuration value</td>
</tr>
</tbody>
</table>
</div>

<div class="admonition note">
<p class="admonition-inline">All secrets and passwords are obfuscated with "*" characters.</p>
</div>

</div>


<h4 id="_health_observability">Health Observability</h4>
<div class="section">
<p>Health observability allows reading application readiness to serve requests, whether the services are alive.
Health observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/health/ready</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns Service Readiness</td>
</tr>
<tr>
<td class=""><code>/health/live</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service is alive</td>
</tr>
<tr>
<td class=""><code>/health/started</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service is started</td>
</tr>
<tr>
<td class=""><code>/health/ready/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns Service <code>name</code> Readiness</td>
</tr>
<tr>
<td class=""><code>/health/live/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service <code>name</code> is alive</td>
</tr>
<tr>
<td class=""><code>/health/started/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns whether the service <code>name</code> is started</td>
</tr>
<tr>
<td class=""><code>/health/check/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns all checks for service <code>name</code></td>
</tr>
<tr>
<td class=""><code>/health/ready</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns Service Readiness without details</td>
</tr>
<tr>
<td class=""><code>/health/live</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service is alive without details</td>
</tr>
<tr>
<td class=""><code>/health/started</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service is started without details</td>
</tr>
<tr>
<td class=""><code>/health/ready/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns Service <code>name</code> Readiness without details</td>
</tr>
<tr>
<td class=""><code>/health/live/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service <code>name</code> is alive without details</td>
</tr>
<tr>
<td class=""><code>/health/started/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns whether the service <code>name</code> is started without details</td>
</tr>
<tr>
<td class=""><code>/health/check/{name}</code></td>
<td class=""><code>HEAD</code></td>
<td class="">Returns all checks for service <code>name</code> without details</td>
</tr>
</tbody>
</table>
</div>

<p>For more information, please, check <router-link to="/se/health">Health</router-link> documentation.</p>

</div>


<h4 id="_information_observability">Information Observability</h4>
<div class="section">
<p>Info observability allows configuration of custom properties to be available to users.
Information observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/info</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the Application information</td>
</tr>
<tr>
<td class=""><code>/info/{name}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the Application information for the specified <code>name</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_logger_observability">Logger Observability</h4>
<div class="section">
<p>Log observability allows reading and configuring of log levels of various loggers and reading log messages.
Logger Observability defines the following endpoints:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Endpoint</th>
<th>Method</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>/log</code></td>
<td class=""><code>GET</code></td>
<td class="">Stream logs (if enabled)</td>
</tr>
<tr>
<td class=""><code>/log/loggers</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns all logger handlers</td>
</tr>
<tr>
<td class=""><code>/log/log/loggers/{logger}</code></td>
<td class=""><code>GET</code></td>
<td class="">Returns the Logger by name <code>logger</code></td>
</tr>
<tr>
<td class=""><code>/log/loggers/{logger}</code></td>
<td class=""><code>POST</code></td>
<td class="">Set Logger level by name <code>logger</code></td>
</tr>
<tr>
<td class=""><code>/log/loggers/{logger}</code></td>
<td class=""><code>DELETE</code></td>
<td class="">Unset the specified logger <code>logger</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_metrics_observability">Metrics Observability</h4>
<div class="section">
<p>Helidon distinguishes among three general <em>types</em>, or scopes, of metrics.</p>

<div class="block-title"><span>Types (scopes) of metrics</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Type/scope</th>
<th>Typical Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">base</td>
<td class="">OS or Java runtime measurements (available heap, disk space, etc.).</td>
</tr>
<tr>
<td class="">vendor</td>
<td class="">Implemented by vendors, including the <code>REST.request</code> metrics and other key performance indicator measurements.</td>
</tr>
<tr>
<td class="">application</td>
<td class="">Declared via annotations or programmatically registered by your service code.</td>
</tr>
</tbody>
</table>
</div>

<p>When you add the metrics dependency to your project, Helidon automatically provides a built-in REST endpoint <code>/observe/metrics</code> which responds with a report of the registered metrics and their values.</p>

<p>Clients can request a particular output format.</p>

<div class="block-title"><span>Formats for <code>/observe/metrics</code> output</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Format</th>
<th>Requested by</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">OpenMetrics (Prometheus)</td>
<td class="">default (<code>text/plain</code>)</td>
</tr>
<tr>
<td class="">JSON</td>
<td class="">Header <code>Accept: application/json</code></td>
</tr>
</tbody>
</table>
</div>

<p>Clients can also limit the report by appending the metric type to the path:</p>

<ul class="ulist">
<li>
<p><code>/observe/metrics/base</code></p>

</li>
<li>
<p><code>/observe/metrics/vendor</code></p>

</li>
<li>
<p><code>/observe/metrics/application</code></p>

</li>
</ul>

<p>For more information see <router-link to="/se/metrics/metrics">Metrics</router-link> documentation.</p>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To customize the endpoint of an observer:</p>

<ol style="margin-left: 15px;">
<li>
Configure a custom endpoint through configuration to modify the <code>ObserveProvider</code> setup (such as <code>observe.health.endpoint</code>)

</li>
<li>
Configure a custom endpoint through a builder on the specific <code>Observer</code> (<code>HealthObserver.builder().endpoint("myhealth")</code>)

</li>
</ol>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>The Observability features are now implemented with <code>HttpFeature</code> and can be registered with <code>HttpRouting.Builder#addFeature(java.util.function.Supplier)</code>. Such a feature encapsulates a set of endpoints, services and/or filters.</p>

<p>Feature is similar to <code>HttpService</code> but gives more freedom in setup.
Main difference is that a feature can add <code>Filter</code> filters and it cannot be  registered on a path (that is left to the discretion of the feature developer).</p>

<ul class="ulist">
<li>
<p>Features are not registered immediately - each feature can define a <code>Weight</code> or implement <code>Weighted</code> to order features according to their weight. Higher weighted features are registered first.</p>

</li>
<li>
<p>This is to allow ordering of features in a meaningful way (e.g. Context should be first, Tracing second, Security third etc).</p>

</li>
</ul>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.0/microprofile-metrics-spec-5.0.0.pdf">MicroProfile Metrics Specification</a></p>

</li>
<li>
<p><router-link to="/se/metrics/metrics">Metrics</router-link> documentation.</p>

</li>
<li>
<p><router-link to="/se/health">Health</router-link> documentation.</p>

</li>
</ul>

</div>

</doc-view>
