<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#Local-Testing" @click.native="this.scrollFix('#Local-Testing')">Local Testing</router-link></p>

</li>
<li>
<p><router-link to="#_references" @click.native="this.scrollFix('#_references')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>HashiCorp Vault is a commonly used Vault in many microservices. The APIs are REST-based and Helidon implements them using
<router-link to="/se/webclient">WebClient</router-link>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable HashiCorp Vault
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.vault&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-vault&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>The following is a list of maven coordinates of all Vault modules available:</p>

<markup
lang="xml"

>&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.auths&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-auths-token&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.auths&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-auths-approle&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.auths&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-auths-k8s&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.secrets&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-secrets-kv1&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.secrets&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-secrets-kv2&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.secrets&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-secrets-cubbyhole&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.secrets&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-secrets-transit&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.secrets&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-secrets-database&lt;/artifactId&gt;
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.integrations.vault.sys&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-integrations-vault-sys&lt;/artifactId&gt;
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Vault integration supports the following:</p>

<ul class="ulist">
<li>
<p><strong>Secret Engines</strong>: Key/Value version 2, Key/Value version 1, Cubbyhole, PKI, Transit, Database</p>

</li>
<li>
<p><strong>Authentication Methods</strong>: Token, Kubernetes (k8s), AppRole</p>

</li>
<li>
<p><strong>Other Sys Operations and Configurations</strong></p>

</li>
</ul>

<p>Each of these features is implemented as a separate module, with the Vault class binding them together. Code to set up Vault and obtain a specific secret engine:</p>

<markup
lang="java"

>Vault vault = Vault.builder()
        .config(config.get("vault"))
        .build();
Kv2Secrets secrets = vault.secrets(Kv2Secrets.ENGINE);</markup>

<p>Similar code can be used for any secret engine available:</p>

<ul class="ulist">
<li>
<p>Kv2SecretsRx - Key/Value Version 2 Secrets (versioned secrets, default)</p>

</li>
<li>
<p>Kv1SecretsRx - Key/Value Version 1 Secrets (unversioned secrets, legacy)</p>

</li>
<li>
<p>CubbyholeSecretsRx - Cubbyhole secrets (token bound secrets)</p>

</li>
<li>
<p>DbSecretsRx - Database secrets (for generating temporary DB credentials)</p>

</li>
<li>
<p>PkiSecretsRx - PKI secrets (for generating keys and X.509 certificates)</p>

</li>
<li>
<p>TransitSecretsRx - Transit operations (encryption, signatures, HMAC)</p>

</li>
</ul>

<p>In addition to these features, Vault itself can be authenticated as follows:</p>

<ul class="ulist">
<li>
<p>Token authentication - token is configured when connecting to Vault</p>

</li>
</ul>

<div class="listing">
<pre>vault:
   address: "http://localhost:8200"
   token: "my-token"</pre>
</div>

<ul class="ulist">
<li>
<p>AppRole authentication - AppRole ID and secret ID are configured, integration exchanges these for a temporary token that is used to connect to Vault</p>

</li>
</ul>

<div class="listing">
<pre>vault:
  auth:
    app-role:
      role-id: "app-role-id"
      secret-id: app-role-secret-id</pre>
</div>

<ul class="ulist">
<li>
<p>K8s authentication - the k8s JWT token is discovered on current node and used to obtain a temporary token that is used to connect to Vault</p>

</li>
</ul>

<div class="listing">
<pre>vault:
  auth:
    k8s:
      token-role: "my-role" <span class="conum" data-value="1" /></pre>
</div>

<ul class="colist">
<li data-value="1">The token role must be configured in Vault
Minimal configuration to connect to Vault:</li>
</ul>

<p>Code to get the Sys operations of Vault:</p>

<markup
lang="java"

>Sys sys = vault.sys(Sys.API);</markup>


<h3 id="_extensibility">Extensibility</h3>
<div class="section">
<p>New secret engines and authentication methods can be implemented quite easily, as the integration is based on service providers (using ServiceLoader). This gives us (or you, as the users) the option to add new secret engines and/or authentication methods without adding a plethora of methods to the Vault class.</p>

<p>See the following SPIs:</p>

<markup
lang="text"

>io.helidon.integrations.vault.spi.AuthMethodProvider
io.helidon.integrations.vault.spi.SecretsEngineProvider
io.helidon.integrations.vault.spi.SysProvider
io.helidon.integrations.vault.spi.VaultAuth
io.helidon.integrations.vault.spi.InjectionProvider</markup>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>The following example shows usage of Vault to encrypt a secret.</p>


<h3 id="_usage_with_webserver">Usage with WebServer</h3>
<div class="section">
<p>Configure the <code>Vault</code> object using token base configuration:</p>

<markup
lang="java"

>Vault tokenVault = Vault.builder()
        .config(config.get("vault.token"))
        .updateWebClient(it -&gt; it
                .connectTimeout(Duration.ofSeconds(5))
                .readTimeout(Duration.ofSeconds(5)))
        .build();</markup>

<p>Then <code>WebServer</code> has to be configured with endpoints routing registered:</p>

<markup
lang="java"

>Sys sys = tokenVault.sys(Sys.API);
WebServer webServer = WebServer.builder()
        .config(config.get("server"))
        .routing(routing -&gt; routing
                .register("/cubbyhole", new CubbyholeService(sys, tokenVault.secrets(CubbyholeSecrets.ENGINE)))
                .register("/kv1", new Kv1Service(sys, tokenVault.secrets(Kv1Secrets.ENGINE)))
                .register("/kv2", new Kv2Service(sys, tokenVault.secrets(Kv2Secrets.ENGINE)))
                .register("/transit", new TransitService(sys, tokenVault.secrets(TransitSecrets.ENGINE))))
        .build()
        .start();</markup>

<p>AppRole-based and Kubernetes authentications are available.</p>

</div>


<h3 id="_cubbyhole_secrets">Cubbyhole secrets</h3>
<div class="section">
<p>Cubbyhole secrets engine operations:</p>

<markup
lang="java"

>@Override
public void routing(HttpRules rules) {
    rules.get("/create", this::createSecrets)
            .get("/secrets/{path:.*}", this::getSecret);
}

void createSecrets(ServerRequest req, ServerResponse res) { <span class="conum" data-value="1" />
    secrets.create("first/secret", Map.of("key", "secretValue"));
    res.send("Created secret on path /first/secret");
}

void getSecret(ServerRequest req, ServerResponse res) { <span class="conum" data-value="2" />
    String path = req.path().pathParameters().get("path");
    Optional&lt;Secret&gt; secret = secrets.get(path);
    if (secret.isPresent()) {
        // using toString so we do not need to depend on JSON-B
        res.send(secret.get().values().toString());
    } else {
        res.status(Status.NOT_FOUND_404);
        res.send();
    }
}</markup>

<ul class="colist">
<li data-value="1">Create a secret from request entity.</li>
<li data-value="2">Get the secret on a specified path.</li>
</ul>

</div>


<h3 id="_kv1_secrets">KV1 Secrets</h3>
<div class="section">
<p>Key/Value version 1 secrets engine operations:</p>

<markup
lang="java"

>@Override
public void routing(HttpRules rules) {
    rules.get("/enable", this::enableEngine)
            .get("/create", this::createSecrets)
            .get("/secrets/{path:.*}", this::getSecret)
            .delete("/secrets/{path:.*}", this::deleteSecret)
            .get("/disable", this::disableEngine);
}

void disableEngine(ServerRequest req, ServerResponse res) { <span class="conum" data-value="1" />
    sys.disableEngine(Kv1Secrets.ENGINE);
    res.send("KV1 Secret engine disabled");
}

void enableEngine(ServerRequest req, ServerResponse res) { <span class="conum" data-value="2" />
    sys.enableEngine(Kv1Secrets.ENGINE);
    res.send("KV1 Secret engine enabled");
}

void createSecrets(ServerRequest req, ServerResponse res) { <span class="conum" data-value="3" />
    secrets.create("first/secret", Map.of("key", "secretValue"));
    res.send("Created secret on path /first/secret");
}

void deleteSecret(ServerRequest req, ServerResponse res) { <span class="conum" data-value="4" />
    String path = req.path().pathParameters().get("path");
    secrets.delete(path);
    res.send("Deleted secret on path " + path);
}

void getSecret(ServerRequest req, ServerResponse res) { <span class="conum" data-value="5" />
    String path = req.path().pathParameters().get("path");

    Optional&lt;Secret&gt; secret = secrets.get(path);
    if (secret.isPresent()) {
        // using toString so we do not need to depend on JSON-B
        res.send(secret.get().values().toString());
    } else {
        res.status(Status.NOT_FOUND_404);
        res.send();
    }
}</markup>

<ul class="colist">
<li data-value="1">Disable the secrets engine on the default path.</li>
<li data-value="2">Enable the secrets engine on the default path.</li>
<li data-value="3">Create a secret from request entity.</li>
<li data-value="4">Delete the secret on a specified path.</li>
<li data-value="5">Get the secret on a specified path.</li>
</ul>

</div>


<h3 id="_kv2_secrets">KV2 Secrets</h3>
<div class="section">
<p>Key/Value version 2 secrets engine operations:</p>

<markup
lang="java"

>@Override
public void routing(HttpRules rules) {
    rules.get("/create", this::createSecrets)
            .get("/secrets/{path:.*}", this::getSecret)
            .delete("/secrets/{path:.*}", this::deleteSecret);
}

void createSecrets(ServerRequest req, ServerResponse res) { <span class="conum" data-value="1" />
    secrets.create("first/secret", Map.of("key", "secretValue"));
    res.send("Created secret on path /first/secret");
}

void deleteSecret(ServerRequest req, ServerResponse res) { <span class="conum" data-value="2" />
    String path = req.path().pathParameters().get("path");
    secrets.deleteAll(path);
    res.send("Deleted secret on path " + path);
}

void getSecret(ServerRequest req, ServerResponse res) { <span class="conum" data-value="3" />
    String path = req.path().pathParameters().get("path");

    Optional&lt;Kv2Secret&gt; secret = secrets.get(path);
    if (secret.isPresent()) {
        // using toString so we do not need to depend on JSON-B
        Kv2Secret kv2Secret = secret.get();
        res.send("Version " + kv2Secret.metadata().version() + ", secret: " + kv2Secret.values().toString());
    } else {
        res.status(Status.NOT_FOUND_404);
        res.send();
    }
}</markup>

<ul class="colist">
<li data-value="1">Create a secret from request entity.</li>
<li data-value="2">Delete the secret on a specified path.</li>
<li data-value="3">Get the secret on a specified path.</li>
</ul>

</div>


<h3 id="_transit_secrets">Transit secrets</h3>
<div class="section">
<p>Transit secrets engine operations:</p>

<markup
lang="java"

>@Override
public void routing(HttpRules rules) {
    rules.get("/enable", this::enableEngine)
            .get("/keys", this::createKeys)
            .delete("/keys", this::deleteKeys)
            .get("/batch", this::batch)
            .get("/encrypt/{text:.*}", this::encryptSecret)
            .get("/decrypt/{text:.*}", this::decryptSecret)
            .get("/sign", this::sign)
            .get("/hmac", this::hmac)
            .get("/verify/sign/{text:.*}", this::verify)
            .get("/verify/hmac/{text:.*}", this::verifyHmac)
            .get("/disable", this::disableEngine);
}

void enableEngine(ServerRequest req, ServerResponse res) { <span class="conum" data-value="1" />
    sys.enableEngine(TransitSecrets.ENGINE);
    res.send("Transit Secret engine enabled");
}

void disableEngine(ServerRequest req, ServerResponse res) { <span class="conum" data-value="2" />
    sys.disableEngine(TransitSecrets.ENGINE);
    res.send("Transit Secret engine disabled");
}

void createKeys(ServerRequest req, ServerResponse res) { <span class="conum" data-value="3" />
    CreateKey.Request request = CreateKey.Request.builder()
            .name(ENCRYPTION_KEY);

    secrets.createKey(request);
    secrets.createKey(CreateKey.Request.builder()
                              .name(SIGNATURE_KEY)
                              .type("rsa-2048"));

    res.send("Created keys");
}

void deleteKeys(ServerRequest req, ServerResponse res) { <span class="conum" data-value="4" />
    secrets.updateKeyConfig(UpdateKeyConfig.Request.builder()
                                    .name(ENCRYPTION_KEY)
                                    .allowDeletion(true));
    System.out.println("Updated key config");

    secrets.deleteKey(DeleteKey.Request.create(ENCRYPTION_KEY));

    res.send("Deleted key.");
}

void encryptSecret(ServerRequest req, ServerResponse res) { <span class="conum" data-value="5" />
    String secret = req.path().pathParameters().get("text");

    Encrypt.Response encryptResponse = secrets.encrypt(Encrypt.Request.builder()
                                                               .encryptionKeyName(ENCRYPTION_KEY)
                                                               .data(Base64Value.create(secret)));

    res.send(encryptResponse.encrypted().cipherText());
}

void decryptSecret(ServerRequest req, ServerResponse res) { <span class="conum" data-value="6" />
    String encrypted = req.path().pathParameters().get("text");

    Decrypt.Response decryptResponse = secrets.decrypt(Decrypt.Request.builder()
                                                               .encryptionKeyName(ENCRYPTION_KEY)
                                                               .cipherText(encrypted));

    res.send(String.valueOf(decryptResponse.decrypted().toDecodedString()));
}

void hmac(ServerRequest req, ServerResponse res) { <span class="conum" data-value="7" />
    Hmac.Response hmacResponse = secrets.hmac(Hmac.Request.builder()
                                                      .hmacKeyName(ENCRYPTION_KEY)
                                                      .data(SECRET_STRING));

    res.send(hmacResponse.hmac());
}

void sign(ServerRequest req, ServerResponse res) { <span class="conum" data-value="8" />
    Sign.Response signResponse = secrets.sign(Sign.Request.builder()
                                                      .signatureKeyName(SIGNATURE_KEY)
                                                      .data(SECRET_STRING));

    res.send(signResponse.signature());
}

void verifyHmac(ServerRequest req, ServerResponse res) { <span class="conum" data-value="9" />
    String hmac = req.path().pathParameters().get("text");

    Verify.Response verifyResponse = secrets.verify(Verify.Request.builder()
                                                            .digestKeyName(ENCRYPTION_KEY)
                                                            .data(SECRET_STRING)
                                                            .hmac(hmac));

    res.send("Valid: " + verifyResponse.isValid());
}

void verify(ServerRequest req, ServerResponse res) { <span class="conum" data-value="10" />
    String signature = req.path().pathParameters().get("text");

    Verify.Response verifyResponse = secrets.verify(Verify.Request.builder()
                                                            .digestKeyName(SIGNATURE_KEY)
                                                            .data(SECRET_STRING)
                                                            .signature(signature));

    res.send("Valid: " + verifyResponse.isValid());
}</markup>

<ul class="colist">
<li data-value="1">Enable the secrets engine on the default path.</li>
<li data-value="2">Disable the secrets engine on the default path.</li>
<li data-value="3">Create the encryption and signature keys.</li>
<li data-value="4">Delete the encryption and signature keys.</li>
<li data-value="5">Encrypt a secret.</li>
<li data-value="6">Decrypt a secret.</li>
<li data-value="7">Create an HMAC for text.</li>
<li data-value="8">Create a signature for text.</li>
<li data-value="9">Verify HMAC.</li>
<li data-value="10">Verify signature.</li>
</ul>

</div>


<h3 id="_authentication_with_kubernetes">Authentication with Kubernetes</h3>
<div class="section">
<p>In order to use Kubernetes authentication:</p>

<markup
lang="java"

>class K8sExample {
    private static final String SECRET_PATH = "k8s/example/secret";
    private static final String POLICY_NAME = "k8s_policy";

    private final Vault tokenVault;
    private final String k8sAddress;
    private final Config config;
    private final Sys sys;

    private Vault k8sVault;

    K8sExample(Vault tokenVault, Config config) {
        this.tokenVault = tokenVault;
        this.sys = tokenVault.sys(Sys.API);
        this.k8sAddress = config.get("cluster-address").asString().get();
        this.config = config;
    }

    public String run() { <span class="conum" data-value="1" />
        // The following tasks must be run before we authenticate
        enableK8sAuth();
        // Now we can login using k8s - must run within a k8s cluster
        // (or you need the k8s configuration files locally)
        workWithSecrets();
        // Now back to token based Vault, as we will clean up
        disableK8sAuth();
        return "k8s example finished successfully.";
    }

    private void workWithSecrets() { <span class="conum" data-value="2" />
        Kv2Secrets secrets = k8sVault.secrets(Kv2Secrets.ENGINE);

        secrets.create(SECRET_PATH, Map.of(
                "secret-key", "secretValue",
                "secret-user", "username"));

        Optional&lt;Kv2Secret&gt; secret = secrets.get(SECRET_PATH);
        if (secret.isPresent()) {
            Kv2Secret kv2Secret = secret.get();
            System.out.println("k8s first secret: " + kv2Secret.value("secret-key"));
            System.out.println("k8s second secret: " + kv2Secret.value("secret-user"));
        } else {
            System.out.println("k8s secret not found");
        }
        secrets.deleteAll(SECRET_PATH);
    }

    private void disableK8sAuth() { <span class="conum" data-value="3" />
        sys.deletePolicy(POLICY_NAME);
        sys.disableAuth(K8sAuth.AUTH_METHOD.defaultPath());
    }

    private void enableK8sAuth() { <span class="conum" data-value="4" />
        // enable the method
        sys.enableAuth(K8sAuth.AUTH_METHOD);
        sys.createPolicy(POLICY_NAME, VaultPolicy.POLICY);
        tokenVault.auth(K8sAuth.AUTH_METHOD)
                .configure(ConfigureK8s.Request.builder()
                                   .address(k8sAddress));
        tokenVault.auth(K8sAuth.AUTH_METHOD)
                // this must be the same role name as is defined in application.yaml
                .createRole(CreateRole.Request.builder()
                                    .roleName("my-role")
                                    .addBoundServiceAccountName("*")
                                    .addBoundServiceAccountNamespace("default")
                                    .addTokenPolicy(POLICY_NAME));
        k8sVault = Vault.create(config);
    }
}</markup>

<ul class="colist">
<li data-value="1">Run the Kubernetes Authentication by enabling it.</li>
<li data-value="2">Create Kubernetes secrets.</li>
<li data-value="3">Disable Kubernetes authentication if needed.</li>
<li data-value="4">Function used to enable Kubernetes authentication.</li>
</ul>

</div>

</div>


<h2 id="Local-Testing">Local testing</h2>
<div class="section">
<p>Vault is available as a docker image, so to test locally, you can simply:</p>

<markup
lang="bash"

>docker run -e VAULT_DEV_ROOT_TOKEN_ID=my-token -d --name=vault -p8200:8200 vault</markup>

<p>This will create a Vault docker image, run it in background and open it on <code>localhost:8200</code> with a custom root token my-token,
using name vault.
This is of course only suitable for local testing, as the root token has too many rights,
but it can be easily used with the examples below.</p>

</div>


<h2 id="_references">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.6/examples/integrations/vault">Hashicorp Vault Usage Examples</a></p>

</li>
</ul>

</div>

</doc-view>
