<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_grpc_server_routing" @click.native="this.scrollFix('#_grpc_server_routing')">gRPC Server Routing</router-link></p>

</li>
<li>
<p><router-link to="#_service_implementation" @click.native="this.scrollFix('#_service_implementation')">Service Implementation</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_configuring_the_grpc_server_in_the_code" @click.native="this.scrollFix('#_configuring_the_grpc_server_in_the_code')">Configuring the gRPC Server in the Code</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>gRPC scope is temporarily smaller in Helidon, please follow issue
<a target="_blank" href="https://github.com/helidon-io/helidon/issues/5418" class="bare">https://github.com/helidon-io/helidon/issues/5418</a>
As this is still work in progress, the WebServer gRPC module is release in preview mode, as we may introduce backward
incompatible changes to our APIs, so we can re-introduce features.</p>

<p>The Helidon gRPC server provides a framework for creating <a target="_blank" href="http://grpc.io/">gRPC</a> applications.
While it allows you to deploy any standard gRPC service that
implements <code>io.grpc.BindableService</code> interface, including services generated
from the Protobuf IDL files (and even allows you to customize them to a certain
extent), using Helidon gRPC framework to implement your services has a number of
benefits:</p>

<ul class="ulist">
<li>
<p>It allows you to define both HTTP and gRPC services using a similar programming
model, simplifying the learning curve for developers.</p>

</li>
<li>
<p>It provides a number of helper methods that make service implementation
significantly simpler.</p>

</li>
<li>
<p>It allows you to run gRPC and HTTP endpoints on the same WebServer, and even on the same port.</p>

</li>
</ul>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable gRPC Server
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-grpc&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_grpc_server_routing">gRPC Server Routing</h3>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_customizing_service_definitions" @click.native="this.scrollFix('#_customizing_service_definitions')">Customizing Service Definitions</router-link></p>

</li>
</ul>

<p>Unlike the HTTP server, which allows you to route requests based on path expression
and the HTTP verb, the gRPC server always routes requests based on the service and
method name. This makes routing configuration somewhat simpler&#8201;&#8212;&#8201;all you need
to do is register your services:</p>

<markup
lang="java"

>private static GrpcRouting.Builder createRouting(Config config) {
    return GrpcRouting.builder()
            .service(new GreetService(config)) <span class="conum" data-value="1" />
            .service(new EchoService())        <span class="conum" data-value="2" />
            .service(new MathService())        <span class="conum" data-value="3" />
            .unary(Strings.getDescriptor(),    <span class="conum" data-value="4" />
                   "StringService",
                   "Upper",
                   Main::grpcUpper);
}</markup>

<ul class="colist">
<li data-value="1">Register <code>GreetService</code> instance.</li>
<li data-value="2">Register <code>EchoService</code> instance.</li>
<li data-value="3">Register <code>MathService</code> instance.</li>
<li data-value="4">Register a custom unary gRPC route</li>
</ul>

<p>Both "standard" gRPC services that implement <code>io.grpc.BindableService</code> interface
(typically implemented by extending the generated server-side stub and overriding
its methods), and Helidon gRPC services that implement
<code>io.helidon.grpc.server.GrpcService</code> interface can be registered.
The difference is that Helidon gRPC services allow you to customize behavior
down to the method level, and provide a number of useful helper methods that
make service implementation easier, as we&#8217;ll see in a moment.</p>


<h4 id="_customizing_service_definitions">Customizing Service Definitions</h4>
<div class="section">
<p>When registering a service, regardless of its type, you can customize its
descriptor by providing an instance of <code>ServerServiceDefinition</code> to <code>service</code> method.</p>

</div>

</div>


<h3 id="_service_implementation">Service Implementation</h3>
<div class="section">

<h4 id="_implementing_protobuf_services">Implementing Protobuf Services</h4>
<div class="section">
<p>In order to implement Protobuf-based service, you would follow the official
<a target="_blank" href="https://grpc.io/docs/quickstart/java.html">instructions</a> on the gRPC
website, which boil down to the following:</p>


<h5 id="_define_the_service_idl">Define the Service IDL</h5>
<div class="section">
<p>For this example, we will re-implement the <code>EchoService</code> above as a Protobuf
service in <code>echo.proto</code> file.</p>

<markup
lang="proto"

>syntax = "proto3";
option java_package = "org.example.services.echo";

service EchoService {
  rpc Echo (EchoRequest) returns (EchoResponse) {}
}

message EchoRequest {
  string message = 1;
}

message EchoResponse {
  string message = 1;
}</markup>

<p>Based on this IDL, the gRPC compiler will generate message classes (<code>EchoRequest</code>
and <code>EchoResponse</code>), client stubs that can be used to make RPC calls to the server,
as well as the base class for the server-side service implementation.</p>

<p>We can ignore the last one, and implement the service using Helidon gRPC framework
instead.</p>

</div>


<h5 id="_implement_the_service">Implement the Service</h5>
<div class="section">
<p>The service implementation will be very similar to our original implementation:</p>

<markup
lang="java"

>class EchoService implements GrpcService {
    @Override
    public Descriptors.FileDescriptor proto() {
        return Echo.getDescriptor(); <span class="conum" data-value="1" />
    }

    @Override
    public void update(Routing routing) {
        routing.unary("Echo", this::echo); <span class="conum" data-value="2" />
    }

    /**
     * Echo the message back to the caller.
     *
     * @param request  the echo request containing the message to echo
     * @param observer the response observer
     */
    public void echo(Echo.EchoRequest request, StreamObserver&lt;Echo.EchoResponse&gt; observer) {  <span class="conum" data-value="3" />
        String message = request.getMessage();  <span class="conum" data-value="4" />
        Echo.EchoResponse response = Echo.EchoResponse.newBuilder().setMessage(message).build();  <span class="conum" data-value="5" />
        complete(observer, response);  <span class="conum" data-value="6" />
    }
}</markup>

<ul class="colist">
<li data-value="1">Specify the proto descriptor in order to provide necessary type information and
enable Protobuf marshalling.</li>
<li data-value="2">Define unary method <code>Echo</code> and map it to the <code>this::echo</code> handler.</li>
<li data-value="3">Create a handler for the <code>Echo</code> method, using Protobuf message types for request and response.</li>
<li data-value="4">Extract message string from the request.</li>
<li data-value="5">Create the response containing extracted message.</li>
<li data-value="6">Send the response back to the client by completing response observer.</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">The <code>complete</code> method shown in the example above is just one of many helper
methods available in the <code>ResponseHelper</code> class. See the full list
<a target="_blank" href="/apidocs/io.helidon.webserver.grpc/io/helidon/webserver/grpc/ResponseHelper.html">here</a>.</p>
</div>

</div>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Configure the gRPC server using the Helidon configuration framework, either programmatically
or via a configuration file.</p>


<h3 id="_configuring_the_grpc_server_in_the_code">Configuring the gRPC Server in the Code</h3>
<div class="section">
<p>Currently, we do not have any custom configuration options for gRPC protocol.</p>

<p>To register a routing with Helidon WebServer, simply add the routing to the listener
(WebServer configuration is itself the default listener configuration)</p>

<markup
lang="java"

>WebServer.builder()
        .port(8080)
        .routing(httpRouting -&gt; httpRouting.get("/greet", (req, res) -&gt; res.send("Hi!"))) <span class="conum" data-value="1" />
        .addRouting(GrpcRouting.builder()  <span class="conum" data-value="2" />
                            .unary(Strings.getDescriptor(),
                                   "StringService",
                                   "Upper",
                                   Main::grpcUpper))
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Configure HTTP routing of the server</li>
<li data-value="2">Configure gRPC routing of the server</li>
</ul>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>The following gRPC examples for Helidon SE are available:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.6/examples/webserver/protocols">Multiple protocols on a single WebServer</a></p>

</li>
</ul>

</div>

</doc-view>
