<doc-view>

<h2 id="_content">Content</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#_maven_coordinates" @click.native="this.scrollFix('#_maven_coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon provides a MicroProfile server implementation (<code>io.helidon.microprofile.server.Server</code>) that encapsulates the Helidon WebServer.</p>

</div>


<h2 id="_maven_coordinates">Maven-Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Server add the helidon-microprofile-core bundle dependency to your project&#8217;s <code>pom.xml</code>
(see <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.bundles&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-core&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>MicroProfile Server is already included in the bundle.</p>

<p>If full control over the dependencies is required, and you want to minimize the quantity of the dependencies -
<code>Helidon MicroProfile Server</code> should be used. In this case the following dependencies should be included in your
project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.server&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-server&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Helidon Microprofile Server is used to collect and deploy JAX-RS application(s).
When starting Helidon MP, it is recommended to use the <code>io.helidon.Main</code> main class, which will take care of starting Helidon. CDI will then discover all extensions, including the Server extension and start it.</p>

<p>See the <router-link to="/mp/guides/quickstart">Helidon MP Quickstart example</router-link>. Note that the server lifecycle is bound to CDI.</p>

<p>Usage of the <code>io.helidon.microprofile.server.Server</code> API is discouraged, as Helidon MP uses convention to discover and configure features, which makes the applications easier to understand and maintain.</p>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The following table provides a brief description of routing annotations, including its parameters. More information
in <code>Configuring a WebServer route</code> section.</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 37.5%;">
<col style="width: 62.5%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@RoutingName(
    value = ""
    required = false
)</pre>
</div>

</doc-view>
</td>
<td class="">Binds a JAX-RS Application or Helidon Service to a specific (named) routing on <code>WebServer</code>.The routing should have
a corresponding named socket configured on the WebServer to run the routing on.</td>
</tr>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@RoutingPath("/path")</pre>
</div>

</doc-view>
</td>
<td class="">Path of a Helidon Service to register with routing.</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>By default, the server uses the MicroProfile Config, but you may also want to use <router-link to="/mp/config/introduction">Helidon configuration</router-link>.</p>

<p>In this example, the configuration is in a file, and it includes Helidon configuration options.</p>

<p>Configuration reference:</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/WebServer.html">io.helidon.webserver.WebServer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>server</code></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backlog</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>Accept backlog.</p>

<pre>@return backlog</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_ConnectionConfig">ConnectionConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of a connection (established from client against our server).</p>

<pre>@return connection configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-options</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_socket_SocketOptions">SocketOptions</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Options for connections accepted by this listener.
 This is not used to setup server connection.</p>

<pre>@return socket options</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>content-encoding</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_encoding_ContentEncodingContext">ContentEncodingContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.encoding.ContentEncodingContext.
 This method discards all previously registered ContentEncodingContext.
 If no content encoding context is registered, content encoding context of the webserver would be used.</p>

<pre>@return content encoding context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>features</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.spi.ServerFeature[&#93; (service provider interface)</p>

<p>Such as:</p>

<ul class="ulist">
<li>
<p><router-link to="/config/io_helidon_webserver_observe_ObserveFeature">observe (ObserveFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_context_ContextFeature">context (ContextFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_cors_CorsFeature">cors (CorsFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_security_SecurityFeature">security (SecurityFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_accesslog_AccessLogFeature">access-log (AccessLogFeature)</router-link></p>

</li>
</ul>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Server features allow customization of the server, listeners, or routings.</p>

<pre>@return server features</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>0.0.0.0</code></td>
<td class=""><doc-view>
<p>Host of the default socket. Defaults to all host addresses (<code>0.0.0.0</code>).</p>

<pre>@return host address to listen on (for the default socket)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idle-connection-period</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT2M</code></td>
<td class=""><doc-view>
<p>How often should we check for #idleConnectionTimeout().
 Defaults to <code>PT2M</code> (2 minutes).</p>

<pre>@return period of checking for idle connections</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idle-connection-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5M</code></td>
<td class=""><doc-view>
<p>How long should we wait before closing a connection that has no traffic on it.
 Defaults to <code>PT5M</code> (5 minutes). Note that the timestamp is refreshed max. once per second, so this setting
 would be useless if configured for shorter periods of time (also not a very good support for connection keep alive,
 if the connections are killed so soon anyway).</p>

<pre>@return timeout of idle connections</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-concurrent-requests</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Limits the number of requests that can be executed at the same time (the number of active virtual threads of requests).
 Defaults to <code>-1</code>, meaning "unlimited" - what the system allows.
 Also make sure that this number is higher than the expected time it takes to handle a single request in your application,
 as otherwise you may stop in-progress requests.</p>

<pre>@return number of requests that can be processed on this listener, regardless of protocol</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-in-memory-entity</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>131072</code></td>
<td class=""><doc-view>
<p>If the entity is expected to be smaller that this number of bytes, it would be buffered in memory to optimize
 performance when writing it.
 If bigger, streaming will be used.</p>

<pre>Note that for some entity types we cannot use streaming, as they are already fully in memory (String, byte[]), for such
cases, this option is ignored.</pre>
<pre>Default is 128Kb.</pre>
<pre>@return maximal number of bytes to buffer in memory for supported writers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-payload-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Maximal number of bytes an entity may have.
 If io.helidon.http.HeaderNames#CONTENT_LENGTH is used, this is checked immediately,
 if io.helidon.http.HeaderValues#TRANSFER_ENCODING_CHUNKED is used, we will fail when the
 number of bytes read would exceed the max payload size.
 Defaults to unlimited (<code>-1</code>).</p>

<pre>@return maximal number of bytes of entity</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-tcp-connections</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Limits the number of connections that can be opened at a single point in time.
 Defaults to <code>-1</code>, meaning "unlimited" - what the system allows.</p>

<pre>@return number of TCP connections that can be opened to this listener, regardless of protocol</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-context</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_media_MediaContext">MediaContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.media.MediaContext.
 This method discards all previously registered MediaContext.
 If no media context is registered, media context of the webserver would be used.</p>

<pre>@return media context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>
<p>Name of this socket. Defaults to <code>@default</code>.
 Must be defined if more than one socket is needed.</p>

<pre>@return name of the socket</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Port of the default socket.
 If configured to <code>0</code> (the default), server starts on a random port.</p>

<pre>@return port to listen on (for the default socket)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocols</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.spi.ProtocolConfig[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of protocols. This may be either protocol selectors, or protocol upgraders from HTTP/1.1.
 As the order is not important (providers are ordered by weight by default), we can use a configuration as an object,
 such as:
 &lt;pre&gt;
 protocols:
   providers:
     http_1_1:
       max-prologue-length: 8192
     http_2:
       max-frame-size: 4096
     websocket:
       &#8230;&#8203;.
 &lt;/pre&gt;</p>

<pre>@return all defined protocol configurations, loaded from service loader by default</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Listener receive buffer size.</p>

<pre>@return buffer size in bytes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>shutdown-grace-period</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.5S</code></td>
<td class=""><doc-view>
<p>Grace period in ISO 8601 duration format to allow running tasks to complete before listener&#8217;s shutdown.
 Default is <code>500</code> milliseconds.
Configuration file values example: <code>PT0.5S</code>, <code>PT2S</code>.</p>

<pre>@return grace period</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>shutdown-hook</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When true the webserver registers a shutdown hook with the JVM Runtime.</p>

<pre>Defaults to true. Set this to false such that a shutdown hook is not registered.</pre>
<pre>@return whether to register a shutdown hook</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_ListenerConfig">Map&lt;string, ListenerConfig&gt;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Socket configurations.
 Note that socket named <code>WebServer#DEFAULT_SOCKET_NAME</code> cannot be used,
 configure the values on the server directly.</p>

<pre>@return map of listener configurations, except for the default one</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_tls_Tls">Tls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Listener TLS configuration.</p>

<pre>@return tls of this configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>write-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Initial buffer size in bytes of java.io.BufferedOutputStream created internally to
 write data to a socket connection. Default is <code>512</code>.</p>

<pre>@return initial buffer size used for writing</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>write-queue-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Number of buffers queued for write operations.</p>

<pre>@return maximal number of queued writes, defaults to 0</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">

<h3 id="_access_log">Access Log</h3>
<div class="section">
<p>Access logging in Helidon is done by a dedicated module that can be
added to Maven and configured.</p>

<p>To enable Access logging add the following dependency to project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-access-log&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_configuring_access_log_in_a_configuration_file">Configuring Access Log in a configuration file</h3>
<div class="section">
<p>Access log can be configured as follows:</p>

<markup
lang="properties"
title="Access Log configuration file"
>server.port=8080
server.host=0.0.0.0
server.features.access-log.format=helidon</markup>

</div>

</div>


<h2 id="_accesslogfeature_webserver_accesslog_configuration">AccessLogFeature (webserver.accesslog) Configuration</h2>
<div class="section">
<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.accesslog/io/helidon/webserver/accesslog/AccessLogFeature.html">io.helidon.webserver.accesslog.AccessLogFeature</a></p>

<markup
lang="text"
title="Config key"
>access-log</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ServerFeatureProvider</code></p>

</li>
</ul>


<h3 id="_configuration_options_2">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether this feature will be enabled.</p>

<pre>@return whether enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>format</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The format for log entries (similar to the Apache <code>LogFormat</code>).
 &lt;table class="config"&gt;
     &lt;caption&gt;Log format elements&lt;/caption&gt;
     &lt;tr&gt;
         &lt;td&gt;%h&lt;/td&gt;
         &lt;td&gt;IP address of the remote host&lt;/td&gt;
         &lt;td&gt;HostLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%l&lt;/td&gt;
         &lt;td&gt;The client identity. This is always undefined in Helidon.&lt;/td&gt;
         &lt;td&gt;UserIdLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%u&lt;/td&gt;
         &lt;td&gt;User ID as asserted by Helidon Security.&lt;/td&gt;
         &lt;td&gt;UserLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%t&lt;/td&gt;
         &lt;td&gt;The timestamp&lt;/td&gt;
         &lt;td&gt;TimestampLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%r&lt;/td&gt;
         &lt;td&gt;The request line (<code>"GET /favicon.ico HTTP/1.0"</code>)&lt;/td&gt;
         &lt;td&gt;RequestLineLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%s&lt;/td&gt;
         &lt;td&gt;The status code returned to the client&lt;/td&gt;
         &lt;td&gt;StatusLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%b&lt;/td&gt;
         &lt;td&gt;The entity size in bytes&lt;/td&gt;
         &lt;td&gt;SizeLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%D&lt;/td&gt;
         &lt;td&gt;The time taken in microseconds (start of request until last byte written)&lt;/td&gt;
         &lt;td&gt;TimeTakenLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%T&lt;/td&gt;
         &lt;td&gt;The time taken in seconds (start of request until last byte written), integer&lt;/td&gt;
         &lt;td&gt;TimeTakenLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%{header-name}i&lt;/td&gt;
         &lt;td&gt;Value of header <code>header-name</code>&lt;/td&gt;
         &lt;td&gt;HeaderLogEntry&lt;/td&gt;
     &lt;/tr&gt;
 &lt;/table&gt;</p>

<pre>@return format string, such as `%h %l %u %t %r %b %{Referer`i}</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>logger-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>io.helidon.webserver.AccessLog</code></td>
<td class=""><doc-view>
<p>Name of the logger used to obtain access log logger from System#getLogger(String).
 Defaults to <code>AccessLogFeature#DEFAULT_LOGGER_NAME</code>.</p>

<pre>@return name of the logger to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of sockets to register this feature on. If empty, it would get registered on all sockets.
 The logger used will have the expected logger with a suffix of the socket name.</p>

<pre>@return socket names to register on, defaults to empty (all available sockets)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>1000.0</code></td>
<td class=""><doc-view>
<p>Weight of the access log feature. We need to log access for anything happening on the server, so weight is high:
 <code>io.helidon.webserver.accesslog.AccessLogFeature#WEIGHT</code>.</p>

<pre>@return weight of the feature</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_configuring_tls">Configuring TLS</h3>
<div class="section">
<p>Helidon MP also supports custom TLS configuration.</p>

<p>You can set the following properties:</p>

<ul class="ulist">
<li>
<p>Server truststore</p>
<ul class="ulist">
<li>
<p>Keystore with trusted certificates</p>

</li>
</ul>

</li>
<li>
<p>Private key and certificate</p>
<ul class="ulist">
<li>
<p>Server certificate which will be used in TLS handshake</p>

</li>
</ul>

</li>
</ul>

<markup
lang="properties"
title="META-INF/microprofile-config.properties - Server configuration"
>#Truststore setup
server.tls.trust.keystore.resource.resource-path=server.p12
server.tls.trust.keystore.passphrase=password
server.tls.trust.keystore.trust-store=true

#Keystore with private key and server certificate
server.tls.private-key.keystore.resource.resource-path=server.p12
server.tls.private-key.keystore.passphrase=password</markup>

<p>Or the same configuration done in application.yaml file.</p>

<markup
lang="yaml"
title="application.yaml - Server configuration"
>server:
  tls:
    #Truststore setup
    trust:
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "keystore.p12"
    #Keystore with private key and server certificate
    private-key:
      keystore:
        passphrase: "password"
        resource:
          resource-path: "keystore.p12"</markup>

</div>


<h3 id="conf-additional-ports">Configuring additional ports</h3>
<div class="section">
<p>Helidon MP can expose multiple ports, with the following limitations:</p>

<ul class="ulist">
<li>
<p>The default port is the port that serves your application (JAX-RS applications and resources)</p>

</li>
<li>
<p>Other ports (in this example we configure one "admin" port) can be assigned endpoints that are exposed by Helidon components,
currently supported by MP Health and MP Metrics</p>

</li>
</ul>

<p>For this example, we will use a <code>YAML</code> file:</p>

<ul class="ulist">
<li>
<p>The port <code>7011</code> is the default port and will serve your application</p>

</li>
<li>
<p>The port <code>8011</code> is named "admin" (this is an arbitrary name)</p>

</li>
<li>
<p>MP Metrics are configured to use the "admin" port through the <code>routing</code> configuration (reference is by name)</p>

</li>
<li>
<p>MP Health is configured the same way to reference the "admin" port</p>

</li>
</ul>

<markup
lang="yaml"
title="application.yaml - Server configuration"
>server:
  port: 7011
  host: "some.host"
  sockets:
    admin:
      port: 8011
      bind-address: "some.host"

metrics:
  routing: "admin"

health:
  routing: "admin"</markup>

</div>


<h3 id="_configuring_a_webserver_route">Configuring A WebServer Route [[</h3>
<div class="section">
<p>Helidon MP Server will pick up CDI beans that implement the <code>io.helidon.webserver.HttpService</code>
interface and configure them with the underlying WebServer.</p>

<p>This allows configuration of WebServer routes to run alongside a JAX-RS application.</p>

<p>The bean is expected to be either <code>ApplicationScoped</code> or <code>Dependent</code> and will be requested
only once during the boot of the <code>Server</code>.</p>

<p>The bean will support injection of <code>ApplicationScoped</code> and <code>Dependent</code> scoped beans.
You cannot inject <code>RequestScoped</code> beans. Please use WebServer features to handle request
related objects.</p>


<h4 id="_customizing_the_http_service">Customizing the HTTP service</h4>
<div class="section">
<p>The service can be customized using annotations and/or configuration to be</p>

<ul class="ulist">
<li>
<p>registered on a specific path</p>

</li>
<li>
<p>registered with a named routing</p>

</li>
</ul>

</div>


<h4 id="_assigning_an_http_service_to_named_ports">Assigning an HTTP service to named ports</h4>
<div class="section">
<p>Helidon has the concept of named routing. These correspond to the named ports
configured with WebServer.</p>

<p>You can assign an HTTP service to a named routing (and as a result to a named port) using
either an annotation or configuration (or both to override the value from annotation).</p>


<h5 id="annotation-routing-name">Annotation <code>@RoutingName</code></h5>
<div class="section">
<p>You can annotate a service bean with this annotation to assign it to a specific named routing,
that is (most likely) going to be bound to a specific port.</p>

<p>The annotation has two attributes:
- <code>value</code> that defines the routing name
- <code>required</code> to mark that the routing name MUST be configured in Helidon server</p>

<markup
lang="java"
title="<code>@RoutingName</code> example"
>@ApplicationScoped
@RoutingName(value = "admin", required = true)
@RoutingPath("/admin")
public class AdminService implements HttpService {
    @Override
    public void routing(HttpRules rules) {
        // ...
    }
}</markup>

<p>The example above will be bound to <code>admin</code> routing (and port) and will fail if such a port
is not configured.</p>

</div>


<h5 id="_configuration_override_of_routing_name">Configuration override of routing name</h5>
<div class="section">
<p>For each service bean you can define the routing name and its required flag by specifying a configuration
option <code>bean-class-name.routing-name.name</code> and <code>bean-class-name.routing-name.required</code>.
For service beans produced with producer method replace <code>bean-class-name</code> with <code>class-name.producer-method-name</code>.</p>

<p>Example (YAML) configuration for a service bean <code>io.helidon.examples.AdminService</code> that changes the
routing name to <code>management</code> and its required flag to <code>false</code>:</p>

<markup
lang="yaml"

>io.helidon.examples.AdminService:
  routing-name:
    name: "management"
    required: false</markup>

</div>

</div>


<h4 id="_configuring_an_http_service_path">Configuring an HTTP service path</h4>
<div class="section">
<p>Each service is registered on a path. If none is configured, then the service would be
configured on the root path.</p>

<p>You can configure service path using an annotation or configuration (or both to override value from annotation)</p>


<h5 id="_annotation_routingpath">Annotation <code>@RoutingPath</code></h5>
<div class="section">
<p>You can configure <code>@RoutingPath</code> to define the path a service is registered on.</p>

</div>


<h5 id="_configuration_override_of_routing_path">Configuration override of routing path</h5>
<div class="section">
<p>For each HTTP service class you can define the routing path by specifying a configuration
option <code>class-name.routing-path.path</code>. The <code>routing-path</code> configuration can be applied to Jax-RS application.
See <router-link to="/mp/jaxrs/jaxrs-applications">Jakarta REST Application</router-link> for more information.</p>

<p>Example (YAML) configuration for a class <code>io.helidon.example.AdminService</code> that changes the
routing path to <code>/management</code>:</p>

<markup
lang="yaml"

>io.helidon.examples.AdminService:
  routing-path:
    path: "/management"</markup>

</div>

</div>

</div>


<h3 id="_serving_static_content">Serving Static Content</h3>
<div class="section">
<markup
lang="properties"
title="META-INF/microprofile-config.properties - File system static content"
># Location of content on file system
server.static.path.location=/var/www/html
# default is index.html
server.static.path.welcome=resource.html
# static content path - default is "/"
# server.static.path.context=/static-file</markup>

<markup
lang="properties"
title="META-INF/microprofile-config.properties - Classpath static content"
># src/main/resources/WEB in your source tree
server.static.classpath.location=/WEB
# default is index.html
server.static.classpath.welcome=resource.html
# static content path - default is "/"
# server.static.classpath.context=/static-cp</markup>

</div>


<h3 id="_example_configuration_of_routing">Example configuration of routing</h3>
<div class="section">
<p>A full configuration example (YAML):</p>

<markup
lang="yaml"

>server:
  port: 8080
  sockets:
   management:
   port: 8090

io.helidon.examples.AdminApplication:
  routing-name:
    name: "management"
    required: true
  routing-path:
    path: "/management"</markup>

</div>


<h3 id="_using_requested_uri_discovery">Using Requested URI Discovery</h3>
<div class="section">
<p>Proxies and reverse proxies between an HTTP client and your Helidon application mask important information (for example <code>Host</code> header, originating IP address, protocol) about the request the client sent.
Fortunately, many of these intermediary network nodes set or update either the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Forwarded">standard HTTP <code>Forwarded</code> header</a> or the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For">non-standard <code>X-Forwarded-*</code> family of headers</a> to preserve information about the original client request.</p>

<p>Helidon&#8217;s requested URI discovery feature allows your application&#8212;&#8203;and Helidon itself&#8212;&#8203;to reconstruct information about the original request using the <code>Forwarded</code> header and the <code>X-Forwarded-*</code> family of headers.</p>

<p>When you prepare the connections in your server you can include the following optional requested URI discovery settings:</p>

<ul class="ulist">
<li>
<p>enabled or disabled</p>

</li>
<li>
<p>which type or types of requested URI discovery to use:</p>
<ul class="ulist">
<li>
<p><code>FORWARDED</code> - uses the <code>Forwarded</code> header</p>

</li>
<li>
<p><code>X_FORWARDED</code> - uses the <code>X-Forwarded-*</code> headers</p>

</li>
<li>
<p><code>HOST</code> - uses the <code>Host</code> header</p>

</li>
</ul>

</li>
<li>
<p>what intermediate nodes to trust</p>

</li>
</ul>

<p>When your application
receives a request
Helidon iterates through the discovery types you set up for the receiving connection, gathering information from the corresponding header(s) for that type.
If the request does not have the corresponding header(s), or your settings do not trust the intermediate nodes reflected in those headers, then Helidon tries the next discovery type you set up.
Helidon uses the <code>HOST</code> discovery type if you do not set up discovery yourself or if, for a particular request, it cannot assemble the request information using any discovery type you did set up for the socket.</p>


<h4 id="_setting_up_requested_uri_discovery">Setting Up Requested URI Discovery</h4>
<div class="section">
<p>You can
use configuration to set up the requested URI discovery behavior.</p>

<markup
lang="properties"
title="Configuring Request URI Discovery (properties format)"
>server.port=8080
server.requested-uri-discovery.types=FORWARDED,X_FORWARDED
server.requested-uri-discovery.trusted-proxies.allow.pattern=lb.*\\.mycorp\\.com
server.requested-uri-discovery.trusted-proxies.deny.exact=lbtest.mycorp.com</markup>

<p>This example might apply if <code>mycorp.com</code> had trusted load balancers named <code>lbxxx.mycorp.com</code> except for an untrusted test load balancer <code>lbtest.mycorp.com</code>.</p>

</div>


<h4 id="_obtaining_the_requested_uri_information">Obtaining the Requested URI Information</h4>
<div class="section">
<p>Helidon makes the requested URI information available as a property in the request context:</p>

<markup
lang="java"
title="Retrieving Requested URI Information"
>public class MyFilter implements ContainerRequestFilter {

    @Override
    public void filter(ContainerRequestContext requestContext) {
        UriInfo uriInfo = (UriInfo) requestContext.getProperty("io.helidon.jaxrs.requested-uri");
        // ...
    }
}</markup>

<p>See the <a target="_blank" href="/apidocs/io.helidon.common.uri/io/helidon/common/uri/UriInfo.html"><code>UriInfo</code></a> JavaDoc for more information.</p>

<div class="admonition note">
<p class="admonition-inline">The <code>requestContext.getUriInfo()</code> method returns the Jakarta RESTful web services <code>UriInfo</code> object, <em>not</em> the Helidon-provided requested URI information <code>UriInfo</code> record.</p>
</div>

</div>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.microprofile.server/module-summary.html">Helidon MicroProfile Server Javadoc</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.6/microprofile/server">Helidon MicroProfile Server on GitHub</a></p>

</li>
</ul>

</div>

</doc-view>
