<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_references" @click.native="this.scrollFix('#_references')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon MP OCI Integration provides easy access to Oracle Cloud Infrastructure using the OCI Java SDK.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable OCI Integration
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
     &lt;groupId&gt;io.helidon.integrations.oci.sdk&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-integrations-oci-sdk-cdi&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>When added to your application Helidon OCI SDK <a target="_blank" href="https://jakarta.ee/specifications/cdi/4.0/jakarta-cdi-spec-4.0.html#spi">CDI portable extension</a> provides support for
injecting <a target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/javasdk.htm">Oracle Cloud Infrastructure SDK Clients</a> in your Helidon MicroProfile application.</p>

<p>The extension also handles authenticating with OCI by automatically picking up OCI credentials from your environment.</p>


<h3 id="_configuring_the_helidon_oci_sdk_extension">Configuring the Helidon OCI SDK Extension</h3>
<div class="section">
<p>When you inject an OCI SDK Client object, the Helidon OCI SDK extension
configures and constructs the object for you. The configuration primarily
consists of initializing an OCI <code>AuthenticationDetailsProvider</code>. By default,
the extension will examine your environment and select the best
<code>AuthenticationDetailsProvider</code> and configure it for you.</p>

<p>This means if your environment is already set up to work with the OCI SDK or
the OCI command line, then it is very likely you do not need to do any additional
configuration of the extension. Just add it as a dependency, and it will self-configure.</p>

<p>If for some reason you require full control over the OCI configuration you have
that as well. For more information concerning the extension and its configuration
and authentication options see the
<a target="_blank" href="/apidocs/io.helidon.integrations.oci.sdk.cdi/io/helidon/integrations/oci/sdk/cdi/OciExtension.html">OciExtension</a>
javadocs. In particular the <code>oci.auth-strategies</code> property lets you control which
<code>AuthenticationDetailsProvider</code> will be used.</p>

</div>


<h3 id="_accessing_oci_services">Accessing OCI Services</h3>
<div class="section">
<p>Since the Helidon OCI SDK extension supports injecting any OCI client
from the OCI SDK, you can use it to access any OCI service supported by the
OCI SDK. In addition to adding the Helidon OCI SDK Extension dependency
(as described above) you will need to add dependencies for the specific
ODI SDK clients you will use.</p>

<p>You will also need to configure your environment to authenticate with OCI.
It is recommended that you do this first, and verify your configuration
by using the <a target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/javasdk.htm">OCI CLI</a> to access the service.</p>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>This example describes how to use Helidon OCI SDK Extension to access OCI Object Storage.</p>

<p>As mentioned above in <router-link to="#_accessing_oci_services" @click.native="this.scrollFix('#_accessing_oci_services')"></router-link>, you need to add a dependency on the OCI SDK
Object Storage API:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;com.oracle.oci.sdk&lt;/groupId&gt;
    &lt;artifactId&gt;oci-java-sdk-objectstorage&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h3 id="_injecting_an_object_storage_client">Injecting an Object Storage Client</h3>
<div class="section">
<p>Now you can inject OCI SDK Clients.</p>

<markup
lang="java"
title="Field-injection example"
>@Inject
private ObjectStorage client;</markup>

<markup
lang="java"
title="Constructor-injection example"
>public class MyClass {

    private final ObjectStorage client;

    @Inject
    public MyClass(@Named("orders") ObjectStorage client) {
        this.client = client;
    }
}</markup>

<p>The extension implements this injection point by creating an Object Storage client
object in the <a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/apidocs/jakarta/inject/Singleton.html">singleton scope</a>.</p>

</div>


<h3 id="_using_the_object_storage_client">Using the Object Storage client</h3>
<div class="section">
<p>Once you have injected an ObjectStorage client you can use it as described in:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://docs.oracle.com/en-us/iaas/tools/java/latest/com/oracle/bmc/objectstorage/package-summary.html">OCI SDK Object Storage Javadocs</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/Object/Concepts/objectstorageoverview.htm">OCI Object Storage Overview</a></p>

</li>
</ul>

</div>

</div>


<h2 id="_references">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.integrations.oci.sdk.cdi/io/helidon/integrations/oci/sdk/cdi/OciExtension.html">OciExtension</a> Javadocs</p>

</li>
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.6/examples/integrations/oci">OCI SDK Usage Examples</a></p>

</li>
</ul>

</div>

</doc-view>
