<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>TracingObserver (webserver.observe.tracing) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.observe.tracing/io/helidon/webserver/observe/tracing/TracingObserver.html">io.helidon.webserver.observe.tracing.TracingObserver</a></p>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.observe.spi.ObserveProvider</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>env-config</code></td>
<td class=""><doc-view>
<p>TracingConfig</p>

</doc-view>
</td>
<td class=""><code>TracingConfig.ENABLED</code></td>
<td class=""><doc-view>
<p>Use the provided configuration as a default for any request.</p>

<pre>@return default web server tracing configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>path-configs</code></td>
<td class=""><doc-view>
<p>PathTracingConfig[&#93;</p>

</doc-view>
</td>
<td class=""><code>new @java.util.ArrayList@(@java.util.List@.of(PathTracingConfig.builder()
.path(&quot;/metrics/<strong>&quot;)
.tracingConfig(TracingConfig.DISABLED)
.build(), PathTracingConfig.builder()
.path(&quot;/health/</strong>&quot;)
.tracingConfig(TracingConfig.DISABLED)
.build(), PathTracingConfig.builder()
.path(&quot;/openapi/*&quot;)
.tracingConfig(TracingConfig.DISABLED)
.build()))</code></td>
<td class=""><doc-view>
<p>Path specific configuration of tracing.</p>

<pre>@return configuration of tracing for specific paths</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>900.0</code></td>
<td class=""><doc-view>
<p>Weight of the feature registered with WebServer.
 Changing weight may cause tracing to be executed at a different time (such as after security, or even after
 all routes). Please understand feature weights before changing this order.</p>

<pre>@return weight of tracing feature</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
