<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuring_the_webclient" @click.native="this.scrollFix('#_configuring_the_webclient')">Configuring the WebClient</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>WebClient is an HTTP client for Helidon SE. It can be used to send requests and retrieve corresponding responses in a programmatic way.</p>

<p>Helidon WebClient provides the following features:</p>

<ul class="ulist">
<li>
<p><strong>Blocking approach</strong><br>

The Webclient uses the blocking approach to synchronously process a request and its correspond response. Both <code>HTTP/1.1</code> and <code>HTTP/2</code> request and response will run in the thread of the user. Additionally, for <code>HTTP/2</code>, virtual thread is employed to manage the connection.</p>

</li>
<li>
<p><strong>Builder-like setup and execution</strong><br>

Creates every client and request as a builder pattern. This improves readability and code maintenance.</p>

</li>
<li>
<p><strong>Redirect chain</strong><br>

Follows the redirect chain and perform requests on the correct endpoint by itself.</p>

</li>
<li>
<p><strong>Tracing and security propagation</strong><br>

Automatically propagates the configured tracing and security settings of the Helidon WebServer to the WebClient and uses them during request and response.</p>

</li>
</ul>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable WebClient
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>The <code>helidon-webclient</code> dependency has built-in support for <code>HTTP/1.1</code>.</p>

<p>If support for <code>HTTP/2</code> is a requirement, below dependency needs to be added:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-http2&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_instantiating_the_webclient">Instantiating the WebClient</h3>
<div class="section">
<p>You can create an instance of a WebClient by executing <code>WebClient.create()</code> which will have default settings and without a base uri set.</p>

<p>To change the default settings and register
additional services, you can use simple builder that allows you to customize the client behavior.</p>

<markup
lang="java"
title="Create a WebClient with simple builder:"
>WebClient client = WebClient.builder()
        .baseUri("http://localhost")
        .build();</markup>

</div>


<h3 id="_creating_the_request">Creating the Request</h3>
<div class="section">
<p>WebClient offers a set of request methods that are used to specify the type of action to be performed on a given resource. Below are some examples of request methods:</p>

<ul class="ulist">
<li>
<p><code>get()</code></p>

</li>
<li>
<p><code>post()</code></p>

</li>
<li>
<p><code>put()</code></p>

</li>
<li>
<p><code>method(String methodName)</code></p>

</li>
</ul>

<p>Check out <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/HttpClient.html">HttpClient</a> API to learn more about request methods. These methods will create a new instance of <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/HttpClientRequest.html">HttpClientRequest</a> which can then be configured to add optional settings that will customize the behavior of the request.</p>

</div>


<h3 id="_customizing_the_request">Customizing the Request</h3>
<div class="section">
<p>Configuration can be set for every request type before it is sent. Below are some examples of the optional parameters.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Parameter</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>uri("http://example.com")</code></td>
<td class="">Overrides baseUri from WebClient</td>
</tr>
<tr>
<td class=""><code>path("/path")</code></td>
<td class="">Adds path to the uri</td>
</tr>
<tr>
<td class=""><code>queryParam("query", "parameter")</code></td>
<td class="">Adds query parameter to the request</td>
</tr>
<tr>
<td class=""><code>fragment("someFragment")</code></td>
<td class="">Adds fragment to the request</td>
</tr>
<tr>
<td class=""><code>headers(headers &#8594; headers.addAccept(MediaType.APPLICATION_JSON))</code></td>
<td class="">Adds header to the request</td>
</tr>
</tbody>
</table>
</div>

<p>For more information about these optional parameters, check out <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/ClientRequestBase.html">ClientRequestBase</a> API, which is a parent class of <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/HttpClientRequest.html">HttpClientRequest</a>.</p>

<p><a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/HttpClientRequest.html">HttpClientRequest</a> class also provides specific header methods that help the user to set a particular header. Some examples of these are:</p>

<ul class="ulist">
<li>
<p><code>contentType</code> (MediaType contentType)</p>

</li>
<li>
<p><code>accept</code> (MediaType&#8230;&#8203; mediaTypes)</p>

</li>
</ul>

<p>For more information about these methods, check out  <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/ClientRequest.html">ClientRequest</a> API, which is a parent class of <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/HttpClientRequest.html">HttpClientRequest</a>.</p>

</div>


<h3 id="_sending_the_request">Sending the Request</h3>
<div class="section">
<p>Once the request setup is completed, the following methods can be used to send it:</p>

<ul class="ulist">
<li>
<p><code>HttpClientResponse request()</code></p>

</li>
<li>
<p><code>&lt;E&gt; ClientResponseTyped&lt;E&gt; request(Class&lt;E&gt; type)</code></p>

</li>
<li>
<p><code>&lt;E&gt; E requestEntity(Class&lt;E&gt; type)</code></p>

</li>
<li>
<p><code>HttpClientResponse submit(Object entity)</code></p>

</li>
<li>
<p><code>&lt;T&gt; ClientResponseTyped&lt;T&gt; submit(Object entity, Class&lt;T&gt; requestedType)</code></p>

</li>
<li>
<p><code>HttpClientResponse outputStream(OutputStreamHandler outputStreamConsumer)</code></p>

</li>
<li>
<p><code>&lt;T&gt; ClientResponseTyped&lt;T&gt; outputStream(OutputStreamHandler outputStreamConsumer, Class&lt;T&gt; requestedType)</code></p>

</li>
</ul>

<p>Each of the methods will provide a way to allow response to be retrieved in a particular response type. Refer to <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/ClientRequest.html">ClientRequest API</a> for more details about these methods.</p>

<markup
lang="java"
title="Execute a simple GET request to endpoint and receive a String response:"
>ClientResponseTyped&lt;String&gt; response = webClient.get()
                .path("/endpoint")
                .request(String.class);
String entityString = response.entity();</markup>

</div>


<h3 id="_protocol_used">Protocol Used</h3>
<div class="section">
<p>WebClient currently supports <code>HTTP/1.1</code> and <code>HTTP/2</code> protocols. Below are the rules on which specific protocol will be used:</p>

<ul class="ulist">
<li>
<p>Using plain socket triggers WebClient to process a request using <code>HTTP/1.1</code>.</p>

</li>
<li>
<p>When using TLS, the client will use ALPN (protocol negotiation) to use appropriate HTTP version (either 1.1, or 2). <code>HTTP/2</code> has a higher weight, so it is chosen if supported by both sides.</p>

</li>
<li>
<p>A specific protocol can be explicitly selected by calling <code>HttpClientRequest#protocolId(String)</code>.</p>

</li>
</ul>

<div class="listing">
<pre>String result = webClient.get()
                         .protocolId("http/1.1")
                         .requestEntity(String.class);</pre>
</div>

<ul class="ulist">
<li>
<p>If <code>HTTP/2</code> is used, an upgrade attempt will be performed. If it fails, the client falls-back to <code>HTTP/1.1</code>.</p>

</li>
<li>
<p>The parameter <code>prior-knowledge</code> can be defined using <code>HTTP/2</code> protocol configuration. Please refer to <router-link to="#_setting_protocol_configuration" @click.native="this.scrollFix('#_setting_protocol_configuration')"></router-link> on how to customize <code>HTTP/2</code>. In such a case, <code>prior-knowledge</code> will be used and fail if it is unable to switch to <code>HTTP/2</code>.</p>

</li>
</ul>

</div>


<h3 id="_adding_media_support">Adding Media Support</h3>
<div class="section">
<p>Webclient supports the following built-in Helidon Media Support libraries:</p>

<ol style="margin-left: 15px;">
<li>
JSON Processing (JSON-P)

</li>
<li>
JSON Binding (JSON-B)

</li>
<li>
Jackson

</li>
</ol>

<p>They can be activated by adding their corresponding libraries into the classpath. This can simply be done by adding their corresponding dependencies.</p>

<markup
lang="xml"
title="Add JSON-P support:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jsonp&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="xml"
title="Add JSON-B support:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jsonb&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="xml"
title="Add Jackson support:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jackson&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Users can also create their own Custom Media Support library and make them work by following either of the approaches:</p>

<ul class="ulist">
<li>
<p>Create a Provider of the Custom Media Support and expose it via Service Loader followed by adding the Media Support library to the classpath.</p>

</li>
<li>
<p>Explicitly register the Custom Media Support from WebClient.</p>

</li>
</ul>

<markup
lang="java"

>WebClient webclient = WebClient.builder()
        .mediaContext(MediaContext.builder()
                .addMediaSupport(CustomMediaSupport.create())   <span class="conum" data-value="1" />
                .build())
        .build()</markup>

<ul class="colist">
<li data-value="1">Register CustomMedia support from the WebClient.</li>
</ul>

</div>


<h3 id="_dns_resolving">DNS Resolving</h3>
<div class="section">
<p>Webclient provides three DNS resolver implementations out of the box:</p>

<ul class="ulist">
<li>
<p><code>Java DNS resolution</code> is the default.</p>

</li>
<li>
<p><code><strong>First</strong> DNS resolution</code> uses the first IP address from a DNS lookup. To enable this option, add below dependency:</p>

</li>
</ul>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient.dns.resolver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-dns-resolver-first&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<ul class="ulist">
<li>
<p><code><strong>Round-Robin</strong> DNS resolution</code> cycles through IP addresses from a DNS lookup. To enable this option, add this dependency:</p>

</li>
</ul>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient.dns.resolver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-dns-resolver-round-robin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_configuring_the_webclient">Configuring the WebClient</h2>
<div class="section">
<p>The class responsible for WebClient configuration is:</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webclient.api/io/helidon/webclient/api/WebClient.html">io.helidon.webclient.api.WebClient</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>clients</code></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>base-uri</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Base uri used by the client in all requests.</p>

<pre>@return base uri of the client requests</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connect-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Connect timeout.</p>

<pre>@return connect timeout
@see io.helidon.common.socket.SocketOptions#connectTimeout()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-cache-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>256</code></td>
<td class=""><doc-view>
<p>Maximal size of the connection cache.
 For most HTTP protocols, we may cache connections to various endpoints for keep alive (or stream reuse in case of HTTP/2).
 This option limits the size. Setting this number lower than the "usual" number of target services will cause connections
 to be closed and reopened frequently.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>content-encoding</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_encoding_ContentEncodingContext">ContentEncodingContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.encoding.ContentEncodingContext.
 This method discards all previously registered ContentEncodingContext.
 If no content encoding context is registered, default encoding context is used.</p>

<pre>@return content encoding context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>cookie-manager</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webclient_api_WebClientCookieManager">WebClientCookieManager</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>WebClient cookie manager.</p>

<pre>@return cookie manager to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>default-headers</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Default headers to be used in every request from configuration.</p>

<pre>@return default headers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>follow-redirects</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to follow redirects.</p>

<pre>@return whether to follow redirects</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>keep-alive</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Determines if connection keep alive is enabled (NOT socket keep alive, but HTTP connection keep alive, to re-use
 the same connection for multiple requests).</p>

<pre>@return keep alive for this connection
@see io.helidon.common.socket.SocketOptions#socketKeepAlive()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-in-memory-entity</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>131072</code></td>
<td class=""><doc-view>
<p>If the entity is expected to be smaller that this number of bytes, it would be buffered in memory to optimize performance.
 If bigger, streaming will be used.</p>

<pre>Note that for some entity types we cannot use streaming, as they are already fully in memory (String, byte[]), for such
cases, this option is ignored. Default is 128Kb.</pre>
<pre>@return maximal number of bytes to buffer in memory for supported writers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-redirects</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>10</code></td>
<td class=""><doc-view>
<p>Max number of followed redirects.
 This is ignored if #followRedirects() option is <code>false</code>.</p>

<pre>@return max number of followed redirects</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-context</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_media_MediaContext">MediaContext</router-link></p>

</doc-view>
</td>
<td class=""><code>create()</code></td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.media.MediaContext.
 This method discards all previously registered MediaContext.
 If no media context is registered, default media context is used.</p>

<pre>@return media context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-type-parser-mode</code></td>
<td class=""><doc-view>
<p>ParserMode (STRICT, RELAXED)</p>

</doc-view>
</td>
<td class=""><code>STRICT</code></td>
<td class=""><doc-view>
<p>Configure media type parsing mode for HTTP <code>Content-Type</code> header.</p>

<pre>@return media type parsing mode</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>properties</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Properties configured for this client. These properties are propagated through client request, to be used by
 services (and possibly for other purposes).</p>

<pre>@return map of client properties</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocol-configs</code></td>
<td class=""><doc-view>
<p>io.helidon.webclient.spi.ProtocolConfig[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of client protocols.</p>

<pre>@return client protocol configurations</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>proxy</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webclient_api_Proxy">Proxy</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Proxy configuration to be used for requests.</p>

<pre>@return proxy to use, defaults to Proxy#noProxy()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-continue-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT1S</code></td>
<td class=""><doc-view>
<p>Socket 100-Continue read timeout. Default is 1 second.
 This read timeout is used when 100-Continue is sent by the client, before it sends an entity.</p>

<pre>@return read 100-Continue timeout duration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Read timeout.</p>

<pre>@return read timeout
@see io.helidon.common.socket.SocketOptions#readTimeout()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>relative-uris</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Can be set to <code>true</code> to force the use of relative URIs in all requests,
 regardless of the presence or absence of proxies or no-proxy lists.</p>

<pre>@return relative URIs flag</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>send-expect-continue</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether Expect-100-Continue header is sent to verify server availability before sending an entity.</p>

<pre>Defaults to `true`.</pre>
<pre>@return whether Expect:100-Continue header should be sent on streamed transfers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>services</code></td>
<td class=""><doc-view>
<p>io.helidon.webclient.spi.WebClientService[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>WebClient services.</p>

<pre>@return services to use with this web client</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>share-connection-cache</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to share connection cache between all the WebClient instances in JVM.</p>

<pre>@return true if connection cache is shared</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>socket-options</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_socket_SocketOptions">SocketOptions</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Socket options for connections opened by this client.
 If there is a value explicitly configured on this type and on the socket options,
 the one configured on this type&#8217;s builder will win:</p>

<ul class="ulist">
<li>
<p>#readTimeout()</p>

</li>
<li>
<p>#connectTimeout()</p>

</li>
</ul>

<p>@return socket options</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_tls_Tls">Tls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>TLS configuration for any TLS request from this client.
 TLS can also be configured per request.
 TLS is used when the protocol is set to <code>https</code>.</p>

<pre>@return TLS configuration to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_protocol_specific_configuration">Protocol Specific Configuration</h3>
<div class="section">
<p>Protocol specific configuration can be set using the  <code>protocol-configs</code> parameter. Webclient currently supports <code>HTTP/1.1.</code> and <code>HTTP/2</code>. Below are the options for each of the protocol type:</p>

<ul class="ulist">
<li>
<p><code>HTTP/1.1</code></p>

</li>
</ul>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webclient.http1/io/helidon/webclient/http1/Http1ClientProtocolConfig.html">io.helidon.webclient.http1.Http1ClientProtocolConfig</a></p>


<h4 id="_configuration_options_2">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>default-keep-alive</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to use keep alive by default.</p>

<pre>@return `true` for keeping connections alive and re-using them for multiple requests (default), `false`
 to create a new connection for each request</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-header-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>Configure the maximum allowed header size of the response.</p>

<pre>@return  maximum header size</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-status-line-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>256</code></td>
<td class=""><doc-view>
<p>Configure the maximum allowed length of the status line from the response.</p>

<pre>@return maximum status line length</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>http_1_1</code></td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-request-headers</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Sets whether the request header format is validated or not.</p>

<pre>Defaults to `false` as user has control on the header creation.</pre>
<pre>@return whether request header validation should be enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-response-headers</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Sets whether the response header format is validated or not.</p>

<pre>Defaults to `true`.</pre>
<pre>@return whether response header validation should be enabled</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<ul class="ulist">
<li>
<p><code>HTTP/2</code></p>

</li>
</ul>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webclient.http2/io/helidon/webclient/http2/Http2ClientProtocolConfig.html">io.helidon.webclient.http2.Http2ClientProtocolConfig</a></p>

</div>


<h4 id="_configuration_options_3">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>flow-control-block-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.1S</code></td>
<td class=""><doc-view>
<p>Timeout for blocking between windows size check iterations.</p>

<pre>@return timeout</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>initial-window-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>65535</code></td>
<td class=""><doc-view>
<p>Configure INITIAL_WINDOW_SIZE setting for new HTTP/2 connections.
 Sends to the server the size of the largest frame payload client is willing to receive.
 Defaults to <code>io.helidon.http.http2.WindowSize#DEFAULT_WIN_SIZE</code>.</p>

<pre>@return units of octets</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-frame-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>Configure initial MAX_FRAME_SIZE setting for new HTTP/2 connections.
 Maximum size of data frames in bytes the client is prepared to accept from the server.
 Default value is 2^14(16_384).</p>

<pre>@return data frame size in bytes between 2^14(16_384) and 2^24-1(16_777_215)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-header-list-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Configure initial MAX_HEADER_LIST_SIZE setting for new HTTP/2 connections.
 Sends to the server the maximum header field section size client is prepared to accept.
 Defaults to <code>-1</code>, which means "unconfigured".</p>

<pre>@return units of octets</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>h2</code></td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>ping</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Check healthiness of cached connections with HTTP/2.0 ping frame.
 Defaults to <code>false</code>.</p>

<pre>@return use ping if true</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>ping-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.5S</code></td>
<td class=""><doc-view>
<p>Timeout for ping probe used for checking healthiness of cached connections.
 Defaults to <code>PT0.5S</code>, which means 500 milliseconds.</p>

<pre>@return timeout</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>prior-knowledge</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Prior knowledge of HTTP/2 capabilities of the server. If server we are connecting to does not
 support HTTP/2 and prior knowledge is set to <code>false</code>, only features supported by HTTP/1 will be available
 and attempts to use HTTP/2 specific will throw an UnsupportedOperationException.
 &lt;h4&gt;Plain text connection&lt;/h4&gt;
 If prior knowledge is set to <code>true</code>, we will not attempt an upgrade of connection and use prior knowledge.
 If prior knowledge is set to <code>false</code>, we will initiate an HTTP/1 connection and upgrade it to HTTP/2,
 if supported by the server.
 plaintext connection (<code>h2c</code>).
 &lt;h4&gt;TLS protected connection&lt;/h4&gt;
 If prior knowledge is set to <code>true</code>, we will negotiate protocol using HTTP/2 only, failing if not supported.
 if prior knowledge is set to <code>false</code>, we will negotiate protocol using both HTTP/2 and HTTP/1, using the protocol
 supported by server.</p>

<pre>@return whether to use prior knowledge of HTTP/2</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h3 id="_example_of_a_webclient_runtime_configuration">Example of a WebClient Runtime Configuration</h3>
<div class="section">
<markup
lang="java"

>Config config = Config.create();
WebClient client = WebClient.builder()
        .baseUri("http://localhost")
        .config(config.get("client"))
        .build();</markup>

</div>


<h3 id="_example_of_a_webclient_yaml_configuration">Example of a WebClient YAML Configuration</h3>
<div class="section">
<markup
lang="java"

>client:
  connect-timeout-millis: 2000
  read-timeout-millis: 2000
  follow-redirects: true <span class="conum" data-value="1" />
  max-redirects: 5
  cookie-manager: <span class="conum" data-value="2" />
    automatic-store-enabled: true
    default-cookies:
      flavor3: strawberry
      flavor4: raspberry
  default-headers: <span class="conum" data-value="3" />
    Accept: '"application/json","text/plain"'
  services: <span class="conum" data-value="4" />
    metrics:
      - methods: ["PUT", "POST", "DELETE"]
        type: METER
        name-format: "client.meter.overall"
      - type: TIMER
        # meter per method
        name-format: "client.meter.%1$s"
      - methods: ["GET"]
        type: COUNTER
        errors: false
        name-format: "client.counter.%1$s.success"
        description: "Counter of successful GET requests"
      - methods: ["PUT", "POST", "DELETE"]
        type: COUNTER
        success: false
        name-format: "wc.counter.%1$s.error"
        description: "Counter of failed PUT, POST and DELETE requests"
    tracing:
  protocol-configs: <span class="conum" data-value="5" />
    http_1_1:
      max-header-size: 20000
      validate-request-headers: true
    h2:
      prior-knowledge: true
  proxy: <span class="conum" data-value="6" />
    host: "hostName"
    port: 80
    no-proxy: ["localhost:8080", ".helidon.io", "192.168.1.1"]
  tls: <span class="conum" data-value="7" />
    trust:
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "client.p12"</markup>

<ul class="colist">
<li data-value="1">Client functional settings</li>
<li data-value="2">Cookie management</li>
<li data-value="3">Default client headers</li>
<li data-value="4">Client service configuration</li>
<li data-value="5">Protocol configuration</li>
<li data-value="6">Proxy configuration</li>
<li data-value="7">TLS configuration</li>
</ul>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">

<h3 id="_webclient_with_proxy">Webclient with Proxy</h3>
<div class="section">
<p>Configure Proxy setup either programmatically or via the Helidon configuration framework.</p>


<h4 id="_configuring_proxy_in_your_code">Configuring Proxy in your code</h4>
<div class="section">
<p>Proxy can be set directly from WebClient builder.</p>

<markup
lang="java"

>Proxy proxy = Proxy.builder()
                .type(Proxy.ProxyType.HTTP)
                .host(PROXY_HOST)
                .port(PROXY_PORT)
                .build();
WebClient webClient = WebClient.builder()
         .proxy(proxy)
         .build();</markup>

<p>Alternative is to set proxy directly from the request via  <code>HttpClientRequest</code>.</p>

<markup
lang="java"

>// Using System Proxy
Proxy proxy = Proxy.create();
System.setProperty("http.proxyHost", PROXY_HOST);
System.setProperty("http.proxyPort", PROXY_PORT);
System.setProperty("http.nonProxyHosts", "localhost|127.0.0.1|10.*.*.*|*.example.com|etc|" + TARGET_HOST);
webClient.get("/proxiedresource").proxy(proxy).request()</markup>

</div>


<h4 id="_configuring_proxy_in_the_config_file">Configuring Proxy in the config file</h4>
<div class="section">
<p>Proxy can also be configured in WebClient through the <code>application.yaml</code> configuration file.</p>

<markup
lang="yaml"
title="WebClient Proxy configuration in <code>application.yaml</code>"
>webclient:
  proxy:
    host: "hostName"
    port: 80
    no-proxy: ["localhost:8080", ".helidon.io", "192.168.1.1"]</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebClient initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebClient webClient = WebClient.create(config.get("webclient"));</markup>

</div>

</div>


<h3 id="_webclient_tls_setup">WebClient TLS Setup</h3>
<div class="section">
<p>Configure TLS either programmatically or by the Helidon configuration framework.</p>


<h4 id="_configuring_tls_in_your_code">Configuring TLS in your code</h4>
<div class="section">
<p>One way to configure TLS in WebClient is in your application code as shown below.</p>

<markup
lang="java"

>WebClient.builder()
         .tls(Tls.builder()
                     .trust(trust -&gt; trust
                             .keystore(store -&gt; store
                                     .passphrase("password")
                                     .trustStore(true)
                                     .keystore(Resource.create("client.p12"))))
                     .build())
         .build();</markup>

</div>


<h4 id="_configuring_tls_in_the_config_file">Configuring TLS in the config file</h4>
<div class="section">
<p>Another way to configure TLS in WebClient is through the <code>application.yaml</code> configuration file.</p>

<markup
lang="yaml"
title="WebClient TLS configuration in <code>application.yaml</code>"
>webclient:
  tls:
    trust:
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "client.p12"</markup>

<div class="admonition note">
<p class="admonition-inline">The <code>passphrase</code> value on the config file can be encrypted if stronger security is required. For more information on how secrets can be encrypted using a master password and store them in a configuration file, please see <router-link to="/mp/security/configuration-secrets">Configuration Secrets</router-link>.</p>
</div>

<p>In the application code, load the settings from the configuration file.</p>

<markup
lang="java"
title="WebClient initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebClient webClient = WebClient.create(config.get("webclient"));</markup>

</div>

</div>


<h3 id="_adding_service_to_webclient">Adding Service to WebClient</h3>
<div class="section">
<p>WebClient currently supports 3 built-in services namely <code>metrics</code>, <code>tracing</code> and <code>security</code>.</p>


<h4 id="_enabling_the_service">Enabling the service</h4>
<div class="section">
<p>In order for a service to function, their dependency needs to be added in the application&#8217;s pom.xml. Below are examples on how to enable the built-in services:</p>

<ul class="ulist">
<li>
<p><code>metrics</code></p>

</li>
</ul>

<div class="listing">
<pre>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</pre>
</div>

<ul class="ulist">
<li>
<p><code>tracing</code></p>

</li>
</ul>

<div class="listing">
<pre>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-tracing&lt;/artifactId&gt;
&lt;/dependency&gt;</pre>
</div>

<ul class="ulist">
<li>
<p><code>security</code></p>

</li>
</ul>

<div class="listing">
<pre>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-security&lt;/artifactId&gt;
&lt;/dependency&gt;</pre>
</div>

</div>


<h4 id="_adding_a_service_in_your_code">Adding a service in your code</h4>
<div class="section">
<p>Services can be added in WebClient as shown in the code below.</p>

<markup
lang="java"

>//Creates new metric which will count all GET requests and has format of example.metric.GET.&lt;host-name&gt;
WebClientService clientService = WebClientMetrics.counter()
        .methods(Method.GET)
        .nameFormat("example.metric.%1$s.%2$s")
        .build();

//This newly created metric now needs to be registered to WebClient.
WebClient client = WebClient.builder()
        .baseUri(url)
        .config(config)
        .addService(clientService)
        .build();</markup>

</div>


<h4 id="_adding_service_in_the_config_file">Adding service in the config file</h4>
<div class="section">
<p>Adding service in WebClient can also be done through the <code>application.yaml</code> configuration file.</p>

<markup
lang="yaml"
title="WebClient Service configuration in <code>application.yaml</code>"
>webclient:
  services:
    metrics:
      - type: METER
        name-format: "client.meter.overall"
      - type: TIMER
        # meter per method
        name-format: "client.meter.%1$s"
      - methods: ["PUT", "POST", "DELETE"]
        type: COUNTER
        success: false
        name-format: "wc.counter.%1$s.error"
        description: "Counter of failed PUT, POST and DELETE requests"
    tracing:</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebClient initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebClient webClient = WebClient.create(config.get("webclient"));</markup>

</div>

</div>


<h3 id="_setting_protocol_configuration">Setting Protocol configuration</h3>
<div class="section">
<p>Individual protocols can be customized using the <code>protocol-config</code> parameter.</p>


<h4 id="_setting_up_protocol_configuration_in_your_code">Setting up protocol configuration in your code</h4>
<div class="section">
<p>Below is an example of customizing <code>HTTP/1.1</code> protocol in the application code.</p>

<markup
lang="java"

>WebClient client = WebClient.builder()
    .baseUri(url)
    .config(config.get("client"))
    .addProtocolConfig(Http1ClientProtocolConfig.builder()
                    .defaultKeepAlive(false)
                    .validateRequestHeaders(true)
                    .validateResponseHeaders(false)
                    .build())
    .build();</markup>

</div>


<h4 id="_setting_up_protocol_configuration_in_the_config_file">Setting up protocol configuration in the config file</h4>
<div class="section">
<p>Protocol configuration can also be set in the <code>application.yaml</code> configuration file.</p>

<markup
lang="yaml"
title="Setting up <code>HTTP/1.1</code> and <code>HTTP/2</code> protocol using <code>application.yaml</code> file."
>webclient:
  protocol-configs:
    http_1_1:
      max-header-size: 20000
      validate-request-headers: true
    h2:
      prior-knowledge: true</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebClient initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebClient webClient = WebClient.create(config.get("webclient"));</markup>

</div>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.api/module-summary.html">Helidon Webclient API</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.http1/module-summary.html">Helidon WebClient HTTP/1.1 Support</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.http2/module-summary.html">Helidon WebClient HTTP/2 Support</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.dns.resolver.first/module-summary.html">Helidon WebClient DNS Resolver First Support</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.dns.resolver.roundrobin/module-summary.html">Helidon WebClient DNS Resolver Round Robin Support</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.metrics/module-summary.html">Helidon WebClient Metrics Support</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.security/module-summary.html">Helidon WebClient Security Support</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webclient.tracing/module-summary.html">Helidon WebClient Tracing Support</a></p>

</li>
</ul>

</div>

</doc-view>
