<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#_server_api" @click.native="this.scrollFix('#_server_api')">Server API</router-link></p>

</li>
<li>
<p><router-link to="#_maven_coordinates" @click.native="this.scrollFix('#_maven_coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_client_api" @click.native="this.scrollFix('#_client_api')">Client API</router-link></p>

</li>
<li>
<p><router-link to="#_maven_coordinates" @click.native="this.scrollFix('#_maven_coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Server-sent events (SSE) enable servers to push data to clients (e.g. Web browsers) using standard HTTP
or HTTPS through a unidirectional server-to-client connection. In the server-sent events communication model,
the client establishes the initial connection, and the server provides the data in the form of
<em>event streams</em>. For more information about server-sent events, see the
<a target="_blank" href="https://html.spec.whatwg.org/multipage/server-sent-events.html"><code>Server-sent events</code></a>
specification.</p>

<p>SSE is an alternative technology to WebSockets when only server-to-client messaging
is required and can be accomplished without the need to switch protocols (upgrades) and without
using imperfect solutions such as long polling. A server-sent connection is typically a long-lived
connection in which messages are sent to the client over a longer period of time compared to a
normal request-response connection. It is useful for updating <em>live data</em> such as stock tickers,
results of live events, etc.</p>

<p>Helidon provides support for server and client APIs, although Web browsers are popular client alternatives.
The following sections describe these APIs in more detail.</p>

</div>


<h2 id="_server_api">Server API</h2>
<div class="section">
<p>The Server API is available as a loadable service in the Helidon WebServer. The following additional
dependency is required to find and load the SSE service in the WebServer.</p>


<h3 id="_maven_coordinates">Maven Coordinates</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-sse&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_usage">Usage</h3>
<div class="section">
<p>Sending events is accomplished by obtaining an <code>SseSink</code> instance from a <code>ServerResponse</code> using the
<code>SseSink.TYPE</code> constant. The following example converts the response into an <code>SseSink</code>, emits two string
messages and then closes the connection.</p>

<markup
lang="java"

>void sseString(ServerRequest req, ServerResponse res) {
    try (SseSink sseSink = res.sink(SseSink.TYPE)) {
        sseSink.emit(SseEvent.create("hello"))
                .emit(SseEvent.create("world"));
    }
}</markup>

<p>Once an <code>SseSink</code> is obtained from a <code>ServerResponse</code>, the latter is no longer usable to send additional
data to the client given that response <code>Content-Type</code> will be automatically set to <code>text/event-stream</code>.
Note that an <code>SseSink</code> is auto closeable, so it can be part of a try-with-resources block as shown above.</p>

<p>Events can be created using any of the static <code>create</code> methods in <code>SseEvent</code> as well as via a builder obtained by
calling <code>SseEvent.builder()</code>. For more information see the Javadocs for those classes. In the example
above, a simple create method with a string param is used to showcase a very common use case. The
API supports integration with Helidon&#8217;s media type providers, so the event data may actually be of any
type as long as it is possible to convert it to a string value.</p>

</div>


<h3 id="_integration_with_media_types">Integration with Media Types</h3>
<div class="section">
<p>It is possible to serialize event data using the media support. For example, if JSON-P is available
in your class path, you can create an SSE event from a <code>JsonObject</code> and Helidon will find the appropriate media
converter and serialize the event data on your behalf.</p>

<markup
lang="java"

>void sseJsonp(ServerRequest req, ServerResponse res) {
    JsonObject json = Json.createObjectBuilder()
            .add("hello", "world")
            .build();
    try (SseSink sseSink = res.sink(SseSink.TYPE)) {
        sseSink.emit(SseEvent.create(json));
    }
}</markup>

<p>Similarly, if JSON-B support is available in your class path, an event can be created from an arbitrary
Java class and serialized as shown next:</p>

<markup
lang="java"

>class HelloWorld {

    private String hello;

    public String getHello() {
        return hello;
    }

    public void setHello(String hello) {
        this.hello = hello;
    }
}

void sseJsonb(ServerRequest req, ServerResponse res) {
    HelloWorld json = new HelloWorld();
    json.setHello("world");
    try (SseSink sseSink = res.sink(SseSink.TYPE)) {
        sseSink.emit(SseEvent.create(json));
    }
}</markup>

<p>An optional media type can be specified alongside the event&#8217;s data, in case a different type
of serialization is required or when multiple media converters are available in the class path.
For example, when passing a Java instance, you may request XML instead of JSON serialization
by using <code>application/xml</code> as the event&#8217;s media type.</p>

</div>

</div>


<h2 id="_client_api">Client API</h2>
<div class="section">
<p>The Client API is available as a loadable service in the Helidon WebClient. The following additional
dependency is required to find and load the service in the WebClient.</p>


<h3 id="_maven_coordinates_2">Maven Coordinates</h3>
<div class="section">
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-sse&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_usage_2">Usage</h3>
<div class="section">
<p>Receiving events is accomplished by providing an <code>SseSource</code> handler using the source
type <code>SseSource.TYPE</code>. An <code>SseSource</code> is a functional interface defined for the purpose of
processing events. The following example, obtains an <code>Http1ClientResponse</code> from a request
and registers an <code>SseSource</code> to process a single event.</p>

<markup
lang="java"

>try (Http1ClientResponse r = client.get("/sseJson")
                                    .header(ACCEPT_EVENT_STREAM)
                                    .request()) {
    CountDownLatch latch = new CountDownLatch(1);
    r.source(SseSource.TYPE, event -&gt; {
        // ...
        latch.countDown();
    });
}</markup>

<p>The <code>SseSource</code> type defines other methods such as <code>onOpen</code>, <code>onClose</code> and <code>onError</code>. The following example
waits for zero or more string events until the connection is closed. A <code>CountDownLatch</code> is a convenient
way to asynchronously wait until all the events are received.</p>

<markup
lang="java"

>try (Http1ClientResponse r = client.get("/sseString")
                                    .header(ACCEPT_EVENT_STREAM)
                                    .request()) {
    CountDownLatch latch = new CountDownLatch(1);
    r.source(SseSource.TYPE, new SseSource() {
        @Override
        public void onEvent(SseEvent event) {
            // ...
        }

        @Override
        public void onClose() {
            latch.countDown();
        }
    });
    assertThat(latch.await(5, TimeUnit.SECONDS), is(true));
}</markup>

</div>


<h3 id="_integration_with_media_types_2">Integration with Media Types</h3>
<div class="section">
<p>The Client API is also integrated with Helidon&#8217;s media type support. The data received as part of an
event can be deserialized using any of the media converters available in your class path. There are
special methods in <code>SseEvent</code> for this purpose. Without a parameter, the method <code>data()</code> in <code>SseEvent</code> will
always return a string. Other types can be requested using <code>data(Class&lt;T&gt;)</code>
and <code>data(Class&lt;T&gt;, MediaType)</code>. The latter is necessary to select the correct media converter given
that there is no (standard) content type available as part of each event --but only a single
<code>text/event-stream</code> content type for the whole response.</p>

<p>For example, to convert an event into a Java instance using JSON-B, the <code>application/json</code> media type
is required as a second parameter --the first parameter <code>HelloWorld.class</code> simply does not convey
sufficient information to select the appropriate converter for the event&#8217;s data in this case.</p>

<markup
lang="java"

>try (Http1ClientResponse r = client.get("/sseJson")
                                    .header(ACCEPT_EVENT_STREAM)
                                    .request()) {
    CountDownLatch latch = new CountDownLatch(1);
    r.source(SseSource.TYPE, event -&gt; {
        HelloWorld json = event.data(HelloWorld.class, MediaTypes.APPLICATION_JSON);
        // ...
        latch.countDown();
    });
}</markup>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>The <a target="_blank" href="https://html.spec.whatwg.org/multipage/server-sent-events.html"><code>Server-sent events</code></a> specification.</p>

</div>

</doc-view>
