<doc-view>

<h2 id="_webserver">WebServer</h2>
<div class="section">
<p>To integrate <router-link to="/se/webserver">web server</router-link>, add the following dependency to your project&#8217;s pom.xml file:</p>

<markup
lang="xml"
title="Maven Dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-security&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h3 id="_configure_security_with_webserver">Configure Security with WebServer</h3>
<div class="section">
<p>There are two steps to configure security with WebServer:</p>

<ol style="margin-left: 15px;">
<li>
Create a security instance and register it with the server.

</li>
<li>
Protect server routes with optional security features.

</li>
</ol>

<markup
lang="java"
title="Example using builders"
>// web server's Routing
HttpRouting.builder()
    // This is step 1 - register security instance with web server processing
    // security - instance of security either from config or from a builder
    // securityDefaults - default enforcement for each route that has a security definition
    .addFeature(SecurityFeature.create(security).securityDefaults(SecurityFeature.authenticate()))
    // this is step 2 - protect a route
    // protect this route with authentication (from defaults) and role "user"
    .get("/service1", SecurityFeature.rolesAllowed("user"), (req, res) -&gt; {
        processService1Request(req, res);
    })
    .build();</markup>

<markup
lang="java"
title="Example using configuration"
>HttpRouting.builder()
    // helper method to load both security and web server security from configuration
    .addFeature(SecurityFeature.create(config))
    // continue with web server route configuration
    .build();</markup>

<markup
lang="yaml"
title="Example using configuration (YAML)"
># This may change in the future - to align with web server configuration, once it is supported
security.web-server:
  # Configuration of integration with web server
  defaults:
    authenticate: true
  paths:
    - path: "/service1/[/{*}]"
      methods: ["get"]
      roles-allowed: ["user"]</markup>

</div>


<h3 id="_protecting_helidon_endpoints">Protecting Helidon endpoints</h3>
<div class="section">
<p>There are several endpoints provided by Helidon services, such as:</p>

<ul class="ulist">
<li>
<p>Health endpoint (<code>/health</code>)</p>

</li>
<li>
<p>Metrics endpoint (<code>/metrics</code>)</p>

</li>
<li>
<p>OpenAPI endpoint (<code>/openapi</code>)</p>

</li>
<li>
<p>Configured static content (can use any path configured)</p>

</li>
</ul>

<p>These endpoints are all implemented using Helidon WebServer and as such
can be protected only through Security integration with WebServer.</p>

<p>The following section describes configuration of such protection using configuration files,
 in this case using a <code>yaml</code> file, as it provides a tree structure.</p>


<h4 id="_configuring_endpoint_protection">Configuring endpoint protection</h4>
<div class="section">
<p>The configuration is usually placed under <code>security.web-server</code> (this can be
customized in Helidon SE).</p>

<p>The following shows an example we will explain in detail:</p>

<markup
lang="yaml"
title="application.yaml"
>security:
  providers:
    - abac: <span class="conum" data-value="1" />
    - provider-key: <span class="conum" data-value="2" />
  web-server:
    defaults:
      authenticate: true <span class="conum" data-value="3" />
    paths:
      - path: "/metrics[/{*}]" <span class="conum" data-value="4" />
        roles-allowed: "admin"
      - path: "/health[/{*}]" <span class="conum" data-value="5" />
        roles-allowed: "monitor"
      - path: "/openapi[/{*}]" <span class="conum" data-value="6" />
        abac:
          scopes: ["openapi"]
      - path: "/static[/{*}]" <span class="conum" data-value="7" />
        roles-allowed: ["user", "monitor"]</markup>

<ul class="colist">
<li data-value="1">Attribute based access control provider that checks roles and scopes</li>
<li data-value="2">The provider(s) used in your application, such as <code>oidc</code></li>
<li data-value="3">Default configuration for all configured paths</li>
<li data-value="4">Protection of <code>/metrics</code> and all nested paths with <code>admin</code> role required</li>
<li data-value="5">Protection of <code>/health</code> and all nested paths with <code>monitor</code> role required</li>
<li data-value="6">Protection of <code>/openapi</code> and all nested paths with <code>openapi</code> scope required</li>
<li data-value="7">Protection of static content configured on <code>/static</code> path with either <code>user</code> or <code>monitor</code> role required</li>
</ul>

<p>If you need to use a properties file, such as <code>microprofile-config.properties</code>, you
can convert the file by using index based numbers for arrays, such as:</p>

<markup
lang="properties"
title="microprofile-config.properties"
>security.providers.0.abac=
security.providers.1.provider-key.optional=false
security.web-server.defaults.authenticate=true
security.web-server.paths.0.path=/metrics[/{*}]
security.web-server.paths.0.roles-allowed=admin
security.web-server.paths.3.path=/static[/{*}]
security.web-server.paths.3.roles-allowed=user,monitor</markup>

</div>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webserver.security/module-summary.html">Helidon WebServer Security Integration</a></p>

</li>
</ul>

</div>

</doc-view>
