<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE Metrics Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon {h1-prefix} project
that can be used to run some basic examples using both built-in and custom meters with Helidon.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 30 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon SE Application</td>
<td class="">You can use your own application or use the
 <router-link to="/se/guides/quickstart">Helidon SE Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://github.com/helm/helm">Helm</a></td>
<td class="">To manage Kubernetes applications.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>


<h3 id="_create_a_sample_helidon_se_project">Create a Sample Helidon SE Project</h3>
<div class="section">
<p>Use the Helidon SE Maven archetype to create a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.5 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

</div>


<h3 id="_using_the_built_in_meters">Using the Built-In Meters</h3>
<div class="section">
<p>Helidon provides three built-in scopes of metrics: base, vendor, and application. Here are the metric endpoints:</p>

<ol style="margin-left: 15px;">
<li>
<code>/observe/metrics?scope=base</code> - Base meters

</li>
<li>
<code>/observe/metrics?scope=vendor</code> - Helidon-specific meters

</li>
<li>
<code>/observe/metrics?scope=application</code> - Application-specific metrics data.

</li>
</ol>

<p>Applications can add their own custom scopes as well simply by specifying a custom scope name when registering a meter.</p>

<div class="admonition note">
<p class="admonition-inline">The <code>/observe/metrics</code> endpoint returns data for all scopes.</p>
</div>

<p>The built-in meters fall into these categories:</p>

<ol style="margin-left: 15px;">
<li>
JVM behavior (in the base scope), and

</li>
<li>
basic key performance indicators for request handling (in the vendor scope).

</li>
</ol>

<p>A later section describes the <router-link to="#basic-and-extended-kpi" @click.native="this.scrollFix('#basic-and-extended-kpi')">key performance indicator meters</router-link> in detail.</p>

<p>The following example demonstrates how to use the other built-in meters.  All examples are executed
from the root directory of your project (helidon-quickstart-se).</p>

<p>The generated source code is already configured for both metrics and health checks, but the following example removes health checks.</p>

<markup
lang="xml"
title="Metrics dependencies in the generated <code>pom.xml</code>:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-metrics&lt;/artifactId&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics-system-meters&lt;/artifactId&gt;     <span class="conum" data-value="2" />
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">Includes the Helidon observability component for metrics and, as transitive dependencies, the Helidon neutral metrics API and a full-featured implementation of the API.</li>
<li data-value="2">Includes the built-in meters.</li>
</ul>

<p>With these dependencies in your project, Helidon&#8217;s auto-discovery of webserver features automatically finds and runs the metrics subsystem.
You do not need to change any of the generated source code.</p>

<markup
lang="bash"
title="Build the application and then run it:"
>mvn package
java -jar target/helidon-quickstart-se.jar</markup>

<div class="admonition note">
<p class="admonition-inline">Metrics output can be returned in either text format (the default), or JSON.  The text format uses OpenMetrics (Prometheus) Text Format,
see <a target="_blank" href="https://prometheus.io/docs/instrumenting/exposition_formats/#text-format-details" class="bare">https://prometheus.io/docs/instrumenting/exposition_formats/#text-format-details</a>.</p>
</div>

<markup
lang="bash"
title="Verify the metrics endpoint in a new terminal window:"
>curl http://localhost:8080/observe/metrics</markup>

<markup
lang="text"
title="Text response:"
># TYPE base:classloader_current_loaded_class_count counter
# HELP base:classloader_current_loaded_class_count Displays the number of classes that are currently loaded in the Java virtual machine.
base:classloader_current_loaded_class_count 7511
# TYPE base:classloader_total_loaded_class_count counter
# HELP base:classloader_total_loaded_class_count Displays the total number of classes that have been loaded since the Java virtual machine has started execution.
base:classloader_total_loaded_class_count 7512</markup>

<p>You can get the same data in JSON format.</p>

<markup
lang="bash"
title="Verify the metrics endpoint with an HTTP accept header:"
>curl -H "Accept: application/json"  http://localhost:8080/observe/metrics</markup>

<markup
lang="json"
title="JSON response:"
>{
  "base": {
    "gc.total;name=G1 Young Generation": 1,
    "cpu.systemLoadAverage": 4.451171875,
    "classloader.loadedClasses.count": 3582,
    "thread.count": 18,
    "classloader.unloadedClasses.total": 0,
    "jvm.uptime": 36.9478,
    "gc.time;name=G1 Young Generation": 0,
    "memory.committedHeap": 541065216,
    "thread.max.count": 19,
    "cpu.availableProcessors": 8,
    "classloader.loadedClasses.total": 3582,
    "thread.daemon.count": 16,
    "memory.maxHeap": 8589934592,
    "memory.usedHeap": 20491248
  },
  "vendor": {
    "requests.count": 3
  }
}</markup>

<p>You can get a single metric by specifying the scope and name as query parameters in the URL.</p>

<markup
lang="bash"
title="Get the Helidon <code>requests.count</code> meter:"
>curl -H "Accept: application/json"  'http://localhost:8080/observe/metrics?scope=vendor&amp;name=requests.count'</markup>

<markup
lang="json"
title="JSON response:"
>{
  "requests.count": 6
}</markup>

<p>The <code>base</code> meters illustrated above provide some insight into the behavior of the JVM in which the server runs.</p>

<p>The <code>vendor</code> meter shown above gives an idea of the request traffic the server is handling. See the <router-link to="#basic-and-extended-kpi" @click.native="this.scrollFix('#basic-and-extended-kpi')">later section</router-link> for more information on the basic and extended key performance indicator meters.</p>

</div>


<h3 id="_controlling_metrics_behavior">Controlling Metrics Behavior</h3>
<div class="section">
<p>By adding a <code>metrics</code> section to your application configuration you can control how the Helidon metrics subsystem behaves in any of several ways.</p>

<ul class="ulist">
<li>
<p><router-link to="#disabling-entirely" @click.native="this.scrollFix('#disabling-entirely')">Disable metrics subsystem entirely</router-link>.</p>

</li>
<li>
<p>Select whether to collect <router-link to="#basic-and-extended-kpi" @click.native="this.scrollFix('#basic-and-extended-kpi')">extended key performance indicator meters</router-link>.</p>

</li>
</ul>

<p>Your Helidon SE application can also control metrics processing programmatically as described in the following sections.</p>


<h4 id="disabling-entirely">Disabling Metrics Subsystem Entirely</h4>
<div class="section">
<p>You can disable the metrics subsystem entirely using configuration:</p>

<markup
lang="yaml"
title="Configuration properties file disabling metrics"
>server:
  features:
    observe:
      observers:
        metrics:
          enabled: false</markup>

<p>A Helidon SE application can disable metrics processing programmatically.</p>

<markup
lang="java"
title="Disable all metrics behavior"
>    ObserveFeature observe = ObserveFeature.builder()   <span class="conum" data-value="1" />
        .addObserver(metricsObserer.builder()           <span class="conum" data-value="2" />
                .enabled(false)                         <span class="conum" data-value="3" />
                .build())                               <span class="conum" data-value="4" />
        .build();                                       <span class="conum" data-value="5" />

    WebServer server = WebServer.builder()              <span class="conum" data-value="6" />
        .config(Config.global().get("server"))
        .addFeature(observe)
        .routing(Main::routing)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Begin preparing the <code>ObserveFeature</code>.</li>
<li data-value="2">Begin preparing the <code>MetricsObserver</code>.</li>
<li data-value="3">Disable metrics.</li>
<li data-value="4">Complete the <code>MetricsObserver</code>.</li>
<li data-value="5">Complete the <code>ObserveFeature</code>.</li>
<li data-value="6">Create and start the <code>WebServer</code> with the <code>ObserveFeature</code> (and other settings).</li>
</ul>

<p>These builders and interfaces also have methods which accept <code>Config</code> objects representing the <code>metrics</code> node from the application configuration.</p>

<p>With metrics processing disabled, Helidon never updates any meters and the <code>/observe/metrics</code> endpoints respond with <code>404</code>.</p>

</div>


<h4 id="basic-and-extended-kpi">Collecting Basic and Extended Key Performance Indicator (KPI) Metrics</h4>
<div class="section">
<p>Any time you include the Helidon metrics module in your application, Helidon tracks a basic performance indicator meter: a <code>Counter</code> of all requests received (<code>requests.count</code>).</p>

<p>Helidon SE also includes additional, extended KPI metrics which are disabled by default:</p>

<ul class="ulist">
<li>
<p>current number of requests in-flight - a <code>Gauge</code> (<code>requests.inFlight</code>) of requests currently being processed</p>

</li>
<li>
<p>long-running requests - a <code>Counter</code> (<code>requests.longRunning</code>) measuring the total number of requests which take at least a given amount of time to complete; configurable, defaults to 10000 milliseconds (10 seconds)</p>

</li>
<li>
<p>load - a <code>Counter</code> (<code>requests.load</code>) measuring the number of requests worked on (as opposed to received)</p>

</li>
<li>
<p>deferred - a <code>Gauge</code> (<code>requests.deferred</code>) measuring delayed request processing (work on a request was delayed after Helidon received the request)</p>

</li>
</ul>

<p>You can enable and control these meters using configuration:</p>

<markup
lang="yaml"

>server:
  features:
    observe:
      observers:
        metrics:
          key-performance-indicators:
            extended: true
            long-running:
              threshold-ms: 2000</markup>

<p>Your Helidon SE application can also control the KPI settings programmatically.</p>

<markup
lang="java"
title="Assign KPI metrics behavior from code"
>    KeyPerformanceIndicatorMetricsConfig kpiConfig =
        KeyPerformanceIndicatorMetricsConfig.builder()              <span class="conum" data-value="1" />
                .extended(true)                                     <span class="conum" data-value="2" />
                .longRunningRequestThreshold(Duration.ofSeconds(4)) <span class="conum" data-value="3" />
                .build();

    MetricsObserver metrics = MetricsObserver.builder()
                .metricsConfig(MetricsConfig.builder()              <span class="conum" data-value="4" />
                                       .keyPerformanceIndicatorMetricsConfig(kpiConfig)) <span class="conum" data-value="5" />
                .build();

    ObserveFeature observe = ObserveFeature.builder()
        .config(config.get("server.features.observe"))
        .addObserver(metrics)                                       <span class="conum" data-value="6" />
        .build();

    WebServer server = WebServer.builder()                          <span class="conum" data-value="7" />
        .config(Config.global().get("server"))
        .addFeature(observe)
        .routing(Main::routing)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Create a <a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/KeyPerformanceIndicatorMetricsConfig.html"><code>KeyPerformanceIndicatorMetricsConfig</a></code> instance (via its <a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/KeyPerformanceIndicatorMetricsConfig.Builder.html"><code>Builder</code></a>) with non-default values.</li>
<li data-value="2">Enabled extended KPI meters.</li>
<li data-value="3">Set the long-running request threshold.</li>
<li data-value="4">Prepare the metrics observer&#8217;s builder.</li>
<li data-value="5">Update the metrics observer&#8217;s builder using the just-prepared KPI metrics config.</li>
<li data-value="6">Add the metrics observer to the <code>ObserveFeature</code>.</li>
<li data-value="7">Add the <code>ObserveFeature</code> to the <code>WebServer</code>.</li>
</ul>

</div>

</div>


<h3 id="_metrics_metadata">Metrics Metadata</h3>
<div class="section">
<p>Each meter has associated metadata that includes:</p>

<ol style="margin-left: 15px;">
<li>
name: The name of the meter.

</li>
<li>
units: The unit of the meter such as time (seconds, milliseconds), size (bytes, megabytes), etc.

</li>
<li>
a description of the meter.

</li>
</ol>

<p>You can get the metadata for any scope, such as <code>/observe/metrics?scope=base</code>, as shown below:</p>

<markup
lang="bash"
title="Get the metrics metadata using HTTP OPTIONS method:"
> curl -X OPTIONS -H "Accept: application/json"  'http://localhost:8080/observe/metrics?scope=base'</markup>

<markup
lang="json"
title="JSON response (truncated):"
>{
   "classloader.loadedClasses.count": {
      "type": "gauge",
      "description": "Displays the number of classes that are currently loaded in the Java virtual machine."
    },
   "jvm.uptime": {
      "type": "gauge",
      "unit": "seconds",
      "description": "Displays the start time of the Java virtual machine in milliseconds. This attribute displays the approximate time when the Java virtual machine started."
    },
   "memory.usedHeap": {
      "type": "gauge",
      "unit": "bytes",
      "description": "Displays the amount of used heap memory in bytes."
    }
}</markup>

</div>


<h3 id="_application_specific_metrics_data">Application-Specific Metrics Data</h3>
<div class="section">
<p>This section demonstrates how to use application-specific meters and integrate them with Helidon, starting from a Helidon SE QuickStart application.</p>

<p>It is the application&#8217;s responsibility to create and update the meters at runtime.  The application has
complete control over when and how each meter is used. For example, an application may use the
same counter for multiple methods, or one counter per method.  Helidon maintains a single meter registry which holds all meters.</p>

<p>In all of these examples, the code uses a meter builder specific to the type of meter needed to register a new meter or locate a previous-registered meter.</p>


<h4 id="_counter_meter">Counter Meter</h4>
<div class="section">
<p>The <code>Counter</code> meter is a monotonically increasing number. The following example demonstrates how to use a <code>Counter</code> to track the number of times the <code>/cards</code> endpoint is called.</p>

<markup
lang="java"
title="Create a new class named <code>GreetingCards</code> with the following code:"
>package io.helidon.examples.quickstart.se;

import java.util.Collections;

import io.helidon.metrics.api.Counter;                      <span class="conum" data-value="1" />
import io.helidon.metrics.api.Metrics;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;

public class GreetingCards implements HttpService {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

    private final Counter cardCounter;                      <span class="conum" data-value="2" />

    GreetingCards() {
        cardCounter = Metrics.globalRegistry()
                .getOrCreate(Counter.builder("cardCount")
                        .description("Counts card retrievals")); <span class="conum" data-value="3" />
    }

    @Override
    public void routing(HttpRules rules) {
        rules.get("/", this::getDefaultMessageHandler);
    }

    private void getDefaultMessageHandler(ServerRequest request, ServerResponse response) {
        cardCounter.increment();                            <span class="conum" data-value="4" />
        sendResponse(response, "Here are some cards ...");
    }

    private void sendResponse(ServerResponse response, String msg) {
        JsonObject returnObject = JSON.createObjectBuilder().add("message", msg).build();
        response.send(returnObject);
    }
}</markup>

<ul class="colist">
<li data-value="1">Import metrics types.</li>
<li data-value="2">Declare a <code>Counter</code> member field.</li>
<li data-value="3">Create and register the <code>Counter</code> meter in the global meter registry`.  This <code>Counter</code> will exist for the lifetime of
the application.</li>
<li data-value="4">Increment the count.</li>
</ul>

<markup
lang="java"
title="Update the <code>Main.routing</code> method as follows:"
>    static void routing(HttpRouting.Builder routing) {
            Config config = Config.global();

            routing
                   .register("/greet", new GreetService())
                   .register("/cards", new GreetingCards())                     <span class="conum" data-value="1" />
                   .get("/simple-greet", (req, res) -&gt; res.send("Hello World!"));
        }</markup>

<ul class="colist">
<li data-value="1">Add the <code>GreetingCards</code> service to the routing.  Helidon routes any REST requests with
the <code>/cards</code> root path to the <code>GreetingCards</code> service.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the endpoints below:"
>curl http://localhost:8080/cards
curl -H "Accept: application/json" 'http://localhost:8080/observe/metrics?scope=application'</markup>

<markup
lang="json"
title="JSON response:"
>{
  "cardCount": 1 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The count value is one since the method was called once.</li>
</ul>

</div>


<h4 id="_timer_meter">Timer Meter</h4>
<div class="section">
<p>The <code>Timer</code> meter aggregates durations.</p>

<p>In the following example,
a <code>Timer</code> meter measures the duration of a method&#8217;s execution.  Whenever the REST <code>/cards</code>
endpoint is called, the code updates the <code>Timer</code> with additional timing information.</p>

<markup
lang="java"
title="Replace the <code>GreetingCards</code> class with the following code:"
>package io.helidon.examples.quickstart.se;

import java.util.Collections;

import io.helidon.metrics.api.Metrics;                      <span class="conum" data-value="1" />
import io.helidon.metrics.api.Timer;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;

public class GreetingCards implements HttpService {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final Timer cardTimer;                          <span class="conum" data-value="2" />

    GreetingCards() {
        cardTimer = Metrics.globalRegistry()
                .getOrCreate(Timer.builder("cardTimer")     <span class="conum" data-value="3" />
                                     .description("Times card retrievals"));
    }

    @Override
    public void routing(HttpRules rules) {
        rules.get("/", this::getDefaultMessageHandler);
    }

    private void getDefaultMessageHandler(ServerRequest request, ServerResponse response) {
        Timer.Sample timerSample = Timer.start();           <span class="conum" data-value="4" />
        sendResponse(response, "Here are some cards ...");
        response.whenSent(() -&gt; timerSample.stop(cardTimer)); <span class="conum" data-value="5" />
    }

    private void sendResponse(ServerResponse response, String msg) {
        JsonObject returnObject = JSON.createObjectBuilder().add("message", msg).build();
        response.send(returnObject);
    }
}</markup>

<ul class="colist">
<li data-value="1">Import relevant metrics classes.</li>
<li data-value="2">Declare a <code>Timer</code> member field.</li>
<li data-value="3">Create and register the <code>Timer</code> metric in the global meter registry.</li>
<li data-value="4">Create a timer sample which, among other things, automatically records the starting time.</li>
<li data-value="5">Arrange for the timer sample to be stopped and applied to the <code>cardTimer</code> once Helidon sends the response to the client.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the endpoints below:"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl -H "Accept: application/json"  'http://localhost:8080/observe/metrics?scope=application'</markup>

<markup
lang="json"
title="JSON response:"
>{
  "cardTimer": {
    "count": 2,
    "max": 0.01439681,
    "mean": 0.0073397075,
    "elapsedTime": 0.014679415,
    "p0.5": 0.000278528,
    "p0.75": 0.01466368,
    "p0.95": 0.01466368,
    "p0.98": 0.01466368,
    "p0.99": 0.01466368,
    "p0.999": 0.01466368
  }
}</markup>

<p>Helidon updated the timer statistics for each of the two accesses to the <code>/cards</code> endpoint.</p>

</div>


<h4 id="_distribution_summary_meters">Distribution Summary Meters</h4>
<div class="section">
<p>The <code>DistributionSummary</code> meter calculates the distribution of a set of values within ranges.  This meter does
not relate to time at all.  The following example records a set of random numbers in a <code>DistributionSummary</code> meter when
the <code>/cards</code> endpoint is invoked.</p>

<markup
lang="java"
title="Replace the <code>GreetingCards</code> class with the following code:"
>package io.helidon.examples.quickstart.se;

import java.util.Collections;
import java.util.Random;

import io.helidon.metrics.api.DistributionSummary;          <span class="conum" data-value="1" />
import io.helidon.metrics.api.Metrics;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;

public class GreetingCards implements HttpService {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final DistributionSummary cardSummary;          <span class="conum" data-value="2" />

    GreetingCards() {
        cardSummary = Metrics.globalRegistry()
                .getOrCreate(DistributionSummary.builder("cardDist")
                                     .description("random card distribution")); <span class="conum" data-value="3" />
    }

    @Override
    public void routing(HttpRules rules) {
        rules.get("/", this::getDefaultMessageHandler);
    }

    private void getDefaultMessageHandler(ServerRequest request, ServerResponse response) {
        Random r = new Random();                            <span class="conum" data-value="4" />
        for (int i = 0; i &lt; 1000; i++) {
            cardSummary.record(1 + r.nextDouble());
        }
        sendResponse(response, "Here are some cards ...");

    }

    private void sendResponse(ServerResponse response, String msg) {
        JsonObject returnObject = JSON.createObjectBuilder().add("message", msg).build();
        response.send(returnObject);
    }
}</markup>

<ul class="colist">
<li data-value="1">Import relevant metrics classes.</li>
<li data-value="2">Declare a <code>DistributionSummary</code> member field.</li>
<li data-value="3">Create and register the <code>DistributionSummary</code> meter in the global meter registry</li>
<li data-value="4">Update the distribution summary with a random number multiple times for each request.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the endpoints below:"
>curl http://localhost:8080/cards
curl -H "Accept: application/json"  'http://localhost:8080/observe/metrics?scope=application'</markup>

<markup
lang="json"
title="JSON response:"
>{
  "cardDist": {
    "count": 1000,
    "max": 1.999805150914427,
    "mean": 1.4971440362723523,
    "total": 1497.1440362723522,
    "p0.5": 1.4375,
    "p0.75": 1.6875,
    "p0.95": 1.9375,
    "p0.98": 1.9375,
    "p0.99": 1.9375,
    "p0.999": 1.9375
  }
}</markup>

<p>The <code>DistributionSummary.Builder</code> allows your code to configure other aspects of the summary, such as bucket boundaries and percentiles to track.</p>

</div>


<h4 id="_gauge_metric">Gauge Metric</h4>
<div class="section">
<p>The <code>Gauge</code> meter measures a value that is maintained by code outside the metrics subsystem. As with other meters, the application explicitly registers a gauge. When the <code>/observe/metrics</code> endpoint
is invoked, Helidon retrieves the value of each registered <code>Gauge</code>.  The following example demonstrates
how a <code>Gauge</code> is used to get the current temperature.</p>

<markup
lang="java"
title="Replace the <code>GreetingCards</code> class with the following code:"
>package io.helidon.examples.quickstart.se;

import java.util.Collections;
import java.util.Random;

import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Metrics;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;

public class GreetingCards implements HttpService {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

    GreetingCards() {
        Random r = new Random();
        Metrics.globalRegistry()
                .getOrCreate(Gauge.builder("temperature",
                                           () -&gt; r.nextDouble(100.0))
                                     .description("Ambient temperature"));      <span class="conum" data-value="1" />
    }

    @Override
    public void routing(HttpRules rules) {
        rules.get("/", this::getDefaultMessageHandler);
    }

    private void getDefaultMessageHandler(ServerRequest request, ServerResponse response) {
        sendResponse(response, "Here are some cards ...");
    }

    private void sendResponse(ServerResponse response, String msg) {
        JsonObject returnObject = JSON.createObjectBuilder().add("message", msg).build();
        response.send(returnObject);
    }
}</markup>

<ul class="colist">
<li data-value="1">Register the <code>Gauge</code>, passing a <code>Supplier&lt;Double&gt;</code> which furnishes a random temperature from 0 to 100.0 each time the metrics system interrogates the gauge.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the endpoint below:"
>curl -H "Accept: application/json"  'http://localhost:8080/observe/metrics?scope=application</markup>

<markup
lang="json"
title="JSON response:"
>{
  "temperature": 46.582132737739066        <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The current (random) temperature. Accessing the endpoint again returns a different value.</li>
</ul>

</div>

</div>


<h3 id="_integration_with_kubernetes_and_prometheus">Integration with Kubernetes and Prometheus</h3>
<div class="section">

<h4 id="_kubernetes_integration">Kubernetes Integration</h4>
<div class="section">
<p>The following example shows how to integrate the Helidon SE application with Kubernetes.</p>

<markup
lang="bash"
title="Stop the application and build the docker image:"
>docker build -t helidon-metrics-se .</markup>

<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>metrics.yaml</code>, with the following content:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-metrics <span class="conum" data-value="1" />
  labels:
    app: helidon-metrics
  annotations:
    prometheus.io/scrape: true <span class="conum" data-value="2" />
spec:
  type: NodePort
  selector:
    app: helidon-metrics
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-metrics
spec:
  replicas: 1 <span class="conum" data-value="3" />
  selector:
    matchLabels:
      app: helidon-metrics
  template:
    metadata:
      labels:
        app: helidon-metrics
        version: v1
    spec:
      containers:
        - name: helidon-metrics
          image: helidon-metrics-se
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">An annotation that will allow Prometheus to discover and scrape the application pod.</li>
<li data-value="3">A deployment with one replica of a pod.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./metrics.yaml</markup>

<markup
lang="bash"
title="Get the service information:"
>kubectl get service/helidon-metrics</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-metrics   NodePort   10.99.159.2   &lt;none&gt;        8080:31143/TCP   8s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>31143</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the metrics endpoint using port <code>30116</code>, your port will likely be different:"
>curl http://localhost:31143/metrics</markup>

<div class="admonition note">
<p class="admonition-inline">Leave the application running in Kubernetes since it will be used for Prometheus integration.</p>
</div>

</div>


<h4 id="_prometheus_integration">Prometheus Integration</h4>
<div class="section">
<p>The metrics service that you just deployed into Kubernetes is already annotated with <code>prometheus.io/scrape:</code>.  This will allow
Prometheus to discover the service and scrape the metrics.  This example shows how to install Prometheus
into Kubernetes, then verify that it discovered the Helidon metrics in your application.</p>

<markup
lang="bash"
title="Install Prometheus and wait until the pod is ready:"
>helm install stable/prometheus --name metrics
export POD_NAME=$(kubectl get pods --namespace default -l "app=prometheus,component=server" -o jsonpath="{.items[0].metadata.name}")
kubectl get pod $POD_NAME</markup>

<p>You will see output similar to the following.  Repeat the <code>kubectl get pod</code> command until you see <code>2/2</code> and <code>Running</code>. This may take up to one minute.</p>

<markup
lang="bash"

>metrics-prometheus-server-5fc5dc86cb-79lk4   2/2     Running   0          46s</markup>

<markup
lang="bash"
title="Create a port-forward so you can access the server URL:"
>kubectl --namespace default port-forward $POD_NAME 7090:9090</markup>

<p>Now open your browser and navigate to <code><a target="_blank" href="http://localhost:7090/targets" class="bare">http://localhost:7090/targets</a></code>.  Search for helidon on the page and you will see your
Helidon application as one of the Prometheus targets.</p>

</div>


<h4 id="_final_cleanup">Final Cleanup</h4>
<div class="section">
<p>You can now delete the Kubernetes resources that were just created during this example.</p>

<markup
lang="bash"
title="Delete the Prometheus Kubernetes resources:"
>helm delete --purge metrics</markup>

<markup
lang="bash"
title="Delete the application Kubernetes resources:"
>kubectl delete -f ./metrics.yaml</markup>

</div>

</div>


<h3 id="_summary">Summary</h3>
<div class="section">
<p>This guide demonstrated how to use metrics in a Helidon SE application using various combinations of
meters and scopes.</p>

<ul class="ulist">
<li>
<p>Access meters for all three built-in scopes: base, vendor, and application</p>

</li>
<li>
<p>Configure meters that are updated by the application when an application REST endpoint is invoked</p>

</li>
<li>
<p>Configure a <code>Gauge</code> meter</p>

</li>
<li>
<p>Integrate Helidon metrics with Kubernetes and Prometheus</p>

</li>
</ul>

<p>Refer to the following references for additional information:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/index.html?overview-summary.html">Helidon Javadoc</a></p>

</li>
</ul>

</div>

</div>

</doc-view>
