<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>GraalVM Native Images</dt>
<dd slot="desc"><p>This guide describes how to build a GraalVM native image for a Helidon SE application.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_introduction">Introduction</h2>
<div class="section">
<p><a target="_blank" href="https://www.graalvm.org/jdk21/reference-manual/native-image/">Native images</a> are ahead-of-time compiled Java code
that result in a self  contained native executable. When used appropriately native images have dramatically faster
startup and lower runtime memory overhead compared to a Java VM.</p>

<p>In this guide you will learn how to build a native image locally on your machine, as well as using Docker.</p>

</div>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 10 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon SE Application</td>
<td class="">You can use your own application or use the
 <router-link to="/se/guides/quickstart">Helidon SE Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.graalvm.org/release-notes/JDK_21/">GraalVM for JDK 21</a></td>

</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>

</div>


<h2 id="_install_graalvm_and_the_native_image_command">Install GraalVM and the Native Image Command</h2>
<div class="section">
<p>After <a target="_blank" href="https://www.graalvm.org/jdk21//docs/getting-started/">downloading and installing</a> GraalVM,
set the <code>GRAALVM_HOME</code> environment variable to point at your GraalVM installation,
or use the GraalVM installation as your Java home.</p>

<markup
lang="bash"

># Your path might be different
export GRAALVM_HOME=/usr/local/graalvm-jdk-21+35.1/Contents/Home/</markup>

<p>Then verify:</p>

<markup
lang="bash"

>$GRAALVM_HOME/bin/java -version
$GRAALVM_HOME/bin/native-image --version</markup>

</div>


<h2 id="_generate_the_project">Generate the Project</h2>
<div class="section">
<p>Generate the project using the Helidon SE Quickstart Maven archetype.</p>

<markup
lang="bash"

>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.5 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

<p>The archetype generates a Maven project in your current directory
(for example, <code>helidon-quickstart-se</code>). Change into this directory and build.</p>

<markup
lang="bash"

>cd helidon-quickstart-se
mvn package</markup>

<p>At this point you can run the application using the JVM:</p>

<markup
lang="bash"

>java -jar target/helidon-quickstart-se.jar</markup>

<p>In another shell test an endpoint:</p>

<markup
lang="bash"

>curl -X GET http://localhost:8080/greet</markup>

<p>The application should respond with <code>{"message":"Hello World!"}</code></p>

<p>Now stop the running application (by pressing Ctrl+C).</p>

<p>For more information about the Quickstart application and other endpoints it supports see the
<router-link to="/se/guides/quickstart">Helidon SE Quickstart Guide</router-link>.</p>

</div>


<h2 id="_building_a_native_image">Building a Native Image</h2>
<div class="section">
<p>You can build a native executable in 2 different ways:</p>

<ul class="ulist">
<li>
<p>With a local installation of GraalVM</p>

</li>
<li>
<p>Using Docker</p>

</li>
</ul>


<h3 id="_local_build">Local build</h3>
<div class="section">
<p>Make sure you have GraalVM locally installed:</p>

<markup
lang="bash"

>$GRAALVM_HOME/bin/native-image --version</markup>

<p>Build the native image using the native image profile:</p>

<markup
lang="bash"

>mvn package -Pnative-image</markup>

<div class="admonition tip">
<p class="admonition-textlabel">Tip</p>
<p >This uses the <code>org.graalvm.buildtools:native-maven-plugin</code> to perform the native compilation using your installed
copy of GraalVM. It might take a while to complete.</p>
</div>

<p>Once it completes start the application using the native executable (no JVM!):</p>

<markup
lang="bash"

>./target/helidon-quickstart-se</markup>

<p>Yep, it starts fast. You can exercise the application&#8217;s endpoints as before.</p>

</div>


<h3 id="_multi_stage_docker_build">Multi-stage Docker build</h3>
<div class="section">
<p>Build the "native" Docker image</p>

<markup
lang="bash"

>docker build -t helidon-quickstart-se-native -f Dockerfile.native .</markup>

<div class="admonition tip">
<p class="admonition-textlabel">Tip</p>
<p >This does a full build inside the Docker container. The first
time you run it, it will take a while because it is downloading all
of the Maven dependencies and caching them in a Docker layer.
Subsequent builds will be much faster as long as you don&#8217;t change
the <code>pom.xml</code> file. If the pom is modified then the dependencies
will be re-downloaded.</p>
</div>

<p>Start the application:</p>

<markup
lang="bash"

>docker run --rm -p 8080:8080 helidon-quickstart-se-native:latest</markup>

<p>Again, it starts fast. You can exercise the application&#8217;s endpoints as before.</p>

</div>

</div>


<h2 id="_when_should_i_use_native_images">When should I use Native Images?</h2>
<div class="section">
<p>Native images are ideal for applications with high horizontal scalability requirements where
the ability to rapidly scale out to numerous instances is important.</p>

<p>That said, native images do have some <a target="_blank" href="https://www.graalvm.org/jdk21/reference-manual/native-image/metadata/Compatibility/">limitations</a>,
and for long running applications where startup and footprint are less of a priority, the Java SE
HotSpot VM might be more appropriate.</p>

<p>For information about creating custom Java runtime images see
<router-link to="/se/guides/jlink-image">Custom Runtime Images with <code>jlink</code></router-link>.</p>

<div class="admonition note">
<p class="admonition-inline">When building Helidon using native-image, we check features on classpath, and warn if there is a problem or restriction of support</p>
</div>

</div>

</doc-view>
