<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon uses Jersey as the Jakarta REST (JAX-RS) implementation. Jersey supports the concept of <em>connectors</em>
which is an SPI to handle low-level HTTP connections when using the Jakarta REST Client API. Helidon provides a
connector that is based on its <code>WebClient</code> implementation and that has a few benefits,
most notably, configuration using Config and support for HTTP/2.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon Connector
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

> &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.jersey&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-jersey-connector&lt;/artifactId&gt;
 &lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>Enabling the Helidon connector is possible at creation time using Jersey&#8217;s <code>ClientConfig</code> instance
as shown below:</p>

<markup
lang="java"

>  ClientConfig clientConfig = new ClientConfig();
  clientConfig.connectorProvider(HelidonConnectorProvider.create());       // Helidon connector
  Client client = ClientBuilder.newClient(clientConfig);</markup>

<p>Any subsequent requests using a <code>Client</code> instance configured this way will defer to the
Helidon connector to handle the underlying HTTP connection.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>The Helidon connector implementation is based on <code>WebClient</code>, so it can be configured
using config in the same way as any other instance of that class.
The config root used by the Helidon connector to initialize all instances of <code>WebClient</code> is
rooted at <code>jersey.connector.helidon.config</code>. Thus, if using a properties file,
use this prefix for all the properties that you want to set in the connector.</p>

<p>For example, suppose you need to enable automatic storage for server cookies and to
turn off redirects, you can add the following lines to your <code>microprofile-config.properties</code> file:</p>

<markup
lang="properties"

>  jersey.connector.helidon.config.cookie-manager.automatic-store-enabled=true
  jersey.connector.helidon.config.follow-redirects=false</markup>

<p>Alternatively, assuming the root of the <code>WebClient</code> configuration is located at
<code>my.webclient</code>, this can be done programmatically when building the <code>ClientConfig</code>
instance as follows:</p>

<markup
lang="java"

>  clientConfig.property(HelidonProperties.CONFIG, config.get("my.webclient"));</markup>

<p>There are additional properties that can be set programmatically and that shall
override any related property set via config. The following table lists all the
properties supported by the connector, their types, scopes and default values.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 25%;">
</colgroup>
<thead>
<tr>
<th>Property Name</th>
<th>Type</th>
<th>Scope</th>
<th>Default</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">jersey.config.client.connectTimeout</td>
<td class=""><code>Integer</code></td>
<td class="">client</td>
<td class="">10000 (millis)</td>
</tr>
<tr>
<td class="">jersey.config.client.readTimeout</td>
<td class=""><code>Integer</code></td>
<td class="">client, invocation</td>
<td class="">10000 (millis)</td>
</tr>
<tr>
<td class="">jersey.config.client.followRedirects</td>
<td class=""><code>Boolean</code></td>
<td class="">client, invocation</td>
<td class="">true</td>
</tr>
<tr>
<td class="">jersey.connector.helidon.config</td>
<td class=""><code>io.helidon.config.Config</code></td>
<td class="">client</td>
<td class="">(none)</td>
</tr>
<tr>
<td class="">jersey.connector.helidon.tls</td>
<td class=""><code>io.helidon.common.tls.Tls</code></td>
<td class="">client</td>
<td class="">(none)</td>
</tr>
<tr>
<td class="">jersey.connector.helidon.protocolConfigs</td>
<td class=""><code>List&lt;? extends ProtocolConfig&gt;</code></td>
<td class="">client</td>
<td class="">(none)</td>
</tr>
<tr>
<td class="">jersey.connector.helidon.defaultHeaders</td>
<td class=""><code>Map&lt;String, String&gt;</code></td>
<td class="">client</td>
<td class="">(none)</td>
</tr>
<tr>
<td class="">jersey.connector.helidon.protocolId</td>
<td class=""><code>String</code></td>
<td class="">invocation</td>
<td class="">(none)</td>
</tr>
<tr>
<td class="">jersey.connector.helidon.shareConnectionCache</td>
<td class=""><code>Boolean</code></td>
<td class="">client</td>
<td class="">false</td>
</tr>
</tbody>
</table>
</div>


<h3 id="_http2_support">HTTP/2 Support</h3>
<div class="section">
<p>One clear advantage of using the Helidon connector, as opposed to the default one
provided by Jersey, is the ability to issue HTTP/2 requests. There are three ways
to enable HTTP/2:</p>

<ol style="margin-left: 15px;">
<li>
Via content negotiation from HTTP/1.1, where the initial request is HTTP/1.1 (text)
and the first response is HTTP/2 (binary), assuming the negotiation is successful.

</li>
<li>
Similar to (1) except that a TLS extension called ALPN is used to convey the
upgrade negotiation. Naturally, this only works with secure connections, so TLS
is a requirement here.

</li>
<li>
Using prior knowledge, where the client simply sends an HTTP/2 request knowing
<em>a priori</em> that the server is capable of handling it. This option always requires TLS.

</li>
</ol>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">

<h3 id="_http2_negotiation_without_tls">HTTP/2 Negotiation Without TLS</h3>
<div class="section">
<p>Without TLS, HTTP/2 negotiation is accomplished by setting a single property. In the
example below, the property is set on the correspoding <code>WebTarget</code>, which indicates
that it applies to all requests created from it.</p>

<markup
lang="java"

>  ClientConfig clientConfig = new ClientConfig();
  clientConfig.connectorProvider(HelidonConnectorProvider.create());
  Client client = ClientBuilder.newClient(clientConfig);

  WebTarget webTarget = client.target(...).path(...)
      .property(HelidonProperties.PROTOCOL_ID, Http2Client.PROTOCOL_ID);      // HTTP/2 upgrade
  try (Response response = webTarget.request().get()) {
      // ...
  }</markup>

<div class="admonition note">
<p class="admonition-inline">Properties in the Jakarta REST Client API can be set on <code>Client</code>, <code>WebTarget</code> and
<code>Invocation</code>  and are inherited accordingly.</p>
</div>

<p>The request invocation in the example above will include an HTTP/2 protocol upgrade
request which may be granted by the server if HTTP/2 support is enabled.</p>

</div>


<h3 id="_http2_negotiation_with_tlsalpn">HTTP/2 Negotiation With TLS/ALPN</h3>
<div class="section">
<p>ALPN is a TLS extension that can be used for HTTP/2 negotiation. The Helidon connector
accepts a <code>Tls</code> instance to enable protocol security and also to
negotiate an HTTP/2 upgrade as shown below.</p>

<markup
lang="java"

>  Tls tls = Tls.builder()
               .trustAll(true)
               .addApplicationProtocol(Http2Client.PROTOCOL_ID)        // HTTP/2 upgrade
               .endpointIdentificationAlgorithm(Tls.ENDPOINT_IDENTIFICATION_NONE)
               .build();

  ClientConfig clientConfig = new ClientConfig();
  clientConfig.connectorProvider(HelidonConnectorProvider.create());
  config.property(HelidonProperties.TLS, tls);
  Client client = ClientBuilder.newClient(clientConfig);

  WebTarget webTarget = client.target(...).path(...);
  try (Response response = webTarget.request().get()) {
      // ...
  }</markup>

<p>The call to <code>addApplicationProtocol()</code> indicates the desire to negotiate a protocol upgrade. Naturally,
ALPN only works on secure connections, so TLS is always configured at the same time.</p>

</div>


<h3 id="_http2_prior_knowledge">HTTP/2 Prior Knowledge</h3>
<div class="section">
<p>The last example shows how to enable HTTP/2 when prior knowledge of the server&#8217;s capabilities is
known ahead of time. In order to force HTTP/2 for the initial request, we must provide an
<code>Http2ClientProtocolConfig</code> instance that is properly configured for that purpose. Passing
protocol configurations is a general mechanism supported by the connector; in this example,
we take advantage of this mechanism to pre-configure the desired HTTP/2 support as shown next.</p>

<markup
lang="java"

>  Tls tls = Tls.builder()
               .trustAll(true)
               .endpointIdentificationAlgorithm(Tls.ENDPOINT_IDENTIFICATION_NONE)
               .build();

  ClientConfig clientConfig = new ClientConfig();
  clientConfig.connectorProvider(HelidonConnectorProvider.create());
  clientConfig.property(HelidonProperties.TLS, tls);
  clientConfig.property(HelidonProperties.PROTOCOL_CONFIGS,
                        List.of(Http2ClientProtocolConfig.builder()
                                                   .priorKnowledge(true)    // HTTP/2 knowlege
                                                   .build()));
  Client client = ClientBuilder.newClient(clientConfig);

  WebTarget webTarget = client.target(...).path(...);
  try (Response response = webTarget.request().get()) {
      // ...
  }</markup>

<p>The property <code>HelidonProperties.PROTOCOL_CONFIGS</code> accepts a list of protocol configurations
that are passed directly to the underlying <code>WebClient</code> layer.</p>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>For additional information, see the <a target="_blank" href="https://jakarta.ee/specifications/restful-ws/3.1/apidocs">Jakarta REST Javadocs</a>.</p>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://jakarta.ee/specifications/restful-ws/3.1/jakarta-restful-ws-spec-3.1.html#client_api">Jakarta REST Client Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://eclipse-ee4j.github.io/jersey.github.io/documentation/latest31x/index.html">Jersey User Guide</a></p>

</li>
</ul>

</div>

</doc-view>
