<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>JdbcParametersConfig (dbclient.jdbc) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.dbclient.jdbc/io/helidon/dbclient/jdbc/JdbcParametersConfig.html">io.helidon.dbclient.jdbc.JdbcParametersConfig</a></p>

<markup
lang="text"
title="Config key"
>parameters</markup>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>set-object-for-java-time</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Set all <code>java.time</code> Date/Time values directly using java.sql.PreparedStatement#setObject(int, Object).
 This option shall work fine for recent JDBC drivers.
 Default value is <code>true</code>.</p>

<pre>@return whether to use java.sql.PreparedStatement#setObject(int, Object) for `java.time` Date/Time values</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>string-binding-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>String values with length above this limit will be bound
 using java.sql.PreparedStatement#setCharacterStream(int, java.io.Reader, int)
 if #useStringBinding() is set to <code>true</code>.
 Default value is <code>1024</code>.</p>

<pre>@return String values length limit for java.io.CharArrayReader binding</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>timestamp-for-local-time</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Use java.sql.PreparedStatement#setTimestamp(int, java.sql.Timestamp)
 to set java.time.LocalTime values when <code>true</code>
 or use java.sql.PreparedStatement#setTime(int, java.sql.Time) when <code>false</code>.
 Default value is <code>true</code>.
This option is vendor specific. Most of the databases are fine with java.sql.Timestamp,
 but for example SQL Server requires java.sql.Time.
 This option does not apply when #setObjectForJavaTime() is set to <code>true</code>.</p>

<pre>@return whether to use java.sql.Timestamp instead of java.sql.Time
        for java.time.LocalTime values</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>use-byte-array-binding</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Use java.sql.PreparedStatement#setBinaryStream(int, java.io.InputStream, int) binding
 for <code>byte[]</code> values.
 Default value is <code>true</code>.</p>

<pre>@return whether to use java.io.ByteArrayInputStream binding</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>use-n-string</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Use SQL <code>NCHAR</code>, <code>NVARCHAR</code> or <code>LONGNVARCHAR</code> value conversion
 for String values.
 Default value is <code>false</code>.</p>

<pre>@return whether NString conversion is used</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>use-string-binding</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Use java.sql.PreparedStatement#setCharacterStream(int, java.io.Reader, int) binding
 for String values with length above #stringBindingSize() limit.
 Default value is <code>true</code>.</p>

<pre>@return whether to use java.io.CharArrayReader binding</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
