<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>SmallRye offers an <a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/3.3.4/ui/open-api-ui">OpenAPI user interface component</a> which displays a web page based on your application&#8217;s OpenAPI document.
Through that UI, users can invoke the operations declared in the document.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>The Helidon team discourages including the OpenAPI UI in production applications. The OpenAPI UI <em>can</em> be useful for demonstrating and testing your service&#8217;s endpoints prior to deployment.</p>
</p>
</div>

<p>The Helidon OpenAPI component allows you to integrate the SmallRye UI into your application, adding the UI web page to your application very simply.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Helidon OpenAPI UI support
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.openapi-ui&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-openapi-ui&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>And add a runtime dependency on the SmallRye UI.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.smallrye&lt;/groupId&gt;
    &lt;artifactId&gt;smallrye-open-api-ui&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>Also, make sure your project has the following dependency.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.openapi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-openapi&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>This dependency allows your application to create, configure, and register the <code>OpenApiFeature</code> service.</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Make sure your application incorporates Helidon OpenAPI support as  described in detail in <a target="_blank" href="/home/runner/work/helidon/helidon/docs/src/main/asciidoc/se/openapi/../../se/openapi/openapi.adoc">the Helidon OpenAPI documentation</a>). Helidon automatically prepares the OpenAPI UI with default settings if you also declare a dependency on the Helidon OpenAPI UI integration component as explained above. The <router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link> section below illustrates adding OpenAPI to your application and customizing the UI behavior.</p>

<p>After you modify, build, and start your Helidon SE service, you can access the OpenAPI UI by default at <code><a target="_blank" href="http://your-host:your-port/openapi/ui" class="bare">http://your-host:your-port/openapi/ui</a></code>.
Helidon also uses conventional content negotiation at <code><a target="_blank" href="http://your-host:your-port/openapi" class="bare">http://your-host:your-port/openapi</a></code> returning the UI to browsers (or any client that accepts HTML) and the OpenAPI document otherwise.</p>

<p>You can customize the path using
either the API or
<router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">configuration</router-link>.</p>

<p>The example below shows the UI
if you modify the Helidon SE QuickStart greeting application to contain a static OpenAPI file which describes the service endpoints.</p>


<div class="block-title"><span>Example OpenAPI UI Screen</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="/images/openapi-ui-screen-capture-greeting-se-start.png" alt="openapi ui screen capture greeting se start" />
</v-card-text>
</v-card>


<p>With the OpenAPI UI displayed, follow these steps to access one of your service&#8217;s operations.</p>

<ol style="margin-left: 15px;">
<li>
Find the operation you want to run and click on its row in the list.

</li>
<li>
The UI expands the operation, showing any input parameters and the possible responses. Click the "Try it out" button in the operation&#8217;s row.

</li>
<li>
The UI now allows you to type into the input parameter field(s) to the right of each parameter name. Enter any required parameter values (first highlighted rectangle) and any non-required values you wish, then click "Execute" (highlighted arrow).

</li>
<li>
Just below the "Execute" button the UI shows several sections:<br>

<ul class="ulist">
<li>
<p>the equivalent <code>curl</code> command for submitting the request with your inputs,</p>

</li>
<li>
<p>the URL used for the request, and</p>

</li>
<li>
<p>a new "Server response" section (second highlighted rectangle) containing several items from the response:<br>
</p>
<ul class="ulist">
<li>
<p>HTTP status code</p>

</li>
<li>
<p>body</p>

</li>
<li>
<p>headers</p>

</li>
</ul>

</li>
</ul>

</li>
</ol>

<p>The next image shows the screen after you submit the "Returns a personalized greeting" operation.</p>

<p>Note that the UI shows the actual response from invoking the operation in the "Server response" section. The "Responses" section farther below describes the possible responses from the operation as declared in the OpenAPI document for the application.</p>


<div class="block-title"><span>Example OpenAPI UI Screen</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="/images/openapi-ui-screen-capture-greeting-se-expanded.png" alt="openapi ui screen capture greeting se expanded" />
</v-card-text>
</v-card>


</div>


<h2 id="_api">API</h2>
<div class="section">
<p>With the Helidon OpenAPI UI dependency in your <code>pom.xml</code> file, Helidon&#8217;s OpenAPI support automatically includes the default UI behavior, possibly modified by any UI settings you have in your configuration.
You do not have to do anything else to enable the UI.</p>


<h3 id="_creating_openapifeature_with_automatic_ui_behavior">Creating <code>OpenApiFeature</code> with Automatic UI Behavior</h3>
<div class="section">
<p>Some applications explicitly create the <code>OpenApiFeature</code> object to tailor its behavior before registering it with the server.
If your <code>pom.xml</code> includes a dependency on the OpenAPI UI component, then any <code>OpenApiFeature</code> object your application builds prepares the default OpenAPI UI behavior, possibly modified as above by any UI settings you have in your configuration.</p>

<markup
lang="java"
title="Create <code>OpenApiFeature</code> with automatic UI"
>Config config = Config.create(); <span class="conum" data-value="1" />
Config.global(config);

WebServer server = WebServer.builder()
        .config(config.get("server"))
        .addFeature(OpenApiFeature.create(Config.global().get("openapi"))) <span class="conum" data-value="2" />
        .routing(Main::routing)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Load and set the global configuration.</li>
<li data-value="2">Add the OpenAPI feature to the server, configured using the <code>openapi</code> section of the configuration.</li>
</ul>

<p>If your code invokes the <code>OpenApiFeature.Builder</code> <code>config</code> method, Helidon automatically applies the <code>ui</code> section of the <code>openapi</code> configuration to the UI.</p>

</div>


<h3 id="_customizing_the_ui_behavior">Customizing the UI Behavior</h3>
<div class="section">
<p>You can control some of the behavior of the UI programmatically in two steps:</p>

<ol style="margin-left: 15px;">
<li>
Create an <a target="_blank" href="/apidocs/io.helidon.integrations.openapi.ui/io/helidon/integrations/openapi/ui/OpenApiUiConfig.Builder.html"><code>OpenApiUiConfig.Builder</code></a> and invoke methods on it to set the UI behavior, then invoke the builder&#8217;s <code>build</code> method to create the <code>OpenApiUi</code> object.

</li>
<li>
Invoke the <code>addService</code> method on <a target="_blank" href="/apidocs/io.helidon.openapi/io/helidon/openapi/OpenApiFeatureConfig.Builder.html"><code>OpenApiFeature.Builder</code></a>, passing the <code>OpenApiUi</code> object you prepared above.

</li>
</ol>

<p>The following example illustrates these steps, combining configuration with explicit programmatic settings.</p>

<markup
lang="java"
title="Create <code>OpenApiUi</code> and <code>OpenAPISupport</code> instances"
>Config config = Config.create(); <span class="conum" data-value="1" />
Config.global(config);

Config openApiConfig = Config.global().get("openapi"); <span class="conum" data-value="2" />
WebServer server = WebServer.builder()
        .config(config.get("server"))
        .addFeature(OpenApiFeature.builder() <span class="conum" data-value="3" />
                            .addService(OpenApiUi.builder() <span class="conum" data-value="4" />
                                                .webContext("my-ui") <span class="conum" data-value="5" />
                                                .config(openApiConfig.get("ui")) <span class="conum" data-value="6" />
                                                .build()) <span class="conum" data-value="7" />
                            .config(openApiConfig)
                            .build()) <span class="conum" data-value="8" />
        .routing(Main::routing)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Load and set global configuration.</li>
<li data-value="2">Extract the <code>openapi</code> config.</li>
<li data-value="3">Begin setting up the <code>OpenApiFeature</code> builder.</li>
<li data-value="4">Create the UI builder.</li>
<li data-value="5">Set UI behavior programmatically.</li>
<li data-value="6">Set additional UI behavior based on UI configuration.</li>
<li data-value="7">Build the <code>OpenApiUi</code> object.</li>
<li data-value="8">Build the <code>OpenApiFeature</code> object.</li>
</ul>

<p>The order in which your code invokes the methods on <code>OpenApiUi.Builder</code> and <code>OpenApiFeature.Builder</code> determines the outcome.
For instance, the example above adds the UI service to the <code>OpenApiFeature.Builder</code> <em>before</em> applying configuration to the <code>OpenApiFeature.Builder</code>.
If the configuration contains a setting for the UI&#8217;s <code>web-context</code> value, then the UI uses the configured value and not the programmatic value because your code applies the configuration later.
Your code should typically apply configuration <em>after</em> setting any values programmatically.
Doing so allows users or deployers of your service to set the behavior using configuration according to their particular needs which your code might not be able to anticipate.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>The <code>webContext(String)</code> method on <code>OpenApiUi.Builder</code>  sets the web context where the UI should respond instead of the default <code>/openapi/ui</code>.
Helidon uses the provided string to set the <em>entire</em> web context for the UI, not as a suffix appended to the web context for the <code>OpenAPISupport</code> service.</p>
</p>
</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To use configuration to control how the Helidon OpenAPI UI service behaves, add
an <code>openapi.services.ui</code> section to your configuration file, such as <code>application.yaml</code>.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.integrations.openapi.ui/io/helidon/integrations/openapi/ui/OpenApiUi.html">io.helidon.integrations.openapi.ui.OpenApiUi</a></p>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Sets whether the service should be enabled.</p>

<pre>@return `true` if enabled, `false` otherwise</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>options</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Merges implementation-specific UI options.</p>

<pre>@return options for the UI to merge</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>web-context</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Full web context (not just the suffix).</p>

<pre>@return full web context path</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The default UI <code>web-context</code> value is the web context for your <code>OpenApiFeature</code> service with the added suffix <code>/ui</code>. If you use the default web context for both <code>OpenApiFeature</code> and the UI, the UI responds at <code>/openapi/ui</code>.</p>

<p>You can use configuration to affect the UI path in two ways:</p>

<ul class="ulist">
<li>
<p>Configure the OpenAPI endpoint path (the <code>/openapi</code> part).</p>
<p>Recall that you can <router-link :to="{path: '/se/openapi/openapi', hash: '#config'}">configure the Helidon OpenAPI component</router-link> to change where it serves the OpenAPI document.</p>

<markup
lang="yaml"
title="Configuring the OpenAPI web context"
>openapi:
  web-context: /my-openapi</markup>

<p>In this case, the path for the UI component is your customized OpenAPI path with <code>/ui</code> as a suffix.
With the example above, the UI responds at <code>/my-openapi/ui</code> and
Helidon uses standard content negotiation at <code>/my-openapi</code> to return either the OpenAPI document or the UI.</p>

</li>
<li>
<p>Separately, configure the entire web context path for the UI independently from the web context for OpenAPI.</p>
<markup
lang="yaml"
title="Configuring the OpenAPI UI web context"
>openapi:
  services:
    ui:
      web-context: /my-ui</markup>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>The <code>openapi.services.ui.web-context</code> setting assigns the <em>entire</em> web-context for the UI, not the suffix appended to the <code>OpenApiFeature</code> endpoint.</p>
</p>
</div>

<p>With this configuration, the UI responds at <code>/my-ui</code> regardless of the path for OpenAPI itself.</p>

</li>
</ul>

<p>The SmallRye OpenAPI UI component accepts several options, but they are of minimal use to application developers and they must be passed to the SmallRye UI code programmatically.
Helidon allows you to specify these values using configuration in the <code>openapi.services.ui.options</code>
section. Helidon then passes the corresponding options to SmallRye for you.
To configure any of these settings, use the enum values&#8212;&#8203;they are all lower case&#8212;&#8203;declared in  the SmallRye <a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/3.3.4/ui/open-api-ui/src/main/java/io/smallrye/openapi/ui/Option.java"><code>Option.java</code></a> class as the keys in your Helidon configuration.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>Helidon prepares several of the SmallRye options automatically based on other settings.
Any options you configure override the values Helidon assigns, possibly interfering with the proper operation of the UI.</p>
</p>
</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p><router-link to="/se/openapi/openapi">Helidon OpenAPI SE documentation</router-link></p>

<p><a target="_blank" href="https://github.com/smallrye/smallrye-open-api/tree/3.3.4/ui/open-api-ui">SmallRye OpenAPI UI GitHub site</a></p>

</div>

</doc-view>
