<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#_maven_coordinates" @click.native="this.scrollFix('#_maven_coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon Injection is an optional feature in Helidon that provides service registry, a lifecycle engine and extensibility for customized code generation.</p>

<div class="admonition note">
<p class="admonition-inline">Helidon Injection provides a way to develop non Helidon-specific declarative code using standard Javax/Jakarta annotation types.</p>
</div>

<p>The Helidon Injection Framework provides a mix of declarative and programmatic ways to build your application.
Helidon Injection&#8217;s minimalist, compile-time generated dependency injection (DI) framework and compile-time source code generation has a number of advantages, including:</p>

<ul class="ulist">
<li>
<p>enables declarative, Inversion of Control-style programming</p>

</li>
<li>
<p>offers visibility into your application by providing "less magic" - understandability and debug-ability of your application</p>

</li>
<li>
<p>provides deterministic behavior (instead of depending on reflection and classpath ordering, etc.)</p>

</li>
<li>
<p>optimizes performance improvements since binding the model at compile-time is more efficient than computing it at runtime.</p>

</li>
</ul>

</div>


<h2 id="_maven_coordinates">Maven Coordinates</h2>
<div class="section">
<markup
lang="java"
title="Injection dependencies"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.inject&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-inject-api&lt;/artifactId&gt;
    &lt;version&gt;${helidon.version}&lt;/version&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.inject&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-inject-types&lt;/artifactId&gt;
    &lt;version&gt;${helidon.version}&lt;/version&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Once you have planned how each of your resources should support Injection, you specify the behavior in one of two ways:</p>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>Adding Injection behavior to your Helidon WebServer application involves just a few simple steps.</p>


<h3 id="_maven_coordinates_2">Maven Coordinates</h3>
<div class="section">
<markup
lang="java"
title="Injection API pom.xml"
> &lt;artifactId&gt;helidon-inject-inject&lt;/artifactId&gt;
 &lt;name&gt;Helidon Injection API&lt;/name&gt;</markup>

</div>


<h3 id="_types">Types</h3>
<div class="section">
<p>The Injection API provides types that are generally useful at compile time to assign special meaning to the type. In this way it also helps with readability and intentions of the code itself.</p>

<markup
lang="java"
title="Injection types pom.xml"
> &lt;artifactId&gt;helidon-inject-types&lt;/artifactId&gt;
 &lt;name&gt;Helidon Injection Types&lt;/name&gt;</markup>

<ul class="ulist">
<li>
<p>{@link io.helidon.inject.api.Contract} - signifies that the type can be used for lookup in the service registry.</p>

</li>
<li>
<p>{@link io.helidon.inject.api.ExternalContracts} - same as Contract, but applied to the implementation class instead.</p>

</li>
<li>
<p>{@link io.helidon.inject.api.RunLevel} - ascribes meaning for when the service should start.</p>

</li>
</ul>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Injection Config builder</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

</div>

</doc-view>
